/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history.reports;

import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.DemoSession;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.history.HistoryDataSource;
import com.aem.shelp.tech.history.reports.PdfReportUtil;
import java.awt.Color;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import utils.simplegraphs.ColorUtil;
import utils.simplegraphs.LayeredBarChart;
import utils.simplegraphs.StackedBarChart;
import utils.simplegraphs.TwinAxisModel;

public class TechnicianActivityReport {
    String ACCESS = "Access";
    String SUPPORT = "Support";
    String DEMO = "Demo";
    Color[] colors = new Color[]{ColorUtil.ACCESS_COLOR, ColorUtil.SUPPORT_COLOR, ColorUtil.DEMO_COLOR};
    HashMap<String, StatsBlock> stats = new HashMap();
    private DecimalFormat df1 = new DecimalFormat("#############0.#");
    private SimpleDateFormat REPORT_FILENAME = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");

    private StatsBlock getBlock(String key) {
        StatsBlock block = this.stats.get(key);
        if (block == null) {
            block = new StatsBlock();
            block.key = key;
            this.stats.put(key, block);
        }
        return block;
    }

    private StatsBlock getAllTechs() {
        StatsBlock block = this.getBlock("Z_ALL");
        block.name = "All Technicians";
        return block;
    }

    private StatsBlock getTech(String name) {
        StatsBlock block = this.getBlock("A_TECH_" + name);
        block.name = name;
        block.isTechBlock = true;
        return block;
    }

    private StatsBlock getGroup(String name) {
        StatsBlock block = this.getBlock("M_GROUP_" + name);
        block.name = "Group " + name;
        block.isGroup = true;
        return block;
    }

    public void generate(boolean generatePDF, OutputStream out, HistoryDataSource source) {
        ArrayList<AbstractSession> list = source.getLoadedSessionData();
        do {
            StatsBlock all = this.getAllTechs();
            for (AbstractSession session : list) {
                String techuser = session.getTechnicianUsername();
                if (techuser == null || techuser.equals("null")) continue;
                StatsBlock tech = this.getTech(techuser);
                StatsBlock nonadmin = null;
                String[] groups = source.getGroupsFor(techuser);
                if (!techuser.equals("SimpleHelpAdmin")) {
                    nonadmin = this.getGroup("Excl Admin");
                }
                this.populate(session, all);
                this.populate(session, tech);
                for (String group : groups) {
                    this.populate(session, this.getGroup(group));
                }
                if (nonadmin != null) {
                    this.populate(session, nonadmin);
                }
                tech.comparisons.put(this.getAllTechs().key, this.getAllTechs());
                for (String group : groups) {
                    tech.comparisons.put(this.getGroup((String)group).key, this.getGroup(group));
                }
                if (nonadmin == null) continue;
                tech.comparisons.put(nonadmin.key, nonadmin);
            }
        } while ((list = source.getNextSessionDataBlock()) != null);
        StatsBlock[] blocks = this.stats.values().toArray(new StatsBlock[0]);
        Arrays.sort(blocks, new Comparator<StatsBlock>(){

            @Override
            public int compare(StatsBlock o1, StatsBlock o2) {
                String k1 = o1.key.toLowerCase();
                String k2 = o2.key.toLowerCase();
                if (k1.equals("SimpleHelpAdmin")) {
                    k1 = "aaaaaaaaa_SimpleHelpAdmin";
                }
                if (k2.equals("SimpleHelpAdmin")) {
                    k2 = "aaaaaaaaa_SimpleHelpAdmin";
                }
                return k1.compareTo(k2);
            }
        });
        for (StatsBlock block : blocks) {
            if (block.allCount > 0) {
                block.allAverageMins = block.allTotalMins / block.allCount;
            }
            if (block.accessCount > 0) {
                block.accessAverageMins = block.accessTotalMins / block.accessCount;
            }
            if (block.supportCount > 0) {
                block.supportAverageMins = block.supportTotalMins / block.supportCount;
            }
            if (block.demoCount <= 0) continue;
            block.demoAverageMins = block.demoTotalMins / block.demoCount;
        }
        if (generatePDF) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE d MMMM yyyy");
            String hostname = ServerConfig.get().hostname;
            String subText = sdf.format(new Date()) + " / " + hostname;
            try {
                PdfReportUtil pdf = new PdfReportUtil();
                String suffix = "";
                String pageTitle = "All Technicians - session counts" + suffix;
                TwinAxisModel model = new TwinAxisModel();
                StatsBlock[] statsBlockArray = blocks;
                int n = statsBlockArray.length;
                for (int group = 0; group < n; ++group) {
                    StatsBlock block = statsBlockArray[group];
                    if (!block.isTechBlock || block.name.equals("SimpleHelpAdmin")) continue;
                    model.add(block.name, this.ACCESS, block.accessCount);
                    model.add(block.name, this.SUPPORT, block.supportCount);
                    model.add(block.name, this.DEMO, block.demoCount);
                }
                Object chart = new StackedBarChart();
                ((StackedBarChart)chart).setModel(model);
                byte[] byArray = ((StackedBarChart)chart).toPNG(1800, 1150);
                pdf.addReportPage(byArray, pageTitle, subText);
                pageTitle = "All Technicians - Total minutes in session" + suffix;
                model = new TwinAxisModel();
                for (StatsBlock block : blocks) {
                    if (!block.isTechBlock || block.name.equals("SimpleHelpAdmin")) continue;
                    model.add(block.name, this.ACCESS, block.accessTotalMins);
                    model.add(block.name, this.SUPPORT, block.supportTotalMins);
                    model.add(block.name, this.DEMO, block.demoTotalMins);
                }
                chart = new StackedBarChart();
                ((StackedBarChart)chart).setModel(model);
                byte[] byArray2 = ((StackedBarChart)chart).toPNG(1800, 1150);
                pdf.addReportPage(byArray2, pageTitle, subText);
                StatsBlock[] AVGMINS = "Average minutes in session";
                StatsBlock[] pageTitle2 = "All Technicians - Average session minutes" + suffix;
                TwinAxisModel model2 = new TwinAxisModel();
                for (StatsBlock block : blocks) {
                    if (!block.isTechBlock || block.name.equals("SimpleHelpAdmin")) continue;
                    model2.add(block.name, this.ACCESS, block.accessAverageMins);
                    model2.add(block.name, this.SUPPORT, block.supportAverageMins);
                    model2.add(block.name, this.DEMO, block.demoAverageMins);
                }
                LayeredBarChart layeredBarChart = new LayeredBarChart();
                layeredBarChart.setModel(model2);
                byte[] png3 = layeredBarChart.toPNG(1800, 1150);
                pdf.addReportPage(png3, (String)pageTitle2, subText);
                this.dumpComparison(pdf, new PrintStream(out), this.getAllTechs(), blocks, subText);
                for (StatsBlock statsBlock : blocks) {
                    if (!statsBlock.isGroup) continue;
                    ArrayList<StatsBlock> users = new ArrayList<StatsBlock>();
                    for (StatsBlock tech : blocks) {
                        if (!tech.isTechBlock || !tech.comparisons.containsKey(statsBlock.key)) continue;
                        users.add(tech);
                    }
                    StatsBlock[] group = users.toArray(new StatsBlock[0]);
                    this.dumpComparison(pdf, new PrintStream(out), statsBlock, group, subText);
                }
                byte[] data = pdf.finish();
                out.write(data);
                out.close();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        } else {
            PrintStream pout = new PrintStream(out);
            pout.print(",");
            for (StatsBlock block : blocks) {
                pout.print(block.name + ",");
            }
            pout.print("\nTotal Sessions,");
            for (StatsBlock block : blocks) {
                pout.print(block.allCount + ",");
            }
            pout.print("\nAccess Sessions,");
            for (StatsBlock block : blocks) {
                pout.print(block.accessCount + ",");
            }
            pout.print("\nSupport Sessions,");
            for (StatsBlock block : blocks) {
                pout.print(block.supportCount + ",");
            }
            pout.print("\nDemo Sessions,");
            for (StatsBlock block : blocks) {
                pout.print(block.demoCount + ",");
            }
            pout.print("\nTotal mins,");
            for (StatsBlock block : blocks) {
                pout.print(block.allTotalMins + ",");
            }
            pout.print("\nTotal Access mins,");
            for (StatsBlock block : blocks) {
                pout.print(block.accessTotalMins + ",");
            }
            pout.print("\nTotal Support mins,");
            for (StatsBlock block : blocks) {
                pout.print(block.supportTotalMins + ",");
            }
            pout.print("\nTotal Demo mins,");
            for (StatsBlock block : blocks) {
                pout.print(block.demoTotalMins + ",");
            }
            pout.print("\nAverage mins,");
            for (StatsBlock block : blocks) {
                pout.print(block.allAverageMins + ",");
            }
            pout.print("\nAverage Access mins,");
            for (StatsBlock block : blocks) {
                pout.print(block.accessAverageMins + ",");
            }
            pout.print("\nAverage Support mins,");
            for (StatsBlock block : blocks) {
                pout.print(block.supportAverageMins + ",");
            }
            pout.print("\nAverage Demo mins,");
            for (StatsBlock block : blocks) {
                pout.print(block.demoAverageMins + ",");
            }
            try {
                this.dumpComparison(null, pout, this.getAllTechs(), blocks, null);
                for (StatsBlock block : blocks) {
                    if (!block.isGroup) continue;
                    ArrayList<StatsBlock> users = new ArrayList<StatsBlock>();
                    for (StatsBlock tech : blocks) {
                        if (!tech.isTechBlock || !tech.comparisons.containsKey(block.key)) continue;
                        users.add(tech);
                    }
                    StatsBlock[] group = users.toArray(new StatsBlock[0]);
                    this.dumpComparison(null, pout, block, group, null);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            pout.flush();
        }
    }

    private void dumpComparison(PdfReportUtil pdf, PrintStream pout, StatsBlock vs, StatsBlock[] group, String subText) throws Exception {
        if (group.length <= 1) {
            return;
        }
        if (pdf == null) {
            pout.println();
            pout.println();
        }
        int totalMinsAverage = 0;
        int accessMinsAverage = 0;
        int supportMinsAverage = 0;
        int demoMinsAverage = 0;
        int totalSessionsAverage = 0;
        int accessSessionsAverage = 0;
        int supportSessionsAverage = 0;
        int demoSessionsAverage = 0;
        int techCount = 0;
        double totalMinsCount = 0.0;
        double accessMinsCount2 = 0.0;
        double supportMinsCount = 0.0;
        double demoMinsCount = 0.0;
        double totalSessionsCount = 0.0;
        double accessSessionsCount = 0.0;
        double supportSessionsCount = 0.0;
        double demoSessionsCount = 0.0;
        for (StatsBlock block : group) {
            if (!block.isTechBlock) continue;
            ++techCount;
            totalSessionsCount += (double)block.allCount;
            accessSessionsCount += (double)block.accessCount;
            supportSessionsCount += (double)block.supportCount;
            demoSessionsCount += (double)block.demoCount;
            totalMinsCount += (double)block.allTotalMins;
            accessMinsCount2 += (double)block.accessTotalMins;
            supportMinsCount += (double)block.supportTotalMins;
            demoMinsCount += (double)block.demoTotalMins;
        }
        totalMinsAverage = (int)(totalMinsCount / (double)techCount);
        accessMinsAverage = (int)(accessMinsCount2 / (double)techCount);
        supportMinsAverage = (int)(supportMinsCount / (double)techCount);
        demoMinsAverage = (int)(demoMinsCount / (double)techCount);
        totalSessionsAverage = (int)(totalSessionsCount / (double)techCount);
        accessSessionsAverage = (int)(accessSessionsCount / (double)techCount);
        supportSessionsAverage = (int)(supportSessionsCount / (double)techCount);
        demoSessionsAverage = (int)(demoSessionsCount / (double)techCount);
        if (pdf != null) {
            String pageTitle = vs.name + " - session count comparison";
            TwinAxisModel model = new TwinAxisModel();
            model.setZeropoint("(see below)");
            StatsBlock[] statsBlockArray = group;
            int accessMinsCount2 = statsBlockArray.length;
            for (int i = 0; i < accessMinsCount2; ++i) {
                StatsBlock block = statsBlockArray[i];
                if (block.isTechBlock) {
                    model.add(block.name, this.ACCESS + " (group avg " + accessSessionsAverage + ")", block.accessCount - accessSessionsAverage);
                }
                if (block.isTechBlock) {
                    model.add(block.name, this.SUPPORT + " (group avg " + supportSessionsAverage + ")", block.supportCount - supportSessionsAverage);
                }
                if (!block.isTechBlock) continue;
                model.add(block.name, this.DEMO + " (group avg " + demoSessionsAverage + ")", block.demoCount - demoSessionsAverage);
            }
            Object chart = new LayeredBarChart();
            ((StackedBarChart)chart).setColors(this.colors);
            ((StackedBarChart)chart).setModel(model);
            byte[] png = ((StackedBarChart)chart).toPNG(1800, 1150);
            pdf.addReportPage(png, pageTitle, subText);
            pageTitle = vs.name + " - total minutes in session comparison";
            model = new TwinAxisModel();
            model.setZeropoint("(see below)");
            for (StatsBlock block : group) {
                if (block.isTechBlock) {
                    model.add(block.name, this.ACCESS + " (group avg " + accessMinsAverage + ")", block.accessTotalMins - accessMinsAverage);
                }
                if (block.isTechBlock) {
                    model.add(block.name, this.SUPPORT + " (group avg " + supportMinsAverage + ")", block.supportTotalMins - supportMinsAverage);
                }
                if (!block.isTechBlock) continue;
                model.add(block.name, this.DEMO + " (group avg " + demoMinsAverage + ")", block.demoTotalMins - demoMinsAverage);
            }
            chart = new LayeredBarChart();
            ((StackedBarChart)chart).setColors(this.colors);
            ((StackedBarChart)chart).setModel(model);
            png = ((StackedBarChart)chart).toPNG(1800, 1150);
            pdf.addReportPage(png, pageTitle, subText);
            pageTitle = vs.name + " - average minutes in session comparison";
            model = new TwinAxisModel();
            model.setZeropoint("(see below)");
            for (StatsBlock block : group) {
                if (block.isTechBlock) {
                    model.add(block.name, this.ACCESS + " (group avg " + vs.accessAverageMins + ")", block.accessAverageMins - vs.accessAverageMins);
                }
                if (block.isTechBlock) {
                    model.add(block.name, this.SUPPORT + " (group avg " + vs.supportAverageMins + ")", block.supportAverageMins - vs.supportAverageMins);
                }
                if (!block.isTechBlock) continue;
                model.add(block.name, this.DEMO + " (group avg " + vs.demoAverageMins + ")", block.demoAverageMins - vs.demoAverageMins);
            }
            chart = new LayeredBarChart();
            ((StackedBarChart)chart).setColors(this.colors);
            ((StackedBarChart)chart).setModel(model);
            png = ((StackedBarChart)chart).toPNG(1800, 1150);
            pdf.addReportPage(png, pageTitle, subText);
        } else {
            String suffix = " vs " + vs.name;
            pout.print(",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.name + ",");
            }
            pout.print("\nSessions" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.allCount - totalSessionsAverage + ",");
            }
            pout.print("\nAccess sessions" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.accessCount - accessSessionsAverage + ",");
            }
            pout.print("\nSupport sessions" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.supportCount - supportSessionsAverage + ",");
            }
            pout.print("\nDemo sesssions" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.demoCount - demoSessionsAverage + ",");
            }
            pout.print("\nTotal mins" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.allTotalMins - totalMinsAverage + ",");
            }
            pout.print("\nAccess mins" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.accessTotalMins - accessMinsAverage + ",");
            }
            pout.print("\nSupport mins" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.supportTotalMins - supportMinsAverage + ",");
            }
            pout.print("\nDemo mins" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.demoTotalMins - demoMinsAverage + ",");
            }
            pout.print("\nAverage mins" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.allAverageMins - vs.allAverageMins + ",");
            }
            pout.print("\nAverage Access mins" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.accessAverageMins - vs.accessAverageMins + ",");
            }
            pout.print("\nAverage Support mins" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.supportAverageMins - vs.supportAverageMins + ",");
            }
            pout.print("\nAverage Demo mins" + suffix + ",");
            for (StatsBlock block : group) {
                if (!block.isTechBlock) continue;
                pout.print(block.demoAverageMins - vs.demoAverageMins + ",");
            }
        }
    }

    private void populate(AbstractSession session, StatsBlock stats) {
        double mins = (double)session.getDuration() / 60000.0;
        ++stats.allCount;
        stats.allTotalMins = (int)((double)stats.allTotalMins + mins);
        if (session instanceof AccessSession) {
            AccessSession acc = (AccessSession)session;
            ++stats.accessCount;
            stats.accessTotalMins = (int)((double)stats.accessTotalMins + mins);
        } else if (session instanceof SupportSession) {
            SupportSession sup = (SupportSession)session;
            ++stats.supportCount;
            stats.supportTotalMins = (int)((double)stats.supportTotalMins + mins);
        } else if (session instanceof DemoSession) {
            DemoSession demo = (DemoSession)session;
            ++stats.demoCount;
            stats.demoTotalMins = (int)((double)stats.demoTotalMins + mins);
        }
    }

    class StatsBlock {
        String key;
        String name;
        boolean isTechBlock = false;
        boolean isGroup = false;
        int allCount = 0;
        int accessCount = 0;
        int supportCount = 0;
        int demoCount = 0;
        int allTotalMins = 0;
        int accessTotalMins = 0;
        int supportTotalMins = 0;
        int demoTotalMins = 0;
        int allAverageMins = 0;
        int accessAverageMins = 0;
        int supportAverageMins = 0;
        int demoAverageMins = 0;
        HashMap<String, StatsBlock> comparisons = new HashMap();

        StatsBlock() {
        }
    }
}

