/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history.reports;

import com.pdfjet.A4;
import com.pdfjet.CoreFont;
import com.pdfjet.Font;
import com.pdfjet.Image;
import com.pdfjet.PDF;
import com.pdfjet.Page;
import com.pdfjet.Paragraph;
import com.pdfjet.TextColumn;
import com.pdfjet.TextLine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class PdfReportUtil {
    PDF pdf;
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    private static Font titleFont;
    private static Font normalFont;
    private static Font normalBold;
    public float MARGIN = 25.0f;
    public float SPACING = 15.0f;
    public float HEADING = 26.0f;
    public float SUBHEADING = 11.0f;

    public PdfReportUtil() throws Exception {
        this.pdf = new PDF((OutputStream)this.bout);
        titleFont = new Font(this.pdf, CoreFont.HELVETICA);
        normalFont = new Font(this.pdf, CoreFont.HELVETICA);
        normalBold = new Font(this.pdf, CoreFont.HELVETICA_BOLD);
    }

    public void addReportPage(byte[] pngImage, String title, String footerText) throws Exception {
        this.addReportPage(new ByteArrayInputStream(pngImage), title, footerText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReportPage(InputStream pngImage, String title, String footerText) throws Exception {
        Image image;
        Page page = new Page(this.pdf, A4.LANDSCAPE);
        float pwidth = page.getWidth();
        float pheight = page.getHeight();
        try {
            image = new Image(this.pdf, pngImage, 1);
        }
        finally {
            pngImage.close();
        }
        int spacing = 7;
        float Y = this.MARGIN;
        TextLine tl = new TextLine(titleFont);
        tl.setFontSize(this.HEADING);
        tl.setLocation(this.MARGIN, Y += this.HEADING);
        tl.setText(title);
        tl.setColor(0x545454);
        tl.drawOn(page);
        image.setLocation(this.MARGIN, Y += (float)spacing);
        image.scaleBy(this.scaleToFullWide(page, image));
        image.drawOn(page);
        Y += this.SUBHEADING;
        tl = new TextLine(normalFont);
        tl.setFontSize(this.SUBHEADING);
        tl.setText(footerText);
        tl.setColor(0x545454);
        Paragraph p1 = new Paragraph();
        p1.setAlignment(0x100000);
        p1.add(tl);
        TextColumn tc = new TextColumn();
        tc.setLocation(0.0f, page.getHeight() - this.MARGIN);
        tc.addParagraph(p1);
        tc.setWidth(page.getWidth() - this.MARGIN);
        tc.drawOn(page);
    }

    public byte[] finish() throws Exception {
        this.bout.flush();
        this.pdf.close();
        return this.bout.toByteArray();
    }

    private float scaleToFullWide(Page page, Image image) {
        return this.getFullWide(page) / image.getWidth();
    }

    private float scaleToHalfWide(Page page, Image image) {
        return this.getHalfWide(page) / image.getWidth();
    }

    private float getFullWide(Page page) {
        float width = page.getWidth();
        return width -= this.MARGIN + this.MARGIN;
    }

    private float getHalfWide(Page page) {
        float width = page.getWidth();
        return (width -= this.MARGIN + this.MARGIN + this.SPACING) / 2.0f;
    }

    public static void main(String[] args) throws Exception {
        PdfReportUtil pdf = new PdfReportUtil();
        pdf.addReportPage(new FileInputStream("/Users/aem/Desktop/stacked.png"), "Title", "Footer");
        byte[] dat = pdf.finish();
        new FileOutputStream("/Users/aem/Desktop/report.pdf").write(dat);
    }
}

