/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history.metrics;

import com.aem.shelp.util.ElapsedTimeFormatter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import utils.swing.color.ConfigurableColor;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.layout.GbPanel;

public class SessionCountPanel {
    private ElapsedTimeFormatter timerFormatter = new ElapsedTimeFormatter();
    private final String title;
    private int minWidth;
    private GbPanel rootComponent = new GbPanel(){

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            d.width = SessionCountPanel.this.minWidth;
            return d;
        }
    };
    private JPanel topPanel = new JPanel(new GridLayout(1, 1));
    private JLabel titleLabel = new JLabel();
    private JPanel middlePanel = new JPanel(new GridLayout(1, 1));
    private JLabel sessionLabel = new JLabel();
    private JPanel bottomPanel = new JPanel(new GridLayout(1, 1));
    private JLabel durationLabel = new JLabel();
    private static Font titleFont = null;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public SessionCountPanel(String title) {
        this.title = title;
        Font font = SessionCountPanel.getTitleFont();
        BufferedImage image = new BufferedImage(1, 1, 1);
        Graphics2D g = image.createGraphics();
        g.setFont(font);
        this.minWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), title) + 10;
        g.dispose();
        this.initUI();
    }

    public int getWidth() {
        return this.minWidth;
    }

    public void setWidth(int width) {
        this.minWidth = width;
    }

    private static TextAttribute getTrackingTextAttribute() {
        try {
            Field field = TextAttribute.class.getDeclaredField("TRACKING");
            if (field != null) {
                return (TextAttribute)field.get(null);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Font getTitleFont() {
        if (titleFont == null) {
            HashMap attributes = new HashMap();
            TextAttribute ta = SessionCountPanel.getTrackingTextAttribute();
            titleFont = SHStyle.largeFont.deriveFont(attributes);
        }
        return titleFont;
    }

    private void initUI() {
        Color borderColor = SHStyle.JPANEL_BACKGROUND_COLOR_BLUE_DARKER;
        this.topPanel.add(this.titleLabel);
        this.middlePanel.add(this.sessionLabel);
        this.bottomPanel.add(this.durationLabel);
        this.rootComponent.add(this.topPanel, 0, 0, 1, 1, 1, 0, 10, 1);
        this.rootComponent.add(this.middlePanel, 0, 1, 1, 1, 1, 1, 10, 1);
        this.rootComponent.add(this.bottomPanel, 0, 2, 1, 1, 1, 1, 10, 1);
        this.titleLabel.setVerticalAlignment(0);
        this.titleLabel.setHorizontalAlignment(0);
        this.sessionLabel.setHorizontalAlignment(0);
        this.durationLabel.setHorizontalAlignment(0);
        this.titleLabel.setFont(SessionCountPanel.getTitleFont());
        this.sessionLabel.setFont(SHStyle.largererFont);
        this.durationLabel.setFont(SHStyle.mediumFont);
        this.titleLabel.setText(this.title);
        this.titleLabel.setForeground(Color.white);
        this.titleLabel.setBorder(SHBorderFactory.createEmptyBorder(5, 0, 2, 0));
        this.topPanel.setBackground(borderColor);
        this.middlePanel.setBorder(SHBorderFactory.createMatteBorder(0, 1, 0, 1, borderColor));
        this.bottomPanel.setBorder(SHBorderFactory.createMatteBorder(0, 1, 1, 1, borderColor));
        Color tempColor = new Color(borderColor.getRGB());
        new ConfigurableColor(tempColor, "SessionCountPanel-" + this.title, this.rootComponent);
        this.sessionLabel.setForeground(tempColor);
        this.middlePanel.setBackground(Color.white);
        this.durationLabel.setForeground(Color.gray);
        this.bottomPanel.setBackground(Color.white);
    }

    public void initWith(int sessions, long duration) {
        if (duration < 0L) {
            duration = 0L;
        }
        this.durationLabel.setVisible(duration > 0L);
        this.durationLabel.setText(this.timerFormatter.getFormattedTime(duration));
        this.sessionLabel.setText(Integer.toString(sessions));
    }

    public void setColorForeground(Color colorForeground) {
        this.sessionLabel.setForeground(colorForeground);
    }
}

