/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.shelp.common.video.VideoUtils;
import com.aem.shelp.mdupload.fs.FSMirror;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.mdupload.fs.TechClientFS;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.AbstractSession;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import utils.dataservice.gziplist.SplitChunkList;

public class SessionDownloader
implements Runnable,
FSMirror.ProgressListener {
    public static final int MAX_SIZE_CHUNK = 51200;
    private boolean die = false;
    private DownloaderListener listener;
    private File targetDirectory;
    private TechClient tc;
    private TechClient.VideoDetails videoDetails;
    private AbstractSession session;
    private long totalTransferred = 0L;
    private ArrayList<File> downloadedFiles = new ArrayList();

    public ArrayList<File> getDownloadedFiles() {
        return this.downloadedFiles;
    }

    public SessionDownloader(TechClient tc, AbstractSession session, TechClient.VideoDetails videoDetails, File targetDirectory, DownloaderListener listener) {
        this.session = session;
        this.videoDetails = videoDetails;
        this.tc = tc;
        this.listener = listener;
        this.targetDirectory = targetDirectory;
    }

    public void die() {
        this.die = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.println("[SessionDownloader] Starting download of " + this.videoDetails.videoID);
        try {
            this.listener.starting(this.videoDetails.videoID);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        boolean worked = true;
        try {
            TechClientFS techFS = new TechClientFS(this.tc, "SG_Server");
            File targetFile = VideoUtils.getServerVideoFile(this.session.getStartTime(), this.session.getSessionID(), ".svf");
            System.out.println("[SessionDownloader] Target file is " + targetFile);
            for (int i = 0; i < this.videoDetails.parts; ++i) {
                File tmpFile = File.createTempFile("shvideo", "tmp");
                BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(tmpFile));
                try {
                    LocalFS localFS = new LocalFS();
                    GFile sourceGFile = LocalFS.getFile(tmpFile);
                    System.out.println("[SessionDownloader] Source GFile is " + sourceGFile.path() + " - " + sourceGFile.name);
                    GFile targetGFile = new GFile(targetFile.getPath(), targetFile.getName(), targetFile.lastModified(), targetFile.length(), targetFile.isDirectory(), targetFile.isHidden());
                    System.out.println("[SessionDownloader] Target GFile is " + targetGFile.path() + " - " + targetGFile.name);
                    new FSMirror().mirror(techFS, targetGFile, localFS, sourceGFile);
                }
                finally {
                    fout.close();
                }
                if (this.die) {
                    worked = false;
                    return;
                }
                File partFile = new File(this.targetDirectory, targetFile.getName());
                System.out.println("[SessionDownloader] Download complete. Renaming local copy:");
                System.out.println("[SessionDownloader] Rename from " + tmpFile.getAbsolutePath());
                System.out.println("[SessionDownloader] Rename to " + partFile.getAbsolutePath());
                worked = worked && tmpFile.renameTo(partFile);
                this.downloadedFiles.add(partFile);
                targetFile = SplitChunkList.iterate(targetFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            worked = false;
        }
        finally {
            try {
                this.listener.done(worked, this.videoDetails.videoID, this.targetDirectory);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void transferred(long bytes) {
        this.totalTransferred += bytes;
        try {
            this.listener.progress(this.videoDetails.videoID, this.totalTransferred, this.videoDetails.lengthInBytes);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void totalSize(long size) {
    }

    @Override
    public boolean cancelled() {
        return false;
    }

    static interface DownloaderListener {
        public void starting(String var1);

        public void progress(String var1, long var2, long var4);

        public void done(boolean var1, String var2, File var3);
    }
}

