/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.util.ErrorDialogs;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import utils.files.FileUtil;
import utils.progtools.StackTracer;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.LeftRightButton;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class MultiSessionPanel
extends GbPanel
implements ActionListener {
    private LeftRightButton exportButton;
    private AbstractSession[] sessions;
    private JLabel summaryLabel;

    public MultiSessionPanel() {
        super(new Insets(3, 3, 3, 3));
        this.initUI();
    }

    private JLabel getDescLabel(String text) {
        JWrapLabel descLabel = new JWrapLabel("<html>" + text);
        descLabel.setFont(SHStyle.smallerFont);
        descLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        return descLabel;
    }

    public void initUI() {
        this.summaryLabel = new JLabel(Language.get("MULTI_SESSION_OPTIONS"));
        this.summaryLabel.setBorder(SHBorderFactory.createEmptyBorder(3, 0, 5, 0));
        this.summaryLabel.setFont(SHStyle.largeFont);
        this.summaryLabel.setVisible(false);
        int Y = 0;
        this.add(this.summaryLabel, 0, Y++, 2, 1, 1, 0, 11, 2);
        this.exportButton = new LeftRightButton(Language.get("EXPORT"), ImageLoader.getImageIcon("images/svg/arrows/share.svg,16"));
        this.exportButton.setRightColour(Color.GRAY);
        this.exportButton.addActionListener(this);
        this.exportButton.setHorizontalAlignment(2);
        JLabel descLabel = this.getDescLabel(Language.get("EXPORT_SESSIONS_DESC"));
        this.add(this.exportButton, 0, Y, 1, 1, 0, 0, 10, 2, new Insets(3, 5, 3, 10));
        this.add(descLabel, 1, Y++, 1, 1, 1000, 0, 17, 2);
        this.add(new JPanel(), 0, Y++, 1, 1, 1, 1, 10, 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.exportButton) {
            this.performExport();
        }
    }

    private void performExport() {
        File file;
        Frame frame = null;
        RootPaneContainer rootPaneContainer = SwingUtil.getRootPaneContainer(this);
        if (rootPaneContainer instanceof Frame) {
            frame = (Frame)((Object)rootPaneContainer);
        }
        FileDialog fd = new FileDialog(frame);
        fd.setDirectory(System.getProperty(System.getProperty("user.home")));
        fd.setMode(1);
        fd.setVisible(true);
        StringBuffer csvOutput = new StringBuffer();
        csvOutput.append(this.sessions[0].csvHeaders()).append("\n");
        for (int i = 0; i < this.sessions.length; ++i) {
            csvOutput.append(this.sessions[i].toCSV()).append("\n");
        }
        String name = fd.getFile();
        if (name.indexOf(46) == -1) {
            name = name + ".csv";
        }
        if ((file = new File(fd.getDirectory(), name)).exists()) {
            file.delete();
        }
        try {
            FileUtil.writeFile(file, csvOutput.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            ErrorDialogs.ErrorGlassDialog ui = new ErrorDialogs.ErrorGlassDialog(SwingUtil.getRootPaneContainer(this), Language.get("SAVE_TO_CSV_ERROR"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), false);
            ui.setText(Language.get("SAVE_TO_CSV_ERROR"), Language.get("SAVE_TO_CSV_ERROR_DESC"), StackTracer.getStacktrace(e));
            ui.setVisible(true);
        }
    }

    public void setSelectedSessions(AbstractSession[] sessions) {
        this.sessions = sessions;
        this.summaryLabel.setVisible(true);
        this.exportButton.setLeftRightText(Language.get("EXPORT"), "" + sessions.length);
    }
}

