/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.hierarchy.utils;

import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.hierarchy.model.TreeElementComparator;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public abstract class TreeSelection<TG extends TreeGroup<TG, TE>, TE extends TreeElement>
implements Iterable<TE> {
    private HashMap<TG, SelectedGroup> groups = new HashMap();
    public int groupCount = 0;
    public int machineCount = 0;

    public SelectedGroup getFirstSelectedGroup() {
        Iterator<SelectedGroup> iterator = this.groups.values().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public void clearSelection() {
        this.groups.clear();
    }

    public int getMachineCount() {
        return this.machineCount;
    }

    protected abstract TE[] initElementArray(int var1);

    public ArrayList<SelectedGroup> getSelection() {
        return new ArrayList<SelectedGroup>(this.groups.values());
    }

    public void addMachines(TG group, TE[] groupSelection) {
        SelectedGroup selectedGroup = this.groups.get(group);
        if (selectedGroup == null) {
            selectedGroup = new SelectedGroup(this, group);
            this.groups.put(group, selectedGroup);
            ++this.groupCount;
        }
        for (TE m : groupSelection) {
            if (!selectedGroup.machines.add(m)) continue;
            ++this.machineCount;
            this.addMachineToStats(m);
        }
    }

    public void removeMachines(TG group, TE[] machines) {
        SelectedGroup selectedGroup = this.groups.get(group);
        if (selectedGroup == null) {
            return;
        }
        for (TE m : machines) {
            if (!selectedGroup.machines.remove(m)) continue;
            --this.machineCount;
            this.removeMachineFromStats(m);
        }
        if (selectedGroup.machines.size() == 0) {
            this.groups.remove(group);
            --this.groupCount;
        }
    }

    protected void removeMachineFromStats(TE m) {
    }

    public TE[] getAllElements() {
        ArrayList<TreeElement> result = new ArrayList<TreeElement>();
        for (TreeElement machine : this) {
            result.add(machine);
        }
        return result.toArray(this.initElementArray(0));
    }

    @Override
    public Iterator<TE> iterator() {
        return new MachineIterator();
    }

    protected void addMachineToStats(TE m) {
    }

    class MachineIterator
    implements Iterator<TE> {
        private Iterator<SelectedGroup> groupsIterator;
        private SelectedGroup currentGroup;
        private Iterator<TE> machinesIterator;
        private TE nextMachine = null;

        public MachineIterator() {
            this.groupsIterator = TreeSelection.this.groups.values().iterator();
            if (this.groupsIterator.hasNext()) {
                this.currentGroup = this.groupsIterator.next();
                this.machinesIterator = this.currentGroup.machines.iterator();
                if (this.machinesIterator.hasNext()) {
                    this.nextMachine = (TreeElement)this.machinesIterator.next();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextMachine != null;
        }

        @Override
        public TE next() {
            Object machine = this.nextMachine;
            if (this.machinesIterator.hasNext()) {
                this.nextMachine = (TreeElement)this.machinesIterator.next();
            } else {
                this.nextMachine = null;
                while (this.groupsIterator.hasNext() && this.nextMachine == null) {
                    this.currentGroup = this.groupsIterator.next();
                    this.machinesIterator = this.currentGroup.machines.iterator();
                    if (!this.machinesIterator.hasNext()) continue;
                    this.nextMachine = (TreeElement)this.machinesIterator.next();
                }
            }
            return machine;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SelectedGroup {
        public TG group;
        public TreeSet<TE> machines = new TreeSet<TreeElement>(TreeElementComparator.INSTANCE);
        final /* synthetic */ TreeSelection this$0;

        public SelectedGroup(TG group) {
            this.this$0 = this$0;
            this.group = group;
        }

        public SelectedGroup(TG group, TE machine) {
            this(this$0, group);
            this.machines.add(machine);
        }

        public boolean equals(Object o) {
            return ((SelectedGroup)o).equals(this.group);
        }

        public int hashCode() {
            return ((TreeGroup)this.group).hashCode();
        }

        public TE getFirstMachine() {
            Iterator iterator = this.machines.iterator();
            if (iterator.hasNext()) {
                return (TreeElement)iterator.next();
            }
            return null;
        }
    }
}

