/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.hierarchy.ui;

import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public abstract class GroupPanelLabel<TG extends TreeGroup<TG, TE>, TE extends TreeElement>
extends JPanel
implements ActionListener {
    public static final Border BORDER_TOP_BOTTOM = SHBorderFactory.createCompoundBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, AccessStyle.GROUP_TITLE_BORDER_TOP), SHBorderFactory.createMatteBorder(0, 0, 1, 0, AccessStyle.GROUP_TITLE_BORDER_BOTTOM)), SHBorderFactory.createMatteBorder(1, 0, 0, 0, Color.WHITE));
    public static final Border BORDER_TOP = SHBorderFactory.createMatteBorder(0, 0, 1, 0, AccessStyle.GROUP_TITLE_BORDER_BOTTOM);
    public static final Border BORDER_PADDED = SHBorderFactory.createCompoundBorder(BORDER_TOP_BOTTOM, SHBorderFactory.createEmptyBorder(4, 4, 4, 4));
    public static final Border BORDER_PADDED_TRIM = SHBorderFactory.createCompoundBorder(BORDER_TOP, SHBorderFactory.createEmptyBorder(4, 4, 4, 4));
    protected TG group;

    public abstract void updateWithNewStats();

    public TG getGroup() {
        return this.group;
    }

    protected void initUI(boolean isFirstGroupAdded) {
        this.setBackground(AccessStyle.GROUP_TITLE_BACKGROUND);
        if (!isFirstGroupAdded) {
            this.setBorder(BORDER_PADDED);
        } else {
            this.setBorder(BORDER_PADDED_TRIM);
        }
        this.setLayout(new BorderLayout());
        JLabel label = new JLabel(((TreeGroup)this.group).groupName);
        GroupLabel hierarchy = new GroupLabel((TreeGroup)this.group);
        hierarchy.setBackground(this.getBackground());
        hierarchy.setForeground(AccessStyle.HEADER_TITLE_COLOR);
        hierarchy.setFont(new Font(null, 0, SimpleHelpLookAndFeel.scale(9)));
        label.setForeground(AccessStyle.GROUP_TITLE_FONT_COLOR_BOLD);
        label.setFont(AccessStyle.GROUP_TITLE_FONT);
        this.add((Component)label, "West");
        this.add((Component)hierarchy, "South");
    }

    public class GroupLabel
    extends JPanel {
        private TreeGroup group;

        public GroupLabel(TreeGroup group) {
            this.group = group;
        }

        @Override
        public Dimension getPreferredSize() {
            int height;
            Dimension dim = super.getPreferredSize();
            dim.height = height = this.getFontMetrics(this.getFont()).getHeight() + 2;
            return dim;
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(this.getFont());
            g.setColor(this.getForeground());
            int height = this.getHeight() / 2 + g.getFontMetrics().getHeight() / 2;
            this.paintGroup((TreeGroup)this.group.getParent(), g, 0, height, g.getFontMetrics());
        }

        public int paintGroup(TreeGroup group, Graphics g, int x, int y, FontMetrics fm) {
            boolean first;
            if (group == null || group.getParent() == null) {
                return x;
            }
            int oldX = x;
            boolean bl = first = oldX == (x = this.paintGroup((TreeGroup)group.getParent(), g, x, y, fm));
            if (!first) {
                int padding = 3;
                String delimiter = " \u27e9 ";
                int delimiterWidth = SwingUtilities.computeStringWidth(fm, delimiter);
                g.setColor(AccessStyle.DELIMITER_COLOR);
                g.drawString(delimiter, x += padding, y);
                x += delimiterWidth + padding;
            }
            String name = group.groupName.trim();
            int width = SwingUtilities.computeStringWidth(fm, name);
            g.setColor(this.getForeground());
            g.drawString(name, x, y);
            return x += width;
        }
    }
}

