/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.hierarchy.ui;

import com.aem.shelp.tech.access.HierarchyPanelListener;
import com.aem.shelp.tech.hierarchy.model.AbstractModelChangeListener;
import com.aem.shelp.tech.hierarchy.model.AbstractTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupsList;
import com.aem.shelp.tech.hierarchy.ui.GroupPanelLabel;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class AbstractGroupPanel<TG extends TreeGroup<TG, TE>, TE extends TreeElement>
implements AbstractModelChangeListener<TG, TE> {
    protected JPanel rootComponent = new JPanel(new BorderLayout());
    protected HierarchyPanelListener panelListener;
    protected TG group;
    protected AbstractTreeModel<TG, TE> machineModel;
    protected AbstractGroupsList<TG, TE> groupsList;
    private final GroupTitleClickListener clickListener = new GroupTitleClickListener();
    private GroupPanelLabel<TG, TE> groupLabel;

    @Override
    public void filterProcessorChanged() {
    }

    protected abstract GroupPanelLabel<TG, TE> initLabel(HierarchyPanelListener var1, TG var2, boolean var3);

    public AbstractGroupPanel(AbstractTreeModel<TG, TE> machineModel, TG group, HierarchyPanelListener panelListener, boolean isFirstGroupAdded, AbstractGroupsList<TG, TE> groupsList) {
        this.machineModel = machineModel;
        this.panelListener = panelListener;
        this.group = group;
        this.groupsList = groupsList;
        this.groupLabel = this.initLabel(panelListener, group, isFirstGroupAdded);
        this.rootComponent.add(this.groupLabel, "North");
        this.groupLabel.setVisible(false);
        this.groupLabel.addMouseListener(this.clickListener);
    }

    public GroupPanelLabel<TG, TE> getGroupHeader() {
        return this.groupLabel;
    }

    public AbstractGroupsList<TG, TE> getGroupsList() {
        return this.groupsList;
    }

    protected void selectAllElements() {
        this.selectAllElementsInGroup(this.group);
    }

    protected abstract boolean allElementsSelected();

    protected abstract void selectAllElementsInGroup(TG var1);

    protected abstract void clearSelection();

    protected abstract void selectElements(boolean var1);

    protected abstract void selectLastElement();

    protected abstract void selectFirstElement();

    public abstract TE[] getSelectedElements();

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public void setAccessPanelListener(HierarchyPanelListener panelListener) {
        this.panelListener = panelListener;
    }

    public abstract boolean isEmpty();

    public abstract void ensureElementIsSelected(TG var1, TE var2);

    class GroupTitleClickListener
    extends MouseAdapter {
        GroupTitleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!AbstractGroupPanel.this.allElementsSelected()) {
                AbstractGroupPanel.this.selectAllElementsInGroup(AbstractGroupPanel.this.groupLabel.getGroup());
            } else {
                AbstractGroupPanel.this.clearSelection();
            }
        }
    }
}

