/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.hierarchy.model;

import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import java.util.Comparator;

public class TreeElementComparator
implements Comparator<TreeElement> {
    public static TreeElementComparator INSTANCE = new TreeElementComparator(false);
    public static TreeElementComparator INSTANCE_WITH_GROUP = new TreeElementComparator(true);
    private boolean includeGroups;

    private TreeElementComparator(boolean includeGroups) {
        this.includeGroups = includeGroups;
    }

    @Override
    public int compare(TreeElement o1, TreeElement o2) {
        int result;
        if (!this.includeGroups) {
            result = o1.getName().getName().toLowerCase().compareTo(o2.getName().getName().toLowerCase());
        } else {
            MachineName name1 = o1.getName();
            MachineName name2 = o2.getName();
            int res = this.compareGroups(name1.getGroup(), name2.getGroup());
            result = res != 0 ? res : o1.getName().compareTo(o2.getName());
        }
        if (result == 0) {
            String id1 = o1.getID() + "";
            String id2 = o2.getID() + "";
            return id1.compareTo(id2);
        }
        return result;
    }

    private int compareGroups(String[] g1, String[] g2) {
        if (g1 == null && g2 == null) {
            return 0;
        }
        if (g1 == null) {
            return -1;
        }
        if (g2 == null) {
            return 1;
        }
        int minSize = Math.min(g1.length, g2.length);
        for (int i = 0; i < minSize; ++i) {
            int res = g1[i].compareTo(g2[i]);
            if (res == 0) continue;
            return res;
        }
        if (g1.length < g2.length) {
            return -1;
        }
        if (g1.length > g2.length) {
            return 1;
        }
        return 0;
    }
}

