/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.hierarchy.model;

import com.aem.CentralDebugging;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.tech.access.model.subgroups.FilterResultsGroup;
import com.aem.shelp.tech.hierarchy.model.AbstractModelChangeListener;
import com.aem.shelp.tech.hierarchy.model.MachineUpdateResult;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.hierarchy.model.TreeElementComparator;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import com.aem.shelp.tech.hierarchy.model.TreeNodeFilterProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import utils.progtools.SingleThreadRunner;
import utils.string.SafeCmp;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.SimpleLock;
import utils.swing.simplelist.jtree.SimpleTreeModel;
import utils.xml.XML14Util;

public abstract class AbstractTreeModel<TG extends TreeGroup<TG, TE>, TE extends TreeElement> {
    protected SimpleTreeModel<TG> treeModel = new SimpleTreeModel();
    protected SimpleLock LOCK = new SimpleLock();
    protected ArrayList<AbstractModelChangeListener<TG, TE>> listeners = new ArrayList();
    protected AutoUpdateModelListener modelListener = new AutoUpdateModelListener();
    protected TG rootElementGroup;
    protected ArrayList<TreeNodeFilterProcessor<TG, TE>> filterProcessors = new ArrayList();
    private FilterChangeListener filterListener = new FilterChangeListener();
    private TreeSet<TG> groupsNeedingUpdate = new TreeSet();
    private HashMap<String, TE> rootElementIdToElementMap = new HashMap();
    private SingleThreadRunner singleThreadRunner = new SingleThreadRunner();
    static long descendentsTime = 0L;
    static long listenerTime = 0L;
    static long updateTime = 0L;
    static long addTime = 0L;
    static long[] listenerTimes = new long[10];
    boolean isBatch = false;

    public AbstractTreeModel() {
        this.rootElementGroup = this.initRootGroup();
        this.addRootGroupToModel();
        this.addFilterProcessors();
        this.addModelChangeListener(this.filterListener);
        this.treeModel.getTreeModel().addTreeModelListener(this.modelListener);
        this.treeModel.setModelEditorListener(new SimpleTreeModel.TreeModelEditorListener(){

            @Override
            public void valueForPathChanged(TreePath path, Object newValue) {
                TreeGroup group = (TreeGroup)((SimpleTreeModel.TreeNode)path.getLastPathComponent()).value;
                group.groupName = newValue.toString();
            }
        });
    }

    protected abstract String getXMLRootTag();

    public TE getElementWithID(String machineID) {
        return (TE)((TreeElement)this.rootElementIdToElementMap.get(machineID));
    }

    protected void addRootGroupToModel() {
        this.treeModel.addChild(null, this.rootElementGroup);
    }

    protected abstract void addFilterProcessors();

    protected abstract TG initRootGroup();

    protected void insertSpecialRootGroup(TG group) {
    }

    public SimpleTreeModel.TreeModelImplementation getTreeModel() {
        return this.treeModel.getTreeModel();
    }

    public TG getOrCreateGroup(String[] path) {
        if (path == null || path.length == 0) {
            return this.rootElementGroup;
        }
        return this.getOrCreateGroup(this.rootElementGroup, path, null);
    }

    public abstract TG newGroup(String var1);

    public void renameGroup(TG group, String newName) {
        TreeNodeFilterProcessor<TG, TE> filterAncestor = this.getFilterAncestor(group);
        if (filterAncestor != null) {
            this.removeFilterProcessor(filterAncestor);
        }
        this.removeGroup(group);
        ((TreeGroup)group).groupName = newName;
        this.treeModel.addChild(((TreeGroup)group).getParent(), group, true, true);
        if (filterAncestor != null) {
            this.addFilterProcessor(filterAncestor, group, false);
        }
    }

    public void renameGroup(TG group, String newName, int groupIndex) {
        try {
            TreeNodeFilterProcessor<TG, TE> filterAncestor = this.getFilterAncestor(group);
            if (filterAncestor != null) {
                this.removeFilterProcessor(filterAncestor);
            }
            TreeGroup groupInModel = (TreeGroup)this.treeModel.getChild(((TreeGroup)group).getParent(), groupIndex);
            groupInModel.groupName = newName;
            this.treeModel.ensureCorrectOrdering(((TreeGroup)group).getParent(), groupInModel);
            if (filterAncestor != null) {
                this.addFilterProcessor(filterAncestor, group, false);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void addFromHierarchy(GroupWrapper wrapper, GroupHierarchyHelper helper) {
        for (GroupWrapper childWrapper : wrapper.getChildren()) {
            this.treeModel.addChild(wrapper.group, childWrapper.group, true, true);
            this.addFromHierarchy(childWrapper, helper);
        }
    }

    private void addToHierarchy(GroupHierarchyHelper helper, GroupWrapper wrapper) {
        TreeGroup[] childGroups;
        for (TreeGroup group : childGroups = this.getGroupsIn((TreeGroup)wrapper.getGroup())) {
            GroupWrapper childWrapper = helper.addChild(wrapper, group);
            this.addToHierarchy(helper, childWrapper);
        }
    }

    public Comparator<TreeElement> getElementComparator() {
        return TreeElementComparator.INSTANCE_WITH_GROUP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElements(TE[] machines) {
        Arrays.sort(machines, this.getElementComparator());
        int count = 0;
        this.startBatchAddMachines();
        try {
            String[] previousGroupPath = null;
            ArrayList<TE> previousGroupMachines = new ArrayList<TE>();
            boolean first = true;
            for (TE machine : machines) {
                String[] newGroupPath;
                if (first) {
                    previousGroupPath = machine.getName().getGroup();
                    first = false;
                }
                if (++count % 1000 == 0) {
                    this.endBatchAddMachines();
                    this.startBatchAddMachines();
                }
                if (!this.arePathsEqual(previousGroupPath, newGroupPath = machine.getName().getGroup())) {
                    TG parentGroup = this.getOrCreateGroup(previousGroupPath);
                    this.addElements((TreeGroup)parentGroup, previousGroupMachines.toArray(this.initElementArray(0)), true);
                    previousGroupPath = newGroupPath;
                    previousGroupMachines.clear();
                }
                previousGroupMachines.add(machine);
            }
            TG parentGroup = this.getOrCreateGroup(previousGroupPath);
            this.addElements((TreeGroup)parentGroup, previousGroupMachines.toArray(this.initElementArray(0)), true);
        }
        finally {
            this.endBatchAddMachines();
        }
    }

    private boolean arePathsEqual(String[] first, String[] second) {
        if (first == null && second == null) {
            return true;
        }
        if (first != null && second != null) {
            return Arrays.equals(first, second);
        }
        return false;
    }

    private TE[] addElements(TG parent, TE[] machines) {
        return this.addElements((TreeGroup)parent, (TreeElement[])machines, true);
    }

    private TE[] addElements(TG parent, TE[] machines, boolean isInAvailableBranch) {
        if (CentralDebugging.TECH_UI_ACCESS_MODEL) {
            System.out.println("[MachineTreeModel] [addElements] Adding " + machines.length + " to " + Arrays.toString(this.getGroupPath(parent)) + " (isInAvailableBranch=" + isInAvailableBranch + ")");
        }
        if (machines.length == 0) {
            return machines;
        }
        MachineUpdateResult result = parent.appendMachines(machines);
        if (isInAvailableBranch) {
            for (TreeElement m : result.addedMachines) {
                this.rootElementIdToElementMap.put(m.getID(), m);
            }
        }
        TreeElement[] addedMachineArray = result.addedMachines.toArray(this.initElementArray(0));
        TreeElement[] removedMachineArray = result.removedMachines.toArray(this.initElementArray(0));
        TreeElement[] updatedMachineArray = result.updatedMachines.toArray(this.initElementArray(0));
        if (CentralDebugging.TECH_UI_ACCESS_MODEL) {
            System.out.println("[MachineTreeModel] [addElements] Add resulted in " + addedMachineArray.length + " adds, " + removedMachineArray.length + " removes, " + updatedMachineArray.length + " updated.");
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).machinesChanged((TreeGroup)parent, addedMachineArray, removedMachineArray, updatedMachineArray, result.updatedMachineChanges);
        }
        this.updateAncestorGroupsAndLock(parent);
        return addedMachineArray;
    }

    protected void startBatchAddMachines() {
        this.warnEDT();
        this.LOCK.getReadWriteLock();
        this.groupsNeedingUpdate.clear();
        this.isBatch = true;
    }

    protected void endBatchAddMachines() {
        try {
            this.isBatch = false;
            for (TreeGroup group : this.groupsNeedingUpdate) {
                if (!this.treeModel.contains(group)) continue;
                this.treeModel.update(group);
            }
        }
        finally {
            this.LOCK.releaseReadWriteLock();
        }
    }

    public void updateGroup(TG group) {
        this.treeModel.update(group);
    }

    public void removeGroups(TG[] groups) {
        for (TG group : groups) {
            this.treeModel.remove(group);
        }
    }

    public void removeGroups(Collection<TG> groups) {
        for (TreeGroup group : groups) {
            this.treeModel.remove(group);
        }
    }

    public void removeGroup(TG group) {
        this.treeModel.remove(group);
    }

    public void removeGroupByIndex(TG parent, int childIndex) {
        this.treeModel.remove(parent, childIndex);
    }

    private void updateAncestorGroupsAndLock(TG parent) {
        UpdateAncestorRunner runner = new UpdateAncestorRunner(this, parent);
        if (SwingUtilities.isEventDispatchThread()) {
            this.singleThreadRunner.addJob(runner);
        } else {
            runner.run();
        }
    }

    private ArrayList<TG> getAncestorGroupsToUpdate(TG parent) {
        ArrayList result = new ArrayList();
        this.getAncestorGroupsToUpdate(parent, result);
        return result;
    }

    private void getAncestorGroupsToUpdate(TG parent, ArrayList<TG> result) {
        if (parent == null) {
            return;
        }
        result.add(parent);
        this.getAncestorGroupsToUpdate(((TreeGroup)parent).getParent(), result);
    }

    private void updateAncestorGroups(TG parent) {
        if (parent == null) {
            return;
        }
        if (!this.isBatch) {
            this.treeModel.update(parent);
        } else {
            this.groupsNeedingUpdate.add(parent);
        }
        this.updateAncestorGroups(((TreeGroup)parent).getParent());
    }

    private void warnEDT() {
        if (SwingUtilities.isEventDispatchThread()) {
            new Exception("TreeModel on EDT Warning").printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElements(TE[] machines) {
        Arrays.sort(machines, TreeElementComparator.INSTANCE_WITH_GROUP);
        int count = 0;
        this.startBatchAddMachines();
        try {
            String[] previousGroupPath = null;
            ArrayList<TE> previousGroupMachines = new ArrayList<TE>();
            for (TE machine : machines) {
                String[] newGroupPath;
                if (++count % 1000 == 0) {
                    this.endBatchAddMachines();
                    this.startBatchAddMachines();
                }
                if (!this.arePathsEqual(previousGroupPath, newGroupPath = machine.getName().getGroup())) {
                    if (previousGroupPath != null) {
                        TG parentGroup = this.getOrCreateGroup(previousGroupPath);
                        this.removeElements((TreeGroup)parentGroup, previousGroupMachines.toArray(this.initElementArray(0)));
                    }
                    previousGroupPath = newGroupPath;
                    previousGroupMachines.clear();
                }
                previousGroupMachines.add(machine);
            }
            TG parentGroup = this.getOrCreateGroup(previousGroupPath);
            this.removeElements((TreeGroup)parentGroup, previousGroupMachines.toArray(this.initElementArray(0)));
        }
        finally {
            this.endBatchAddMachines();
        }
    }

    private TE[] removeElements(TG parent, TE[] machines) {
        return this.removeElements((TreeGroup)parent, (TreeElement[])machines, true);
    }

    private TE[] removeElements(TG parent, TE[] machines, boolean isInAvailableBranch) {
        if (CentralDebugging.TECH_UI_ACCESS_MODEL) {
            System.out.println("[MachineTreeModel] Removing " + machines.length + " from " + Arrays.toString(this.getGroupPath(parent)) + " (in available branch = " + isInAvailableBranch + ")");
        }
        TreeElement[] removedMachines = parent.removeElements(machines);
        if (CentralDebugging.TECH_UI_ACCESS_MODEL) {
            System.out.println("[MachineTreeModel] Managed to remove " + removedMachines.length + " machines");
        }
        if (isInAvailableBranch) {
            for (TreeElement m : removedMachines) {
                this.rootElementIdToElementMap.remove(m.getID());
            }
        }
        for (AbstractModelChangeListener abstractModelChangeListener : this.listeners) {
            abstractModelChangeListener.machinesChanged((TreeGroup)parent, null, removedMachines, null, null);
        }
        if (((TreeGroup)parent).getElements().size() == 0) {
            int n;
            if (CentralDebugging.TECH_UI_ACCESS_MODEL) {
                System.out.println("[MachineTreeModel] Parent group " + Arrays.toString(this.getGroupPath(parent)) + " is now empty. Pruning.");
            }
            Object parentGroup = parent;
            int n2 = ((TreeGroup)parentGroup).getElementCount();
            int groupCount = this.treeModel.getChildCount(parentGroup);
            while (n == 0 && groupCount == 0) {
                if (((TreeGroup)parentGroup).getParent() == null) {
                    if (this.isFilterGroupThatShouldBeRemoved(parentGroup)) {
                        this.treeModel.remove(parentGroup);
                    }
                    break;
                }
                boolean result = this.treeModel.remove(parentGroup);
                if (CentralDebugging.TECH_UI_ACCESS_MODEL) {
                    System.out.println("[MachineTreeModel] Removed " + Arrays.toString(this.getGroupPath(parentGroup)) + " : success = " + result);
                }
                parentGroup = ((TreeGroup)parentGroup).getParent();
                groupCount = this.treeModel.getChildCount(parentGroup);
                n = ((TreeGroup)parentGroup).getElementCount();
            }
        } else {
            this.updateAncestorGroupsAndLock(parent);
        }
        return removedMachines;
    }

    public abstract TG[] initGroupArray(int var1);

    public abstract TE[] initElementArray(int var1);

    public TE[] initElementArray(TE o) {
        TreeElement[] array = this.initElementArray(1);
        array[0] = o;
        return array;
    }

    public int getChildGroupCount(TG group) {
        SimpleTreeModel.TreeNode<TG> parent = this.treeModel.getTreeNodeFor(group);
        if (parent == null) {
            return 0;
        }
        return parent.children.size();
    }

    public TG[] getGroupsIn(TG group) {
        SimpleTreeModel.TreeNode<TG> parent = this.treeModel.getTreeNodeFor(group);
        if (parent == null) {
            return null;
        }
        TreeGroup[] result = this.initGroupArray(parent.children.size());
        for (int i = 0; i < parent.children.size(); ++i) {
            result[i] = (TreeGroup)parent.children.get((int)i).value;
        }
        return result;
    }

    protected boolean containsRootGroup(TG group) {
        SimpleTreeModel.TreeNode<Object> parent = this.treeModel.getTreeNodeFor(null);
        return parent.getChildWithValue(group) != null;
    }

    public void getGroupPath(TG parent, ArrayList<String> path) {
        if (((TreeGroup)parent).getParent() == null) {
            return;
        }
        this.getGroupPath(((TreeGroup)parent).getParent(), path);
        path.add(((TreeGroup)parent).groupName);
    }

    public String[] getGroupPath(TG group) {
        ArrayList<String> path = new ArrayList<String>();
        this.getGroupPath(group, path);
        return path.toArray(new String[0]);
    }

    public void matchGroupIndices(TG original, TG change) {
        if (original == null || change == null || ((TreeGroup)original).getParent() == null || ((TreeGroup)change).getParent() == null) {
            return;
        }
        SimpleTreeModel.TreeNode<TG> tgTreeNode = this.treeModel.reIndexMapRemove(change);
        ((TreeGroup)change).setGroupIndex(((TreeGroup)original).getGroupIndex());
        this.treeModel.reIndexMapAdd(change, tgTreeNode);
        this.matchGroupIndices(((TreeGroup)original).getParent(), ((TreeGroup)change).getParent());
    }

    protected void createSubtreeForNewFilter(TreeNodeFilterProcessor<TG, TE> newFilter, TG oldGroup) {
        int oldChildCount = this.treeModel.getChildCount(oldGroup);
        for (int i = 0; i < oldChildCount; ++i) {
            TreeGroup child = (TreeGroup)this.treeModel.getChild(oldGroup, i);
            this.createSubtreeForNewFilter(newFilter, child);
        }
        String[] result = this.getGroupPath(oldGroup);
        TreeElement[] includedMachines = this.filterListener.getIncludedMachines(newFilter, ((TreeGroup)oldGroup).getElements());
        if (includedMachines.length > 0) {
            TG metadataParentGroup = this.getOrCreateGroup(newFilter.getRoot(), result, newFilter.getMetadata());
            this.addElements((TreeGroup)metadataParentGroup, includedMachines, false);
        }
    }

    protected void updateFilterProcessorsFor(TE element) {
        TG currentGroup = this.getOrCreateGroup(element.getName().getGroup());
        this.filterListener.machinesChanged((TreeGroup)currentGroup, this.initElementArray(0), this.initElementArray(0), this.initElementArray((TreeElement)element), null);
    }

    public boolean groupExistsEquals(TG parent, TG group) {
        return this.treeModel.getChildWithValueThatEquals(parent, group) != null;
    }

    public boolean groupExistsSameObject(TG parent, TG group) {
        SimpleTreeModel.TreeNode<TG> parentNode = this.treeModel.getTreeNodeFor(parent);
        for (SimpleTreeModel.TreeNode child : parentNode.children) {
            if (child.value != group) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterProcessor(TreeNodeFilterProcessor<TG, TE> searchFilter, TG searchResultGroup, boolean temporarySearch) {
        ArrayList<TreeNodeFilterProcessor<TG, TE>> arrayList = this.filterProcessors;
        synchronized (arrayList) {
            if (!this.filterProcessors.contains(searchFilter)) {
                this.filterProcessors.add(searchFilter);
            }
        }
        if (!this.groupExistsSameObject(null, searchResultGroup)) {
            this.addFilterProcessorGroup(searchResultGroup, temporarySearch);
        }
        this.createSubtreeForNewFilter(searchFilter, this.rootElementGroup);
        this.notifyFilterProcessorChange();
    }

    protected void addFilterProcessorGroup(TG searchResultGroup, boolean temporarySearch) {
        this.treeModel.addChild(null, searchResultGroup);
    }

    public void moveElements(TG currentGroup, TE[] machines, TG newGroup) {
        TreeElement[] removedElements;
        if (CentralDebugging.TECH_UI_ACCESS_MODEL) {
            System.out.println("[AbstractTreeModel] Moving " + machines.length + " machine from " + currentGroup + " to " + newGroup);
        }
        if ((removedElements = this.removeElements((TreeGroup)currentGroup, (TreeElement[])machines, true)).length == 0) {
            return;
        }
        String[] newGroupPath = this.getGroupPath(newGroup);
        if (CentralDebugging.TECH_UI_ACCESS_MODEL) {
            System.out.println("[AbstractTreeModel] Setting machine's group to " + newGroupPath);
        }
        for (TE m : machines) {
            m.getName().setGroup(newGroupPath);
        }
        this.addElements((TreeGroup)newGroup, (TreeElement[])machines, true);
    }

    public void saveToXML(StringBuffer xml) {
        xml.append("<" + this.getXMLRootTag() + ">\n");
        for (TreeNodeFilterProcessor<TG, TE> process : this.filterProcessors) {
            if (!(process.getRoot() instanceof FilterResultsGroup) || ((FilterResultsGroup)process.getRoot()).isTemporary()) continue;
            process.saveToXML(xml);
        }
        this.appendSpecificFilterProcessorXML(xml);
        xml.append("</" + this.getXMLRootTag() + ">\n");
    }

    protected void appendSpecificFilterProcessorXML(StringBuffer xml) {
    }

    public void loadFromXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        if (xml == null || xml.length() == 0) {
            return;
        }
        Element root = XML14Util.parseXML(xml);
        ArrayList<Element> children = XML14Util.getChildren(root, "FilterProcessor");
        for (Element filterProcessor : children) {
            this.loadFilterProcessor(filterProcessor);
        }
    }

    protected abstract void loadFilterProcessor(Element var1);

    public void renameElement(TG parent, TE machine, MachineName newName) {
        TreeElement[] array = this.initElementArray((TreeElement)machine);
        parent.removeElements(array);
        for (AbstractModelChangeListener<TG, TE> listener : this.listeners) {
            listener.machinesChanged((TreeGroup)parent, null, array, null, null);
        }
        machine.setName(newName);
        parent.appendMachines(array);
        for (AbstractModelChangeListener<TG, TE> listener : this.listeners) {
            listener.machinesChanged((TreeGroup)parent, array, null, null, null);
        }
    }

    public void updateMachine(TE machine) {
        boolean isMove;
        TreeElement existingMachine = (TreeElement)this.rootElementIdToElementMap.get(machine.getID());
        if (existingMachine == null) {
            System.out.println("[Warning] Attempting to update a machine that does not exist? " + machine.getID());
            return;
        }
        TG currentGroup = this.getOrCreateGroup(existingMachine.getName().getGroup());
        boolean bl = isMove = !SafeCmp.equal(existingMachine.getName().getGroup(), machine.getName().getGroup());
        if (isMove) {
            TG newGroup = this.getOrCreateGroup(machine.getName().getGroup());
            this.moveElements((TreeGroup)currentGroup, this.initElementArray((TreeElement)machine), (TreeGroup)newGroup);
        } else {
            Machine.MachineChanges copyStateFrom = existingMachine.copyStateFrom((TreeElement)machine);
            if (!copyStateFrom.nameChange) {
                for (AbstractModelChangeListener<TG, TE> listener : this.listeners) {
                    listener.machinesChanged((TreeGroup)currentGroup, null, null, this.initElementArray(existingMachine), copyStateFrom);
                }
            } else {
                this.renameElement(currentGroup, existingMachine, machine.getName());
            }
            for (Object newParent = ((TreeGroup)currentGroup).getParent(); newParent != null; newParent = ((TreeGroup)newParent).getParent()) {
                ((TreeGroup)newParent).getGroupStats().descendentUpdated(copyStateFrom);
            }
        }
    }

    public void removeMachineFromFilter(TE machine, TreeNodeFilterProcessor<TG, TE> filter) {
        TreeElement existingMachine = (TreeElement)this.rootElementIdToElementMap.get(machine.getID());
        if (existingMachine == null) {
            return;
        }
        TG currentGroup = this.getOrCreateGroup(filter.getRoot(), existingMachine.getName().getGroup(), filter.getMetadata());
        this.removeElements((TreeGroup)currentGroup, this.initElementArray((TreeElement)machine));
    }

    public TG translatedGroupIntoAvailableMachinesTree(TG filteredGroup) {
        String[] path = this.getGroupPath(filteredGroup);
        return this.getOrCreateGroup(path);
    }

    public TG getAvailableMachinesGroup() {
        return this.rootElementGroup;
    }

    public void addModelChangeListener(AbstractModelChangeListener<TG, TE> modelListener) {
        this.listeners.add(modelListener);
    }

    public boolean isInRootElementBranch(TG object) {
        if (((TreeGroup)object).equals(this.rootElementGroup)) {
            return true;
        }
        return this.doesObjectHaveAncestor(object, this.rootElementGroup);
    }

    public int getIndexOf(TG group) {
        Object parent = ((TreeGroup)group).getParent();
        SimpleTreeModel.TreeNode<TG> parentNode = this.treeModel.getTreeNodeFor(parent);
        for (int i = 0; i < parentNode.children.size(); ++i) {
            SimpleTreeModel.TreeNode child = parentNode.children.get(i);
            if (!child.value.equals(group)) continue;
            return i;
        }
        return -1;
    }

    public TreeNodeFilterProcessor<TG, TE> getFilterAncestor(TG object) {
        SimpleTreeModel.TreeNode root = this.getRootAncestorOf(object);
        Object rootValue = root.value;
        for (TreeNodeFilterProcessor<TG, TE> processor : this.filterProcessors) {
            if (processor.getRoot() != rootValue) continue;
            return processor;
        }
        return null;
    }

    protected SimpleTreeModel.TreeNode getRootAncestorOf(TG object) {
        Object[] pathToRoot = this.getPathToRoot(object);
        if (pathToRoot == null || pathToRoot.length < 2) {
            return null;
        }
        return (SimpleTreeModel.TreeNode)pathToRoot[1];
    }

    protected boolean doesObjectHaveAncestor(TG object, TG ancestor) {
        SimpleTreeModel.TreeNode<TG> objectNode = this.treeModel.getTreeNodeFor(object);
        if (objectNode == null) {
            return false;
        }
        SimpleTreeModel.TreeNode<TG> ancestorNode = this.treeModel.getTreeNodeFor(ancestor);
        SimpleTreeModel.TreeNode parentNode = objectNode.parent;
        while (parentNode != null) {
            if (parentNode == ancestorNode) {
                return true;
            }
            parentNode = parentNode.parent;
        }
        return false;
    }

    public Iterator<TE> getDescendentElements(TG parentGroup) {
        return new ElementInterator(this, parentGroup);
    }

    protected void getPathToRoot(SimpleTreeModel.TreeNode groupNode, ArrayList<Object> list) {
        if (groupNode.parent != null) {
            this.getPathToRoot(groupNode.parent, list);
        }
        list.add(groupNode);
    }

    public Object[] getPathToRoot(TG group) {
        SimpleTreeModel.TreeNode<TG> groupNode = this.treeModel.getTreeNodeFor(group);
        ArrayList<Object> path = new ArrayList<Object>();
        if (groupNode != null) {
            this.getPathToRoot(groupNode, path);
        }
        return path.toArray();
    }

    private boolean isFilterGroupThatShouldBeRemoved(TG parentGroup) {
        for (int i = 0; i < this.filterProcessors.size(); ++i) {
            TreeNodeFilterProcessor<TG, TE> filter = this.filterProcessors.get(i);
            if (filter.getRoot() != parentGroup) continue;
            return filter.removeIfEmpty();
        }
        return false;
    }

    public TG[] getRootGroups() {
        return this.getGroupsIn(null);
    }

    private TG getOrCreateGroup(TG parent, String[] path, String metadata) {
        if (path == null) {
            path = new String[]{};
        }
        for (int i = 0; i < path.length; ++i) {
            TreeGroup existingChild;
            Object tmpGroup = this.newGroup(path[i]);
            ((TreeGroup)tmpGroup).setParent(parent);
            if (metadata != null) {
                ((TreeGroup)tmpGroup).appendToMetadata(metadata);
            }
            if ((existingChild = (TreeGroup)this.treeModel.getChildWithValueThatEquals(parent, tmpGroup)) == null) {
                this.treeModel.addChild(parent, tmpGroup, true, true);
            } else {
                tmpGroup = existingChild;
            }
            ((TreeGroup)tmpGroup).setParent(parent);
            parent = tmpGroup;
        }
        SimpleTreeModel.TreeNode<TG> treeNode = this.treeModel.getTreeNodeFor(parent);
        if (treeNode != null) {
            return (TG)((TreeGroup)treeNode.value);
        }
        return null;
    }

    public void notifyFilterProcessorChange() {
        for (AbstractModelChangeListener<TG, TE> listener : this.listeners) {
            listener.filterProcessorChanged();
        }
    }

    public void moveGroupToFinalChild(TG groupToSave) {
        int count = this.treeModel.getChildCount(((TreeGroup)groupToSave).getParent());
        this.treeModel.moveChild(((TreeGroup)groupToSave).getParent(), groupToSave, count);
    }

    public void removeAllGroupsAndMachines(TG resultsGroup) {
        this.removeAllGroupsAndMachines(resultsGroup, true);
    }

    public void removeAllGroupsAndMachines(TG resultsGroup, boolean alsoRemoveGroup) {
        if (this.treeModel.contains(resultsGroup)) {
            SimpleList machines;
            TreeGroup[] groups = this.getGroupsIn((TreeGroup)resultsGroup);
            if (groups != null) {
                this.removeGroups(groups);
            }
            if ((machines = ((TreeGroup)resultsGroup).getElements()).size() > 0) {
                TreeElement[] temp = this.initElementArray(machines.size());
                machines.toArray((T[])temp);
                this.removeElements((TreeGroup)resultsGroup, temp, false);
            }
            if (alsoRemoveGroup) {
                this.removeGroup(resultsGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterProcessor(TreeNodeFilterProcessor<TG, TE> searchFilter) {
        ArrayList<TreeNodeFilterProcessor<TG, TE>> arrayList = this.filterProcessors;
        synchronized (arrayList) {
            this.filterProcessors.remove(searchFilter);
        }
        for (AbstractModelChangeListener abstractModelChangeListener : this.listeners) {
            abstractModelChangeListener.filterProcessorChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(TG filterGroup) {
        try {
            ArrayList<TreeNodeFilterProcessor<TG, TE>> arrayList = this.filterProcessors;
            synchronized (arrayList) {
                boolean save = false;
                for (int i = this.filterProcessors.size() - 1; i >= 0; --i) {
                    TreeNodeFilterProcessor<TG, TE> processor = this.filterProcessors.get(i);
                    if (!((TreeGroup)processor.getRoot()).equals(filterGroup)) continue;
                    save = true;
                    this.filterProcessors.remove(processor);
                }
                if (save) {
                    for (AbstractModelChangeListener<TG, TE> listener : this.listeners) {
                        listener.filterProcessorChanged();
                    }
                }
            }
        }
        finally {
            this.removeGroup(filterGroup);
        }
    }

    protected void notifyMachineChanged(TG currentGroup, TE[] inserted, TE[] removed, TE[] updated, Machine.MachineChanges updateResults) {
        for (AbstractModelChangeListener<TG, TE> listener : this.listeners) {
            listener.machinesChanged((TreeGroup)currentGroup, (TreeElement[])inserted, (TreeElement[])removed, (TreeElement[])updated, updateResults);
        }
    }

    public TE[] getDescendentElementsArray(TG parent) {
        Iterator<TE> descendentElements = this.getDescendentElements(parent);
        ArrayList<TE> descendentList = new ArrayList<TE>();
        while (descendentElements.hasNext()) {
            descendentList.add(descendentElements.next());
        }
        return descendentList.toArray(this.initElementArray(0));
    }

    public void dumpHierarchyToString(TG group, String s) {
        TreeGroup[] groups;
        System.out.println(s + "[" + group + "]");
        s = s + "   ";
        for (TreeElement child : ((TreeGroup)group).getElements()) {
            System.out.println(s + "-> " + child);
        }
        for (TreeGroup groupChild : groups = this.getGroupsIn((TreeGroup)group)) {
            this.dumpHierarchyToString(groupChild, s);
        }
    }

    public class GroupHierarchyHelper {
        public GroupWrapper getRootWrapper(TG root) {
            return new GroupWrapper(AbstractTreeModel.this, root);
        }

        public GroupWrapper addChild(GroupWrapper parent, TG child) {
            GroupWrapper childWrapper = new GroupWrapper(AbstractTreeModel.this, child);
            parent.children.add(childWrapper);
            return childWrapper;
        }
    }

    public static class GroupWrapper {
        private TG group;
        private ArrayList<GroupWrapper> children = new ArrayList();
        final /* synthetic */ AbstractTreeModel this$0;

        public GroupWrapper(TG group) {
            this.this$0 = this$0;
            this.group = group;
        }

        public ArrayList<GroupWrapper> getChildren() {
            return this.children;
        }

        public TG getGroup() {
            return this.group;
        }
    }

    class AutoUpdateModelListener
    implements TreeModelListener {
        AutoUpdateModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            SimpleTreeModel.TreeNode parent = (SimpleTreeModel.TreeNode)e.getTreePath().getLastPathComponent();
            TreeGroup parentObject = (TreeGroup)parent.value;
            if (parentObject == null) {
                return;
            }
            Object[] changedTreeNodeChildren = e.getChildren();
            TreeGroup[] changedChildren = AbstractTreeModel.this.initGroupArray(changedTreeNodeChildren.length);
            for (int i = 0; i < changedTreeNodeChildren.length; ++i) {
                changedChildren[i] = (TreeGroup)((SimpleTreeModel.TreeNode)changedTreeNodeChildren[i]).value;
            }
            int[] childIndices = e.getChildIndices();
            for (AbstractModelChangeListener listener : AbstractTreeModel.this.listeners) {
                listener.groupsChanged(parentObject, changedChildren, childIndices);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            SimpleTreeModel.TreeNode parent = (SimpleTreeModel.TreeNode)e.getTreePath().getLastPathComponent();
            TreeGroup parentObject = (TreeGroup)parent.value;
            Object[] insertedTreeNodeChildren = e.getChildren();
            TreeGroup[] insertedChildren = AbstractTreeModel.this.initGroupArray(insertedTreeNodeChildren.length);
            for (int i = 0; i < insertedTreeNodeChildren.length; ++i) {
                insertedChildren[i] = (TreeGroup)((SimpleTreeModel.TreeNode)insertedTreeNodeChildren[i]).value;
            }
            int[] childIndices = e.getChildIndices();
            for (AbstractModelChangeListener listener : AbstractTreeModel.this.listeners) {
                listener.groupsAdded(parentObject, insertedChildren, childIndices);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            SimpleTreeModel.TreeNode parent = (SimpleTreeModel.TreeNode)e.getTreePath().getLastPathComponent();
            TreeGroup parentObject = (TreeGroup)parent.value;
            Object[] removedTreeNodeChildren = e.getChildren();
            TreeGroup[] removedChildren = AbstractTreeModel.this.initGroupArray(removedTreeNodeChildren.length);
            for (int i = 0; i < removedTreeNodeChildren.length; ++i) {
                removedChildren[i] = (TreeGroup)((SimpleTreeModel.TreeNode)removedTreeNodeChildren[i]).value;
            }
            int[] childIndices = e.getChildIndices();
            for (AbstractModelChangeListener listener : AbstractTreeModel.this.listeners) {
                listener.groupsRemoved(parentObject, removedChildren, childIndices);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    static class ElementInterator
    implements Iterator<TE> {
        private TG rootGroup;
        private LinkedList<Iterator<TE>> iterators = new LinkedList();
        private Iterator<TE> iterator = null;
        final /* synthetic */ AbstractTreeModel this$0;

        public ElementInterator(TG rootGroup) {
            this.this$0 = this$0;
            this.rootGroup = rootGroup;
            this.addAll(rootGroup);
            if (this.iterators.size() > 0) {
                this.iterator = this.iterators.removeFirst();
            }
        }

        private void addAll(TG group) {
            TreeGroup[] groupsIn;
            if (((TreeGroup)group).getElementCount() > 0) {
                this.iterators.add(((TreeGroup)group).getElements().iterator());
            }
            for (TreeGroup child : groupsIn = this.this$0.getGroupsIn((TreeGroup)group)) {
                this.addAll(child);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            while (!this.iterator.hasNext()) {
                if (this.iterators.size() > 0) {
                    this.iterator = this.iterators.removeFirst();
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public TE next() {
            if (this.iterator == null) {
                return null;
            }
            return (TreeElement)this.iterator.next();
        }

        @Override
        public void remove() {
        }
    }

    private class FilterChangeListener
    implements AbstractModelChangeListener<TG, TE> {
        private FilterChangeListener() {
        }

        @Override
        public void groupsRemoved(TG parentGroup, TG[] removedChildren, int[] removedIndices) {
        }

        @Override
        public void groupsAdded(TG parentGroup, TG[] insertedChildren, int[] insertedIndices) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void groupsChanged(TG parentGroup, TG[] changedChildren, int[] changedIndices) {
            if (AbstractTreeModel.this.isInRootElementBranch(parentGroup)) {
                ArrayList clonedList;
                ArrayList arrayList = AbstractTreeModel.this.filterProcessors;
                synchronized (arrayList) {
                    clonedList = new ArrayList(AbstractTreeModel.this.filterProcessors);
                }
                for (int i = 0; i < clonedList.size(); ++i) {
                    TreeNodeFilterProcessor filter = clonedList.get(i);
                    TreeGroup metadataParentGroup = null;
                    String[] result = AbstractTreeModel.this.getGroupPath(parentGroup);
                    if (metadataParentGroup == null) {
                        metadataParentGroup = AbstractTreeModel.this.getOrCreateGroup(filter.getRoot(), result, filter.getMetadata());
                    }
                    if (metadataParentGroup == null) continue;
                    for (Object newVersion : changedChildren) {
                        int count = AbstractTreeModel.this.treeModel.getChildCount(metadataParentGroup);
                        for (int childIndex = 0; childIndex < count; ++childIndex) {
                            boolean nameChange;
                            TreeGroup existingVersion = AbstractTreeModel.this.treeModel.getChild(metadataParentGroup, childIndex);
                            if (existingVersion == null || existingVersion.uniqueIndex != ((TreeGroup)newVersion).uniqueIndex) continue;
                            boolean bl = nameChange = !((TreeGroup)newVersion).groupName.equals(existingVersion.groupName);
                            if (nameChange) {
                                System.out.println("Name change for updated groups.");
                                existingVersion.groupName = ((TreeGroup)newVersion).groupName;
                                AbstractTreeModel.this.treeModel.ensureCorrectOrdering(metadataParentGroup, existingVersion);
                            }
                            AbstractTreeModel.this.treeModel.update(existingVersion);
                        }
                    }
                }
            }
        }

        protected TE[] getIncludedMachines(TreeNodeFilterProcessor<TG, TE> filter, TE[] machines) {
            ArrayList machineList = new ArrayList();
            for (int i = 0; i < machines.length; ++i) {
                try {
                    Object machine = machines[i];
                    if (!filter.includes(machines[i])) continue;
                    machineList.add(machine);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    System.out.println("[AbstractTreeModel] Somewhat expected out of bounds exception (" + ex.getMessage() + ")");
                }
            }
            return machineList.toArray(AbstractTreeModel.this.initElementArray(0));
        }

        protected TE[] getIncludedMachines(TreeNodeFilterProcessor<TG, TE> filter, List<TE> machines) {
            ArrayList<TreeElement> machineList = new ArrayList<TreeElement>();
            for (int i = 0; i < machines.size(); ++i) {
                try {
                    TreeElement machine = (TreeElement)machines.get(i);
                    if (!filter.includes(machine)) continue;
                    machineList.add(machine);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    System.out.println("[AbstractTreeModel] Somewhat expected out of bounds exception (" + ex.getMessage() + ")");
                }
            }
            return machineList.toArray(AbstractTreeModel.this.initElementArray(0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void machinesChanged(TG parent, TE[] inserted, TE[] removed, TE[] updated, Machine.MachineChanges updateResults) {
            if (AbstractTreeModel.this.isInRootElementBranch(parent)) {
                ArrayList clonedList;
                ArrayList arrayList = AbstractTreeModel.this.filterProcessors;
                synchronized (arrayList) {
                    clonedList = new ArrayList(AbstractTreeModel.this.filterProcessors);
                }
                for (int i = 0; i < clonedList.size(); ++i) {
                    TreeElement[] includedMachines;
                    TreeNodeFilterProcessor filter = clonedList.get(i);
                    TreeGroup metadataParentGroup = null;
                    if (removed != null && removed.length > 0) {
                        String[] result = AbstractTreeModel.this.getGroupPath(parent);
                        if (metadataParentGroup == null) {
                            metadataParentGroup = AbstractTreeModel.this.getOrCreateGroup(filter.getRoot(), result, filter.getMetadata());
                        }
                        AbstractTreeModel.this.matchGroupIndices(parent, metadataParentGroup);
                        if (metadataParentGroup != null) {
                            AbstractTreeModel.this.removeElements(metadataParentGroup, removed, false);
                            for (Object m : removed) {
                                filter.deregister(m);
                            }
                        }
                    }
                    if (inserted != null && inserted.length > 0 && (includedMachines = this.getIncludedMachines(filter, (TreeElement[])inserted)).length > 0) {
                        String[] result = AbstractTreeModel.this.getGroupPath(parent);
                        AbstractTreeModel.this.insertSpecialRootGroup(filter.getRoot());
                        if (metadataParentGroup == null) {
                            metadataParentGroup = AbstractTreeModel.this.getOrCreateGroup(filter.getRoot(), result, filter.getMetadata());
                        }
                        AbstractTreeModel.this.matchGroupIndices(parent, metadataParentGroup);
                        if (metadataParentGroup != null) {
                            AbstractTreeModel.this.addElements(metadataParentGroup, includedMachines, false);
                            TreeElement[] treeElementArray = includedMachines;
                            int n = treeElementArray.length;
                            for (int m = 0; m < n; ++m) {
                                TreeElement m2 = treeElementArray[m];
                                filter.register(m2);
                            }
                        }
                    }
                    if (updated == null || updated.length <= 0) continue;
                    boolean hasBeenUpdated = false;
                    for (Object machine : updated) {
                        String[] result;
                        if (!filter.contains(machine)) {
                            if (filter.includes(machine)) {
                                result = AbstractTreeModel.this.getGroupPath(parent);
                                AbstractTreeModel.this.insertSpecialRootGroup(filter.getRoot());
                                if (metadataParentGroup == null) {
                                    metadataParentGroup = AbstractTreeModel.this.getOrCreateGroup(filter.getRoot(), result, filter.getMetadata());
                                }
                                AbstractTreeModel.this.matchGroupIndices(parent, metadataParentGroup);
                                if (metadataParentGroup != null) {
                                    hasBeenUpdated = true;
                                    AbstractTreeModel.this.addElements(metadataParentGroup, AbstractTreeModel.this.initElementArray((TreeElement)machine), false);
                                    filter.register(machine);
                                }
                            }
                        } else {
                            result = AbstractTreeModel.this.getGroupPath(parent);
                            if (metadataParentGroup == null) {
                                metadataParentGroup = AbstractTreeModel.this.getOrCreateGroup(filter.getRoot(), result, filter.getMetadata());
                            }
                            AbstractTreeModel.this.matchGroupIndices(parent, metadataParentGroup);
                            if (!filter.includes(machine) && metadataParentGroup != null) {
                                AbstractTreeModel.this.removeElements(metadataParentGroup, AbstractTreeModel.this.initElementArray((TreeElement)machine), false);
                                filter.deregister(machine);
                            }
                        }
                        if (metadataParentGroup == null || hasBeenUpdated) continue;
                        for (TreeGroup newParent = metadataParentGroup; newParent != null; newParent = newParent.getParent()) {
                            newParent.getGroupStats().descendentUpdated(updateResults);
                        }
                        AbstractTreeModel.this.updateAncestorGroupsAndLock(metadataParentGroup);
                    }
                }
            }
        }

        @Override
        public void filterProcessorChanged() {
        }
    }

    private static class UpdateAncestorRunner
    implements Runnable {
        private TG parent;
        final /* synthetic */ AbstractTreeModel this$0;

        public UpdateAncestorRunner(TG parent) {
            this.this$0 = var1_1;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.this$0.LOCK.getReadWriteLock();
            try {
                this.this$0.updateAncestorGroups(this.parent);
            }
            finally {
                this.this$0.LOCK.releaseReadWriteLock();
            }
        }
    }
}

