/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.gstarted;

import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.licence.License;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechUi;
import com.aem.shelp.tech.gstarted.MonitoringOnlyUtil;
import com.aem.shelp.util.PleaseWaitDialog;
import com.aem.utils.StreamUtils;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.FadedHorizontalLine;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class NoLicensePane
extends GbPanel
implements ActionListener {
    TechClient client;
    JButton addLicenseButton;
    private PleaseWaitDialog pleaseWaitDialog;
    GbPanel main;
    TechUi techui;
    int licmode;

    public NoLicensePane(TechClient tc, int licmode, TechUi techui) {
        this.client = tc;
        this.licmode = licmode;
        this.techui = techui;
        this.initUI();
    }

    private void initUI() {
        String submessage;
        String message;
        this.setBackground(SHStyle.TECH_BACKGROUND);
        this.main = new GbPanel(new ScaledInsets(14, 14, 14, 14));
        this.main.setBackground(this.getBackground());
        this.add(this.main, 0, 0, 1, 1, 100, 100, 10, 0);
        this.addLicenseButton = new JButton(Language.get("GETTING_STARTED_UPLOAD"), ImageLoader.getImageIcon("images/svg/general/add.svg,16"));
        JButton maybe = null;
        JButton maybe2 = null;
        if (this.licmode == 0) {
            message = Language.get("GETTING_STARTED_NEW_TITLE");
            submessage = Language.get("GETTING_STARTED_NEW_DESC");
            maybe = MonitoringOnlyUtil.getTrialLicenseButton();
        } else if (this.licmode == 1) {
            message = Language.get("GETTING_STARTED_TRIAL_TITLE");
            submessage = Language.get("GETTING_STARTED_TRIAL_DESC");
            maybe = MonitoringOnlyUtil.getBuyLicenseButton();
        } else {
            message = Language.get("GETTING_STARTED_OLD_TITLE");
            submessage = Language.get("GETTING_STARTED_OLD_DESC");
            maybe = MonitoringOnlyUtil.getUpdateLicenseButton();
            maybe2 = MonitoringOnlyUtil.getTrialVersionLicenseButton();
        }
        if (maybe2 != null) {
            SwingUtil.setSizesToWidest(new JComponent[]{this.addLicenseButton, maybe, maybe2});
        } else if (maybe != null) {
            SwingUtil.setSizesToWidest(new JComponent[]{this.addLicenseButton, maybe});
        }
        int Y = 0;
        FadedHorizontalLine line1 = new FadedHorizontalLine();
        SwingUtil.setWidth(line1, 500);
        FadedHorizontalLine line2 = new FadedHorizontalLine();
        SwingUtil.setWidth(line2, 500);
        JLabel mainMessageLabel = new JLabel(message);
        JTextArea area = new JTextArea();
        area.setText(submessage);
        area.setFont(mainMessageLabel.getFont());
        area.setBackground(this.getBackground());
        area.setEditable(false);
        area.setEnabled(false);
        area.setWrapStyleWord(true);
        area.setDisabledTextColor(mainMessageLabel.getForeground());
        area.setLineWrap(true);
        mainMessageLabel.setFont(mainMessageLabel.getFont().deriveFont(SHStyle.LARGE_FONT_SIZE));
        mainMessageLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        JPanel buttonsBar = new JPanel(new GridLayout(1, 0, 20, 20));
        buttonsBar.setBackground(this.getBackground());
        buttonsBar.add(this.addLicenseButton);
        if (maybe != null) {
            buttonsBar.add(maybe);
        }
        if (maybe2 != null) {
            buttonsBar.add(maybe2);
        }
        this.main.add(new JLabel(ImageLoader.getImageIcon(Icons.SH_LOGO_LARGE)), 0, Y++, 1, 1, 100, 100, 10, 0);
        this.main.add(line1, 0, Y++, 1, 1, 100, 0, 10, 1);
        this.main.add(mainMessageLabel, 0, Y++, 1, 1, 100, 100, 10, 0);
        this.main.add(area, 0, Y++, 1, 1, 100, 100, 10, 1);
        this.main.add(buttonsBar, 0, Y++, 1, 1, 100, 100, 10, 0);
        this.main.add(line2, 0, Y++, 1, 1, 100, 0, 10, 1);
        this.addLicenseButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block3: {
            File licenseFile;
            Object o = e.getSource();
            if (o == this.addLicenseButton && (licenseFile = SafeJFileChooser.pickFile(this, new String[]{"txt"})) != null) {
                try {
                    FileInputStream fin = new FileInputStream(licenseFile);
                    String licenseData = StreamUtils.readAllAsStringISO88951(fin);
                    fin.close();
                    this.pleaseWaitDialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer(this), Language.get("PLEASE_WAIT_TITLE"), Language.get("PLEASE_WAIT_SAVING_LICENSE"));
                    new SaveLicenseThread(licenseData).start();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (this.pleaseWaitDialog == null) break block3;
                    this.pleaseWaitDialog.hideDialog();
                }
            }
        }
    }

    class SaveLicenseThread
    extends Thread {
        private String data;

        public SaveLicenseThread(String licenseData) {
            this.data = licenseData;
        }

        @Override
        public void run() {
            String error = null;
            try {
                NoLicensePane.this.client.putServerLicense(this.data);
                ArrayList<License> licensesReadFromServer = new ArrayList<License>();
                NoLicensePane.this.client.fetchServerConfiguration(null, licensesReadFromServer);
                NoLicensePane.this.client.updateServerManagement();
            }
            catch (Exception e) {
                e.printStackTrace();
                error = e.getMessage() != null ? e.getMessage().trim() : "";
                error = error.replace("VALID_LICENSE_EXPIRED", Language.get("VALID_LICENSE_EXPIRED").trim());
            }
            if (NoLicensePane.this.pleaseWaitDialog != null) {
                NoLicensePane.this.pleaseWaitDialog.setVisible(false);
            }
            if (error != null) {
                String htmlError = Language.get("FAILED_SAVE_LICENSE_MSG") + "\n\n" + error;
                SHGlassOptionPane.showErrorDialog(SwingUtil.getRootPaneContainer(NoLicensePane.this), htmlError, Language.get("FAILED_SAVE_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            }
        }
    }
}

