/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.customer;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.customer.OSIconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import jwrapper.jwutils.JWMacOS;
import utils.ostools.OS;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class OSTag
implements Icon {
    private static final Pattern numberPattern = Pattern.compile("[\\d.]+");
    private BufferedImage cachedImage = null;
    private boolean isSelected;
    private String summaryText;
    private int width;
    private int height;
    private Icon osIcon;
    private Color colour;
    public static final int TAG_WIDTH = 54;
    private static final HashMap<String, OSTag> tags = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OSTag getOSTag(Machine m, boolean isSelected) {
        OSTag osTag;
        String key = m.getOsBaseType() + "-" + m.getOsVariant() + "-" + m.getOsSummary() + "-" + isSelected;
        HashMap<String, OSTag> hashMap = tags;
        synchronized (hashMap) {
            osTag = tags.get(key);
            if (osTag == null) {
                osTag = new OSTag(m, isSelected);
                tags.put(key, osTag);
            }
        }
        return osTag;
    }

    public OSTag(Machine m, boolean isSelected) {
        int osBaseType = m.getOsBaseType();
        String osSummary = m.getOsSummary();
        int osVariant = m.getOsVariant();
        if (osBaseType == 0) {
            this.colour = new Color(95, 125, 201);
        } else if (osBaseType == 2) {
            this.colour = new Color(183, 156, 0);
        } else if (osBaseType == 1) {
            this.colour = new Color(145, 145, 145);
        }
        this.width = SimpleHelpLookAndFeel.scale(54);
        this.height = SimpleHelpLookAndFeel.scale(20);
        this.isSelected = isSelected;
        this.osIcon = OSIconLoader.getOSIcon(osBaseType, osVariant, false, osSummary, isSelected, true);
        if (osSummary != null) {
            String newOSSummary;
            Matcher matcher;
            if (0 == osBaseType) {
                if (osSummary.contains("Windows 7")) {
                    this.summaryText = "7";
                } else if (osSummary.contains("Windows 10")) {
                    this.summaryText = "10";
                    if (osSummary.contains("November Update")) {
                        this.summaryText = "NU";
                    } else if (osSummary.contains("Anniversary Update")) {
                        this.summaryText = "AU";
                    } else if (osSummary.contains("Creators Update")) {
                        this.summaryText = "CU";
                    } else if (osSummary.contains("Fall Creators Update")) {
                        this.summaryText = "FCU";
                    } else if (osSummary.contains("Spring Creators Update")) {
                        this.summaryText = "SCU";
                    }
                } else if (osSummary.contains("Windows XP")) {
                    this.summaryText = "XP";
                } else if (osSummary.contains("Windows 8.1")) {
                    this.summaryText = "8.1";
                } else if (osSummary.contains("Windows 8")) {
                    this.summaryText = "8";
                } else if (osSummary.contains("2003")) {
                    this.summaryText = "2003";
                } else if (osSummary.contains("2000")) {
                    this.summaryText = "2000";
                } else if (osSummary.contains("Windows Server 2008")) {
                    this.summaryText = "2008";
                } else if (osSummary.contains("Windows Server 2012")) {
                    this.summaryText = "2012";
                } else if (osSummary.contains("Windows Server 2016")) {
                    this.summaryText = "2016";
                } else if (osSummary.contains("Vista")) {
                    this.summaryText = "V";
                }
            } else if (1 == osBaseType) {
                int tenIndex = osSummary.indexOf("10.");
                if (tenIndex != -1) {
                    String text;
                    int spaceIndex = osSummary.indexOf(32, tenIndex + 1);
                    if (spaceIndex == -1) {
                        spaceIndex = osSummary.length();
                    }
                    if ((text = JWMacOS.macOSVersionName(osSummary.substring(tenIndex, spaceIndex))) != null) {
                        StringBuilder builder = new StringBuilder();
                        for (int i = 0; i < text.length(); ++i) {
                            char ch = text.charAt(i);
                            if (!Character.isUpperCase(ch)) continue;
                            builder.append(ch);
                        }
                        this.summaryText = builder.toString();
                    }
                }
            } else if (2 == osBaseType && (matcher = numberPattern.matcher(newOSSummary = osSummary.replace("x64", ""))).find()) {
                this.summaryText = matcher.group();
                if (this.summaryText.length() > 5) {
                    this.summaryText = this.summaryText.substring(0, 5);
                    if (this.summaryText.endsWith(".")) {
                        this.summaryText = this.summaryText.substring(0, this.summaryText.length() - 1);
                    }
                }
            }
        } else {
            this.summaryText = "";
        }
        int factor = 1;
        if (OS.isOSXRetina()) {
            factor = 2;
        }
        BufferedImage cachedImage = new BufferedImage(factor * this.width, factor * this.height, 2);
        this.drawToImage(cachedImage);
        this.cachedImage = cachedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int factor = 1;
        if (OS.isOSXRetina()) {
            factor = 2;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform affineTransform = SwingUtil.prepareForRetina(g2d);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        try {
            g2d.drawImage((Image)this.cachedImage, x * factor, y * factor, null);
        }
        finally {
            g2d.setTransform(affineTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawToImage(BufferedImage cachedImage) {
        int x = 0;
        int y = 0;
        float factor = 1.0f;
        if (OS.isOSXRetina()) {
            factor = 2.0f;
        }
        Graphics2D g2d = cachedImage.createGraphics();
        AffineTransform affineTransform = g2d.getTransform();
        if (OS.isOSXRetina()) {
            g2d.scale(2.0, 2.0);
        }
        try {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            if (this.osIcon != null) {
                this.osIcon.paintIcon(null, g2d, x + SimpleHelpLookAndFeel.scale(3), y + (this.height - this.osIcon.getIconHeight()) / 2);
            }
            if (this.summaryText != null) {
                if (this.summaryText.length() <= 2) {
                    g2d.setFont(SHStyle.mediumFont);
                } else if (this.summaryText.length() <= 4) {
                    g2d.setFont(SHStyle.normalFont);
                } else if (this.summaryText.length() <= 6) {
                    g2d.setFont(SHStyle.smallFont);
                } else {
                    g2d.setFont(SHStyle.smallFont);
                }
                int fontHeight = g2d.getFontMetrics().getMaxAscent();
                int baseLine = this.height - (this.height - fontHeight) / 2;
                if (this.isSelected) {
                    g2d.setColor(Color.white);
                } else {
                    g2d.setColor(this.colour);
                }
                g2d.drawString(this.summaryText, x + SimpleHelpLookAndFeel.scale(24), baseLine);
            }
        }
        finally {
            g2d.dispose();
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

