/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.customer;

import com.aem.shelp.common.Language;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.border.Border;
import utils.swing.SwingUtil;
import utils.swing.borders.TopDownGradientBorder;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.layout.GbPanel;

public class HeaderPanel
extends GbPanel {
    private JLabel os;
    private JLabel waitingFor;
    private JLabel[] detailsLabels;
    private int nameWidth = 250;
    private int height = 20;
    private ArrayList<String> detailsToShow = null;
    private int scrollBarWidth = 0;
    private boolean isWaitingList;

    public HeaderPanel(boolean isWaitingList) {
        this.isWaitingList = isWaitingList;
    }

    public void setDetailsToShow(ArrayList<String> detailsToShow) {
        if (this.detailsToShow != null && this.detailsToShow.equals(detailsToShow)) {
            return;
        }
        if (detailsToShow == null) {
            detailsToShow = new ArrayList();
        }
        this.detailsToShow = detailsToShow;
        this.removeAll();
        this.waitingFor = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }
        };
        JLabel primaryLabel = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = HeaderPanel.this.nameWidth;
                return dim;
            }
        };
        this.initLabelSettings(primaryLabel, 2);
        this.initLabelSettings(this.waitingFor, 4);
        if (this.isWaitingList) {
            this.waitingFor.setText(Language.get("WAITING"));
        } else {
            this.waitingFor.setText(Language.get("SESSION_TIME"));
        }
        this.os = new JLabel();
        SwingUtil.setSize(this.os, 24, this.height);
        int labelCount = Math.max(detailsToShow.size(), 1);
        this.detailsLabels = new JLabel[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            if (i == 0) {
                this.detailsLabels[i] = primaryLabel;
            } else {
                this.detailsLabels[i] = new JLabel(){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension dim = super.getPreferredSize();
                        dim.width = 20;
                        return dim;
                    }
                };
                this.initLabelSettings(this.detailsLabels[i], 2);
                this.detailsLabels[i].setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            }
            if (detailsToShow.size() <= 0) continue;
            this.detailsLabels[i].setText(Language.get(detailsToShow.get(i)));
        }
        int X = 0;
        this.add(this.os, X++, 0, 1, 1, 0, 0, 10, 0, new Insets(0, 2, 0, 2));
        for (int i = 0; i < this.detailsLabels.length; ++i) {
            int widthWeight = 1;
            if (i == 0 && this.detailsLabels.length != 1) {
                widthWeight = 0;
            }
            this.add(this.detailsLabels[i], X++, 0, 1, 1, widthWeight, 1, 17, 1, new Insets(0, 1, 0, 2));
        }
        this.add(this.waitingFor, X++, 0, 1, 1, 0, 1, 13, 1, new Insets(0, 1, 0, 2));
        this.revalidate();
        this.repaint();
    }

    private void initLabelSettings(JLabel label, int alignment) {
        label.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        label.setHorizontalAlignment(alignment);
        label.setFont(SHStyle.smallerFont);
        Border emptyBorder = SHBorderFactory.createEmptyBorder(0, 2, 0, 0);
        TopDownGradientBorder gradientBorder = new TopDownGradientBorder(0, 1, 0, 0, label.getBackground(), SHStyle.TABLE_BORDER_DARK);
        label.setBorder(SHBorderFactory.createCompoundBorder(gradientBorder, emptyBorder));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = this.height;
        return dim;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        dim.height = this.height;
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        dim.height = this.height;
        return dim;
    }

    public void setScrollBarWidth(int width) {
        if (width == this.scrollBarWidth) {
            return;
        }
        this.scrollBarWidth = width;
        this.setBorder(SHBorderFactory.createEmptyBorder(0, 0, 0, this.scrollBarWidth));
    }
}

