/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile.ui;

import com.aem.profiles.model.AppProfile;
import com.aem.profiles.model.ProfileType;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.appprofile.ProfileUIListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import utils.swing.components.SimpleTabbedPanel;
import utils.swing.customlaf.SHStyle;

public abstract class AbstractProfileUI {
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private SimpleTabbedPanel tabs = new SimpleTabbedPanel();
    protected ProfileUIListener uiListener;
    protected AppProfile appProfile;
    public TechClient client;
    public RootPaneContainer rpc;

    public abstract AppProfileTab[] getTabs();

    public abstract void loadFromProfile(AppProfile var1);

    public AppProfile getAppProfile() {
        return this.appProfile;
    }

    public TechClient getTechClient() {
        return this.client;
    }

    public AbstractProfileUI(AppProfile appProfile, ProfileUIListener uiListener, RootPaneContainer rpc, TechClient client) {
        this.uiListener = uiListener;
        this.appProfile = appProfile;
        this.client = client;
        this.rpc = rpc;
        this.resetTabs();
        this.loadFromProfile(appProfile);
    }

    protected void resetTabs() {
        this.rootComponent.removeAll();
        int selectedIndex = 0;
        if (this.tabs != null && this.tabs.getTabCount() > 1) {
            selectedIndex = this.tabs.getSelectedIndex();
            System.out.println("Selected Index " + selectedIndex);
        }
        this.tabs = new SimpleTabbedPanel();
        this.tabs.setTitleFont(SHStyle.normalFont);
        AppProfileTab[] tabConfig = this.getTabs();
        if (tabConfig.length > 1) {
            this.rootComponent.add((Component)this.tabs.getRootComponent(), "Center");
            for (AppProfileTab tab : tabConfig) {
                this.tabs.addTab(tab.name, tab.icon, tab.tab);
            }
            try {
                this.tabs.setSelectedIndex(selectedIndex);
            }
            catch (Exception exception) {}
        } else {
            this.rootComponent.add((Component)tabConfig[0].tab, "Center");
        }
    }

    public Component getRootComponent() {
        return this.rootComponent;
    }

    public boolean isForAppType(ProfileType type) {
        return this.appProfile.getType().equals(type);
    }

    public static class AppProfileTab {
        private JComponent tab;
        private Icon icon;
        private String name;

        public AppProfileTab(String name, Icon icon, JComponent tab) {
            this.name = name;
            this.icon = icon;
            this.tab = tab;
        }

        public JComponent getTab() {
            return this.tab;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }
    }
}

