/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.LazyPassword;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.tech.TechServerConfig;
import com.aem.shelp.tech.appprofile.TranslatedException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class ProfileAccountsConfig
implements TechServerConfig.TechServerConfigListener {
    private boolean GET_GROUPS_BY_NAME_PROFILE_ID = true;
    private ArrayList<ProfileAccountsReadyListener> listeners = new ArrayList();
    private TechServerConfig techServerConfig;
    private ServerConfig config;

    public ProfileAccountsConfig(TechServerConfig techServerConfig) {
        this.techServerConfig = techServerConfig;
        this.config = techServerConfig.getServerConfig();
        techServerConfig.addTechServerConfigListener(this);
        if (techServerConfig.hasBeenFetched()) {
            this.notifyReady();
        }
    }

    public void addProfileAccountsReadyListener(ProfileAccountsReadyListener listener) {
        this.listeners.add(listener);
        if (this.techServerConfig.hasBeenFetched()) {
            this.notifyReady();
        }
    }

    private void notifyReady() {
        if (this.listeners.size() > 0) {
            SwingUtilities.invokeLater(new ReadyNotifier());
        }
    }

    @Override
    public void serverConfigFetched() {
        this.notifyReady();
    }

    @Override
    public void serverConfigChanged(String sourceID) {
        if (!sourceID.equals("Profile")) {
            this.notifyReady();
        }
    }

    public static boolean isTechGroupForAppProfile(TechGroup group, AppProfile profile) {
        if (group == null) {
            return false;
        }
        if (profile == null) {
            return false;
        }
        return group.getAssociatedAppProfileID() != null && group.getAssociatedAppProfileID().equals(profile.getID());
    }

    public static boolean isTechUserInAppProfile(TechUser user, AppProfile profile) {
        TechGroup[] groups;
        for (TechGroup group : groups = user.getGroups()) {
            if (!ProfileAccountsConfig.isTechGroupForAppProfile(group, profile)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<TechUser> getTechsForAppProfile(AppProfile profile) {
        TechUser[] techs = this.config.getAllTechUsersIncludingSimpleHelpAdmin();
        ArrayList<TechUser> list = new ArrayList<TechUser>();
        for (TechUser user : techs) {
            if (!ProfileAccountsConfig.isTechUserInAppProfile(user, profile)) continue;
            list.add(user);
        }
        return list;
    }

    public TechGroup getGroupForAppProfile(AppProfile profile) {
        TechGroup[] groups;
        if (this.GET_GROUPS_BY_NAME_PROFILE_ID) {
            return this.config.getGroupByName(profile.getID());
        }
        for (TechGroup group : groups = this.config.getAllTechGroups()) {
            if (!ProfileAccountsConfig.isTechGroupForAppProfile(group, profile)) continue;
            return group;
        }
        return null;
    }

    public TechGroup getOrCreateGroupForAppProfile(AppProfile profile) {
        TechGroup existing = this.getGroupForAppProfile(profile);
        if (existing != null) {
            return existing;
        }
        int id = ServerConfig.get().getTechnicianGroupID();
        TechGroup created = new TechGroup(id, profile.getID());
        created.setAssociatedAppProfileID(profile.getID());
        TechGroup[] old = this.config.groups;
        TechGroup[] tmp = new TechGroup[old.length + 1];
        System.arraycopy(old, 0, tmp, 0, old.length);
        tmp[old.length] = created;
        this.config.groups = tmp;
        return created;
    }

    public TechUser[] listAllTechUsers() {
        return this.config.technicians;
    }

    public ArrayList<TechUser> listTechUsersForProfile(AppProfile profile) {
        TechUser[] all = this.listAllTechUsers();
        ArrayList<TechUser> list = new ArrayList<TechUser>();
        for (TechUser user : all) {
            System.out.println("[ProfileAccountsConfig] Checking " + user.getLogin());
            if (!ProfileAccountsConfig.isTechUserInAppProfile(user, profile)) continue;
            System.out.println("[ProfileAccountsConfig] Tech is member of " + profile.getName());
            list.add(user);
        }
        return list;
    }

    public void addTechToProfile(TechUser user, AppProfile profile) {
        TechGroup group = this.getOrCreateGroupForAppProfile(profile);
        user.addGroup(group);
    }

    public void removeTechFromProfile(TechUser user, AppProfile profile) {
        TechGroup group = this.getGroupForAppProfile(profile);
        if (group != null) {
            user.removeGroup(group);
        }
        if (user.isForAppProfilesOnly() && user.getGroups().length == 0) {
            TechUser[] old = this.config.technicians;
            TechUser[] tmp = new TechUser[old.length - 1];
            int N = 0;
            for (TechUser olduser : old) {
                if (olduser.getUserID() == user.getUserID()) continue;
                tmp[N++] = olduser;
            }
            this.config.technicians = tmp;
        }
    }

    public TechUser createNewTechForAppProfile(AppProfile profile, String name, String username, String password, String email) throws TranslatedException {
        TechGroup group = this.getOrCreateGroupForAppProfile(profile);
        TechUser user = new TechUser(this.config.getTechnicianID(), name, username, new LazyPassword(password), email, false, true, true);
        user.setIsForAppProfilesOnly(true);
        user.addGroup(group);
        for (TechUser check : this.config.technicians) {
            if (!check.getLogin().equals(username)) continue;
            throw new TranslatedException(Language.get("USER_ALREADY_EXISTS"));
        }
        System.out.println("[ProfileAccountsPanel] Total technicians before = " + this.config.technicians.length);
        TechUser[] old = this.config.technicians;
        TechUser[] tmp = new TechUser[old.length + 1];
        System.arraycopy(old, 0, tmp, 0, old.length);
        tmp[old.length] = user;
        this.config.technicians = tmp;
        System.out.println("[ProfileAccountsPanel] Total technicians after = " + this.config.technicians.length);
        return user;
    }

    public void saveAsync() {
        this.techServerConfig.requestSave("Profile");
    }

    private class ReadyNotifier
    implements Runnable {
        private ReadyNotifier() {
        }

        @Override
        public void run() {
            for (ProfileAccountsReadyListener listener : ProfileAccountsConfig.this.listeners) {
                listener.profileAccountsReady();
            }
        }
    }

    static interface ProfileAccountsReadyListener {
        public void profileAccountsReady();
    }
}

