/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.events.server;

import com.aem.sgateway.ui.SimpleMachineGroupList;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.logging.targets.runtool.RunToolTarget;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.proxy.types.ServerEvent;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.AbstractAlertsDetailsPanel;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.events.server.details.ServerEventsInfoPanel;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.TargetUIListener;
import utils.loggingframework.ui.SelectTargetComponent;
import utils.loggingframework.ui.SpecifyFiltersUI;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ServerEventsDetailsPanel
extends AbstractAlertsDetailsPanel
implements SimpleMachineGroupList.ButtonClickListener,
TargetUIListener {
    private JComponent[] viewPanels;
    private GbPanel filtersPanel;
    private GbPanel actionsPanel;
    private JScrollPane infoPanelScrollPane;
    private JScrollPane filtersScrollPane;
    private JScrollPane actionsScrollPane;
    JToggleButton infoViewButton;
    JToggleButton filterButton;
    JToggleButton actionButton;
    private ServerEventsInfoPanel infoPanel;
    private SpecifyFiltersUI filterUI;
    private SelectTargetComponent targetUI;

    @Override
    public void setTechClient(TechClient client) {
        super.setTechClient(client);
        this.infoPanel.setTechClient(client);
        this.infoPanel.setMachineTreeModel(this.machineModel);
        boolean canManageAlerts = client.getPermissions().canManageServerEvents();
        this.deleteButton.setVisible(canManageAlerts);
        this.saveButton.setVisible(canManageAlerts);
        this.activeButton.setVisible(canManageAlerts);
        this.activeLabel.setVisible(canManageAlerts);
    }

    public ServerEventsDetailsPanel(MachineTreeModel machineModel, AlertPanelListener alertPanelListener) {
        super(machineModel, alertPanelListener);
    }

    @Override
    public void initUI() {
        this.initInfoPanel();
        this.initFiltersPane();
        this.initActionsPanel();
        this.infoViewButton = new JToggleButton(ImageLoader.getImageIcon("images/svg/general/spanner-dark.svg,16"));
        this.filterButton = new JToggleButton(ImageLoader.getImageIcon("images/svg/general/funnel.svg,16"));
        this.actionButton = new JToggleButton(ImageLoader.getImageIcon("images/svg/users/runner.svg,16"));
        this.infoViewButton.setToolTipText(Language.get("SERVER_EVENT_VIEW_TOOLTIP"));
        this.filterButton.setToolTipText(Language.get("SERVER_EVENT_FILTER_TOOLTIP"));
        this.actionButton.setToolTipText(Language.get("SERVER_EVENT_ACTION_TOOLTIP"));
        this.infoPanelScrollPane = new JScrollPane(this.infoPanel);
        this.infoPanelScrollPane.setHorizontalScrollBarPolicy(31);
        this.infoPanelScrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.filtersScrollPane = new JScrollPane(this.filtersPanel);
        this.filtersScrollPane.setHorizontalScrollBarPolicy(31);
        this.filtersScrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.actionsScrollPane = new JScrollPane(this.actionsPanel);
        this.actionsScrollPane.setHorizontalScrollBarPolicy(31);
        this.actionsScrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.infoPanelScrollPane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.infoPanelScrollPane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.filtersScrollPane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.filtersScrollPane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.actionsScrollPane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.actionsScrollPane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.setViewButtons(new AbstractButton[]{this.infoViewButton, this.filterButton, this.actionButton}, new JComponent[]{this.infoPanelScrollPane, this.filtersScrollPane, this.actionsScrollPane});
        super.initUI();
    }

    @Override
    public void alertModified() {
        this.filterUI.setEvents(this.infoPanel.getSelectedEvents());
        this.targetUI.setLogEventsToTarget(this.infoPanel.getSelectedEvents());
        ServerEvent se = (ServerEvent)this.alert;
        se.setFilters(this.filterUI.getFilters());
        se.setTarget(this.targetUI.getSelectedAbstractTarget());
        super.alertModified();
    }

    private void initFiltersPane() {
        this.filtersPanel = new GbPanel();
        this.filterUI = new SpecifyFiltersUI(Language.DEFLANG, SHStyle.INSTANCE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerEventsDetailsPanel.this.alertModified();
            }
        });
        JLabel nameLabel = new JLabel(Language.get("LOGGING_UI_FILTER_EVENTS_DESC"));
        nameLabel.setIcon(ImageLoader.getImageIcon("images/svg/general/funnel.svg,16"));
        nameLabel.setIconTextGap(8);
        this.filtersPanel.add(nameLabel, 0, 0, 1, 1, 0, 0, 13, 0, new Insets(10, 3, 10, 3));
        this.filtersPanel.add(this.filterUI.getRootComponent(), 0, 2, 2, 1, 1, 100, 10, 1, new Insets(3, 3, 3, 3));
    }

    private void initInfoPanel() {
        this.infoPanel = new ServerEventsInfoPanel(this);
    }

    private void initActionsPanel() {
        this.targetUI = new SelectTargetComponent(Language.DEFLANG, this, SHStyle.INSTANCE, false){

            @Override
            protected AbstractTarget[] filterTargetInstances(AbstractTarget[] instances) {
                ArrayList<AbstractTarget> finalList = new ArrayList<AbstractTarget>();
                for (AbstractTarget target : instances) {
                    if (target instanceof RunToolTarget) continue;
                    finalList.add(target);
                }
                return finalList.toArray(new AbstractTarget[0]);
            }
        };
        this.actionsPanel = new GbPanel();
        JLabel desc = new JLabel(Language.get("LOGGING_UI_SELECT_TARGET_DESC"));
        desc.setIcon(ImageLoader.getImageIcon("images/svg/users/runner.svg,16"));
        desc.setIconTextGap(8);
        this.actionsPanel.add(desc, 0, 0, 1, 1, 0, 0, 17, 0, new Insets(10, 3, 10, 3));
        this.actionsPanel.add(this.targetUI.getComponent(), 0, 1, 1, 1, 1, 1, 10, 1, new Insets(3, 3, 3, 3));
    }

    @Override
    protected void initUIForSingleAlert(ResourceContainer alert) {
        super.initUIForSingleAlert(alert);
        if (alert instanceof ServerEvent) {
            this.infoPanel.initPanelWith((ServerEvent)alert);
            this.filterUI.setEvents(this.infoPanel.getSelectedEvents());
            this.targetUI.setLogEventsToTarget(this.infoPanel.getSelectedEvents());
            this.targetUI.load(((ServerEvent)alert).getTarget());
            this.filterUI.loadFromExistingFilters(((ServerEvent)alert).getFilters());
        }
    }

    @Override
    public void buttonClicked(Object machineID) {
        this.alertPanelListener.showMachineInUI((String)machineID);
    }

    @Override
    public void targetUIComplete() {
    }

    @Override
    public void targetUIIncomplete() {
    }

    @Override
    public void targetChanged() {
        this.alertModified();
    }

    public void groupsChanged(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
    }
}

