/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.events.server;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.proxy.types.ServerEvent;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.contents.ContentsMetrics;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.alerts.model.AlertModelChangeListener;
import com.aem.shelp.tech.alerts.alerts.model.FilterAlertResultsGroup;
import com.aem.shelp.tech.alerts.alerts.model.filters.TextAlertFilter;
import com.aem.shelp.tech.alerts.alerts.utils.AlertSelection;
import com.aem.shelp.tech.alerts.alerts.utils.ServerEventAlertSelection;
import com.aem.shelp.tech.alerts.events.AlertContentsPanelInterface;
import com.aem.shelp.tech.alerts.events.server.contents.ServerEventsTableGroupList;
import com.aem.shelp.tech.alerts.events.server.model.ServerEventsTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import utils.swing.SwingUtil;
import utils.swing.components.JIconTextField;
import utils.swing.components.JSearchTextField;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ServerEventsContentsPanel
implements MessageFieldHandler.FilterListener,
AlertModelChangeListener,
ActionListener,
AlertContentsPanelInterface {
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private ServerEventsTableGroupList currentContentsPanel;
    private ServerEventsTableGroupList eventsTableGroupList;
    private AlertPanelListener alertPanelListener;
    private ServerEventsTreeModel eventsModel;
    private GbPanel buttonPanel;
    private FilterSetter delayedFilterSetter = null;
    private Object setFilterLock = new Object();
    private ButtonListener buttonListener = new ButtonListener();
    private JToggleButton toggleDetailsButton;
    private JButton newEventsButton;
    private JSearchTextField filterField;
    private ResourceContainerGroup resultsGroup;
    private TextAlertFilter searchFilter;
    private ResourceContainerGroup[] selectedGroups;
    private boolean isDetailsPanelVisible = true;
    private AlertSelection selection;

    public Component getRootComponent() {
        return this.rootComponent;
    }

    public ServerEventsContentsPanel(ServerEventsTreeModel machineInterface, AlertPanelListener listener) {
        this.alertPanelListener = listener;
        this.eventsModel = machineInterface;
        this.initUI();
    }

    @Override
    public void setDetailsPanelIsShowing(boolean isDetailsPanelVisible) {
        this.isDetailsPanelVisible = isDetailsPanelVisible;
        this.toggleDetailsButton.setSelected(isDetailsPanelVisible);
        this.setDetailsButtonTooltip();
    }

    public void setDetailsButtonTooltip() {
        if (this.toggleDetailsButton.isSelected()) {
            this.toggleDetailsButton.setToolTipText(Language.get("HIDE_DETAILS_TOOLTIP"));
        } else {
            this.toggleDetailsButton.setToolTipText(Language.get("SHOW_DETAILS_TOOLTIP"));
        }
    }

    @Override
    public void updateUIWithMetrics(ContentsMetrics metrics) {
    }

    private void initUI() {
        this.resultsGroup = FilterAlertResultsGroup.newResultsGroup(Language.get("SEARCH_RESULTS"));
        this.searchFilter = new TextAlertFilter(this.resultsGroup);
        this.eventsTableGroupList = new ServerEventsTableGroupList(this.alertPanelListener);
        this.eventsModel.addModelChangeListener(this.eventsTableGroupList);
        this.currentContentsPanel = this.eventsTableGroupList;
        this.initButtonPanel();
        this.rootComponent.add((Component)this.eventsTableGroupList.getRootComponent(), "Center");
        this.rootComponent.add((Component)this.buttonPanel, "North");
        this.newEventsButton.addActionListener(this.buttonListener);
        this.toggleDetailsButton.addActionListener(this.buttonListener);
        this.eventsTableGroupList.initUI(this.eventsModel, this.eventsModel.getRootGroups());
        this.setSelectedAlerts(ServerEventAlertSelection.EMPTY);
    }

    private void initButtonPanel() {
        this.buttonPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        this.buttonPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARK);
        MatteBorder outer = SHBorderFactory.createMatteBorder(0, 0, 1, 0, AccessStyle.GROUP_TITLE_BORDER_TOP);
        Border inner = SHBorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.buttonPanel.setBorder(SHBorderFactory.createCompoundBorder(outer, inner));
        this.toggleDetailsButton = new JToggleButton(ImageLoader.getImageIcon("images/svg/dialogs/information-square-green.svg,16"));
        this.newEventsButton = new JButton(Language.get("NEW_SERVER_EVENT")){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(d.width, ((ServerEventsContentsPanel)ServerEventsContentsPanel.this).toggleDetailsButton.getPreferredSize().height);
            }
        };
        this.setDetailsButtonTooltip();
        this.toggleDetailsButton.setSelected(true);
        this.updateSelectedView();
        this.filterField = new JSearchTextField(Language.get("SEARCH_TREE_TEXT"));
        this.filterField.addIcon(ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.filterField.addIcon(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"), false, false, "SEARCH");
        this.filterField.setFilterListener(this);
        this.filterField.addIconClickListener(new JIconTextField.IconClickListener(){

            @Override
            public void iconClicked(String id) {
                if (id.equals("SEARCH") && ServerEventsContentsPanel.this.filterField.getText().length() > 0) {
                    ResourceContainerGroup groupToSave = ServerEventsContentsPanel.this.resultsGroup;
                    ServerEventsContentsPanel.this.resultsGroup = FilterAlertResultsGroup.newResultsGroup(Language.get("SEARCH_RESULTS"));
                    ServerEventsContentsPanel.this.eventsModel.moveGroupToFinalChild(groupToSave);
                    ServerEventsContentsPanel.this.eventsModel.renameGroup(groupToSave, ServerEventsContentsPanel.this.filterField.getText().trim());
                    if (groupToSave instanceof FilterAlertResultsGroup) {
                        ((FilterAlertResultsGroup)groupToSave).setTemporary(false);
                    }
                    ServerEventsContentsPanel.this.filterField.setText(null);
                    ServerEventsContentsPanel.this.filterField.changeIcon(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"), "SEARCH");
                    ServerEventsContentsPanel.this.filterField.repaint();
                    ServerEventsContentsPanel.this.alertPanelListener.renameSelectedNode(groupToSave);
                    ServerEventsContentsPanel.this.eventsModel.notifyFilterProcessorChange();
                }
            }
        });
        this.filterField.setSize(250, 24);
        this.filterField.setPreferredSize(new Dimension(250, 24));
        SwingUtil.setWidth(this.filterField, 250);
        int X = 0;
        this.buttonPanel.add(this.toggleDetailsButton, X++, 0, 1, 1, 0, 1, 17, 0, new Insets(3, 3, 3, 3));
        this.buttonPanel.add(this.newEventsButton, X++, 0, 1, 1, 0, 1, 17, 0, new Insets(3, 8, 3, 3));
        this.buttonPanel.add(this.filterField, X++, 0, 1, 1, 1, 1, 13, 0, new Insets(3, 0, 3, 3));
    }

    @Override
    public void setSelectedGroups(ResourceContainerGroup[] selectedGroups) {
        if (Arrays.equals(selectedGroups, this.selectedGroups)) {
            return;
        }
        this.selectedGroups = selectedGroups;
        Runnable work = new Runnable(){

            @Override
            public void run() {
                ServerEventsContentsPanel.this.currentContentsPanel.initUI(ServerEventsContentsPanel.this.eventsModel, ServerEventsContentsPanel.this.selectedGroups);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            work.run();
        } else {
            SwingUtilities.invokeLater(work);
        }
    }

    @Override
    public void setSelectedGroup(ResourceContainerGroup selectedGroup) {
        this.setSelectedGroups(new ResourceContainerGroup[]{selectedGroup});
    }

    public void updateSelectedView() {
        this.currentContentsPanel.setVisible(false);
        this.currentContentsPanel = this.eventsTableGroupList;
        this.currentContentsPanel.initUI(this.eventsModel, this.selectedGroups);
        this.currentContentsPanel.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFilter(String filter, boolean immediately) {
        Object object = this.setFilterLock;
        synchronized (object) {
            if (this.delayedFilterSetter != null) {
                this.delayedFilterSetter.setFilter(filter, immediately);
            } else {
                this.delayedFilterSetter = new FilterSetter(filter, immediately);
            }
        }
    }

    public void clearSearchResults() {
        TreeGroup[] groupsIn = (ResourceContainerGroup[])this.eventsModel.getGroupsIn(this.resultsGroup);
        if (groupsIn != null) {
            this.eventsModel.removeGroups(groupsIn);
        }
    }

    public void groupsRemoved(ResourceContainerGroup parentGroup, ResourceContainerGroup[] removedChildren, int[] removedIndices) {
        if (this.isSelectedGroup(parentGroup)) {
            this.setSelectedGroups(this.selectedGroups);
        }
    }

    public void groupsAdded(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
        if (this.isSelectedGroup(parentGroup)) {
            this.setSelectedGroups(this.selectedGroups);
        }
    }

    public void groupsChanged(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
    }

    private boolean isSelectedGroup(ResourceContainerGroup group) {
        if (this.selectedGroups == null || group == null) {
            return false;
        }
        for (ResourceContainerGroup selectedGroup : this.selectedGroups) {
            if (selectedGroup.equals(group)) {
                return true;
            }
            if (!this.isSelectedGroup((ResourceContainerGroup)group.getParent())) continue;
            return true;
        }
        return false;
    }

    public void machinesChanged(ResourceContainerGroup parent, ResourceContainer[] inserted, ResourceContainer[] removed, ResourceContainer[] updated, Machine.MachineChanges updateResults) {
    }

    @Override
    public void setSelectedAlerts(AlertSelection selection) {
        this.selection = selection;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void filterProcessorChanged() {
    }

    @Override
    public boolean isAlertSelected(ResourceContainer alert) {
        return this.selection.getMachineCount() == 1 && ((ResourceContainer[])this.selection.getAllElements())[0].equals(alert);
    }

    @Override
    public void ensureAlertIsSelected(ResourceContainerGroup group, ResourceContainer machine) {
        this.alertPanelListener.setSelectedGroup(null, this.eventsModel.getAvailableMachinesGroup());
        this.currentContentsPanel.ensureMachineIsSelected(group, machine);
    }

    class FilterSetter
    extends Thread {
        private long endTime;
        private String filter;

        public FilterSetter(String filter, boolean immediately) {
            super("FilterSetter");
            this.setFilter(filter, immediately);
            this.start();
        }

        public void setEndTime(long time) {
            this.endTime = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFilter(String filter, boolean immediately) {
            Object object = ServerEventsContentsPanel.this.setFilterLock;
            synchronized (object) {
                this.filter = filter;
                this.endTime = !immediately ? System.currentTimeMillis() + 500L : System.currentTimeMillis();
                ServerEventsContentsPanel.this.setFilterLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ServerEventsContentsPanel.this.setFilterLock;
            synchronized (object) {
                while (System.currentTimeMillis() < this.endTime) {
                    try {
                        ServerEventsContentsPanel.this.setFilterLock.wait(this.endTime - System.currentTimeMillis());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ServerEventsContentsPanel.this.clearSearchResults();
                String[] newFilter = null;
                if (this.filter != null && this.filter.trim().length() != 0) {
                    newFilter = this.filter.toLowerCase().split("\\s+");
                    for (int i = 0; i < newFilter.length; ++i) {
                        newFilter[i] = newFilter[i].trim();
                    }
                }
                if (newFilter == null) {
                    ServerEventsContentsPanel.this.eventsModel.removeFilter(ServerEventsContentsPanel.this.resultsGroup);
                    ServerEventsContentsPanel.this.filterField.changeIcon(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"), "SEARCH");
                    ServerEventsContentsPanel.this.filterField.repaint();
                    ServerEventsContentsPanel.this.delayedFilterSetter = null;
                    return;
                }
                final String[] finalFilter = newFilter;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ServerEventsContentsPanel.this.filterField.changeIcon(ImageLoader.getImageIcon("images/svg/general/star.svg,16"), "SEARCH");
                        ServerEventsContentsPanel.this.filterField.repaint();
                        ServerEventsContentsPanel.this.eventsModel.removeAllGroupsAndMachines(ServerEventsContentsPanel.this.resultsGroup);
                        ServerEventsContentsPanel.this.searchFilter.setRoot(ServerEventsContentsPanel.this.resultsGroup);
                        ServerEventsContentsPanel.this.searchFilter.setConjunctionFilters(finalFilter);
                        ServerEventsContentsPanel.this.eventsModel.addFilterProcessor(ServerEventsContentsPanel.this.searchFilter, ServerEventsContentsPanel.this.resultsGroup, true);
                        ServerEventsContentsPanel.this.alertPanelListener.setSelectedGroups(ServerEventsContentsPanel.this, new ResourceContainerGroup[]{ServerEventsContentsPanel.this.resultsGroup});
                        ServerEventsContentsPanel.this.currentContentsPanel.initUI(ServerEventsContentsPanel.this.eventsModel, ServerEventsContentsPanel.this.selectedGroups);
                    }
                });
                ServerEventsContentsPanel.this.delayedFilterSetter = null;
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ServerEventsContentsPanel.this.newEventsButton) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        ServerEvent alert = new ServerEvent();
                        MachineName name = new MachineName(Language.get("ALERT_NEW_NAME"));
                        alert.setName(name);
                        ResourceContainerGroup alertGroup = (ResourceContainerGroup)ServerEventsContentsPanel.this.eventsModel.getAvailableMachinesGroup();
                        if (ServerEventsContentsPanel.this.selectedGroups != null) {
                            alertGroup = ServerEventsContentsPanel.this.selectedGroups[0];
                            String[] path = ServerEventsContentsPanel.this.eventsModel.getGroupPath(alertGroup);
                            name.setGroup(path);
                        }
                        ServerEventsContentsPanel.this.eventsModel.addElements(new ServerEvent[]{alert});
                        ServerEventAlertSelection selection = new ServerEventAlertSelection();
                        selection.addMachines(alertGroup, new ServerEvent[]{alert});
                        ServerEventsContentsPanel.this.alertPanelListener.setSelectedElements(this, selection, true);
                        ServerEventsContentsPanel.this.alertPanelListener.ensureElementSelected(alertGroup, alert);
                        ServerEventsContentsPanel.this.alertPanelListener.alertCreated(alert);
                    }
                };
                new Thread(task).start();
            } else if (source == ServerEventsContentsPanel.this.toggleDetailsButton) {
                boolean shouldShowDetails = ServerEventsContentsPanel.this.toggleDetailsButton.isSelected();
                ServerEventsContentsPanel.this.alertPanelListener.setDetailsPanelVisiblity(shouldShowDetails);
            }
        }
    }
}

