/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.utils;

import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.tech.access.AccessStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;

public class StatusIcon
implements Icon {
    private int width = stdWidth;
    private int height = ImageLoader.getImageIcon("images/svg/machine-state/inuse.svg,16").getIconHeight();
    private LocatedAlert alert;
    private static int stdWidth = SimpleHelpLookAndFeel.scale(52);
    public static final boolean PAINT_BORDERS = false;
    static Color bgokborder = new Color(222, 228, 235);
    static Color bg;
    static Color bgok;
    static Color border;
    static Color text;

    public static int getStdWidth() {
        return stdWidth;
    }

    public static void renderStatus(Graphics g, LocatedAlert alert, int xCenter, int yCenter) {
        Color orig = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        Icon statusIcon = null;
        int paddedHeight = yCenter * 2 - SimpleHelpLookAndFeel.scale(2);
        int num = alert.getTriggeredMachines().size();
        boolean draw = false;
        if (!alert.isActive()) {
            draw = false;
        } else if (num > 0) {
            draw = true;
            statusIcon = ImageLoader.getImageIcon("images/svg/alert-flags/grey.svg,16");
        } else {
            draw = true;
            statusIcon = ImageLoader.getImageIcon("images/svg/alert-flags/blue-down.svg,24");
        }
        if (draw) {
            String numstr = "" + num;
            int lhs = xCenter - stdWidth / 2 + 3;
            if (numstr.length() < 5 && statusIcon != null) {
                statusIcon.paintIcon(null, g, lhs, yCenter - statusIcon.getIconHeight() / 2);
            }
            Font font = AccessStyle.MACHINE_TABLE_FONT;
            g.setFont(font);
            lhs += 18;
            int rhs = xCenter + stdWidth / 2 - 3;
            Rectangle2D r2 = font.getStringBounds(numstr, 0, numstr.length(), g2.getFontRenderContext());
            g.setColor(orig);
            int yAdjust = -2;
            g.drawString(numstr, rhs - (int)r2.getWidth(), yCenter + (int)(r2.getHeight() / 2.0) + yAdjust);
        }
    }

    public static void renderMachines(Graphics g, LocatedAlert alert, int xCenter, int yCenter, int num) {
        Color orig = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        Icon statusIcon = null;
        int paddedHeight = yCenter * 2 - SimpleHelpLookAndFeel.scale(2);
        boolean triggered = alert.getTriggeredMachines().size() > 0;
        boolean draw = false;
        if (!alert.isActive()) {
            draw = false;
        } else if (triggered) {
            draw = true;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GradientPaint gp = new GradientPaint(xCenter - stdWidth / 2, 0.0f, bg, xCenter + stdWidth / 2, paddedHeight, bgok);
            g2.setPaint(gp);
            statusIcon = ImageLoader.getImageIcon("images/svg/technology/screen.svg,16");
        } else {
            draw = true;
            statusIcon = ImageLoader.getImageIcon("images/svg/technology/screen.svg,16");
        }
        if (draw) {
            String numstr = "" + num;
            int lhs = xCenter - stdWidth / 2 + 3;
            if (numstr.length() < 5 && statusIcon != null) {
                statusIcon.paintIcon(null, g, lhs, yCenter - statusIcon.getIconHeight() / 2);
            }
            Font font = AccessStyle.MACHINE_TABLE_FONT;
            g.setFont(font);
            lhs += 18;
            int rhs = xCenter + stdWidth / 2 - 3;
            Rectangle2D r2 = font.getStringBounds(numstr, 0, numstr.length(), g2.getFontRenderContext());
            g.setColor(orig);
            int yAdjust = -2;
            g.drawString(numstr, rhs - (int)r2.getWidth(), yCenter + (int)(r2.getHeight() / 2.0) + yAdjust);
        }
    }

    public void setAlert(LocatedAlert alert) {
        this.alert = alert;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.alert == null) {
            return;
        }
        StatusIcon.renderStatus(g, this.alert, x + this.width / 2, y + this.height / 2);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    static {
        bgok = bg = new Color(255, 220, 79);
        border = new Color(232, 192, 32);
        text = new Color(30, 30, 30);
    }
}

