/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details.triggers;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.alerts.details.AlertModifyListener;
import com.aem.shelp.tech.alerts.alerts.details.AlertTriggersPanel;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggerGroupPanel;
import com.aem.utils.gui.verifiers.DigitDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class TriggersListPanel
implements ActionListener,
DocumentListener,
AlertModifyListener {
    private JPanel rootComponent = new JPanel();
    private ArrayList<TriggerGroup> triggerGroups;
    private JButton addNewGroupButton;
    ArrayList<TriggerGroupPanel> panels = new ArrayList();
    private JToggleButton reverseConjunction = new JToggleButton(ImageLoader.getImageIcon("images/svg/computing/and.svg,16"));
    private GbPanel centrePanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    private boolean conjunctionBetweenGroups;
    JTextField mins;
    AlertModifyListener modify;
    TechClient client;
    MachineTreeModel machines;
    private AlertTriggersPanel alertTriggersPanel;
    private GbPanel bottom;
    private long timeMS;
    private boolean initialising;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public ArrayList<ArrayList<Alert>> getAlerts() {
        ArrayList<ArrayList<Alert>> groups = new ArrayList<ArrayList<Alert>>();
        if (this.triggerGroups != null) {
            for (TriggerGroup tg : this.triggerGroups) {
                ArrayList<Alert> ids = new ArrayList<Alert>();
                if (CentralDebugging.ALERT_ROUND_TRIPPING) {
                    System.out.println("TG / " + tg.triggers.size());
                }
                for (Alert alert : tg.triggers) {
                    ids.add(alert);
                }
                groups.add(ids);
            }
        }
        if (CentralDebugging.ALERT_ROUND_TRIPPING) {
            System.out.println("TOTGROUPS / " + groups.size());
        }
        return groups;
    }

    public long getTimeMS() {
        String value = this.mins.getText();
        double d = value.length() == 0 ? 0.5 : Double.parseDouble(this.mins.getText());
        return (long)(d *= 60000.0);
    }

    public void setTimeMS(long t) {
        double d = t;
        this.mins.setText("" + (d /= 60000.0));
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        TriggersListPanel triggerListPanel = new TriggersListPanel(null, null, SwingUtil.getRootPaneContainer(frame), "Test", true);
        frame.getContentPane().add(triggerListPanel.getRootComponent());
        TriggerGroup g1 = new TriggerGroup();
        g1.triggers = new ArrayList();
        g1.triggers.add(Alert.createTestAlert());
        g1.triggers.add(Alert.createTestAlert());
        g1.triggers.add(Alert.createTestAlert());
        TriggerGroup g2 = new TriggerGroup();
        g2.triggers = new ArrayList();
        g2.triggers.add(Alert.createTestAlert());
        g2.triggers.add(Alert.createTestAlert());
        g2.triggers.add(Alert.createTestAlert());
        ArrayList<TriggerGroup> groups = new ArrayList<TriggerGroup>();
        groups.add(g1);
        groups.add(g2);
        triggerListPanel.initFor(groups, true, 30000L);
        frame.setVisible(true);
    }

    public boolean isConjunctionBetweenGroups() {
        return this.conjunctionBetweenGroups;
    }

    public void setConjunctionBetweenGroups(boolean b) {
        this.conjunctionBetweenGroups = b;
        this.reinit();
    }

    public void setMachineTreeModel(MachineTreeModel machines) {
        this.machines = machines;
    }

    public MachineTreeModel getMachineTreeModel() {
        return this.machines;
    }

    public void setTechClient(TechClient client) {
        this.client = client;
    }

    public TechClient getTechClient() {
        return this.client;
    }

    public TriggersListPanel(AlertTriggersPanel atp, AlertModifyListener modify, RootPaneContainer rpc, String name, boolean isTriggers) {
        this.modify = modify;
        this.alertTriggersPanel = atp;
        this.rootComponent.setLayout(new BorderLayout());
        JLabel nom = new JLabel();
        nom.setHorizontalAlignment(2);
        nom.setText(name);
        this.bottom = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        int X = 0;
        this.bottom.add(nom, X++, 0, 1, 1, 0, 0, 17, 2);
        this.mins = new JTextField("1");
        this.mins.setColumns(3);
        this.mins.setDocument(new DigitDocument(false, true));
        this.mins.getDocument().addDocumentListener(this);
        JLabel minl = new JLabel(Language.get("ALERT_TIME_PASSES"));
        this.bottom.add(this.mins, X++, 0, 1, 1, 0, 0, 13, 2);
        this.bottom.add(minl, X++, 0, 1, 1, 1, 0, 17, 2);
        this.bottom.add(this.reverseConjunction, X++, 0, 1, 1, 0, 0, 13, 0, new Insets(3, 20, 3, 3));
        SwingUtil.setWidth(this.mins, SimpleHelpLookAndFeel.scale(40));
        SwingUtil.setHeight(this.bottom, SimpleHelpLookAndFeel.scale(32));
        this.setConjunctionTooltip();
        this.bottom.setVisible(false);
        this.bottom.setBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        this.bottom.setBackground(SHStyle.PANEL_BACKGROUND_LIGHT);
        this.rootComponent.add("South", this.bottom);
        JScrollPane scroller = new JScrollPane(this.centrePanel);
        scroller.setBorder(SHBorderFactory.createEmptyBorder());
        this.rootComponent.add("Center", scroller);
        this.addNewGroupButton = isTriggers ? new JButton(Language.get("ALERT_ADD_GROUP_TRIGGER")) : new JButton(Language.get("ALERT_ADD_GROUP_RESET"));
        this.addNewGroupButton.setFont(SHStyle.smallerFont);
        this.addNewGroupButton.addActionListener(this);
        this.reverseConjunction.addActionListener(this);
    }

    private void setConjunctionTooltip() {
        if (this.reverseConjunction.isSelected()) {
            this.reverseConjunction.setToolTipText(Language.get("REVERSE_CONJUNCTION_TOOLTIP_AND"));
        } else {
            this.reverseConjunction.setToolTipText(Language.get("REVERSE_CONJUNCTION_TOOLTIP_OR"));
        }
    }

    private void reinit() {
        this.initFor(this.triggerGroups, this.conjunctionBetweenGroups, this.timeMS);
    }

    public void addThreshold(Alert alert, int groupIndex) {
        if (CentralDebugging.ALERT_COROLLARY) {
            System.out.println("[AlertCorollary] Adding corollary " + alert.getID() + " (" + alert.isCorollaryFor() + ")");
        }
        while (groupIndex >= this.triggerGroups.size()) {
            if (CentralDebugging.ALERT_COROLLARY) {
                System.out.println("[AlertCorollary] Adding new group for corollary");
            }
            this.addNewGroup();
        }
        if (CentralDebugging.ALERT_COROLLARY) {
            System.out.println("[AlertCorollary] Adding corollary to index " + groupIndex);
        }
        this.triggerGroups.get((int)groupIndex).triggers.add(alert);
        if (CentralDebugging.ALERT_COROLLARY) {
            System.out.println("[AlertCorollary] Reiniting");
        }
        this.initFor(this.triggerGroups, this.conjunctionBetweenGroups, this.getTimeMS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFor(ArrayList<TriggerGroup> triggerGroups, boolean conjunctionBetweenGroups, long timeMS) {
        this.initialising = true;
        try {
            this.triggerGroups = triggerGroups;
            if (triggerGroups.size() == 0) {
                TriggerGroup newGroup = new TriggerGroup();
                newGroup.triggers = new ArrayList();
                triggerGroups.add(newGroup);
            }
            this.conjunctionBetweenGroups = conjunctionBetweenGroups;
            this.timeMS = timeMS;
            this.reverseConjunction.setSelected(conjunctionBetweenGroups);
            this.setConjunctionTooltip();
            this.centrePanel.removeAll();
            int Y = 0;
            this.reverseConjunction.setVisible(false);
            for (TriggerGroup group : triggerGroups) {
                if (Y > 0) {
                    JLabel conjunctionLabel = new JLabel(Language.get(conjunctionBetweenGroups ? "AND" : "OR"));
                    conjunctionLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
                    conjunctionLabel.setHorizontalAlignment(0);
                    this.centrePanel.add(conjunctionLabel, 0, Y++, 1, 1, 1, 0, 10, 2);
                }
                if (group.triggers.size() > 0) {
                    this.reverseConjunction.setVisible(true);
                }
                TriggerGroupPanel panel = new TriggerGroupPanel(this.modify, group, this, !conjunctionBetweenGroups);
                panel.addAlertModifyListener(this);
                this.panels.add(panel);
                this.centrePanel.add(panel, 0, Y++, 1, 1, 1, 0, 10, 2);
            }
            if (triggerGroups.size() > 1) {
                this.reverseConjunction.setVisible(true);
            }
            this.centrePanel.add(this.addNewGroupButton, 0, Y++, 1, 1, 1, 0, 10, 0);
            this.centrePanel.add(new JPanel(), 0, Y++, 1, 1, 1, 1, 10, 2);
            this.showSouthPanel();
            this.centrePanel.revalidate();
            this.centrePanel.repaint();
            this.updateEnabled();
            this.setTimeMS(timeMS);
        }
        finally {
            this.initialising = false;
        }
    }

    private void showSouthPanel() {
        if (this.centrePanel.getComponentCount() > 2) {
            this.bottom.setVisible(true);
        } else {
            this.bottom.setVisible(false);
        }
    }

    public void updateCorollary(Alert master) {
        if (CentralDebugging.ALERT_COROLLARY) {
            System.out.println("[AlertCorollary] Checking for corollary of " + master.getID());
        }
        for (TriggerGroup group : this.triggerGroups) {
            if (CentralDebugging.ALERT_COROLLARY) {
                System.out.println("[AlertCorollary] Checking group");
            }
            for (int i = 0; i < group.triggers.size(); ++i) {
                if (CentralDebugging.ALERT_COROLLARY) {
                    System.out.println("[AlertCorollary] Checking trigger " + i);
                }
                Alert check = group.triggers.get(i);
                if (CentralDebugging.ALERT_COROLLARY) {
                    System.out.println("[AlertCorollary] Checking " + check.getName() + " (" + check.isCorollaryFor() + ")");
                }
                if (!check.isCorollaryFor().equals(master.getID())) continue;
                Alert co = master.createCorollary();
                co.importIDfrom(check);
                co.setIsCorollaryFor(master.getID());
                co.setName(co.getDefaultName());
                co.setUsingDefaultName(true);
                group.triggers.set(i, co);
                if (CentralDebugging.ALERT_COROLLARY) {
                    System.out.println("[AlertCorollary] Found, created new corollary alert " + co.getName() + " / " + co.getID() + " (" + co.isCorollaryFor() + ")");
                }
                this.initFor(this.triggerGroups, this.conjunctionBetweenGroups, this.getTimeMS());
                return;
            }
        }
    }

    public void removeCorollary(Alert master) {
        if (CentralDebugging.ALERT_COROLLARY) {
            System.out.println("[AlertCorollary] Checking for corollary of " + master.getID());
        }
        for (TriggerGroup group : this.triggerGroups) {
            for (int i = 0; i < group.triggers.size(); ++i) {
                Alert check = group.triggers.get(i);
                if (!check.isCorollaryFor().equals(master.getID())) continue;
                if (CentralDebugging.ALERT_COROLLARY) {
                    System.out.println("[AlertCorollary] Found, removed.");
                }
                group.triggers.remove(i);
                this.initFor(this.triggerGroups, this.conjunctionBetweenGroups, this.getTimeMS());
                return;
            }
        }
    }

    public void removeCorollaryIfExists(Alert master) {
        this.alertTriggersPanel.removeCorollaryIfExists(master, this);
    }

    public void updateCorollaryIfExists(Alert master) {
        this.alertTriggersPanel.updateCorollaryIfExists(master, this);
    }

    public void corollaryCreated(Alert alert, TriggerGroup group) {
        this.alertTriggersPanel.corollaryCreated(alert, this, this.triggerGroups.indexOf(group));
    }

    private boolean containsEmptyTriggerGroup() {
        for (TriggerGroup group : this.triggerGroups) {
            if (group.triggers.size() != 0) continue;
            return true;
        }
        return false;
    }

    private void updateEnabled() {
        this.addNewGroupButton.setEnabled(!this.containsEmptyTriggerGroup());
        this.addNewGroupButton.repaint();
    }

    private void addNewGroup() {
        TriggerGroup newGroup = new TriggerGroup();
        newGroup.triggers = new ArrayList();
        this.triggerGroups.add(newGroup);
        this.initFor(this.triggerGroups, this.conjunctionBetweenGroups, this.getTimeMS());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addNewGroupButton) {
            this.addNewGroup();
        } else if (e.getSource() == this.reverseConjunction) {
            this.setConjunctionBetweenGroups(!this.isConjunctionBetweenGroups());
            this.setConjunctionTooltip();
        }
        if (this.modify != null) {
            this.modify.alertModified();
        }
    }

    public void removeTriggerGroup(TriggerGroup triggerGroup) {
        this.triggerGroups.remove(triggerGroup);
        this.initFor(this.triggerGroups, this.conjunctionBetweenGroups, this.getTimeMS());
        if (this.modify != null) {
            this.modify.alertModified();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.initialising) {
            return;
        }
        if (this.modify != null) {
            this.modify.alertModified();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.initialising) {
            return;
        }
        if (this.modify != null) {
            this.modify.alertModified();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.initialising) {
            return;
        }
        if (this.modify != null) {
            this.modify.alertModified();
        }
    }

    @Override
    public void alertModified() {
        this.updateEnabled();
    }

    public void threshholdAdded(TriggerGroup triggerGroup) {
        if (!this.reverseConjunction.isVisible() && triggerGroup.triggers.size() > 1) {
            this.reverseConjunction.setVisible(true);
        }
    }

    public static class TriggerGroup {
        public ArrayList<Alert> triggers;
    }
}

