/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details.triggers;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.tech.alerts.alerts.details.AlertModifyListener;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggerPickerDialog;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggersListPanel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.swing.SwingUtil;
import utils.swing.borders.ImprovedRoundRectBorder;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.glassdialog.GlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class TriggerGroupPanel
extends ColorPropagatingPanel
implements MouseListener {
    private static int maxConjunctionWidth;
    private TriggersListPanel.TriggerGroup triggerGroup;
    private static final Color backgroundColor;
    private static final Color backgroundColorDarker;
    private static final Color backgroundColorDarkest;
    ArrayList<AlertModifyListener> listeners = new ArrayList();
    private boolean isConjunction;
    private GbPanel contentPanel;
    private static ArrayList<TriggerGroupRow> rowsWithEditButtonsShowing;
    private TriggersListPanel triggersListPanel;

    public TriggersListPanel.TriggerGroup getTriggerGroup() {
        return this.triggerGroup;
    }

    public void removeAlert(Alert alert) {
        Component[] comps;
        if (CentralDebugging.ALERT_COROLLARY) {
            System.out.println("[AlertCorollary] Searching to remove " + alert.getID() + " (" + alert.isCorollaryFor() + ")");
        }
        for (Component comp : comps = this.contentPanel.getComponents()) {
            if (CentralDebugging.ALERT_COROLLARY) {
                System.out.println("[AlertCorollary] Comp: " + comp);
            }
            if (!(comp instanceof TriggerGroupRow)) continue;
            TriggerGroupRow tg = (TriggerGroupRow)comp;
            if (tg.trigger != null) {
                if (CentralDebugging.ALERT_COROLLARY) {
                    System.out.println("[AlertCorollary] Trigger: " + tg.trigger.getID() + " (" + tg.trigger.isCorollaryFor() + ")");
                }
                if (!tg.trigger.getID().equals(alert.getID())) continue;
                if (CentralDebugging.ALERT_COROLLARY) {
                    System.out.println("[AlertCorollary] Removing");
                }
                this.triggerGroup.triggers.remove(tg.trigger);
                this.removeRow(tg);
                this.notifyChanged();
                continue;
            }
            if (!CentralDebugging.ALERT_COROLLARY) continue;
            System.out.println("[AlertCorollary] Trigger: " + tg.trigger);
        }
    }

    public TriggerGroupPanel(AlertModifyListener modify, TriggersListPanel.TriggerGroup triggerGroup, TriggersListPanel triggersListPanel, boolean isConjunction) {
        super(new GridLayout(1, 1));
        this.isConjunction = isConjunction;
        this.triggersListPanel = triggersListPanel;
        this.triggerGroup = triggerGroup;
        this.addAlertModifyListener(modify);
        this.initUI();
    }

    public void addAlertModifyListener(AlertModifyListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void notifyChanged() {
        for (AlertModifyListener listener : this.listeners) {
            listener.alertModified();
        }
    }

    private void initUI() {
        ImprovedRoundRectBorder border = new ImprovedRoundRectBorder(backgroundColorDarkest, this.getBackground(), backgroundColor);
        border.setRadius(2);
        border.setWidth(1);
        this.setBorder(border);
        this.contentPanel = new GbPanel();
        this.contentPanel.setBackground(backgroundColor);
        this.add(this.contentPanel);
        int Y = 0;
        for (Alert trigger : this.triggerGroup.triggers) {
            TriggerGroupRow row = new TriggerGroupRow(trigger);
            row.setShowConjunction(Y > 0);
            this.contentPanel.add(row, 0, Y++, 1, 1, 1, 1, 17, 2);
        }
        TriggerGroupRow row = new TriggerGroupRow(null);
        row.setShowConjunction(Y > 0);
        this.contentPanel.add(row, 0, Y++, 1, 1, 1, 1, 17, 2);
    }

    public void addNewRow(TriggerGroupRow newRow) {
        TriggerGroupRow newItemRow = (TriggerGroupRow)this.contentPanel.getComponent(this.contentPanel.getComponentCount() - 1);
        this.contentPanel.remove(newItemRow);
        newRow.setShowConjunction(this.contentPanel.getComponentCount() > 0);
        this.contentPanel.add(newRow, 0, this.contentPanel.getComponentCount(), 1, 1, 1, 1, 17, 2);
        newItemRow.setShowConjunction(true);
        this.contentPanel.add(newItemRow, 0, this.contentPanel.getComponentCount(), 1, 1, 1, 1, 17, 2);
        this.notifyChanged();
    }

    public void setIsConjunction(boolean isConjunction) {
        this.isConjunction = isConjunction;
    }

    public void addThreshold(Alert alert) {
        TriggerGroupRow newRow = new TriggerGroupRow(alert);
        this.addNewRow(newRow);
        this.triggerGroup.triggers.add(alert);
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        this.notifyChanged();
    }

    public void removeRow(TriggerGroupRow triggerGroupRow) {
        this.contentPanel.remove(triggerGroupRow);
        if (this.contentPanel.getComponentCount() == 1) {
            this.triggersListPanel.removeTriggerGroup(this.triggerGroup);
        } else {
            boolean first = true;
            for (Component c : this.contentPanel.getComponents()) {
                if (c instanceof TriggerGroupRow) {
                    ((TriggerGroupRow)c).setShowConjunction(!first);
                }
                first = false;
            }
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseExited(MouseEvent e) {
        ArrayList<TriggerGroupRow> arrayList = rowsWithEditButtonsShowing;
        synchronized (arrayList) {
            for (Component c : this.contentPanel.getComponents()) {
                if (c instanceof TriggerGroupRow) {
                    TriggerGroupRow row = (TriggerGroupRow)c;
                    row.hideButtons();
                    row.repaint();
                }
                rowsWithEditButtonsShowing.remove(c);
            }
        }
    }

    static {
        backgroundColor = SHStyle.PANEL_BACKGROUND_BLUE;
        backgroundColorDarker = new Color(200, 220, 240);
        backgroundColorDarkest = new Color(190, 210, 240);
        rowsWithEditButtonsShowing = new ArrayList();
        JButton AND = new JButton(Language.get("AND"));
        JButton OR = new JButton(Language.get("OR"));
        maxConjunctionWidth = Math.max(AND.getPreferredSize().width, OR.getPreferredSize().width);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent && rowsWithEditButtonsShowing.size() > 0) {
                    ArrayList arrayList = rowsWithEditButtonsShowing;
                    synchronized (arrayList) {
                        MouseEvent e = (MouseEvent)event;
                        for (int i = rowsWithEditButtonsShowing.size() - 1; i >= 0; --i) {
                            TriggerGroupRow row = (TriggerGroupRow)rowsWithEditButtonsShowing.get(i);
                            if (row.contains(e.getPoint())) continue;
                            row.hideButtons();
                            rowsWithEditButtonsShowing.remove(i);
                        }
                    }
                }
            }
        }, 16L);
    }

    class TriggerGroupRow
    extends JPanel
    implements MouseListener,
    ActionListener {
        private Alert trigger;
        private JLabel triggerLabel;
        private JPanel eastButtons;
        private JButton editButton;
        private JButton removeButton;
        private JLabel conjunctionLabel;
        private JButton addButton;
        boolean eastButtonsShowing;

        private void update() {
            this.triggerLabel.setText(this.trigger.getName());
        }

        public TriggerGroupRow(Alert trigger) {
            super(new BorderLayout());
            this.eastButtons = new JPanel();
            this.eastButtonsShowing = false;
            this.trigger = trigger;
            this.setBackground(backgroundColor);
            if (trigger != null) {
                this.eastButtons.setOpaque(false);
                this.editButton = new JButton(Language.get("EDIT"));
                this.editButton.setFont(SHStyle.smallerFont);
                this.editButton.setMargin(new ScaledInsets(3, 5, 3, 5));
                this.removeButton = new JButton(Language.get("REMOVE"));
                this.removeButton.setFont(SHStyle.smallerFont);
                this.removeButton.setMargin(new ScaledInsets(3, 5, 3, 5));
                SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(new AbstractButton[]{this.editButton, this.removeButton});
                SHButtonUI.makeButtonRed(this.removeButton);
                this.triggerLabel = new JLabel(trigger.getName()){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension dim = super.getPreferredSize();
                        dim.width = 1;
                        return dim;
                    }
                };
                this.add((Component)this.triggerLabel, "Center");
                this.eastButtons.setLayout(new GridLayout(1, 2));
                this.eastButtons.add(this.editButton);
                this.eastButtons.add(this.removeButton);
                this.addMouseListener(this);
                this.editButton.addActionListener(this);
                this.removeButton.addActionListener(this);
            } else {
                JPanel buttonPanel = new JPanel(new BorderLayout());
                buttonPanel.setBackground(backgroundColor);
                this.addButton = new JButton(Language.get("ALERT_TRIGGER"), ImageLoader.getImageIcon("images/svg/general/add.svg,12"));
                this.addButton.setFont(SHStyle.smallerFont);
                this.addButton.setMargin(new Insets(3, 5, 3, 5));
                buttonPanel.add((Component)this.addButton, "West");
                this.add((Component)buttonPanel, "Center");
                this.addButton.addActionListener(this);
            }
            this.conjunctionLabel = new JLabel();
            SwingUtil.setWidth(this.conjunctionLabel, maxConjunctionWidth);
            this.conjunctionLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            this.conjunctionLabel.setHorizontalAlignment(0);
            this.add((Component)this.conjunctionLabel, "West");
            this.setBorder(SHBorderFactory.createEmptyBorder(5, 0, 5, 5));
            SwingUtil.setHeight(this, SimpleHelpLookAndFeel.scale(30));
        }

        public void setShowConjunction(boolean showConjunction) {
            if (showConjunction) {
                this.conjunctionLabel.setText(Language.get(TriggerGroupPanel.this.isConjunction ? "AND" : "OR"));
            } else {
                this.conjunctionLabel.setText("");
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseEntered(MouseEvent e) {
            e.consume();
            if (!this.eastButtonsShowing) {
                int width = this.eastButtons.getPreferredSize().width;
                int height = this.eastButtons.getPreferredSize().height;
                int y = (this.getHeight() - height) / 2;
                int x = this.getWidth() - width - 2;
                Point convertPoint = SwingUtilities.convertPoint(this, x, y, this.getRootPane());
                this.eastButtons.setBounds(convertPoint.x, convertPoint.y, width, height);
                this.getRootPane().getLayeredPane().add((Component)this.eastButtons, JLayeredPane.DEFAULT_LAYER);
                this.getRootPane().getLayeredPane().repaint();
                this.eastButtonsShowing = true;
                ArrayList arrayList = rowsWithEditButtonsShowing;
                synchronized (arrayList) {
                    for (TriggerGroupRow row : rowsWithEditButtonsShowing) {
                        row.hideButtons();
                        row.repaint();
                    }
                    rowsWithEditButtonsShowing.clear();
                    rowsWithEditButtonsShowing.add(this);
                }
            }
            this.setBackground(backgroundColorDarker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseExited(MouseEvent e) {
            Point p = (Point)e.getPoint().clone();
            Object source = e.getSource();
            SwingUtilities.convertPointToScreen(p, (JComponent)source);
            SwingUtilities.convertPointFromScreen(p, this.eastButtons);
            if (this.eastButtons.contains(p)) {
                return;
            }
            e.consume();
            this.hideButtons();
            ArrayList arrayList = rowsWithEditButtonsShowing;
            synchronized (arrayList) {
                rowsWithEditButtonsShowing.remove(this);
            }
            this.setBackground(backgroundColor);
        }

        private void hideButtons() {
            JLayeredPane layeredPane;
            this.eastButtonsShowing = false;
            JRootPane rootPane = this.getRootPane();
            if (rootPane != null && (layeredPane = rootPane.getLayeredPane()) != null) {
                layeredPane.remove(this.eastButtons);
                layeredPane.revalidate();
                layeredPane.repaint();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.removeButton) {
                this.hideButtons();
                ((TriggerGroupPanel)TriggerGroupPanel.this).triggerGroup.triggers.remove(this.trigger);
                TriggerGroupPanel.this.removeRow(this);
                if (CentralDebugging.ALERT_COROLLARY) {
                    System.out.println("[AlertCorollary] Removing any corollary for master " + this.trigger.getID() + " (" + this.trigger.getName() + ")");
                }
                TriggerGroupPanel.this.triggersListPanel.removeCorollaryIfExists(this.trigger);
                TriggerGroupPanel.this.notifyChanged();
            } else if (e.getSource() == this.editButton) {
                this.hideButtons();
                RootPaneContainer rpc = SwingUtil.getRootPaneContainer(this.getRootPane());
                if (rpc == null) {
                    rpc = SwingUtil.getRootPaneContainer(this.editButton);
                }
                if (this.trigger.isCorollaryFor().length() > 0 && 0 != GlassOptionPane.showConfirmDialog(rpc, Language.get("ALERT_CRLEDIT_QUESTION"), Language.get("ALERT_CRLEDIT_TITLE"), ImageLoader.getImageIcon("images/svg/alert-flags/yellow.svg,48"), new String[]{Language.get("YES"), Language.get("NO"), Language.get("CANCEL")})) {
                    return;
                }
                TriggerPickerDialog dialog = new TriggerPickerDialog(TriggerGroupPanel.this.triggersListPanel.getTechClient(), TriggerGroupPanel.this.triggersListPanel.getMachineTreeModel(), rpc, this.trigger);
                dialog.showDialog();
                if (dialog.isOKResult()) {
                    this.trigger.setIsCorollaryFor("");
                    int index = ((TriggerGroupPanel)TriggerGroupPanel.this).triggerGroup.triggers.indexOf(this.trigger);
                    ((TriggerGroupPanel)TriggerGroupPanel.this).triggerGroup.triggers.remove(index);
                    if (CentralDebugging.ALERT_COROLLARY) {
                        System.out.println("[AlertCorollary] Before edit " + this.trigger.getID());
                    }
                    this.trigger = dialog.getConfiguredAlert();
                    if (CentralDebugging.ALERT_COROLLARY) {
                        System.out.println("[AlertCorollary] After edit " + this.trigger.getID());
                    }
                    ((TriggerGroupPanel)TriggerGroupPanel.this).triggerGroup.triggers.add(index, this.trigger);
                    TriggerGroupPanel.this.triggersListPanel.updateCorollaryIfExists(this.trigger);
                    this.update();
                    TriggerGroupPanel.this.notifyChanged();
                }
            } else if (e.getSource() == this.addButton) {
                RootPaneContainer rpc = SwingUtil.getRootPaneContainer(this.getRootPane());
                if (rpc == null) {
                    rpc = SwingUtil.getRootPaneContainer(this.addButton);
                }
                this.hideButtons();
                TriggerPickerDialog dialog = new TriggerPickerDialog(TriggerGroupPanel.this.triggersListPanel.getTechClient(), TriggerGroupPanel.this.triggersListPanel.getMachineTreeModel(), rpc);
                dialog.showDialog();
                if (dialog.isOKResult()) {
                    Alert result = dialog.getConfiguredAlert();
                    if (result.isUsingDefaultName()) {
                        result.setName(result.getDefaultName());
                    } else {
                        result.setUsingDefaultName(false);
                    }
                    if (result != null) {
                        TriggerGroupPanel.this.addThreshold(result);
                        TriggerGroupPanel.this.triggersListPanel.threshholdAdded(TriggerGroupPanel.this.triggerGroup);
                        if (dialog.mustCreatePair()) {
                            Alert corollary = result.createCorollary();
                            if (CentralDebugging.ALERT_COROLLARY) {
                                System.out.println("[AlertCorollary] Created corollary " + corollary.getID() + " for master " + result.getID() + " (" + result.getName() + ")");
                            }
                            corollary.setIsCorollaryFor(result.getID());
                            if (result.isUsingDefaultName()) {
                                corollary.setUsingDefaultName(true);
                                corollary.setName(corollary.getDefaultName());
                            } else {
                                corollary.setUsingDefaultName(false);
                            }
                            TriggerGroupPanel.this.triggersListPanel.corollaryCreated(corollary, TriggerGroupPanel.this.triggerGroup);
                        }
                    }
                    TriggerGroupPanel.this.notifyChanged();
                }
            }
        }
    }
}

