/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details;

import aurelienribon.slidinglayout.DoTransition;
import aurelienribon.slidinglayout.SLAnimator;
import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.slidinglayout.SLSide;
import aurelienribon.slidinglayout.SLTransition;
import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.logging.alerts.LocatedAlertLogEvent;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.AlertLocation;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.alertlocs.AllMachinesAloc;
import com.aem.shelp.proxy.types.alertlocs.MachineFilterAloc;
import com.aem.shelp.proxy.types.alerts.BasicAlert;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.MachineFilter;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.AlertIcons;
import com.aem.shelp.tech.alerts.alerts.AlertDetailsPanel;
import com.aem.shelp.tech.alerts.alerts.details.AlertTriggersPanel;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggersListPanel;
import com.aem.shelp.tech.utils.MachinePickerPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.ui.SelectTargetComponent;
import utils.swing.SwingUtil;
import utils.swing.components.AlertGradientPanel;
import utils.swing.components.JEditableLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.ScalingUtil;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.FadeOnHoverPanel;
import utils.swing.layout.GbPanel;

public class AlertConfigPanel
extends GbPanel {
    private LocatedAlert alert;
    private AlertDetailsPanel detailsPanel;
    protected SLPanel containerSliding = new SLPanel();
    private SLConfig[] viewConfigs;
    private JComponent[] viewPanels;
    private GbPanel summaryPanel;
    private JEditableLabel title = new JEditableLabel(true);
    private JLabel alertIconLabel;
    private AlertTriggersPanel alertTriggersPanel;
    private GbPanel contentMachines = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    private MachinePickerPanel machinePickerPanel;
    private GbPanel triggerActionsPanel;
    private GbPanel resetActionsPanel;
    private SelectTargetComponent triggerActionsUI;
    private SelectTargetComponent resetActionsUI;
    ArrayList<SummaryLabel> labelsList = new ArrayList();
    private JComponent[] configureButtons;
    private MouseListener summaryLabelMouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == AlertConfigPanel.this.triggerSummary) {
                AlertConfigPanel.this.switchToConfigureTriggersAndResets();
            } else if (e.getSource() == AlertConfigPanel.this.resetSummary) {
                AlertConfigPanel.this.switchToConfigureTriggersAndResets();
            } else if (e.getSource() == AlertConfigPanel.this.machinesSummary) {
                AlertConfigPanel.this.switchToConfigureMachines();
            } else if (e.getSource() == AlertConfigPanel.this.triggerActionsSummary) {
                AlertConfigPanel.this.switchToConfigureTriggerActions();
            } else if (e.getSource() == AlertConfigPanel.this.triggerResetsSummary) {
                AlertConfigPanel.this.switchToConfigureResetActions();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ((JLabel)e.getSource()).setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ((JLabel)e.getSource()).setCursor(Cursor.getDefaultCursor());
        }
    };
    private JLabel[] summaryLabels;
    private JLabel triggersTitle;
    private JLabel resetsTitle;
    private JLabel machinesTitle;
    private JLabel triggerActionTitle;
    private JLabel resetActionTitle;
    private AlertGradientPanel titleGradientPanel;
    float modeTime = 0.5f;
    private SLConfig currentConfig;
    private JLabel triggerSummary;
    private JLabel resetSummary;
    private JLabel machinesSummary;
    private JLabel triggerActionsSummary;
    private JLabel triggerResetsSummary;
    private JComponent triggerButton;
    private JComponent resetButton;
    private JComponent resetActionsButton;
    private JComponent triggerActionsButton;
    private JComponent machinesButton;
    private MachineTreeModel machineModel;

    protected void initSlidingConfigs() {
        JComponent[] panels = this.getViewPanels();
        this.viewConfigs = new SLConfig[panels.length];
        for (int i = 0; i < panels.length; ++i) {
            this.viewConfigs[i] = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, panels[i]);
        }
        this.containerSliding.setTweenManager(SLAnimator.createTweenManager());
        this.containerSliding.initialize(this.viewConfigs[0]);
        this.currentConfig = this.viewConfigs[0];
    }

    private JComponent[] getViewPanels() {
        if (this.viewPanels != null) {
            return this.viewPanels;
        }
        this.initSummaryPanel();
        this.initMachinesPanel();
        this.initTriggerActionsPanel();
        this.initResetActionsPanel();
        this.alertTriggersPanel = new AlertTriggersPanel(this.detailsPanel);
        JScrollPane summaryScoller = new JScrollPane(this.summaryPanel);
        summaryScoller.setBorder(SHBorderFactory.createEmptyBorder());
        this.viewPanels = new JComponent[]{summaryScoller, new BackContentPanel(this.alertTriggersPanel.getRootComponent(), Language.get("ALERT_TRIGGERS_TITLE"), Language.get("ALERT_TRIGGERS_DESC")), new BackContentPanel(this.contentMachines, Language.get("ALERT_MACHINES_TITLE"), Language.get("MACHINE_PICKER_DESCRIPTION_ALERTS")), new BackContentPanel(this.triggerActionsPanel, Language.get("ALERT_TRIGGER_ACTIONS_TITLE"), Language.get("ALERT_TRIGGER_ACTIONS_DESC")), new BackContentPanel(this.resetActionsPanel, Language.get("ALERT_RESET_ACTIONS_TITLE"), Language.get("ALERT_RESET_ACTIONS_DESC"), true)};
        return this.viewPanels;
    }

    private void switchToNext(JComponent currentContentPanel) {
        if (currentContentPanel == this.alertTriggersPanel.getRootComponent()) {
            this.switchToConfigureMachines();
        } else if (currentContentPanel == this.contentMachines) {
            this.switchToConfigureTriggerActions();
        } else if (currentContentPanel == this.triggerActionsPanel) {
            this.switchToConfigureResetActions();
        } else if (currentContentPanel == this.resetActionsPanel) {
            this.switchToSummary();
        }
    }

    private void initTriggerActionsPanel() {
        this.triggerActionsUI = new SelectTargetComponent(Language.DEFLANG, this.detailsPanel, SHStyle.INSTANCE, true);
        JScrollPane pane = new JScrollPane(this.triggerActionsUI.getComponent());
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.triggerActionsPanel = new GbPanel();
        this.triggerActionsPanel.add(pane, 0, 0, 1, 1, 1, 1, 10, 1, new Insets(3, 3, 3, 3));
    }

    private void initResetActionsPanel() {
        this.resetActionsUI = new SelectTargetComponent(Language.DEFLANG, this.detailsPanel, SHStyle.INSTANCE, true);
        JScrollPane pane = new JScrollPane(this.resetActionsUI.getComponent());
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.resetActionsPanel = new GbPanel();
        this.resetActionsPanel.add(pane, 0, 0, 1, 1, 1, 1, 10, 1, new Insets(3, 3, 3, 3));
    }

    private void initMachinesPanel() {
        this.contentMachines = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        this.machinePickerPanel = new MachinePickerPanel(this.detailsPanel, this.machineModel);
        this.contentMachines.add(this.machinePickerPanel.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
    }

    private JComponent setPanelBorder(JComponent comp) {
        comp.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY), SHBorderFactory.createEmptyBorder(4, 5, 0, 5)));
        return comp;
    }

    private void setPanelLight(JComponent comp) {
        comp.setBackground(Color.white);
    }

    private JLabel createTitleLabel(JLabel jl, boolean smaller) {
        if (smaller) {
            jl.setFont(SHStyle.normalFont);
            jl.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        } else {
            jl.setFont(SHStyle.mediumFont);
            jl.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
        }
        jl.setHorizontalAlignment(0);
        return jl;
    }

    private JLabel summaryLabel(String text, String icon) {
        SummaryLabel jl = new SummaryLabel();
        jl.setText(Language.get(text));
        jl.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        jl.setIcon(ImageLoader.getImageIcon(icon));
        this.labelsList.add(jl);
        return jl;
    }

    private JLabel summaryLabel(String text, String icon, String overlay) {
        SummaryLabel jl = new SummaryLabel();
        jl.setText(Language.get(text));
        jl.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        jl.setIcon(ImageLoader.getImageIcon(Icons.overlay(icon, overlay)));
        this.labelsList.add(jl);
        return jl;
    }

    public void reloadChanges(ArrayList<String> triggeredMachines) {
        if (triggeredMachines != null && triggeredMachines.size() > 0) {
            this.alertIconLabel.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/grey.svg,24"));
            this.titleGradientPanel.setWarningBackground(SHStyle.WARNING_GRADIENT_COLOR);
        } else {
            this.alertIconLabel.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/blue-down.svg,24"));
            this.titleGradientPanel.setWarningBackground(null);
        }
        this.repaint();
    }

    private void initSummaryPanel() {
        this.labelsList = new ArrayList();
        this.titleGradientPanel = new AlertGradientPanel();
        GbPanel condp = new GbPanel(new ScaledInsets(0, 2, 0, 2));
        GbPanel machp = new GbPanel(new ScaledInsets(0, 2, 0, 2));
        GbPanel actp = new GbPanel(new ScaledInsets(0, 2, 0, 2));
        this.titleGradientPanel.setOpaque(false);
        this.title.setOpaque(false);
        this.setPanelBorder(condp);
        this.setPanelBorder(machp);
        this.setPanelBorder(actp);
        this.setPanelLight(condp);
        this.setPanelLight(actp);
        this.triggerButton = new JButton(Language.get("ACP_SET_TRIGGER"));
        this.machinesButton = new JButton(Language.get("ACP_PICK_MACHINES"));
        this.triggerActionsButton = new JButton(Language.get("ACP_CREATE_TRIGGER_ACTIONS"));
        this.resetActionsButton = new JButton(Language.get("ACP_CREATE_RESET_ACTIONS"));
        for (JComponent jComponent : this.configureButtons = new JComponent[]{this.triggerButton, this.machinesButton, this.triggerActionsButton, this.resetActionsButton}) {
            jComponent.setBorder(SHBorderFactory.createEmptyBorder(4, 4, 4, 4));
            SwingUtil.setHeight(jComponent, SimpleHelpLookAndFeel.scale(20));
            jComponent.setFont(SHStyle.smallerFont);
            jComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.simulateExit(e.getSource());
                    if (e.getSource() == AlertConfigPanel.this.triggerButton) {
                        AlertConfigPanel.this.switchToConfigureTriggersAndResets();
                    } else if (e.getSource() == AlertConfigPanel.this.resetButton) {
                        AlertConfigPanel.this.switchToConfigureTriggersAndResets();
                    } else if (e.getSource() == AlertConfigPanel.this.machinesButton) {
                        AlertConfigPanel.this.switchToConfigureMachines();
                    } else if (e.getSource() == AlertConfigPanel.this.triggerActionsButton) {
                        AlertConfigPanel.this.switchToConfigureTriggerActions();
                    } else if (e.getSource() == AlertConfigPanel.this.resetActionsButton) {
                        AlertConfigPanel.this.switchToConfigureResetActions();
                    }
                }

                private void simulateExit(Object source) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        }
        SwingUtil.setSizesToWidest(new JComponent[]{this.triggerButton, this.machinesButton, this.triggerActionsButton, this.resetActionsButton});
        this.triggerSummary = new JLabel();
        this.resetSummary = new JLabel();
        this.machinesSummary = new JLabel();
        this.triggerActionsSummary = new JLabel();
        this.triggerResetsSummary = new JLabel();
        this.summaryLabels = new JLabel[]{this.triggerSummary, this.resetSummary, this.machinesSummary, this.triggerActionsSummary, this.triggerResetsSummary};
        for (JComponent jComponent : this.summaryLabels) {
            jComponent.setBorder(SHBorderFactory.createEmptyBorder(4, 0, 4, 0));
            jComponent.addMouseListener(this.summaryLabelMouseListener);
        }
        this.title.setBorder(SHBorderFactory.createEmptyBorder(3, 0, 3, 3));
        this.alertIconLabel = new JLabel(ImageLoader.getImageIcon("images/svg/alert-flags/blue-down.svg,24"));
        this.titleGradientPanel.add(this.alertIconLabel, 0, 0, 1, 1, 0, 0, 11, 2, new Insets(4, 5, 0, 2));
        this.titleGradientPanel.add(this.title, 1, 0, 3, 1, 1, 0, 11, 2, new Insets(0, 0, 0, 0));
        this.triggersTitle = this.summaryLabel("ALERTS_TRIGGER_CONDITIONS", "images/svg/alert-flags/yellow.svg,16");
        this.resetsTitle = this.summaryLabel("ALERTS_RESET_CONDITIONS", "images/svg/alert-flags/blue.svg,16");
        this.machinesTitle = this.summaryLabel("ALERTS_MACHINES_CONDITIONS", "images/svg/technology/screen.svg,16");
        this.triggerActionTitle = this.summaryLabel("ALERTS_TRIGGER_ACTIONS", "images/svg/users/runner.svg,16", "images/svg/alert-flags/yellow.svg,8");
        this.resetActionTitle = this.summaryLabel("ALERTS_RESET_ACTIONS", "images/svg/users/runner.svg,16", "images/svg/alert-flags/blue.svg,8");
        int Y = 0;
        FadeOnHoverPanel fadep = new FadeOnHoverPanel();
        fadep.addBoth(this.createTitleLabel(new JLabel(Language.get("ALERT_CONDITIONS_TITLE")), false), this.createTitleLabel(new JLabel(Language.get("ALERT_CONDITIONS_DESC")), true));
        fadep.setOpaque(false);
        condp.add(fadep, 0, Y++, 3, 1, 1, 1, 10, 0, new Insets(7, 2, 10, 2));
        condp.add(this.triggerButton, 2, Y, 1, 2, 1, 1, 13, 0);
        condp.add(this.triggersTitle, 0, Y, 1, 1, 0, 0, 17, 2);
        condp.add(this.summaryLabels[0], 1, Y++, 1, 1, 1, 1, 17, 2);
        condp.add(this.resetsTitle, 0, Y, 1, 1, 0, 0, 17, 2);
        condp.add(this.summaryLabels[1], 1, Y++, 1, 1, 1, 1, 17, 2);
        Y = 0;
        fadep = new FadeOnHoverPanel();
        fadep.addBoth(this.createTitleLabel(new JLabel(Language.get("ALERT_MACHINES_TITLE")), false), this.createTitleLabel(new JLabel(Language.get("ALERT_MACHINES_DESC")), true));
        fadep.setOpaque(false);
        machp.add(fadep, 0, Y++, 3, 1, 1, 1, 10, 0, new Insets(7, 2, 10, 2));
        machp.add(this.machinesButton, 2, Y, 1, 1, 1, 1, 13, 0);
        machp.add(this.machinesTitle, 0, Y, 1, 1, 0, 0, 17, 2);
        machp.add(this.summaryLabels[2], 1, Y++, 1, 1, 1, 1, 17, 2);
        Y = 0;
        fadep = new FadeOnHoverPanel();
        fadep.addBoth(this.createTitleLabel(new JLabel(Language.get("ALERT_ACTIONS_TITLE")), false), this.createTitleLabel(new JLabel(Language.get("ALERT_ACTIONS_DESC")), true));
        fadep.setOpaque(false);
        actp.add(fadep, 0, Y++, 3, 1, 1, 1, 10, 0, new Insets(7, 2, 10, 2));
        actp.add(this.triggerActionsButton, 2, Y, 1, 1, 1, 1, 13, 0);
        actp.add(this.triggerActionTitle, 0, Y, 1, 1, 0, 0, 17, 2);
        actp.add(this.summaryLabels[3], 1, Y++, 1, 1, 1, 1, 17, 2);
        actp.add(this.resetActionsButton, 2, Y, 1, 1, 1, 1, 13, 0);
        actp.add(this.resetActionTitle, 0, Y, 1, 1, 0, 0, 17, 2);
        actp.add(this.summaryLabels[4], 1, Y++, 1, 1, 1, 1, 17, 2);
        Y = 0;
        this.summaryPanel = new GbPanel();
        this.summaryPanel.add(this.titleGradientPanel, 0, Y++, 1, 1, 1, 1, 11, 2);
        this.summaryPanel.add(condp, 0, Y++, 1, 1, 1, 1, 11, 2);
        this.summaryPanel.add(machp, 0, Y++, 1, 1, 1, 1, 11, 2);
        this.summaryPanel.add(actp, 0, Y++, 1, 1, 1, 1, 11, 2);
        this.summaryPanel.add(this.setPanelBorder(new JPanel()), 0, Y++, 1, 1, 0, 1000, 10, 1);
    }

    private int getSLConfigIndex(SLConfig config) {
        for (int i = 0; i < this.viewConfigs.length; ++i) {
            if (this.viewConfigs[i] != config) continue;
            return i;
        }
        return -1;
    }

    private void switchToNewView(SLConfig newConfig, Component myComponent) {
        if (this.currentConfig != newConfig) {
            SLSide mySide = this.getSLConfigIndex(newConfig) > this.getSLConfigIndex(this.currentConfig) ? SLSide.RIGHT : SLSide.LEFT;
            SLTransition trans = this.containerSliding.createTransition().push(new SLKeyframe(newConfig, 0.5f).setStartSide(mySide, myComponent));
            new DoTransition(trans).start();
            this.currentConfig = newConfig;
        }
    }

    public static void main(String[] args) throws IOException {
        ScalingUtil.forceScalingPercentage(150);
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        AlertConfigPanel configPanel = new AlertConfigPanel(null, null);
        configPanel.initInfoPanelWith(LocatedAlert.createTestAlert(), null);
        JScrollPane scrollContent = new JScrollPane(configPanel);
        scrollContent.setHorizontalScrollBarPolicy(31);
        scrollContent.setBorder(SHBorderFactory.createEmptyBorder());
        frame.getContentPane().add(scrollContent);
        frame.setVisible(true);
    }

    public void setTechClient(TechClient client) {
        this.alertTriggersPanel.setTechClient(client);
        boolean canManage = client.getPermissions().canManageAlerts();
        for (JComponent jComponent : this.configureButtons) {
            jComponent.setVisible(canManage);
        }
        this.title.setIsEditable(canManage);
        if (canManage) {
            for (JComponent jComponent : this.summaryLabels) {
                jComponent.addMouseListener(this.summaryLabelMouseListener);
            }
        } else {
            for (JComponent jComponent : this.summaryLabels) {
                jComponent.removeMouseListener(this.summaryLabelMouseListener);
            }
        }
    }

    public void setMachineTreeModel(MachineTreeModel machines) {
        this.alertTriggersPanel.setMachineTreeModel(machines);
    }

    public AlertConfigPanel(AlertDetailsPanel detailsPanel, MachineTreeModel machineModel) {
        super(new Insets(0, 0, 0, 0));
        this.machineModel = machineModel;
        this.detailsPanel = detailsPanel;
        this.initUI();
        if (detailsPanel != null) {
            this.title.addListener(detailsPanel);
        }
        this.title.setFont(SHStyle.largeFont);
    }

    private void initUI() {
        this.initSlidingConfigs();
        int Y = 0;
        this.add(this.containerSliding, 0, Y++, 4, 1, 1, 1, 10, 1);
    }

    protected void switchToConfigureResetActions() {
        this.switchToNewView(this.viewConfigs[4], this.viewPanels[4]);
    }

    protected void switchToConfigureTriggerActions() {
        this.switchToNewView(this.viewConfigs[3], this.viewPanels[3]);
    }

    protected void switchToConfigureMachines() {
        this.switchToNewView(this.viewConfigs[2], this.viewPanels[2]);
    }

    protected void switchToConfigureTriggersAndResets() {
        this.switchToNewView(this.viewConfigs[1], this.viewPanels[1]);
    }

    protected void switchToSummary() {
        this.switchToNewView(this.viewConfigs[0], this.viewPanels[0]);
    }

    public BasicAlert getConfiguredAlert() {
        BasicAlert ba = (BasicAlert)this.alert.getAlert();
        if (CentralDebugging.ALERT_ROUND_TRIPPING) {
            System.out.println("Pre conf alert: " + ba);
        }
        this.alertTriggersPanel.saveConfigurationTo(ba);
        if (CentralDebugging.ALERT_ROUND_TRIPPING) {
            System.out.println("Post conf alert: " + ba);
        }
        return ba;
    }

    public void saveConfiguredAlert() {
        AlertLocation aloc;
        this.alert.setAlert(this.getConfiguredAlert());
        LocatedAlert locatedAlert = this.alert;
        if (this.machinePickerPanel.includeAllMachines()) {
            aloc = new AllMachinesAloc();
        } else {
            aloc = new MachineFilterAloc();
            Filter[] filters = this.machinePickerPanel.getSpecifiedFilters();
            MachineFilter[] mf = new MachineFilter[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                mf[i] = (MachineFilter)filters[i];
            }
            ((MachineFilterAloc)aloc).setFilters(mf);
        }
        locatedAlert.setLocation(aloc, null);
        System.out.println("Selected trigger: " + this.triggerActionsUI.getSelectedAbstractTarget());
        System.out.println("Selected reset: " + this.resetActionsUI.getSelectedAbstractTarget());
        locatedAlert.setTriggerTarget(this.triggerActionsUI.getSelectedAbstractTarget());
        locatedAlert.setResetTarget(this.resetActionsUI.getSelectedAbstractTarget());
        if (CentralDebugging.ALERT_ROUND_TRIPPING) {
            System.out.println("Saved alert: " + this.alert.getAlert());
        }
    }

    private ArrayList<TriggersListPanel.TriggerGroup> buildGroups(ArrayList<ArrayList<Alert>> all) {
        ArrayList<TriggersListPanel.TriggerGroup> groups = new ArrayList<TriggersListPanel.TriggerGroup>();
        ArrayList<ArrayList<Alert>> alerts = all;
        for (ArrayList<Alert> list : alerts) {
            TriggersListPanel.TriggerGroup tg = new TriggersListPanel.TriggerGroup();
            tg.triggers = new ArrayList();
            tg.triggers.addAll(list);
            groups.add(tg);
        }
        return groups;
    }

    public void initInfoPanelWith(LocatedAlert alert, ArrayList<String> triggeredMachines) {
        this.alert = alert;
        if (CentralDebugging.ALERT_ROUND_TRIPPING) {
            System.out.println("Loading alert: " + alert.getAlert());
        }
        if (triggeredMachines != null && triggeredMachines.size() > 0) {
            this.alertIconLabel.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/grey.svg,24"));
            this.titleGradientPanel.setWarningBackground(SHStyle.WARNING_GRADIENT_COLOR);
        } else {
            this.alertIconLabel.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/blue-down.svg,24"));
            this.titleGradientPanel.setWarningBackground(null);
        }
        this.alertIconLabel.repaint();
        this.title.setText("<html>" + alert.getName().getName());
        BasicAlert ba = (BasicAlert)alert.getAlert();
        this.updateSummaries(ba);
        this.alertTriggersPanel.initInfoPanelWith(alert, triggeredMachines);
        System.out.println("Init trigger actions ui...");
        this.triggerActionsUI.setLogEventsToTarget(new LogEvent[]{new LocatedAlertLogEvent(null, null, true)});
        System.out.println("Init reset actions ui...");
        this.resetActionsUI.setLogEventsToTarget(new LogEvent[]{new LocatedAlertLogEvent(null, null, false)});
        System.out.println("Loading trigger actions...");
        this.triggerActionsUI.load(alert.getTriggerTarget());
        System.out.println("Loading reset actions...");
        this.resetActionsUI.load(alert.getResetTarget());
        AlertLocation aloc = alert.getLocation();
        if (aloc instanceof AllMachinesAloc) {
            this.machinePickerPanel.load(null);
        } else if (aloc instanceof MachineFilterAloc) {
            MachineFilterAloc mfilt = (MachineFilterAloc)aloc;
            this.machinePickerPanel.load(mfilt.getFilters());
        } else {
            this.machinePickerPanel.load(null);
        }
        this.repaint();
    }

    private void updateSummaries(BasicAlert ba) {
        if (ba.getTriggers().size() > 0) {
            this.triggerSummary.setIcon(AlertIcons.getIcon(ba, 16));
            this.triggerSummary.setText(ba.getTriggersAsString());
            this.triggerSummary.setForeground(Color.black);
        } else {
            this.triggerSummary.setIcon(AlertIcons.getIcon(ba, 16));
            this.triggerSummary.setText(Language.get("ALERTS_NO_TRIGGER_SUMMARY"));
            this.triggerSummary.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHTEST);
        }
        if (ba.getTriggers().size() > 0) {
            this.resetSummary.setIcon(AlertIcons.getIcon(ba, 16));
            this.resetSummary.setText(ba.getResetsAsString());
            this.resetSummary.setForeground(Color.black);
        } else {
            this.resetSummary.setIcon(AlertIcons.getIcon(ba, 16));
            this.resetSummary.setText(Language.get("ALERTS_NO_RESET_SUMMARY"));
            this.resetSummary.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHTEST);
        }
        this.machinesSummary.setText(this.alert.getLocation().getMachineSummary());
        if (this.alert.getTriggerTarget() == null) {
            this.triggerActionsSummary.setText(Language.get("NO_ACTIONS"));
            this.triggerActionsSummary.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHTEST);
        } else {
            this.triggerActionsSummary.setText(this.alert.getTriggerTarget().getTargetSummary());
            this.triggerActionsSummary.setForeground(Color.BLACK);
        }
        if (this.alert.getResetTarget() == null) {
            this.triggerResetsSummary.setText(Language.get("NO_ACTIONS"));
            this.triggerResetsSummary.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHTEST);
        } else {
            this.triggerResetsSummary.setText(this.alert.getResetTarget().getTargetSummary());
            this.triggerResetsSummary.setForeground(Color.BLACK);
        }
    }

    class SummaryLabel
    extends JLabel {
        SummaryLabel() {
        }

        public Dimension getInternalSize() {
            return super.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            for (SummaryLabel jl : AlertConfigPanel.this.labelsList) {
                Dimension tmp = jl.getInternalSize();
                tmp.width += 10;
                if (tmp.width <= d.width) continue;
                d.width = tmp.width;
            }
            return d;
        }
    }

    class BackContentPanel
    extends JPanel
    implements ActionListener {
        private JComponent content;
        private JButton backButton;
        private JButton nextButton;
        private String description;
        private String title;
        private boolean isLast;

        public BackContentPanel(JComponent content, String title, String description) {
            this(content, title, description, false);
        }

        public BackContentPanel(JComponent content, String title, String description, boolean isLast) {
            super(new BorderLayout());
            this.isLast = isLast;
            this.description = description;
            this.content = content;
            this.title = title;
            this.initUI();
        }

        private void initUI() {
            this.nextButton = this.isLast ? new JButton(Language.get("DONE")) : new JButton(Language.get("NEXT"));
            this.backButton = new JButton(Language.get("ALERT_BACK"));
            this.nextButton.setFont(SHStyle.smallerFont);
            this.backButton.setFont(SHStyle.smallerFont);
            JLabel titleLabel = new JLabel(this.title);
            titleLabel.setFont(SHStyle.largeFont);
            GbPanel topPanel = new GbPanel();
            topPanel.setBackground(Color.white);
            topPanel.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), SHBorderFactory.createEmptyBorder(0, 5, 0, 5)));
            GbPanel titlePanel = new GbPanel();
            titlePanel.setBackground(Color.white);
            titlePanel.add(titleLabel, 1, 0, 1, 1, 1, 0, 17, 2, new Insets(10, 3, 5, 3));
            if (this.description != null) {
                JLabel descriptionLabel = new JLabel(this.description);
                descriptionLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
                titlePanel.add(descriptionLabel, 1, 1, 1, 1, 1, 0, 17, 2, new Insets(5, 3, 5, 3));
            }
            topPanel.add(this.backButton, 0, 0, 1, 1, 0, 0, 17, 0, new Insets(10, 3, 5, 3));
            topPanel.add(titlePanel, 1, 0, 1, 1, 1, 0, 17, 3, new Insets(0, 3, 0, 3));
            topPanel.add(this.nextButton, 2, 0, 1, 1, 0, 0, 17, 0, new Insets(10, 3, 5, 3));
            this.add((Component)topPanel, "North");
            this.add((Component)this.content, "Center");
            this.backButton.addActionListener(this);
            this.nextButton.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicAlert ba = (BasicAlert)AlertConfigPanel.this.alert.getAlert();
            AlertConfigPanel.this.updateSummaries(ba);
            AlertConfigPanel.this.summaryPanel.repaint();
            if (e.getSource() == this.backButton) {
                AlertConfigPanel.this.switchToSummary();
            } else {
                AlertConfigPanel.this.switchToNext(this.content);
            }
        }
    }
}

