/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.contents.table;

import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.MachineUIMetadata;
import com.aem.shelp.tech.alerts.AlertIcons;
import com.aem.shelp.tech.alerts.alerts.contents.table.AlertGroupPanel;
import com.aem.shelp.tech.alerts.alerts.contents.table.AlertLiveInfoProvider;
import com.aem.shelp.tech.alerts.alerts.contents.table.AlertTableColumns;
import com.aem.shelp.tech.alerts.alerts.utils.StatusIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import utils.swing.customlaf.SHBorderFactory;

public class AlertTableRenderer
extends DefaultTableCellRenderer
implements AlertTableColumns.AlertColumnPainter {
    private LocatedAlert alert;
    private AlertGroupPanel tableGroupPanel;
    private AlertLiveInfoProvider alertInfo;
    private boolean paintSelected = false;

    public AlertTableRenderer(AlertGroupPanel tableGroupPanel, AlertLiveInfoProvider alertInfo) {
        this.tableGroupPanel = tableGroupPanel;
        this.alertInfo = alertInfo;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.paintSelected = isSelected;
        if (isSelected) {
            label.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            label.setForeground(UIManager.getColor("Table.foreground"));
        }
        this.alert = (LocatedAlert)value;
        if (this.alert == null) {
            label.setText(" ");
            label.setIcon(null);
        } else {
            if (!this.alert.isActive() && !isSelected) {
                label.setForeground(Color.GRAY);
            }
            if (this.alert.getName() != null) {
                label.setText(" " + this.alert.getName().getName());
            } else {
                label.setText(" ");
            }
            Object uiMetadata = this.alert.getUIMetadata();
            if (uiMetadata != null) {
                label.setIcon(((MachineUIMetadata)uiMetadata).getIcon());
            } else {
                label.setIcon(AlertIcons.getIcon(this.alert, 14));
            }
            label.setBorder(SHBorderFactory.createEmptyBorder(0, 2, 0, 0));
        }
        return label;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (AlertTableColumns.getColumnsWidth() == -1) {
            return dim;
        }
        dim.width = this.getWidth() - AlertTableColumns.getColumnsWidth();
        return dim;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = super.getWidth();
        int height = super.getHeight();
        Dimension prefSize = this.getPreferredSize();
        this.setSize(prefSize.width, height);
        super.paint(g);
        this.setSize(width, height);
        g.setColor(this.getBackground());
        g.fillRect(prefSize.width, 0, width - prefSize.width, height);
        g.setColor(this.getForeground());
        g.setFont(AccessStyle.MACHINE_TABLE_FONT);
        AlertTableColumns.callPaintMethods(g, width, height, this);
        this.tableGroupPanel.getGroupsList().justPainted(this.alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintText(Graphics g, String text, int width, int height, int centerX, int columnWidth) {
        if (text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int baseTextLine = height / 2 + fm.getDescent() + 1;
        Shape currentClip = g.getClip();
        Rectangle bounds = currentClip.getBounds();
        try {
            int x = width + centerX - columnWidth / 2;
            int y = 0;
            int w = columnWidth;
            int h = height;
            int x2 = x + w;
            int y2 = y + h;
            int newx = Math.max(x, bounds.x);
            int newy = Math.max(y, bounds.y);
            int newx2 = Math.min(bounds.x + bounds.width, x2);
            int newy2 = Math.min(bounds.y + bounds.height, y2);
            g.setClip(new Rectangle(newx, newy, newx2 - newx, newy2 - newy));
            g.drawString(text, width + centerX - columnWidth / 2, baseTextLine);
        }
        finally {
            g.setClip(currentClip);
        }
    }

    @Override
    public void paintMachines(Graphics g, int width, int height) {
        if (this.alert != null) {
            if (this.paintSelected) {
                g.setColor(UIManager.getColor("Table.selectionForeground"));
            } else if (this.alert.isTriggered()) {
                g.setColor(UIManager.getColor("Table.foreground"));
            } else {
                g.setColor(Color.GRAY);
            }
            StatusIcon.renderMachines(g, this.alert, width + AlertTableColumns.machinesCenter, height / 2, this.alertInfo == null ? 0 : this.alertInfo.getTargetCountForAlert(this.alert.getID()));
        }
    }

    @Override
    public void paintStatus(Graphics g, int width, int height) {
        if (this.alert != null) {
            if (this.paintSelected) {
                g.setColor(UIManager.getColor("Table.selectionForeground"));
            } else if (this.alert.isTriggered()) {
                g.setColor(UIManager.getColor("Table.foreground"));
            } else {
                g.setColor(Color.GRAY);
            }
            StatusIcon.renderStatus(g, this.alert, width + AlertTableColumns.statusCenter, height / 2);
        }
    }

    @Override
    public void paintAlertName(Graphics g, int width, int height) {
    }
}

