/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.contents.table;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.alerts.alerts.contents.table.AlertTableColumns;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class AlertTableHeader
extends JPanel
implements ComponentListener,
AlertTableColumns.AlertColumnPainter {
    public AlertTableHeader() {
        this.setBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, AccessStyle.GROUP_TITLE_BORDER_TOP));
        this.addComponentListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = SimpleHelpLookAndFeel.scale(20);
        return size;
    }

    @Override
    public void paintComponent(Graphics g) {
        AlertTableColumns.setAvailableWidth(this.getWidth());
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setFont(AccessStyle.HEADER_TITLE_FONT);
        g2d.setColor(AccessStyle.HEADER_TITLE_COLOR);
        int width = super.getWidth();
        int height = super.getHeight();
        AlertTableColumns.callPaintMethods(g, width, height, this);
    }

    private void drawTextCentered(Graphics g, String string, int memCenter, int heightTotal) {
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        int hgt = heightTotal - (heightTotal - metrics.getAscent()) / 2;
        int adv = metrics.stringWidth(string);
        g.drawString(string, memCenter - adv / 2, hgt);
    }

    private void drawText(Graphics g, String string, int x, int heightTotal) {
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        int hgt = heightTotal - (heightTotal - metrics.getAscent()) / 2;
        int adv = metrics.stringWidth(string);
        g.drawString(string, x, hgt);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        AlertTableColumns.setAvailableWidth(this.getWidth());
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void paintStatus(Graphics g, int width, int height) {
        this.drawTextCentered(g, Language.get("TRIGGERED"), width + AlertTableColumns.statusCenter, height);
    }

    @Override
    public void paintMachines(Graphics g, int width, int height) {
        this.drawTextCentered(g, Language.get("ALERT_ALERTED"), width + AlertTableColumns.machinesCenter, height);
    }

    @Override
    public void paintAlertName(Graphics g, int width, int height) {
        this.drawText(g, Language.get("ALERT_NAME"), 5, height);
    }
}

