/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.contents.table;

import com.aem.shelp.tech.alerts.alerts.utils.StatusIcon;
import java.awt.Graphics;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class AlertTableColumns {
    public static int[] cumulativeColumnWidths;
    public static int columnsToShow;
    public static final int PADDING;
    public static final int STATUS_ICON_WIDTH;
    public static final int MACHINES_WIDTH;
    public static int statusCenter;
    public static int machinesCenter;
    private static int availableWidth;

    public static void setAvailableWidth(int width) {
        if (width == availableWidth) {
            return;
        }
        availableWidth = width;
        int metricsWidth = width - SimpleHelpLookAndFeel.scale(200);
        if (metricsWidth < 0) {
            AlertTableColumns.setColumnsToShow(1);
        } else {
            int colCount;
            for (colCount = cumulativeColumnWidths.length - 1; colCount > 0 && cumulativeColumnWidths[colCount] > metricsWidth; --colCount) {
            }
            AlertTableColumns.setColumnsToShow(++colCount);
        }
    }

    public static int getColumnsWidth() {
        if (columnsToShow == 0) {
            return -1;
        }
        return cumulativeColumnWidths[columnsToShow - 1];
    }

    private static void setColumnsToShow(int count) {
        columnsToShow = count;
        switch (columnsToShow) {
            case 2: {
                statusCenter = -PADDING - STATUS_ICON_WIDTH / 2;
                break;
            }
            case 3: {
                machinesCenter = -PADDING - MACHINES_WIDTH / 2;
                statusCenter = machinesCenter - PADDING - MACHINES_WIDTH / 2 - STATUS_ICON_WIDTH / 2;
            }
        }
    }

    public static void callPaintMethods(Graphics g, int width, int height, AlertColumnPainter painter) {
        switch (columnsToShow) {
            case 3: {
                painter.paintMachines(g, width, height);
            }
            case 2: {
                painter.paintStatus(g, width, height);
            }
            case 0: 
            case 1: {
                painter.paintAlertName(g, width, height);
            }
        }
    }

    static {
        columnsToShow = 0;
        PADDING = SimpleHelpLookAndFeel.scale(4);
        STATUS_ICON_WIDTH = StatusIcon.getStdWidth();
        MACHINES_WIDTH = StatusIcon.getStdWidth();
        cumulativeColumnWidths = new int[3];
        AlertTableColumns.cumulativeColumnWidths[0] = 0;
        AlertTableColumns.cumulativeColumnWidths[1] = cumulativeColumnWidths[0] + PADDING + STATUS_ICON_WIDTH;
        AlertTableColumns.cumulativeColumnWidths[2] = cumulativeColumnWidths[1] + PADDING + MACHINES_WIDTH;
        AlertTableColumns.setColumnsToShow(3);
    }

    public static interface AlertColumnPainter {
        public void paintStatus(Graphics var1, int var2, int var3);

        public void paintAlertName(Graphics var1, int var2, int var3);

        public void paintMachines(Graphics var1, int var2, int var3);
    }
}

