/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts;

import com.aem.sgateway.ui.SimpleMachineGroupList;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.AbstractAlertsDetailsPanel;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.alerts.details.AlertConfigPanel;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import utils.loggingframework.targets.TargetUIListener;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AlertDetailsPanel
extends AbstractAlertsDetailsPanel
implements SimpleMachineGroupList.ButtonClickListener,
TargetUIListener {
    private GbPanel infoPanelContainer;
    private AlertConfigPanel infoPanel;
    private NoContentsInfoPanel machinesInfoPanel;
    private GbPanel triggeredMachinesPanel = new GbPanel(new ScaledInsets(0, 0, 0, 0));
    private SimpleMachineGroupList triggeredMachinesGroupList;
    private JScrollPane infoPanelScrollPane;
    private JToggleButton infoViewButton;
    private JToggleButton triggeredMachinesButton;

    @Override
    public void setTechClient(TechClient client) {
        super.setTechClient(client);
        this.infoPanel.setTechClient(client);
        this.infoPanel.setMachineTreeModel(this.machineModel);
        boolean canManageAlerts = client.getPermissions().canManageAlerts();
        this.deleteButton.setVisible(canManageAlerts);
        this.saveButton.setVisible(canManageAlerts);
        this.activeButton.setVisible(canManageAlerts);
        this.activeLabel.setVisible(canManageAlerts);
    }

    public AlertDetailsPanel(MachineTreeModel machineModel, AlertPanelListener alertPanelListener) {
        super(machineModel, alertPanelListener);
    }

    @Override
    public void alertModified() {
        this.saveStateToAlert();
        super.alertModified();
    }

    public void alertChanged(LocatedAlert la) {
        if (this.alert != null && la.getID().equals(this.alert.getID())) {
            ((LocatedAlert)this.alert).setAlert(la.getAlert());
            ArrayList<String> triggeredMachines = ((LocatedAlert)this.alert).getTriggeredMachines();
            this.infoPanel.reloadChanges(triggeredMachines);
            this.initTriggeredMachines(triggeredMachines);
        }
    }

    protected void saveStateToAlert() {
        this.infoPanel.saveConfiguredAlert();
    }

    @Override
    protected void initUI() {
        this.infoPanelContainer = new GbPanel();
        this.infoPanel = new AlertConfigPanel(this, this.machineModel);
        this.triggeredMachinesPanel = new GbPanel(new ScaledInsets(0, 0, 0, 0));
        this.triggeredMachinesGroupList = new SimpleMachineGroupList(null, null, null, Language.get("VIEW_MACHINE"), this){

            @Override
            protected Icon getMachineIcon() {
                return ImageLoader.getImageIcon("O[images/svg/technology/screen.svg,16 | images/svg/alert-flags/yellow.svg,12]");
            }
        };
        this.infoPanelContainer.add(this.infoPanel, 0, 0, 1, 1, 1, 1, 17, 1);
        this.triggeredMachinesPanel.add(this.triggeredMachinesGroupList.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
        this.triggeredMachinesGroupList.setScrollPaneBorder(SHBorderFactory.createEmptyBorder());
        this.infoViewButton = new JToggleButton(ImageLoader.getImageIcon("images/svg/general/spanner-dark.svg,16"));
        this.infoViewButton.setToolTipText(Language.get("ALERT_VIEW_TOOLTIP"));
        this.triggeredMachinesButton = new JToggleButton(ImageLoader.getImageIcon(Icons.ALERT_TRIGGERED_MACHINES_ON));
        this.triggeredMachinesButton.setToolTipText(Language.get("ALERT_MACHINES_TOOLTIP"));
        this.infoPanelScrollPane = new JScrollPane(this.infoPanelContainer);
        this.infoPanelScrollPane.setHorizontalScrollBarPolicy(31);
        this.infoPanelScrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.infoPanelScrollPane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.infoPanelScrollPane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.machinesInfoPanel = new NoContentsInfoPanel(Language.get("ALERTS_NO_MACHINES_TRIGGERED"), null, false);
        this.machinesInfoPanel.setContentsPanel(this.triggeredMachinesPanel);
        super.setViewButtons(new AbstractButton[]{this.infoViewButton, this.triggeredMachinesButton}, new JComponent[]{this.infoPanelScrollPane, this.machinesInfoPanel});
        super.initUI();
    }

    @Override
    protected void initUIForSingleAlert(ResourceContainer alertContainer) {
        super.initUIForSingleAlert(this.alert);
        LocatedAlert alert = (LocatedAlert)alertContainer;
        ArrayList<String> triggeredMachines = alert.getTriggeredMachines();
        this.infoPanel.initInfoPanelWith(alert, triggeredMachines);
        this.initTriggeredMachines(triggeredMachines);
    }

    private void initTriggeredMachines(ArrayList<String> triggeredMachines) {
        ArrayList<String[]> groupsToShow = new ArrayList<String[]>();
        ArrayList<String> machineNames = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : triggeredMachines) {
            Machine machine = (Machine)this.machineModel.getElementWithID(id);
            if (machine == null) continue;
            groupsToShow.add(machine.getName().getGroup());
            machineNames.add(machine.getName().getName());
            ids.add(machine.getID());
        }
        this.machinesInfoPanel.setHasContents(triggeredMachines.size() > 0);
        this.triggeredMachinesGroupList.setGroupsToShow(groupsToShow, machineNames, ids);
    }

    @Override
    public void buttonClicked(Object machineID) {
        this.alertPanelListener.showMachineInUI((String)machineID);
    }

    @Override
    public void targetUIComplete() {
    }

    @Override
    public void targetUIIncomplete() {
    }

    @Override
    public void targetChanged() {
        this.alertModified();
    }

    public void groupsChanged(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
    }
}

