/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.LazyPassword;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.tech.admin.subsections.technicians.AdminTechnicians;
import com.aem.shelp.tech.utils.SummaryBlobLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import utils.progtools.DataUtil;
import utils.progtools.SaverUtil;
import utils.swing.components.JSearchTextField;
import utils.swing.components.JSmartPopupMenu;
import utils.swing.components.SHJTable;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.renderers.AlignTableCellRendererWrapper;
import utils.swing.renderers.BorderedTableCellRendererWrapper;
import utils.swing.simplelist.EventList;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.SortWrapper;
import utils.swing.simplelist.wrapper.filter.FilterWrapper;

public class TechTable
extends MouseAdapter
implements MessageFieldHandler.FilterListener,
SaverUtil.SaveListener,
ActionListener {
    private final AdminTechnicians selectionListener;
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private JSearchTextField searchTextField;
    private JButton addTechnician = new JButton(Language.get("ADD_TECH"), ImageLoader.getImageIcon("images/svg/general/add.svg,16"));
    private JButton configureButton = new JButton(ImageLoader.getImageIcon("images/svg/general/gear.svg,16"));
    private GroupsPanel panel = new GroupsPanel();
    private SHJTable techniciansTable;
    private SimpleTableModel tableModel;
    private SimpleList<TechUser> techniciansList = new SimpleList();
    private SortWrapper<TechUser> sortWrapper = new SortWrapper<TechUser>(this.techniciansList, new Comparator<TechUser>(){

        @Override
        public int compare(TechUser o1, TechUser o2) {
            int ret = o1.getLogin().toLowerCase().compareTo(o2.getLogin().toLowerCase());
            if (ret != 0) {
                return ret;
            }
            return DataUtil.compare(o1.uniqueID, o2.uniqueID);
        }
    });
    private TechFilterWrapper filterWrapper = new TechFilterWrapper(this.sortWrapper);
    private TableCellRenderer technicianRenderer;
    private final SaverUtil deferredFilterSetter = new SaverUtil("Technician Table Filter Setter", 500, this, false);
    private String lastFilter;

    public TechTable(AdminTechnicians selectionListener) {
        this.selectionListener = selectionListener;
        this.initUI();
    }

    private void initUI() {
        TableStructure ts = TableStructure.createTableStructure(TechUser.class, new String[]{"displayName", "login", "", "", "", ""}, new String[]{Language.get("NAME"), Language.get("LOGIN"), Language.get("ADMIN_TECH_GROUPS"), "", "", ""});
        ts.setMinWidths(SimpleHelpLookAndFeel.scale(new int[]{50, 50, 100, 24, 24, 24}));
        ts.setMaxWidths(new int[]{-1, -1, -1, SimpleHelpLookAndFeel.scale(24), SimpleHelpLookAndFeel.scale(24), SimpleHelpLookAndFeel.scale(24)});
        ts.setAlignment(new int[]{2, 2, 2, 0, 0, 0});
        this.tableModel = new SimpleTableModel(this.filterWrapper, ts);
        this.techniciansTable = new SHJTable();
        this.techniciansTable.setRowHeight(SimpleHelpLookAndFeel.scale(30));
        this.techniciansTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.tableModel.assignToTable(this.techniciansTable);
        TechTableRenderer renderer = new TechTableRenderer();
        this.techniciansTable.setDefaultRenderer(Object.class, renderer);
        this.techniciansTable.setDefaultRenderer(Boolean.class, renderer);
        this.technicianRenderer = new BorderedTableCellRendererWrapper(this.techniciansTable.getDefaultRenderer(Object.class), SHBorderFactory.createEmptyBorder(4, 5, 4, 0));
        this.techniciansTable.setDefaultRenderer(Object.class, this.technicianRenderer);
        TableCellRenderer headerRenderer = this.techniciansTable.getTableHeader().getDefaultRenderer();
        headerRenderer = new BorderedTableCellRendererWrapper(new AlignTableCellRendererWrapper(headerRenderer, 2));
        this.techniciansTable.getTableHeader().setDefaultRenderer(headerRenderer);
        ts.initTableDimensions(this.techniciansTable);
        this.searchTextField = new JSearchTextField(Language.get("SEARCH_TREE_TEXT"));
        this.searchTextField.addIcon(ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.searchTextField.addIcon(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"), false, false, "SEARCH");
        this.searchTextField.setFilterListener(this);
        JScrollPane tableScroller = new JScrollPane(this.techniciansTable);
        tableScroller.setBorder(SHBorderFactory.createEmptyBorder());
        int buffer = SimpleHelpLookAndFeel.scale(10);
        JPanel paddedPanel = new JPanel(new BorderLayout(buffer, buffer));
        paddedPanel.add((Component)this.searchTextField, "Center");
        JPanel buttons = new JPanel(new BorderLayout(buffer / 2, buffer));
        buttons.add((Component)this.addTechnician, "West");
        buttons.add((Component)this.configureButton, "East");
        paddedPanel.add((Component)buttons, "East");
        paddedPanel.setBorder(SHBorderFactory.createEmptyBorder(buffer, buffer, buffer, buffer));
        this.addTechnician.addActionListener(this);
        this.configureButton.addActionListener(this);
        this.rootComponent.add((Component)paddedPanel, "North");
        this.rootComponent.add((Component)tableScroller, "Center");
    }

    @Override
    public void setFilter(String filter, boolean immediately) {
        this.filterWrapper.setCaseSensitive(false);
        this.lastFilter = filter;
        this.deferredFilterSetter.queueSave();
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        int row = this.techniciansTable.rowAtPoint(event.getPoint());
        int col = this.techniciansTable.columnAtPoint(event.getPoint());
        TechUser user = (TechUser)this.filterWrapper.get(row);
        if (user.getGroups() == null || user.getGroups().length == 0) {
            return;
        }
        if (col == 2) {
            TableColumn column = this.techniciansTable.getColumnModel().getColumn(col);
            int leftX = 0;
            for (int i = 0; i < col; ++i) {
                leftX += this.techniciansTable.getColumnModel().getColumn(i).getWidth();
            }
            boolean groupX = false;
            boolean groupW = false;
            this.panel.setTechGroups(user.getGroups());
            int selectedGroupIndex = this.panel.getGroupAtX(event.getX() - leftX);
            if (selectedGroupIndex >= 0) {
                System.out.println("TechGroup: " + user.getGroups()[selectedGroupIndex]);
            }
        }
    }

    @Override
    public void performSave() {
        this.filterWrapper.setFilterText(this.lastFilter);
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTechnicians(final TechUser[] technicians) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TechTable.this.setTechnicians(technicians);
                }
            });
            return;
        }
        this.techniciansList.startBatch();
        try {
            int size = this.techniciansList.size();
            while (size > technicians.length) {
                this.techniciansList.remove(--size);
            }
            for (int i = 0; i < technicians.length; ++i) {
                TechUser tech = technicians[i];
                if (this.techniciansList.size() > i) {
                    this.techniciansList.set(i, tech);
                    continue;
                }
                this.techniciansList.add(tech);
            }
        }
        finally {
            this.techniciansList.endBatch();
        }
    }

    public TechUser[] getTechnicians() {
        return this.techniciansList.toArray((X[])new TechUser[0]);
    }

    public void update(TechUser selectedTech) {
        this.techniciansList.notifyElementUpdate(selectedTech);
    }

    public TechUser[] getSelectedTechnicians() {
        ArrayList users = new ArrayList();
        for (int row : this.techniciansTable.getSelectedRows()) {
            users.add(this.filterWrapper.get(row));
        }
        if (users.size() == 0) {
            return null;
        }
        return users.toArray(new TechUser[0]);
    }

    public void removeSelectedTechnicians() {
        TechUser[] users = this.getSelectedTechnicians();
        this.techniciansList.startBatch();
        try {
            this.techniciansList.removeAll(Arrays.asList(users));
        }
        finally {
            this.techniciansList.endBatch();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addTechnician) {
            if (this.selectionListener != null) {
                this.selectionListener.createNewTechnician();
            } else {
                int id = 10101;
                TechUser tech = new TechUser(id, "New Technician", "newtechnician", new LazyPassword(""), "", false, true, true);
                this.addNewTech(tech);
            }
        } else {
            JSmartPopupMenu menu = new JSmartPopupMenu();
            String text = Language.get("ADMIN_SHOW_ANONYMOUS");
            if (text.equals("ADMIN_SHOW_ANONYMOUS")) {
                text = "Show Group Authenticated Users";
            }
            final JCheckBox showAnonymousTechnicians = new JCheckBox(text);
            showAnonymousTechnicians.setSelected(this.filterWrapper.isShowingAnonymousTechnicians());
            showAnonymousTechnicians.setIconTextGap(SimpleHelpLookAndFeel.scale(15));
            showAnonymousTechnicians.setBorder(SHBorderFactory.createEmptyBorder(10, 10, 10, 10));
            showAnonymousTechnicians.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TechTable.this.filterWrapper.showAnonymousTechnicians(showAnonymousTechnicians.isSelected());
                }
            });
            menu.add(showAnonymousTechnicians);
            menu.show(this.configureButton, this.configureButton.getWidth() - showAnonymousTechnicians.getPreferredSize().width, this.configureButton.getHeight() + SimpleHelpLookAndFeel.scale(2));
        }
    }

    public void addNewTech(TechUser tech) {
        this.techniciansList.add(tech);
        int row = this.filterWrapper.indexOf(tech);
        this.techniciansTable.getSelectionModel().setSelectionInterval(row, row);
        this.techniciansTable.scrollRectToVisible(new Rectangle(this.techniciansTable.getCellRect(row, 0, true)));
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        Language.loadTranslations();
        String[] groups = new String[]{"Group A", "Group B", "Group C", "All technicians, Administrators"};
        String[] firstNames = new String[]{"George", "Antony", "Wayne", "Maria", "Raphael", "Leonardo", "Chris", "Janine"};
        String[] lastNames = new String[]{"Christelis", "Miguel", "Davidson", "Rupert", "Turtle", "da Vinci", "Telis", "Joseph"};
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        TechTable table = new TechTable(null);
        table.sortWrapper.setComparator(new Comparator<TechUser>(){

            @Override
            public int compare(TechUser o1, TechUser o2) {
                int oo1 = Integer.parseInt(o1.displayName.substring(0, o1.displayName.indexOf(45)));
                int oo2 = Integer.parseInt(o2.displayName.substring(0, o2.displayName.indexOf(45)));
                return DataUtil.compare(oo1, oo2);
            }
        });
        frame.getContentPane().add(table.rootComponent);
        frame.setVisible(true);
        ArrayList<TechUser> allUsers = new ArrayList<TechUser>();
        boolean allowAnonymous = true;
        Random r = new Random();
        for (int i = 0; i < 5; ++i) {
            String first = firstNames[r.nextInt(firstNames.length)];
            String last = lastNames[r.nextInt(lastNames.length)];
            TechUser user = new TechUser(100 + i, i + "-" + first + " " + last, i + "-" + (first + "." + last).toLowerCase(), new LazyPassword("xxxxxx"), first + "." + last + "@gmail.com", allowAnonymous ? i % 2 == 0 : false, r.nextInt(5) > 0, r.nextInt(10) > 0);
            if (r.nextInt(10) == 1) {
                user.setIsForAppProfilesOnly(true);
            }
            if (r.nextBoolean()) {
                String[] s = groups[r.nextInt(groups.length)].split("\\,");
                ArrayList<TechGroup> techGroups = new ArrayList<TechGroup>();
                for (String group : s) {
                    TechGroup g = new TechGroup(100, group);
                    techGroups.add(g);
                }
                user.setGroups(techGroups.toArray(new TechGroup[0]));
            }
            table.techniciansList.add(user);
            allUsers.add(user);
        }
        Thread.sleep(2000L);
        ((TechUser)allUsers.get(0)).setDefaultName("1-WOOOOOOOOOOOOT");
        table.setTechnicians(allUsers.toArray(new TechUser[0]));
    }

    class TechFilterWrapper
    extends FilterWrapper<TechUser> {
        private boolean showAnonymousTechnicians;

        public TechFilterWrapper(EventList<TechUser> list) {
            super(list);
        }

        public void showAnonymousTechnicians(boolean show) {
            this.showAnonymousTechnicians = show;
            this.doFilter();
        }

        public boolean isShowingAnonymousTechnicians() {
            return this.showAnonymousTechnicians;
        }

        @Override
        protected boolean isIncluded(TechUser object) {
            if (!this.showAnonymousTechnicians && object.isAnonymous()) {
                return false;
            }
            return super.isIncluded(object);
        }
    }

    class TechTableRenderer
    extends DefaultTableCellRenderer {
        GroupsPanel panel;

        TechTableRenderer() {
            this.panel = new GroupsPanel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            switch (column) {
                case 2: {
                    TechUser user = (TechUser)value;
                    TechGroup[] groups = user.getGroups();
                    if (groups.length > 0) {
                        this.panel.setBlue(!user.isAnonymous());
                        this.panel.setBackground(label.getBackground());
                        this.panel.setTechGroups(groups);
                        return this.panel;
                    }
                    this.setText("");
                    break;
                }
                case 3: {
                    label.setText("");
                    TechUser user = (TechUser)value;
                    if (!user.isAccountEnabled()) {
                        label.setIcon(ImageLoader.getImageIconDisabled("images/svg/general/lock.svg,16"));
                        break;
                    }
                    label.setIcon(null);
                    break;
                }
                case 4: {
                    label.setText("");
                    TechUser user = (TechUser)value;
                    if (user.allowLocallyAuthenticatedLogins()) {
                        label.setIcon(ImageLoader.getImageIconDisabled("images/svg/security/key.svg,16"));
                        break;
                    }
                    label.setIcon(null);
                    break;
                }
                case 5: {
                    label.setText("");
                    TechUser user = (TechUser)value;
                    if (user.isForAppProfilesOnly()) {
                        label.setIcon(ImageLoader.getImageIconDisabled("images/svg/general/cube.svg,16"));
                        break;
                    }
                    label.setIcon(null);
                    break;
                }
                default: {
                    this.setIcon(null);
                }
            }
            return label;
        }
    }

    private class GroupsPanel
    extends JPanel {
        private ArrayList<SummaryBlobLabel> labels;
        private ArrayList<Integer> labelWidths;
        private Color backgroundColour;

        public GroupsPanel() {
            super(new FlowLayout(0, SimpleHelpLookAndFeel.scale(5), 0));
            this.labels = new ArrayList();
            this.labelWidths = new ArrayList();
        }

        public void setBlue(boolean blue) {
            this.backgroundColour = blue ? SHStyle.PANEL_BACKGROUND_BLUE : SHStyle.PANEL_BACKGROUND_GREEN;
        }

        public void setTechGroups(TechGroup[] groups) {
            int i;
            for (i = 0; i < groups.length; ++i) {
                SummaryBlobLabel label;
                if (i == this.labels.size()) {
                    label = new SummaryBlobLabel("", null, this.backgroundColour);
                    label.setBuffer(SimpleHelpLookAndFeel.scale(5), SimpleHelpLookAndFeel.scale(3));
                    this.labels.add(label);
                    this.add(label);
                    this.labelWidths.add(0);
                } else {
                    label = this.labels.get(i);
                }
                label.setColor(this.backgroundColour);
                label.setBackground(this.getBackground());
                label.setText(groups[i].toString());
                this.labelWidths.set(i, label.getPreferredSize().width);
                label.setVisible(true);
            }
            for (i = groups.length; i < this.labels.size(); ++i) {
                this.labels.get(i).setVisible(false);
                this.labelWidths.set(i, 0);
            }
        }

        public int getGroupAtX(int x) {
            if (x < 0) {
                return -1;
            }
            int left = 0;
            for (int i = 0; i < this.labelWidths.size(); ++i) {
                if (left < x && left + this.labelWidths.get(i) > x) {
                    return i;
                }
                left += this.labelWidths.get(i).intValue();
            }
            return -1;
        }
    }
}

