/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.ServerManagement;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;

public class AdminTechPresence
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    private ValidationKeyListener validationKeyListener;
    JCheckBox remoteCustomersBox;
    JCheckBox remoteMachinesBox;

    @Override
    protected void initUI() {
        this.validationKeyListener = new ValidationKeyListener(this);
        this.initTechnicianDialogPanel(this.rootComponent);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_NOTIFY_TECH_DIALOG_TAB");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.remoteCustomersBox.setSelected(config.remoteCustomersTechPresence);
        this.remoteMachinesBox.setSelected(config.remoteMachinesTechPresence);
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.remoteCustomersTechPresence = this.remoteCustomersBox.isSelected();
        config.remoteMachinesTechPresence = this.remoteMachinesBox.isSelected();
    }

    private void initTechnicianDialogPanel(JPanel loggingPanel) {
        loggingPanel.setBorder(SHBorderFactory.createEmptyBorder(3, 3, 3, 3));
        JWrapLabel desc = new JWrapLabel("<html>" + Language.get("ADMIN_TD_DESC") + "</html>");
        this.remoteCustomersBox = new JCheckBox(Language.get("ADMIN_TD_REMOTE_CUSTOMER"));
        this.remoteMachinesBox = new JCheckBox(Language.get("ADMIN_TD_REMOTE_MACHINE"));
        GridBagLayout gbl = new GridBagLayout();
        loggingPanel.setLayout(gbl);
        int Y = 0;
        gbl.setConstraints(desc, new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        if (ServerManagement.isServerSuite() || ServerManagement.isSimpleHelp()) {
            gbl.setConstraints(this.remoteCustomersBox, new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            loggingPanel.add(this.remoteCustomersBox);
        }
        if (ServerManagement.isServerSuite() || ServerManagement.isSimpleGateway()) {
            gbl.setConstraints(this.remoteMachinesBox, new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            loggingPanel.add(this.remoteMachinesBox);
        }
        loggingPanel.add(desc);
        this.remoteCustomersBox.addActionListener(this.validationKeyListener);
        this.remoteMachinesBox.addActionListener(this.validationKeyListener);
    }

    @Override
    public void checkEnabled() {
    }
}

