/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.sdesktop.client.gui.FPSSlider;
import com.aem.sgateway.common.SGServiceNameUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.Templates;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.filters.CustomerFilter;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.MachineFilter;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.admin.AuthenticationPanel;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.technicians.GroupPermissionsUI;
import com.aem.shelp.tech.utils.FiltersUI;
import com.aem.shelp.tech.utils.MachineTestFiltersDialog;
import com.aem.shelp.util.swing.EmptyBorderedPanel;
import com.aem.shelp.util.swing.IconedAbstractListUI;
import com.aem.utils.gui.verifiers.DigitDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.JComboBoxFixer;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapCheckBox;
import utils.swing.components.JWrapLabel;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.SHSplitPane;
import utils.swing.components.messagefields.MessageTextField;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class AdminGroups
extends SubSection
implements ListSelectionListener,
ActionListener {
    public static AdminGroups INSTANCE = null;
    private final AdminPanel adminPanel;
    private ValidationListener validationListener;
    private GroupList groupList;
    private JButton addVariableButton;
    private FiltersUI groupCustomerFilters;
    private FiltersUI groupMachineFilters;
    private AuthenticationPanel groupAuthPanel;
    private JTextField groupNameField;
    private JLabel groupNameLabel;
    private boolean loading = false;
    private JLabel groupHostnameLabel;
    private MessageTextField groupHostname;
    private JLabel sgServiceLabel;
    private MessageTextField sgServiceField;
    private JCheckBox allowAnonymousLoginsCheckBox;
    private JWrapCheckBox shSessionLimitCheckBox;
    private JWrapCheckBox sgSessionLimitCheckBox;
    private JLabel groupMaxShSessions;
    private JLabel userMaxShSessions;
    private JLabel groupMaxSgSessions;
    private JLabel userMaxSgSessions;
    private JTextField groupMaxShSessionsT;
    private JTextField userMaxShSessionsT;
    private JTextField groupMaxSgSessionsT;
    private JTextField userMaxSgSessionsT;
    private JLabel groupLimitFileTransferLabel;
    private JTextField groupLimitFileTransferTextField;
    private JComboBox groupLimitUnitBox;
    private JWrapCheckBox fileTransferLimitCheckBox;
    private JWrapCheckBox speedLimitCheckBox;
    private JTextField sessionLimitTextField;
    private JLabel sessionLimitLabel;
    private JLabel sessionLimitUnits;
    private JWrapCheckBox fpsLimitCheckBox;
    private FPSSlider fpsSlider;
    private GroupPermissionsUI permissionsUI;
    private TechGroup selectedGroup;
    private CUIField[] details;
    private JButton testMachineFilters;
    private MachineTreeModel model;
    private boolean forceSave = false;
    JTabbedPane groupTabs;
    JPanel customerFiltering;
    JPanel machineFiltering;
    private NoContentsInfoPanel groupInfoPanel;
    private EmptyBorderedPanel groupSessions;
    boolean filteringOn = false;

    public AdminGroups(AdminPanel adminPanel) {
        INSTANCE = this;
        this.adminPanel = adminPanel;
    }

    public void setMachineTreeModel(MachineTreeModel model) {
        this.model = model;
    }

    @Override
    public void setTechClient(TechClient techClient) {
        super.setTechClient(techClient);
        this.groupAuthPanel.setTechClient(techClient);
        this.permissionsUI.setTechClient(techClient);
    }

    @Override
    public boolean forceSave() {
        if (this.forceSave) {
            this.forceSave = false;
            return true;
        }
        return false;
    }

    @Override
    public void overrideBorderForSubSection() {
        this.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder());
    }

    @Override
    public boolean grabAllVerticalSpace() {
        return true;
    }

    private JPopupMenu getAddVariableMenu(String[] customerDetails) {
        JPopupMenu variableAddressMenu = new JPopupMenu();
        JComboBoxFixer.fix(variableAddressMenu);
        String[] names = SGServiceNameUtil.getAllVariableNames(customerDetails);
        String[] ids = SGServiceNameUtil.getAllVariableIDs(customerDetails);
        for (int i = 0; i < names.length; ++i) {
            JMenuItem item = new JMenuItem(new InsertVariableAction(names[i], ids[i]));
            variableAddressMenu.add(item);
        }
        return variableAddressMenu;
    }

    @Override
    protected void initUI() {
        this.groupList = new GroupList(Language.DEFLANG, new TechGroup[0]);
        this.groupList.addListSelectionListener(this);
        this.initGroupsTab(this.rootComponent);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_TECH_GROUPS");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        if (config.groups != null) {
            Arrays.sort(config.groups);
        }
        this.setDetails(config.getDetails());
        this.groupList.setObjects(config.groups);
        this.groupHostname.setMessageText(config.hostname);
        this.groupAuthPanel.setConfiguredServers(config.ldapEnable, config.radiusEnable, config.emailSettingsEnabled);
    }

    private void setDetails(CUIField[] details) {
        this.details = details;
        ArrayList<String> detailList = new ArrayList<String>();
        if (details != null) {
            for (CUIField field : details) {
                if (!(field instanceof AbstractField)) continue;
                detailList.add(field.getLabel());
            }
        }
        String[] result = detailList.toArray(new String[0]);
        this.groupCustomerFilters.setDetailKeys(result);
        this.groupMachineFilters.setDetailKeys(result);
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.groups = this.groupList.getObjects(new TechGroup[0]);
    }

    @Override
    public boolean insertDefaultPadding() {
        return false;
    }

    private void initGroupsTab(JPanel groupsPanel) {
        this.validationListener = new ValidationListener();
        groupsPanel.setLayout(new BorderLayout());
        JPanel groupDetails = new JPanel();
        groupDetails.setLayout(new GridLayout(1, 1));
        this.groupTabs = new JTabbedPane();
        groupDetails.add(this.groupTabs);
        EmptyBorderedPanel groupInfo = new EmptyBorderedPanel();
        this.initGroupInfo(groupInfo);
        EmptyBorderedPanel groupPermissions = new EmptyBorderedPanel();
        this.initGroupPermissions(groupPermissions);
        this.groupSessions = new EmptyBorderedPanel();
        this.initGroupSessions(this.groupSessions);
        this.customerFiltering = new EmptyBorderedPanel();
        this.initGroupPanelCustomer(this.customerFiltering);
        this.machineFiltering = new EmptyBorderedPanel();
        this.initGroupPanelMachines(this.machineFiltering);
        EmptyBorderedPanel authenticationPanel = new EmptyBorderedPanel();
        this.initGroupAuthenticationPanel(authenticationPanel);
        this.groupTabs.addTab(Language.get("ADMIN_GROUP_INFO_TAB"), ImageLoader.getImageIcon("images/svg/general/preferences.svg,16"), groupInfo);
        JScrollPane sp = new JScrollPane(groupPermissions);
        sp.setBorder(SHBorderFactory.createEmptyBorder());
        JScrollPane authPane = new JScrollPane(authenticationPanel);
        authPane.setBorder(SHBorderFactory.createEmptyBorder());
        JScrollPane sessionLimitPane = new JScrollPane(this.groupSessions);
        sessionLimitPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.groupTabs.addTab(Language.get("ADMIN_GROUP_PERMISSIONS_TAB"), ImageLoader.getImageIcon("images/svg/general/preferences.svg,16"), sp);
        this.groupTabs.addTab(Language.get("ADMIN_GROUP_SESSIONS_TAB"), ImageLoader.getImageIcon("images/svg/general/help.svg,16"), sessionLimitPane);
        this.groupTabs.addTab(Language.get("ADMIN_GROUP_AUTH_TAB"), ImageLoader.getImageIcon("images/svg/general/lock.svg,16"), authPane);
        this.addFilteringTabs();
        Dimension dim = this.groupList.getPreferredSize();
        dim.width = 170;
        this.groupList.setPreferredSize(dim);
        this.groupList.setMinimumSize(dim);
        this.groupList.setMaximumSize(dim);
        this.groupList.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(0, 0, 0, 1, SHStyle.LIGHT_GRAY_HORIZONTAL_LINE), SHBorderFactory.createEmptyBorder(0, 0, 5, 0)));
        this.groupList.setElementListBorder(SHBorderFactory.createEmptyBorder());
        this.groupList.setScrollPaneBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, SHStyle.LIGHT_GRAY_HORIZONTAL_LINE));
        this.groupList.setRowHeight(SimpleHelpLookAndFeel.scale(24));
        this.groupInfoPanel = new NoContentsInfoPanel(Language.get("ADMIN_PANEL_SELECT_GROUP"), ImageLoader.getImageIconLighter("images/svg/users/queue.svg,48"), false);
        this.groupInfoPanel.setContentsPanel(groupDetails);
        SHSplitPane leftSplit = new SHSplitPane();
        leftSplit.setDividerLocation(0.25);
        leftSplit.setLeftComponent(this.groupList);
        leftSplit.setRightComponent(this.groupInfoPanel);
        leftSplit.setBorder(null);
        leftSplit.setResizeWeight(0.0);
        leftSplit.setOneTouchExpandable(false);
        leftSplit.setContinuousLayout(true);
        groupsPanel.add((Component)leftSplit, "Center");
    }

    private void removeFilteringTabs() {
        if (this.filteringOn) {
            this.filteringOn = false;
            this.groupTabs.remove(this.customerFiltering);
            this.groupTabs.remove(this.machineFiltering);
        }
    }

    private void addFilteringTabs() {
        if (!this.filteringOn) {
            this.filteringOn = true;
            this.groupTabs.addTab(Language.get("ADMIN_CUST_FILTERING_TAB"), ImageLoader.getImageIcon("images/svg/general/funnel-abstract-blue.svg,16"), this.customerFiltering);
            this.groupTabs.addTab(Language.get("ADMIN_MACH_FILTERING_TAB"), ImageLoader.getImageIcon("images/svg/general/funnel-abstract-blue.svg,16"), this.machineFiltering);
        }
    }

    public void reloadTwoTierEmailDefaults() {
        this.groupAuthPanel.reloadEmailAuthenticationDefaults();
    }

    private void initAdvancedPanel(JPanel advancedPanel) {
        GbPanelWrapper wrapper = new GbPanelWrapper(advancedPanel);
        JWrapLabel networkTitle = new JWrapLabel("<html>" + Language.get("TECH_UI_SESSION_PROPERTIES"));
        networkTitle.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        networkTitle.setFont(SHStyle.largeFont);
        int Y = 0;
        wrapper.add(networkTitle, 0, Y++, 2, 1, 1, 0, 18, 1, new Insets(5, 15, 0, 0));
    }

    private void initGroupAuthenticationPanel(JPanel authenticationPanel) {
        GridBagLayout gbl = new GridBagLayout();
        authenticationPanel.setLayout(gbl);
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("ADMIN_GROUP_AUTH_DESC") + "</html>");
        this.groupAuthPanel = new AuthenticationPanel(){

            @Override
            public void save() {
                if (AdminGroups.this.selectedGroup == null) {
                    return;
                }
                AdminGroups.this.selectedGroup.setPassword(this.usePassword());
                if (this.usePassword()) {
                    AdminGroups.this.selectedGroup.setPassword(this.password);
                } else {
                    AdminGroups.this.selectedGroup.setPassword(null);
                }
                AdminGroups.this.selectedGroup.setLDAP(this.useLDAP());
                if (this.useLDAP()) {
                    this.saveLDAPSettings(AdminGroups.this.selectedGroup.getLDAPProperties());
                }
                AdminGroups.this.selectedGroup.setMultiTierEmail(this.useTwoTier());
                AdminGroups.this.selectedGroup.setTwoTierCodeLength(this.multiTierConfig.getEmailCodeLength());
                AdminGroups.this.selectedGroup.setTwoTierEmail(this.multiTierConfig.getEmailSubject(), this.multiTierConfig.getEmailBody());
                AdminGroups.this.selectedGroup.setMultiTierRememberMachine(this.multiTierConfig.rememberBox.isSelected());
                AdminGroups.this.selectedGroup.setRadius(this.useRadius());
                AdminGroups.this.selectedGroup.setMultiTierApp(this.useAppAuthentication());
                AdminGroups.this.forceSave = true;
                AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
                AdminGroups.this.saveListener.techGroupChanged();
            }

            @Override
            public void switchToRadiusServerConfig() {
                AdminGroups.this.adminPanel.switchToLoginSecuritySection();
            }

            @Override
            public void switchToLDAPServerConfig() {
                AdminGroups.this.adminPanel.switchToLoginSecuritySection();
            }

            @Override
            public void switchToEmailServerConfig() {
                AdminGroups.this.adminPanel.switchToEmailSection();
            }
        };
        int Y = 0;
        gbl.setConstraints(description, new GridBagConstraints(0, Y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        gbl.setConstraints(this.groupAuthPanel.getRootComponent(), new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        authenticationPanel.add(description);
        authenticationPanel.add(this.groupAuthPanel.getRootComponent());
    }

    private void initGroupPanelCustomer(JPanel generalPanel) {
        GridBagLayout gbl = new GridBagLayout();
        generalPanel.setLayout(gbl);
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("ADMIN_CUST_FILTER_DESC") + "</html>");
        this.groupCustomerFilters = new FiltersUI(new SaveFilterListener(true), false);
        int Y = 0;
        gbl.setConstraints(description, new GridBagConstraints(0, Y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 0), 0, 0));
        gbl.setConstraints(this.groupCustomerFilters.getRootComponent(), new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
        generalPanel.add(description);
        generalPanel.add(this.groupCustomerFilters.getRootComponent());
    }

    private void initGroupPanelMachines(JPanel generalPanelMachines) {
        GridBagLayout gbl = new GridBagLayout();
        generalPanelMachines.setLayout(gbl);
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("ADMIN_MACH_FILTER_DESC") + "</html>");
        this.groupMachineFilters = new FiltersUI(new SaveFilterListener(false), true);
        this.testMachineFilters = new JButton(Language.get("MACHINE_TEST_BUTTON"));
        this.testMachineFilters.addActionListener(this);
        int Y = 0;
        gbl.setConstraints(description, new GridBagConstraints(0, Y, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 0), 0, 0));
        gbl.setConstraints(this.testMachineFilters, new GridBagConstraints(1, Y++, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 3, 0), 0, 0));
        gbl.setConstraints(this.groupMachineFilters.getRootComponent(), new GridBagConstraints(0, Y++, 2, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
        generalPanelMachines.add(description);
        generalPanelMachines.add(this.testMachineFilters);
        generalPanelMachines.add(this.groupMachineFilters.getRootComponent());
    }

    private void initGroupPermissions(JPanel groupPermissions) {
        GbPanelWrapper wrapper = new GbPanelWrapper(groupPermissions);
        this.permissionsUI = new GroupPermissionsUI(this.validationListener);
        wrapper.add(this.permissionsUI.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
    }

    private void initGroupInfo(JPanel gInfo) {
        GbPanelWrapper groupInfo = new GbPanelWrapper(gInfo);
        this.groupNameLabel = new JLabel(Language.get("ADMIN_GROUP_NAME"));
        this.groupNameField = new JTextField();
        JWrapLabel anonDescription = new JWrapLabel("<html>" + Language.get("ADMIN_GROUP_ANON_DESC") + "</html>");
        anonDescription.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.allowAnonymousLoginsCheckBox = new JCheckBox(Language.get("ADMIN_GROUP_ANON_LOGINS"));
        this.allowAnonymousLoginsCheckBox.setVerticalAlignment(1);
        this.allowAnonymousLoginsCheckBox.setBorder(SHBorderFactory.createEmptyBorder());
        this.groupHostnameLabel = new JLabel(Language.get("ADMIN_GROUP_HOSTNAME"));
        this.groupHostname = new MessageTextField(null, null);
        this.sgServiceLabel = new JLabel(Language.get("ADMIN_GROUP_SGSERVICE_NAME"));
        this.sgServiceField = new MessageTextField(null, null);
        this.sgServiceField.setMessageText(Language.get("CUSTOMER") + "/${CustomerDetails}");
        JPanel paddy = new JPanel();
        SwingUtil.setWidth(this.groupNameField, 230);
        SwingUtil.setWidth(this.groupHostname, 230);
        SwingUtil.setWidth(this.sgServiceField, 230);
        this.groupNameField.addKeyListener(this.validationListener);
        this.groupHostname.addKeyListener(this.validationListener);
        this.sgServiceField.addKeyListener(this.validationListener);
        this.allowAnonymousLoginsCheckBox.addActionListener(this.validationListener);
        this.addVariableButton = new JButton("+");
        SHButtonUI.makeButtonSegmentedRight(this.addVariableButton);
        SwingUtil.setHeight(this.addVariableButton, this.sgServiceField.getPreferredSize().height);
        GbPanel panel = new GbPanel();
        panel.add(this.sgServiceField, 0, 0, 1, 1, 0, 1, 13, 0);
        panel.add(this.addVariableButton, 1, 0, 1, 1, 0, 1, 13, 0);
        this.addVariableButton.addActionListener(new AddVariableActionListener());
        int Y = 0;
        groupInfo.add(this.groupNameLabel, 0, Y, 1, 1, 0, 0, 13, 0, new Insets(20, 30, 0, 0));
        groupInfo.add(this.groupNameField, 1, Y++, 1, 1, 0, 0, 17, 0, new Insets(20, 5, 0, 0));
        groupInfo.add(this.allowAnonymousLoginsCheckBox, 1, Y, 1, 1, 0, 0, 18, 3, new Insets(15, 5, 0, 0));
        groupInfo.add(anonDescription, 2, Y++, 1, 1, 100, 0, 18, 2, new Insets(15, 0, 0, 0));
        groupInfo.add(this.groupHostnameLabel, 0, Y, 1, 1, 0, 0, 13, 0, new Insets(20, 30, 0, 0));
        groupInfo.add(this.groupHostname, 1, Y++, 1, 1, 0, 0, 17, 0, new Insets(20, 5, 0, 0));
        groupInfo.add(this.sgServiceLabel, 0, Y, 1, 1, 0, 0, 13, 0, new Insets(20, 30, 0, 0));
        groupInfo.add(panel, 1, Y++, 2, 1, 0, 0, 17, 0, new Insets(20, 5, 0, 0));
        groupInfo.add(paddy, 0, Y++, 2, 1, 3, 100, 10, 0, new Insets(0, 0, 0, 0));
    }

    private void initGroupSessions(JPanel groupPanel) {
        GbPanelWrapper groupInfo = new GbPanelWrapper(groupPanel, new Insets(3, 3, 3, 3));
        this.shSessionLimitCheckBox = new JWrapCheckBox(Language.get("ADMIN_RESTRICT_SH_SESSIONS"));
        this.groupMaxShSessions = new JLabel(Language.get("ADMIN_GROUP_MAX_SH_SESSIONS"));
        this.groupMaxShSessionsT = TextField.getTextFieldForType(1, Language.get("UNLIMITED"));
        this.userMaxShSessions = new JLabel(Language.get("ADMIN_USER_MAX_SH_SESSIONS"));
        this.userMaxShSessionsT = TextField.getTextFieldForType(1, Language.get("UNLIMITED"));
        this.sgSessionLimitCheckBox = new JWrapCheckBox(Language.get("ADMIN_RESTRICT_SG_SESSIONS"));
        this.groupMaxSgSessions = new JLabel(Language.get("ADMIN_GROUP_MAX_SG_SESSIONS"));
        this.groupMaxSgSessionsT = TextField.getTextFieldForType(1, Language.get("UNLIMITED"));
        this.userMaxSgSessions = new JLabel(Language.get("ADMIN_USER_MAX_SG_SESSIONS"));
        this.userMaxSgSessionsT = TextField.getTextFieldForType(1, Language.get("UNLIMITED"));
        this.fileTransferLimitCheckBox = new JWrapCheckBox(Language.get("ADMIN_RESTRICTION_FTP_SIZE"));
        this.groupLimitFileTransferLabel = new JLabel(Language.get("ADMIN_RESTRICTION_FTP_SIZE_LABEL"));
        this.groupLimitFileTransferTextField = new JTextField();
        this.groupLimitFileTransferTextField.setDocument(new DigitDocument());
        this.groupLimitUnitBox = new JComboBox<String>(new String[]{Language.get("BYTES"), Language.get("KBYTES"), Language.get("MBYTES")});
        this.sessionLimitLabel = new JLabel(Language.get("ADMIN_SESSION_LIMIT_LABEL"));
        this.sessionLimitUnits = new JLabel(Language.get("KBPS"));
        this.speedLimitCheckBox = new JWrapCheckBox(Language.get("ADMIN_GROUP_LIMIT_SPEED_BOX"));
        this.sessionLimitTextField = new JTextField();
        this.sessionLimitTextField.setDocument(new DigitDocument());
        this.fpsLimitCheckBox = new JWrapCheckBox(Language.get("ADMIN_GROUP_LIMIT_FPS_BOX"));
        this.fpsSlider = new FPSSlider();
        JPanel paddy = new JPanel();
        SwingUtil.setWidth(this.groupMaxShSessionsT, 75);
        SwingUtil.setWidth(this.userMaxShSessionsT, 75);
        SwingUtil.setWidth(this.groupMaxSgSessionsT, 75);
        SwingUtil.setWidth(this.userMaxSgSessionsT, 75);
        SwingUtil.setWidth(this.groupLimitFileTransferTextField, 125);
        SwingUtil.setWidth(this.sessionLimitTextField, 100);
        this.shSessionLimitCheckBox.addActionListener(this.validationListener);
        this.sgSessionLimitCheckBox.addActionListener(this.validationListener);
        this.fileTransferLimitCheckBox.addActionListener(this.validationListener);
        this.speedLimitCheckBox.addActionListener(this.validationListener);
        this.fpsLimitCheckBox.addActionListener(this.validationListener);
        this.groupLimitUnitBox.addActionListener(this.validationListener);
        this.groupMaxShSessionsT.addKeyListener(this.validationListener);
        this.userMaxShSessionsT.addKeyListener(this.validationListener);
        this.groupMaxSgSessionsT.addKeyListener(this.validationListener);
        this.userMaxSgSessionsT.addKeyListener(this.validationListener);
        this.groupLimitFileTransferTextField.addKeyListener(this.validationListener);
        this.sessionLimitTextField.addKeyListener(this.validationListener);
        this.fpsSlider.addChangeListener(this.validationListener);
        int Y = 0;
        groupInfo.add(this.shSessionLimitCheckBox.getRootComponent(), 0, Y++, 4, 1, 1, 0, 17, 2);
        groupInfo.add(this.groupMaxShSessions, 0, Y, 1, 1, 0, 0, 13, 0);
        groupInfo.add(this.groupMaxShSessionsT, 1, Y++, 1, 1, 1, 0, 17, 0);
        groupInfo.add(this.userMaxShSessions, 0, Y, 1, 1, 0, 0, 13, 0);
        groupInfo.add(this.userMaxShSessionsT, 1, Y++, 1, 1, 1, 0, 17, 0);
        groupInfo.add(this.sgSessionLimitCheckBox.getRootComponent(), 0, Y++, 4, 1, 1, 0, 17, 2);
        groupInfo.add(this.groupMaxSgSessions, 0, Y, 1, 1, 0, 0, 13, 0);
        groupInfo.add(this.groupMaxSgSessionsT, 1, Y++, 1, 1, 1, 0, 17, 0);
        groupInfo.add(this.userMaxSgSessions, 0, Y, 1, 1, 0, 0, 13, 0);
        groupInfo.add(this.userMaxSgSessionsT, 1, Y++, 1, 1, 1, 0, 17, 0);
        groupInfo.add(this.fileTransferLimitCheckBox.getRootComponent(), 0, Y++, 4, 1, 1, 0, 17, 2);
        GbPanel fileLimitPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        fileLimitPanel.add(this.groupLimitFileTransferLabel, 0, 0, 1, 1, 0, 0, 13, 2);
        fileLimitPanel.add(this.groupLimitFileTransferTextField, 1, 0, 1, 1, 0, 0, 13, 2);
        fileLimitPanel.add(this.groupLimitUnitBox, 2, 0, 1, 1, 1, 1, 17, 0);
        groupInfo.add(fileLimitPanel, 0, Y++, 2, 1, 0, 0, 13, 2);
        groupInfo.add(this.speedLimitCheckBox.getRootComponent(), 0, Y++, 4, 1, 1, 0, 17, 2);
        GbPanel sessionLimitPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        sessionLimitPanel.add(this.sessionLimitLabel, 0, 0, 1, 1, 0, 0, 13, 2);
        sessionLimitPanel.add(this.sessionLimitTextField, 1, 0, 1, 1, 0, 0, 13, 2);
        sessionLimitPanel.add(this.sessionLimitUnits, 2, 0, 1, 1, 1, 1, 17, 0);
        groupInfo.add(sessionLimitPanel, 0, Y++, 2, 1, 0, 0, 13, 2);
        groupInfo.add(this.fpsLimitCheckBox.getRootComponent(), 0, Y++, 4, 1, 1, 0, 17, 2);
        GbPanel fpsLimitPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        fpsLimitPanel.add(this.fpsSlider.getRootComponent(), 0, 0, 1, 1, 1, 0, 17, 0);
        groupInfo.add(fpsLimitPanel, 0, Y++, 4, 1, 0, 0, 17, 2);
        groupInfo.add(paddy, 0, Y++, 4, 1, 1, 1, 17, 2);
    }

    @Override
    public void checkEnabled() {
        this.groupAuthPanel.getRootComponent().setEnabled(this.selectedGroup != null);
        if (this.selectedGroup != null) {
            this.groupNameField.setEnabled(this.selectedGroup != null);
        }
        this.groupHostname.setEnabled(this.selectedGroup != null);
        this.sgServiceField.setEnabled(this.selectedGroup != null);
        this.addVariableButton.setEnabled(this.selectedGroup != null);
        this.permissionsUI.checkEnabled(this.selectedGroup);
        this.allowAnonymousLoginsCheckBox.setEnabled(this.selectedGroup != null);
        this.groupCustomerFilters.setEnabled(this.selectedGroup != null);
        this.groupMachineFilters.setEnabled(this.selectedGroup != null);
        this.shSessionLimitCheckBox.setEnabled(this.selectedGroup != null);
        this.sgSessionLimitCheckBox.setEnabled(this.selectedGroup != null);
        this.fileTransferLimitCheckBox.setEnabled(this.selectedGroup != null);
        this.speedLimitCheckBox.setEnabled(this.selectedGroup != null);
        this.fpsLimitCheckBox.setEnabled(this.selectedGroup != null);
        this.groupLimitFileTransferLabel.setEnabled(this.selectedGroup != null && this.fileTransferLimitCheckBox.isSelected());
        this.groupLimitFileTransferTextField.setEnabled(this.selectedGroup != null && this.fileTransferLimitCheckBox.isSelected());
        this.groupLimitUnitBox.setEnabled(this.selectedGroup != null && this.fileTransferLimitCheckBox.isSelected());
        this.groupMaxShSessions.setEnabled(this.selectedGroup != null && this.selectedGroup.isShConcurrencyLimited());
        this.userMaxShSessions.setEnabled(this.selectedGroup != null && this.selectedGroup.isShConcurrencyLimited());
        this.groupMaxShSessionsT.setEnabled(this.selectedGroup != null && this.selectedGroup.isShConcurrencyLimited());
        this.userMaxShSessionsT.setEnabled(this.selectedGroup != null && this.selectedGroup.isShConcurrencyLimited());
        this.groupMaxSgSessions.setEnabled(this.selectedGroup != null && this.selectedGroup.isSgConcurrencyLimited());
        this.userMaxSgSessions.setEnabled(this.selectedGroup != null && this.selectedGroup.isSgConcurrencyLimited());
        this.groupMaxSgSessionsT.setEnabled(this.selectedGroup != null && this.selectedGroup.isSgConcurrencyLimited());
        this.userMaxSgSessionsT.setEnabled(this.selectedGroup != null && this.selectedGroup.isSgConcurrencyLimited());
        if (this.selectedGroup != null) {
            this.shSessionLimitCheckBox.setEnabled(this.selectedGroup.getAssociatedAppProfileID() == null);
        }
        this.sessionLimitTextField.setEnabled(this.selectedGroup != null && this.selectedGroup.isSessionLimited());
        this.sessionLimitLabel.setEnabled(this.selectedGroup != null && this.selectedGroup.isSessionLimited());
        this.sessionLimitUnits.setEnabled(this.selectedGroup != null && this.selectedGroup.isSessionLimited());
        this.fpsSlider.setEnabled(this.selectedGroup != null && this.selectedGroup.isFPSLimited());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource().equals(this.groupList.getList())) {
            block31: {
                this.loading = true;
                try {
                    this.selectedGroup = (TechGroup)((JList)e.getSource()).getSelectedValue();
                    this.groupInfoPanel.setHasContents(this.selectedGroup != null);
                    if (this.selectedGroup == null) break block31;
                    System.out.println("[AdminGroups] Selected group " + this.selectedGroup + " (" + this.selectedGroup.getAssociatedAppProfileID() + ")");
                    try {
                        if (this.selectedGroup.getAssociatedAppProfileID() != null) {
                            System.out.println("[AdminGroups] Removing filtering tabs");
                            this.removeFilteringTabs();
                            this.groupNameField.setVisible(false);
                            this.groupNameLabel.setVisible(false);
                        } else {
                            System.out.println("[AdminGroups] Adding filtering tabs");
                            this.addFilteringTabs();
                            this.groupNameField.setVisible(true);
                            this.groupNameLabel.setVisible(true);
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    this.groupNameField.setText(this.selectedGroup.getName());
                    if (this.selectedGroup.getHostname() != null && this.selectedGroup.getHostname().length() > 0) {
                        this.groupHostname.setText(this.selectedGroup.getHostname());
                    } else {
                        this.groupHostname.clear();
                    }
                    if (this.selectedGroup.getDefaultSGServiceName() != null && this.selectedGroup.getDefaultSGServiceName().length() > 0) {
                        this.sgServiceField.setText(this.selectedGroup.getDefaultSGServiceName());
                    } else {
                        this.sgServiceField.clear();
                    }
                    this.permissionsUI.load(this.selectedGroup);
                    this.allowAnonymousLoginsCheckBox.setSelected(this.selectedGroup.allowAnonymousLogins());
                    this.groupAuthPanel.setPasswordName(this.selectedGroup.getName());
                    this.groupAuthPanel.setUseLDAP(this.selectedGroup.isLDAP());
                    this.groupAuthPanel.setLDAPProperties(this.selectedGroup.getLDAPProperties());
                    this.groupAuthPanel.setUseRadius(this.selectedGroup.isRadius());
                    this.groupAuthPanel.setUseAppAuthentication(this.selectedGroup.isMultiTierApp());
                    this.groupAuthPanel.setUseEmailAuthentication(this.selectedGroup.isMultiTierEmail());
                    this.groupAuthPanel.multiTierConfig.setTwoTierSettings(this.selectedGroup.getTwoTierCodeLength(), this.selectedGroup.getTwoTierSubject(), this.selectedGroup.getTwoTierBody());
                    this.groupAuthPanel.multiTierConfig.setRememberMachine(this.selectedGroup.getMultiTierRememberMachine());
                    this.groupAuthPanel.setUsePassword(this.selectedGroup.isPassword());
                    this.groupAuthPanel.password = this.selectedGroup.getPassword();
                    this.groupAuthPanel.getRootComponent().setEnabled(this.groupAuthPanel.getRootComponent().isEnabled());
                    this.groupAuthPanel.getRootComponent().repaint();
                    this.groupCustomerFilters.setExistingFilters(this.selectedGroup.getCustomerFilters());
                    this.groupMachineFilters.setExistingFilters(this.selectedGroup.getMachineFilters());
                    this.shSessionLimitCheckBox.setSelected(this.selectedGroup.isShConcurrencyLimited());
                    if (this.selectedGroup.isShConcurrencyLimited()) {
                        if (this.selectedGroup.getMaxShGroupConcurrency() == -1) {
                            this.groupMaxShSessionsT.setText(null);
                        } else {
                            this.groupMaxShSessionsT.setText("" + this.selectedGroup.getMaxShGroupConcurrency());
                        }
                        if (this.selectedGroup.getMaxShUserConcurrency() == -1) {
                            this.userMaxShSessionsT.setText(null);
                        } else {
                            this.userMaxShSessionsT.setText("" + this.selectedGroup.getMaxShUserConcurrency());
                        }
                    } else {
                        this.groupMaxShSessionsT.setText("");
                        this.userMaxShSessionsT.setText("");
                    }
                    this.sgSessionLimitCheckBox.setSelected(this.selectedGroup.isSgConcurrencyLimited());
                    if (this.selectedGroup.isSgConcurrencyLimited()) {
                        if (this.selectedGroup.getMaxSgGroupConcurrency() == -1) {
                            this.groupMaxSgSessionsT.setText(null);
                        } else {
                            this.groupMaxSgSessionsT.setText("" + this.selectedGroup.getMaxSgGroupConcurrency());
                        }
                        if (this.selectedGroup.getMaxSgUserConcurrency() == -1) {
                            this.userMaxSgSessionsT.setText(null);
                        } else {
                            this.userMaxSgSessionsT.setText("" + this.selectedGroup.getMaxSgUserConcurrency());
                        }
                    } else {
                        this.groupMaxSgSessionsT.setText("");
                        this.userMaxSgSessionsT.setText("");
                    }
                    this.fileTransferLimitCheckBox.setSelected(this.selectedGroup.isMaxFileTransferSizeLimited());
                    if (this.selectedGroup.isMaxFileTransferSizeLimited()) {
                        long maxFileSize = this.selectedGroup.getMaxFileTransferSize();
                        if (maxFileSize % 0x100000L == 0L) {
                            this.groupLimitUnitBox.setSelectedIndex(2);
                            maxFileSize /= 0x100000L;
                        } else if (maxFileSize % 1024L == 0L) {
                            this.groupLimitUnitBox.setSelectedIndex(1);
                            maxFileSize /= 1024L;
                        } else {
                            this.groupLimitUnitBox.setSelectedIndex(0);
                        }
                        this.groupLimitFileTransferTextField.setText(String.valueOf(maxFileSize));
                    } else {
                        this.groupLimitFileTransferTextField.setText("");
                    }
                    this.speedLimitCheckBox.setSelected(this.selectedGroup.isSessionLimited());
                    this.sessionLimitTextField.setText(this.selectedGroup.getSessionLimitKbps() + "");
                    this.fpsLimitCheckBox.setSelected(this.selectedGroup.isFPSLimited());
                    this.fpsSlider.setAppropriateDelay(this.selectedGroup.getFPSDelay());
                    this.groupSessions.repaint();
                }
                finally {
                    this.loading = false;
                }
            }
            this.checkEnabled();
            this.contentChanged(this.checkIfValid());
        }
    }

    @Override
    public void saveComplete(ServerConfig config) {
        this.groupAuthPanel.setConfiguredServers(config.ldapEnable, config.radiusEnable, config.emailSettingsEnabled);
    }

    @Override
    protected ArrayList<JComponent> checkAndMarkValid() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (this.selectedGroup != null) {
            int tmp;
            if (this.groupNameField.getText().length() == 0) {
                list.add(this.groupNameField);
            } else {
                this.groupNameField.setBorder(this.defaultTextFieldBorder);
            }
            if (this.selectedGroup.isSessionLimited()) {
                try {
                    if (this.sessionLimitTextField.getText().length() > 0 && (tmp = Integer.parseInt(this.sessionLimitTextField.getText().trim())) < 0) {
                        throw new NumberFormatException("Negative not allowed");
                    }
                    this.sessionLimitTextField.setBorder(this.defaultTextFieldBorder);
                }
                catch (NumberFormatException x) {
                    list.add(this.sessionLimitTextField);
                }
            }
            if (this.selectedGroup.isShConcurrencyLimited()) {
                try {
                    if (this.groupMaxShSessionsT.getText().length() > 0 && (tmp = Integer.parseInt(this.groupMaxShSessionsT.getText().trim())) < 0) {
                        throw new NumberFormatException("Negative numbers not allowed");
                    }
                    this.groupMaxShSessionsT.setBorder(this.defaultTextFieldBorder);
                }
                catch (NumberFormatException x) {
                    list.add(this.groupMaxShSessionsT);
                }
                try {
                    int tmp2;
                    if (this.userMaxShSessionsT.getText().length() > 0 && (tmp2 = Integer.parseInt(this.userMaxShSessionsT.getText().trim())) < 0) {
                        throw new NumberFormatException("Negative numbers not allowed");
                    }
                    this.userMaxShSessionsT.setBorder(this.defaultTextFieldBorder);
                }
                catch (NumberFormatException x) {
                    list.add(this.userMaxShSessionsT);
                }
                if (this.userMaxShSessionsT.getText().length() == 0 && this.groupMaxShSessionsT.getText().length() == 0) {
                    list.add(this.userMaxShSessionsT);
                    list.add(this.groupMaxShSessionsT);
                }
            } else {
                this.groupMaxShSessionsT.setBorder(this.defaultTextFieldBorder);
                this.userMaxShSessionsT.setBorder(this.defaultTextFieldBorder);
            }
            if (this.selectedGroup.isSgConcurrencyLimited()) {
                try {
                    int tmp3;
                    if (this.groupMaxSgSessionsT.getText().length() > 0 && (tmp3 = Integer.parseInt(this.groupMaxSgSessionsT.getText().trim())) < 0) {
                        throw new NumberFormatException("Negative numbers not allowed");
                    }
                    this.groupMaxSgSessionsT.setBorder(this.defaultTextFieldBorder);
                }
                catch (NumberFormatException x) {
                    list.add(this.groupMaxSgSessionsT);
                }
                try {
                    int tmp4;
                    if (this.userMaxSgSessionsT.getText().length() > 0 && (tmp4 = Integer.parseInt(this.userMaxSgSessionsT.getText().trim())) < 0) {
                        throw new NumberFormatException("Negative numbers not allowed");
                    }
                    this.userMaxSgSessionsT.setBorder(this.defaultTextFieldBorder);
                }
                catch (NumberFormatException x) {
                    list.add(this.userMaxSgSessionsT);
                }
                if (this.userMaxSgSessionsT.getText().length() == 0 && this.groupMaxSgSessionsT.getText().length() == 0) {
                    list.add(this.userMaxSgSessionsT);
                    list.add(this.groupMaxSgSessionsT);
                }
            } else {
                this.groupMaxSgSessionsT.setBorder(this.defaultTextFieldBorder);
                this.userMaxSgSessionsT.setBorder(this.defaultTextFieldBorder);
            }
        } else {
            this.groupNameField.setBorder(this.defaultTextFieldBorder);
        }
        return list;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.testMachineFilters) {
            Filter[] filters = this.groupMachineFilters.getFilters();
            MachineTestFiltersDialog.showDialog(SwingUtil.getRootPaneContainer(this.rootComponent), this.model, filters);
        }
    }

    class GroupList
    extends IconedAbstractListUI<TechGroup> {
        public GroupList(ResourceBundle lang, TechGroup[] initialList) {
            super(lang, initialList, false, true);
        }

        @Override
        protected boolean isHorizontal() {
            return false;
        }

        @Override
        protected Icon getIconForObject(TechGroup element) {
            return ImageLoader.getImageIcon("images/svg/users/queue.svg,16");
        }

        @Override
        protected TechGroup getNewObject() {
            int id = ServerConfig.get().getTechnicianGroupID();
            TechGroup group = new TechGroup(id, "New Group");
            group.setTwoTierEmail(Templates.twoTierActivationSubject, Templates.twoTierActivationContent);
            return group;
        }

        @Override
        protected void listChanged() {
            AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
        }

        @Override
        protected void elementAdded(TechGroup newObject) {
            AdminGroups.this.groupTabs.setSelectedIndex(0);
            AdminGroups.this.groupNameField.requestFocusInWindow();
            AdminGroups.this.groupNameField.selectAll();
        }

        @Override
        protected ListCellRenderer getCellRenderer() {
            return new TechGroupRenderer();
        }

        class TechGroupRenderer
        extends DefaultListCellRenderer {
            TechGroupRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                TechGroup group = (TechGroup)value;
                Icon icon = group.getAssociatedAppProfileID() != null ? ImageLoader.getImageIcon("images/logos/logo/systemtray/SH_Tray_16_Blue.png") : ImageLoader.getImageIcon("images/svg/users/queue.svg,16");
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setIcon(icon);
                return label;
            }
        }
    }

    class SaveFilterListener
    implements FiltersUI.FilterListener {
        private boolean isCustomer = false;

        public SaveFilterListener(boolean isCustomer) {
            this.isCustomer = isCustomer;
        }

        private Filter[] getFilters() {
            if (this.isCustomer) {
                return AdminGroups.this.groupCustomerFilters.getFilters();
            }
            return AdminGroups.this.groupMachineFilters.getFilters();
        }

        @Override
        public void filterChanged(Filter filter) {
            Filter[] filters = this.getFilters();
            if (this.isCustomer) {
                CustomerFilter[] newFilters = new CustomerFilter[filters.length];
                System.arraycopy(filters, 0, newFilters, 0, filters.length);
                AdminGroups.this.selectedGroup.setCustomerFilters(newFilters);
                AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
            } else {
                MachineFilter[] newFilters = new MachineFilter[filters.length];
                System.arraycopy(filters, 0, newFilters, 0, filters.length);
                AdminGroups.this.selectedGroup.setMachineFilters(newFilters);
                AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
            }
            AdminGroups.this.forceSave = true;
            AdminGroups.this.saveListener.filtersChanged();
        }
    }

    class ValidationListener
    implements KeyListener,
    ActionListener,
    ChangeListener {
        ValidationListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.processKeyPress(e.getSource());
        }

        public void processKeyPress(Object source) {
            if (source.equals(AdminGroups.this.groupNameField)) {
                AdminGroups.this.selectedGroup.setName(AdminGroups.this.groupNameField.getText());
                AdminGroups.this.groupList.repaint();
            } else if (source.equals(AdminGroups.this.groupHostname)) {
                AdminGroups.this.selectedGroup.setHostname(AdminGroups.this.groupHostname.getText());
            } else if (source.equals(AdminGroups.this.sgServiceField)) {
                AdminGroups.this.selectedGroup.setDefaultSGServiceName(AdminGroups.this.sgServiceField.getText());
            } else if (source.equals(AdminGroups.this.groupLimitFileTransferTextField)) {
                this.setGroupFileTransferLimit();
            } else if (source.equals(AdminGroups.this.groupMaxShSessionsT) || source.equals(AdminGroups.this.userMaxShSessionsT) || source.equals(AdminGroups.this.groupMaxSgSessionsT) || source.equals(AdminGroups.this.userMaxSgSessionsT)) {
                this.saveLimitSettings();
            } else if (source.equals(AdminGroups.this.sessionLimitTextField)) {
                this.setSessionSpeed();
            } else {
                AdminGroups.this.permissionsUI.handleKeyPress(AdminGroups.this.selectedGroup, source);
            }
            AdminGroups.this.forceSave = true;
            AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
            AdminGroups.this.saveListener.techGroupChanged();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private void saveLimitSettings() {
            block19: {
                block18: {
                    if (AdminGroups.this.shSessionLimitCheckBox.isSelected()) {
                        try {
                            if (AdminGroups.this.groupMaxShSessionsT.getText().trim().length() == 0) {
                                AdminGroups.this.selectedGroup.setMaxShGroupConcurrency(0);
                            } else {
                                AdminGroups.this.selectedGroup.setMaxShGroupConcurrency(Integer.parseInt(AdminGroups.this.groupMaxShSessionsT.getText().trim()));
                            }
                        }
                        catch (NumberFormatException x) {
                            AdminGroups.this.selectedGroup.setMaxShGroupConcurrency(100);
                            AdminGroups.this.groupMaxShSessionsT.setText(AdminGroups.this.selectedGroup.getMaxShGroupConcurrency() + "");
                        }
                        try {
                            if (AdminGroups.this.userMaxShSessionsT.getText().trim().length() == 0) {
                                AdminGroups.this.selectedGroup.setMaxShUserConcurrency(0);
                                break block18;
                            }
                            AdminGroups.this.selectedGroup.setMaxShUserConcurrency(Integer.parseInt(AdminGroups.this.userMaxShSessionsT.getText().trim()));
                        }
                        catch (NumberFormatException x) {
                            AdminGroups.this.selectedGroup.setMaxShUserConcurrency(10);
                            AdminGroups.this.userMaxShSessionsT.setText(AdminGroups.this.selectedGroup.getMaxShUserConcurrency() + "");
                        }
                    } else {
                        AdminGroups.this.selectedGroup.setMaxShGroupConcurrency(-1);
                        AdminGroups.this.selectedGroup.setMaxShUserConcurrency(-1);
                    }
                }
                if (AdminGroups.this.sgSessionLimitCheckBox.isSelected()) {
                    try {
                        if (AdminGroups.this.groupMaxSgSessionsT.getText().trim().length() == 0) {
                            AdminGroups.this.selectedGroup.setMaxSgGroupConcurrency(0);
                        } else {
                            AdminGroups.this.selectedGroup.setMaxSgGroupConcurrency(Integer.parseInt(AdminGroups.this.groupMaxSgSessionsT.getText().trim()));
                        }
                    }
                    catch (NumberFormatException x) {
                        AdminGroups.this.selectedGroup.setMaxSgGroupConcurrency(100);
                        AdminGroups.this.groupMaxSgSessionsT.setText(AdminGroups.this.selectedGroup.getMaxSgGroupConcurrency() + "");
                    }
                    try {
                        if (AdminGroups.this.userMaxSgSessionsT.getText().trim().length() == 0) {
                            AdminGroups.this.selectedGroup.setMaxSgUserConcurrency(0);
                            break block19;
                        }
                        AdminGroups.this.selectedGroup.setMaxSgUserConcurrency(Integer.parseInt(AdminGroups.this.userMaxSgSessionsT.getText().trim()));
                    }
                    catch (NumberFormatException x) {
                        AdminGroups.this.selectedGroup.setMaxSgUserConcurrency(10);
                        AdminGroups.this.userMaxSgSessionsT.setText(AdminGroups.this.selectedGroup.getMaxSgUserConcurrency() + "");
                    }
                } else {
                    AdminGroups.this.selectedGroup.setMaxSgGroupConcurrency(-1);
                    AdminGroups.this.selectedGroup.setMaxSgUserConcurrency(-1);
                }
            }
        }

        public void setFPSLimit() {
            if (AdminGroups.this.fpsLimitCheckBox.isSelected()) {
                AdminGroups.this.selectedGroup.setFPSLimited(true);
                long delay = AdminGroups.this.fpsSlider.getAppropriateDelay();
                AdminGroups.this.selectedGroup.setFPSDelay(delay);
            } else {
                AdminGroups.this.selectedGroup.setFPSLimited(false);
            }
        }

        public void setSessionSpeed() {
            if (AdminGroups.this.speedLimitCheckBox.isSelected()) {
                AdminGroups.this.selectedGroup.setSessionLimited(true);
                if (AdminGroups.this.sessionLimitTextField.getText().length() > 0) {
                    try {
                        AdminGroups.this.selectedGroup.setSessionLimitKbps(Integer.parseInt(AdminGroups.this.sessionLimitTextField.getText()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                AdminGroups.this.selectedGroup.setSessionLimited(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean requestSave = true;
            if (!AdminGroups.this.loading && e.getSource() == AdminGroups.this.groupLimitUnitBox) {
                this.setGroupFileTransferLimit();
            } else if (e.getSource().equals(AdminGroups.this.allowAnonymousLoginsCheckBox)) {
                AdminGroups.this.selectedGroup.setAllowAnonymousLogins(AdminGroups.this.allowAnonymousLoginsCheckBox.isSelected());
            } else if (e.getSource().equals(AdminGroups.this.shSessionLimitCheckBox.getCheckBoxComponent())) {
                this.saveLimitSettings();
            } else if (e.getSource() == AdminGroups.this.fileTransferLimitCheckBox.getCheckBoxComponent()) {
                this.setGroupFileTransferLimit();
            } else if (e.getSource().equals(AdminGroups.this.sgSessionLimitCheckBox.getCheckBoxComponent())) {
                this.saveLimitSettings();
            } else if (e.getSource().equals(AdminGroups.this.speedLimitCheckBox.getCheckBoxComponent())) {
                this.setSessionSpeed();
            } else if (e.getSource().equals(AdminGroups.this.fpsLimitCheckBox.getCheckBoxComponent())) {
                this.setFPSLimit();
            } else {
                requestSave = AdminGroups.this.permissionsUI.actionPerformed(AdminGroups.this.selectedGroup, e);
            }
            if (requestSave) {
                AdminGroups.this.forceSave = true;
            }
            AdminGroups.this.checkEnabled();
            AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
            if (requestSave) {
                AdminGroups.this.saveListener.techGroupChanged();
            }
        }

        private void setGroupFileTransferLimit() {
            if (AdminGroups.this.fileTransferLimitCheckBox.isSelected()) {
                long size = -1L;
                try {
                    size = Long.parseLong(AdminGroups.this.groupLimitFileTransferTextField.getText());
                    switch (AdminGroups.this.groupLimitUnitBox.getSelectedIndex()) {
                        case 1: {
                            size *= 1024L;
                            break;
                        }
                        case 2: {
                            size *= 0x100000L;
                            break;
                        }
                    }
                    AdminGroups.this.selectedGroup.setMaxFileTransferSize(size);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                AdminGroups.this.selectedGroup.setMaxFileTransferSize(-1L);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.setFPSLimit();
            AdminGroups.this.forceSave = true;
            AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
            AdminGroups.this.saveListener.techGroupChanged();
        }
    }

    class InsertVariableAction
    extends AbstractAction {
        private String id;

        public InsertVariableAction(String name, String id) {
            super(name);
            this.id = id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedVariable = "${" + this.id + "}";
            int pos = AdminGroups.this.sgServiceField.getCaretPosition();
            AdminGroups.this.sgServiceField.setText(AdminGroups.this.sgServiceField.getText().substring(0, pos) + selectedVariable + AdminGroups.this.sgServiceField.getText().substring(pos));
            AdminGroups.this.sgServiceField.setCaretPosition(pos + selectedVariable.length());
            AdminGroups.this.validationListener.processKeyPress(AdminGroups.this.sgServiceField);
        }
    }

    class AddVariableActionListener
    implements ActionListener {
        AddVariableActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] keys;
            if (AdminGroups.this.details != null) {
                keys = new String[AdminGroups.this.details.length];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = AdminGroups.this.details[i].getLabel();
                }
            } else {
                keys = new String[]{};
            }
            JPopupMenu menu = AdminGroups.this.getAddVariableMenu(keys);
            Rectangle bounds = AdminGroups.this.addVariableButton.getBounds();
            menu.show(AdminGroups.this.addVariableButton, -1, bounds.y + bounds.height);
        }
    }
}

