/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.sessions;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.HiddenPanelContainer;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import utils.swing.JComboBoxFixer;
import utils.swing.SwingUtil;
import utils.swing.components.RoundBorderPanel;
import utils.swing.components.SHComboBox;
import utils.swing.cui.types.CUIField;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.switches.Switches;

public class AdminEndOfSession
extends SubSection
implements ValidationKeyListener.ValidationInterface,
HiddenPanelContainer {
    public static final int OPTION_NONE = 0;
    public static final int OPTION_URL = 1;
    public static final int OPTION_SURVEY = 2;
    private SHComboBox endOfSessionCombo;
    private GbPanel sessionConfigurationPanel;
    private JTextField urlField;
    private JLabel urlLabel;
    private RoundBorderPanel urlPanel;
    private JCheckBox urlSupportBox;
    private JCheckBox urlAccessBox;
    private JButton addVariableButton;
    private CUIField[] details;

    private void setDetails(CUIField[] details) {
        this.details = details;
        if (details == null || details.length == 0) {
            this.addVariableButton.setEnabled(false);
        } else {
            this.addVariableButton.setEnabled(true);
        }
    }

    @Override
    protected void initUI() {
        this.initEndOfSessionPanel(this.rootComponent);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_SESSION_END_CUSTOMER");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        String endOfSessionOption = config.endOfSessionOption;
        this.urlField.setText(config.endOfSessionURL);
        this.urlSupportBox.setSelected(config.endOfSessionURLSupport);
        this.urlAccessBox.setSelected(config.endOfSessionURLAccess);
        this.setDetails(config.getDetails());
        if (endOfSessionOption == null || endOfSessionOption.equals("None")) {
            this.endOfSessionCombo.setSelectedIndex(0);
        } else if (endOfSessionOption.equals("URL")) {
            this.endOfSessionCombo.setSelectedIndex(1);
        } else if (endOfSessionOption.equals("Survey")) {
            this.endOfSessionCombo.setSelectedIndex(2);
        }
        this.changeUIForNewComboSelection();
    }

    private void changeUIForNewComboSelection() {
        int selectedIndex = this.endOfSessionCombo.getSelectedIndex();
        this.sessionConfigurationPanel.removeAll();
        if (selectedIndex != 0 && selectedIndex != -1 && selectedIndex == 1) {
            this.sessionConfigurationPanel.add(this.urlPanel, 0, 0, 1, 1, 1, 0, 10, 2, new Insets(10, 0, 0, 0));
        }
        this.sessionConfigurationPanel.revalidate();
        this.sessionConfigurationPanel.repaint();
    }

    @Override
    public void saveTo(ServerConfig config) {
        int selIndex = this.endOfSessionCombo.getSelectedIndex();
        if (selIndex == 0 || selIndex == -1) {
            config.endOfSessionOption = "None";
        } else if (selIndex == 1) {
            config.endOfSessionOption = "URL";
            config.endOfSessionURL = this.urlField.getText().trim();
            config.endOfSessionURLSupport = this.urlSupportBox.isSelected();
            config.endOfSessionURLAccess = this.urlAccessBox.isSelected();
        } else if (selIndex == 2) {
            config.endOfSessionOption = "Survey";
        }
    }

    private void initEndOfSessionPanel(JPanel endOfSessionPanel) {
        GbPanelWrapper wrapper = new GbPanelWrapper(endOfSessionPanel);
        this.endOfSessionCombo = Switches.SH_endOfSessionRatings ? new SHComboBox(new String[]{Language.get(Language.get("ADMIN_SESSION_END_NOTHING")), Language.get(Language.get("ADMIN_SESSION_END_URL")), Language.get(Language.get("ADMIN_SESSION_END_NPS")), Language.get(Language.get("ADMIN_SESSION_END_RATING"))}) : new SHComboBox(new String[]{Language.get(Language.get("ADMIN_SESSION_END_NOTHING")), Language.get(Language.get("ADMIN_SESSION_END_URL"))});
        this.endOfSessionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminEndOfSession.this.changeUIForNewComboSelection();
                AdminEndOfSession.this.contentChanged(AdminEndOfSession.this.checkIfValid());
            }
        });
        this.sessionConfigurationPanel = new GbPanel();
        this.sessionConfigurationPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        JLabel urlLabel = new JLabel(Language.get("ADMIN_SESSION_URL_LABEL") + ":");
        this.urlField = new JTextField();
        this.urlField.addKeyListener(this.validateListener);
        this.urlSupportBox = new JCheckBox(Language.get("ADMIN_SESSION_END_ACCESS"));
        this.urlAccessBox = new JCheckBox(Language.get("ADMIN_SESSION_END_SUPPORT"));
        this.urlSupportBox.addActionListener(this.validateListener);
        this.urlAccessBox.addActionListener(this.validateListener);
        this.addVariableButton = new JButton("+");
        SHButtonUI.makeButtonSegmentedRight(this.addVariableButton);
        this.addVariableButton.addActionListener(new AddVariableActionListener());
        this.urlPanel = new RoundBorderPanel(false);
        GbPanelWrapper urlWrapper = new GbPanelWrapper(this.urlPanel, new Insets(3, 3, 3, 3));
        int YY = 0;
        urlWrapper.add(urlLabel, 0, YY, 1, 1, 0, 1, 13, 0, new Insets(3, 30, 3, 10));
        urlWrapper.add(this.urlField, 1, YY, 1, 1, 1, 1, 17, 2, new Insets(3, 3, 3, 0));
        urlWrapper.add(this.addVariableButton, 2, YY++, 1, 1, 0, 1, 17, 0, new Insets(3, 0, 3, 3));
        SwingUtil.setHeight(this.addVariableButton, this.urlField.getPreferredSize().height);
        urlWrapper.add(this.urlSupportBox, 0, YY++, 3, 1, 1, 1, 17, 2);
        urlWrapper.add(this.urlAccessBox, 0, YY++, 3, 1, 1, 1, 17, 2);
        wrapper.add(new JLabel(Language.get("ADMIN_SESSION_CHOICE_LABEL") + ": "), 0, 0, 1, 1, 0, 0, 13, 2);
        wrapper.add(this.endOfSessionCombo, 1, 0, 1, 1, 1, 0, 10, 2);
        wrapper.add(this.sessionConfigurationPanel, 0, 1, 2, 1, 1, 0, 10, 1);
        this.changeUIForNewComboSelection();
    }

    private JPopupMenu getAddVariableMenu(String[] customerDetails) {
        JPopupMenu variableAddressMenu = new JPopupMenu();
        JComboBoxFixer.fix(variableAddressMenu);
        for (int i = 0; i < customerDetails.length; ++i) {
            JMenuItem item = new JMenuItem(new InsertVariableAction(customerDetails[i], customerDetails[i]));
            variableAddressMenu.add(item);
        }
        JMenuItem item = new JMenuItem(new InsertVariableAction("Technician", "Technician"));
        variableAddressMenu.add(item);
        return variableAddressMenu;
    }

    @Override
    public ArrayList<JComponent> checkAndMarkValid() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (this.endOfSessionCombo.getSelectedIndex() == 1 && this.urlField.getText().length() == 0) {
            list.add(this.urlField);
        } else {
            this.urlField.setBorder(this.defaultTextFieldBorder);
        }
        return list;
    }

    @Override
    public Component[] getHiddenComponents() {
        return new Component[]{this.urlPanel};
    }

    class InsertVariableAction
    extends AbstractAction {
        private String id;

        public InsertVariableAction(String name, String id) {
            super(name);
            this.id = id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedVariable = "${" + this.id + "}";
            int pos = AdminEndOfSession.this.urlField.getCaretPosition();
            AdminEndOfSession.this.urlField.setText(AdminEndOfSession.this.urlField.getText().substring(0, pos) + selectedVariable + AdminEndOfSession.this.urlField.getText().substring(pos));
            AdminEndOfSession.this.urlField.setCaretPosition(pos + selectedVariable.length());
            AdminEndOfSession.this.saveListener.actionPerformed(e);
            AdminEndOfSession.this.contentChanged(AdminEndOfSession.this.checkIfValid());
        }
    }

    class AddVariableActionListener
    implements ActionListener {
        AddVariableActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] keys;
            if (AdminEndOfSession.this.details != null) {
                keys = new String[AdminEndOfSession.this.details.length];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = AdminEndOfSession.this.details[i].getLabel();
                }
            } else {
                keys = new String[]{};
            }
            JPopupMenu menu = AdminEndOfSession.this.getAddVariableMenu(keys);
            Rectangle bounds = AdminEndOfSession.this.addVariableButton.getBounds();
            menu.show(AdminEndOfSession.this.addVariableButton, -1, bounds.y + bounds.height);
        }
    }
}

