/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.sessions;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.cui.ui.FieldListUI;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class AdminCustomerDetails
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    public static AdminCustomerDetails INSTANCE = null;
    private ValidationKeyListener keyListener;
    private FieldListUI detailsList;
    JTextField widthTextField;
    JTextField heightTextField;
    JLabel detailsSizelabel;
    JLabel xLabel;
    JLabel pixelsLabel;
    private JCheckBox fixSizeBox;

    public AdminCustomerDetails() {
        INSTANCE = this;
    }

    private void initDetailsPanel(JPanel detailsTab) {
        this.keyListener = new ValidationKeyListener(this);
        GbPanelWrapper wrapper = new GbPanelWrapper(detailsTab, new Insets(3, 3, 3, 3));
        this.detailsList = new FieldListUI(Language.DEFLANG, SHStyle.INSTANCE, new AbstractField.ChangeListener(){

            @Override
            public void changed(AbstractField source) {
                AdminCustomerDetails.this.contentChanged(AdminCustomerDetails.this.checkIfValid());
                AdminCustomerDetails.this.saveListener.detailsChanged();
            }
        });
        this.detailsList.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.detailsList.getRootComponent().setBorder(SHBorderFactory.createLineBorder(SHStyle.BORDER_COLOR));
        this.detailsSizelabel = new JLabel(Language.get("DETAILS_DIALOG_SIZE"));
        this.pixelsLabel = new JLabel(Language.get("PIXELS") + ".");
        this.xLabel = new JLabel("x");
        TextField widthField = new TextField("", null, 1);
        TextField heightField = new TextField("", null, 1);
        widthField.setLengthConstraints(3, 1);
        heightField.setLengthConstraints(3, 1);
        this.widthTextField = (JTextField)widthField.getComponent();
        this.heightTextField = (JTextField)heightField.getComponent();
        SwingUtil.setWidth(this.widthTextField, 40);
        SwingUtil.setWidth(this.heightTextField, 40);
        this.fixSizeBox = new JCheckBox();
        this.fixSizeBox.addActionListener(this.keyListener);
        GbPanel configurationPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        configurationPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        int X = 0;
        configurationPanel.add(this.fixSizeBox, X++, 0, 1, 1, 0, 1, 17, 0);
        configurationPanel.add(this.detailsSizelabel, X++, 0, 1, 1, 0, 1, 17, 0);
        configurationPanel.add(this.widthTextField, X++, 0, 1, 1, 0, 1, 10, 0);
        configurationPanel.add(this.xLabel, X++, 0, 1, 1, 0, 1, 17, 0);
        configurationPanel.add(this.heightTextField, X++, 0, 1, 1, 0, 1, 10, 0);
        configurationPanel.add(this.pixelsLabel, X++, 0, 1, 1, 0, 1, 17, 0);
        JScrollPane pane = new JScrollPane(this.detailsList.getRootComponent());
        pane.setBorder(null);
        SwingUtil.setHeight(pane, SimpleHelpLookAndFeel.scale(250));
        JWrapLabel desc = new JWrapLabel("<html>" + Language.get("ADMIN_DETAILS_DESC") + "</html>");
        int Y = 0;
        wrapper.add(desc, 0, Y++, 1, 1, 1, 1, 17, 2);
        wrapper.add(pane, 0, Y++, 1, 1, 1, 1, 11, 2);
    }

    @Override
    protected void initUI() {
        this.initDetailsPanel(this.rootComponent);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_DETAILS_TAB");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        CUIField[] fields = config.getDetails();
        if (fields != null) {
            this.detailsList.initUIForList(fields);
        } else {
            this.detailsList.initUIForList(new CUIField[0]);
        }
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.setDetails(this.detailsList.getFields());
    }

    @Override
    public void checkEnabled() {
        this.widthTextField.setEnabled(this.fixSizeBox.isSelected());
        this.heightTextField.setEnabled(this.fixSizeBox.isSelected());
        this.detailsSizelabel.setEnabled(this.fixSizeBox.isSelected());
        this.xLabel.setEnabled(this.fixSizeBox.isSelected());
        this.pixelsLabel.setEnabled(this.fixSizeBox.isSelected());
    }
}

