/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.gstarted.SHWebsiteURLUtil;
import com.aem.shelp.tech.gstarted.TrialUtils;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import jwrapper.jwutils.JWSystem;
import utils.site.transact.TrialUtil;
import utils.swing.SwingUtil;
import utils.swing.browser.Browser;
import utils.swing.components.JMultiLineLabel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanelWrapper;

public class BusinessFeatureSet
extends SubSection
implements ValidationKeyListener.ValidationInterface,
ActionListener {
    private JButton gettrial;
    private JButton more;
    private JPanel buttonsPanel;
    private String status;

    @Override
    protected void initUI() {
        GbPanelWrapper wrap = new GbPanelWrapper(this.rootComponent, new Insets(1, 3, 9, 0));
        JMultiLineLabel label = new JMultiLineLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension up = super.getPreferredSize();
                return new Dimension(Math.min(500, up.width), up.height);
            }
        };
        label.addPara(this.getExplanation());
        this.gettrial = new JButton();
        this.more = new JButton(Language.get("ONLINE_GUIDE"), ImageLoader.getImageIcon("images/svg/general/book.svg,16"));
        wrap.add(label, 0, 0, 1, 1, 100, 1000, 18, 1);
        this.buttonsPanel = new JPanel(new GridLayout(1, 2, 6, 6));
        this.buttonsPanel.add(this.more);
        this.buttonsPanel.add(this.gettrial);
        wrap.add(this.buttonsPanel, 1, 0, 1, 1, 0, 1, 11, 2);
        this.more.addActionListener(this);
        this.gettrial.addActionListener(this);
    }

    public void updateConfig() {
        boolean fullyLicensed = false;
        if (AdminPanel.LOADED_LICENSE != null && this.getTuFeature().equals(TrialUtil.FEATURE_BIZ)) {
            boolean bl = fullyLicensed = AdminPanel.LOADED_LICENSE.isVersion2Business() || AdminPanel.LOADED_LICENSE.isVersion2Enterprise();
        }
        if (fullyLicensed) {
            this.gettrial.setIcon(ImageLoader.getImageIcon("images/svg/general/clock-darker.svg,16"));
            this.gettrial.setText(Language.get("TRIAL_NOW"));
            this.gettrial.setEnabled(false);
            this.status = Language.get("STATUS_LICENSED");
            this.setRightTitleGreen();
            this.updateTitleLabels();
        } else {
            TrialUtil tu = new TrialUtil(JWSystem.getAllAppVersionsSharedFolder());
            if (tu.hasTrialStarted(this.getTuFeature())) {
                int daysLeft = tu.trialDaysLeft(this.getTuFeature());
                if (daysLeft <= 0) {
                    this.status = Language.get("STATUS_EXPIRED");
                    this.setRightTitleRed();
                    this.updateTitleLabels();
                    this.gettrial.setText(Language.get("RESTART_TRIAL"));
                    this.gettrial.setIcon(ImageLoader.getImageIcon("images/svg/general/clock-darker.svg,16"));
                } else {
                    this.status = Language.get("STATUS_TRIALLING", new Object[]{daysLeft});
                    this.setRightTitleYellow();
                    this.updateTitleLabels();
                    this.gettrial.setText(Language.get("EXTEND_TRIAL"));
                    this.gettrial.setIcon(ImageLoader.getImageIcon("images/svg/general/clock-darker.svg,16"));
                }
            } else {
                this.status = null;
                this.updateTitleLabels();
                this.gettrial.setText(Language.get("TRIAL_NOW"));
                this.gettrial.setIcon(ImageLoader.getImageIcon("images/svg/general/clock-darker.svg,16"));
            }
            this.gettrial.setEnabled(true);
        }
    }

    public String getTuFeature() {
        return TrialUtil.FEATURE_BIZ;
    }

    @Override
    public String getTitle() {
        return Language.get("BUSINESS_SET");
    }

    public String getExplanation() {
        return Language.get("BUSINESS_EXPLAIN");
    }

    @Override
    public String getRightTitle() {
        return this.status;
    }

    public String getGuideURL() {
        return SHWebsiteURLUtil.getBusinessEnterpriseGuideURL();
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.updateConfig();
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.more) {
            try {
                Browser.openURL(new URL(this.getGuideURL()));
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        } else if (src == this.gettrial) {
            try {
                TrialUtils.getTrialNow(SwingUtil.getRootPaneContainer(this.rootComponent), this.techClient, this.getTuFeature());
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.updateConfig();
        }
    }
}

