/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.LazyPassword;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.KeystoreDescriptionPanel;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.serversettings.NewSSLCertificateWizardDialog;
import com.aem.utils.KeyStoreUtility;
import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AdminNewSSL
extends SubSection
implements ActionListener {
    private JButton keystoreView;
    private JButton leRenew;
    private String recentKeystoreType;
    private String recentKeystoreStorePassword;
    private String recentKeystoreKeyPassword;
    private JButton createNewCertificate;
    private JLabel summaryLabel;
    private JLabel expiresLabel;

    @Override
    protected void initUI() {
        this.initSslPanel(this.rootComponent);
    }

    private void initSslPanel(JPanel sslPanel) {
        sslPanel.setLayout(new BorderLayout());
        GbPanel main = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        sslPanel.add("Center", main);
        this.keystoreView = new JButton(Language.get("KEYSTORE_VIEW"));
        this.keystoreView.setIcon(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"));
        this.keystoreView.setFont(SHStyle.smallerFont);
        this.keystoreView.addActionListener(this);
        this.leRenew = new JButton(Language.get("LE_RENEW"));
        this.leRenew.setIcon(ImageLoader.getImageIcon("images/svg/arrows/refresh.svg,16"));
        this.leRenew.setFont(SHStyle.smallerFont);
        this.leRenew.addActionListener(this);
        this.createNewCertificate = new JButton(Language.get("SSL_ADD_CERTIFICATE"));
        this.createNewCertificate.setIcon(ImageLoader.getImageIcon("images/svg/general/add.svg,16"));
        this.createNewCertificate.addActionListener(this);
        int Y = 0;
        JWrapLabel importantNoteLabel = new JWrapLabel("<html><b>" + Language.get("IMPORTANT_PREFIX") + "</b> " + Language.get("ADMIN_SSL_WARNING_2") + "</html>");
        this.summaryLabel = new JLabel();
        this.expiresLabel = new JLabel();
        main.add(importantNoteLabel, 0, Y++, 2, 1, 1, 1, 17, 2);
        main.add(this.summaryLabel, 0, Y, 1, 1, 0, 1, 17, 2, new Insets(10, 2, 5, 2));
        main.add(this.keystoreView, 1, Y++, 2, 1, 1, 1, 17, 0, new Insets(10, 40, 5, 2));
        main.add(this.expiresLabel, 0, Y, 1, 1, 0, 1, 17, 2, new Insets(5, 2, 20, 2));
        main.add(this.leRenew, 1, Y++, 2, 1, 1, 1, 17, 0, new Insets(5, 40, 20, 2));
        main.add(this.createNewCertificate, 0, Y, 1, 2, 0, 1, 17, 0);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_SSL");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.recentKeystoreType = config.keystoreType;
        this.recentKeystoreStorePassword = config.keystoreStorePassword != null ? config.keystoreStorePassword.getDecryptedPassword() : null;
        this.recentKeystoreKeyPassword = config.keystoreKeyPassword != null ? config.keystoreKeyPassword.getDecryptedPassword() : null;
        this.updateKeystoreSummary();
    }

    @Override
    public void saveTo(ServerConfig config) {
        if (this.recentKeystoreType != null) {
            if (config.keystoreStorePassword == null) {
                config.keystoreStorePassword = new LazyPassword(this.recentKeystoreStorePassword);
            } else {
                config.keystoreStorePassword.setDecryptedPassword(this.recentKeystoreStorePassword);
            }
            if (config.keystoreKeyPassword == null) {
                config.keystoreKeyPassword = new LazyPassword(this.recentKeystoreKeyPassword);
            } else {
                config.keystoreKeyPassword.setDecryptedPassword(this.recentKeystoreKeyPassword);
            }
            config.keystoreType = this.recentKeystoreType;
        }
    }

    public void setExpiryDate(long expiryDate) {
        this.expiresLabel.setVisible(true);
        if (expiryDate < System.currentTimeMillis()) {
            this.expiresLabel.setText(Language.get("LE_IS_EXPIRED"));
            this.expiresLabel.setIcon(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16"));
        } else {
            int days = (int)((expiryDate - System.currentTimeMillis()) / 86400000L);
            this.expiresLabel.setText(Language.get("LE_EXPIRE", new Object[]{Integer.toString(days)}));
            this.expiresLabel.setIcon(ImageLoader.getImageIcon("images/svg/general/ok.svg,16"));
        }
        this.expiresLabel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.keystoreView)) {
            this.keystoreView.setEnabled(false);
            new KeystoreViewThread().start();
        } else if (e.getSource() == this.createNewCertificate) {
            NewSSLCertificateWizardDialog wizard = new NewSSLCertificateWizardDialog(SwingUtil.getRootPaneContainer(this.rootComponent), this.techClient, this);
            wizard.showDialog();
        } else if (e.getSource() == this.leRenew) {
            this.leRenew.setEnabled(false);
            this.leRenew.repaint();
            new RenewLEThread().start();
        }
    }

    public void setKeystoreAndSave(String keystoreType, String storePassword, String keyPassword) {
        this.recentKeystoreStorePassword = storePassword;
        this.recentKeystoreKeyPassword = keyPassword;
        this.recentKeystoreType = keystoreType;
        this.updateKeystoreSummary();
        this.contentChanged(this.checkIfValid());
    }

    private void updateKeystoreSummary() {
        this.expiresLabel.setVisible(false);
        this.leRenew.setVisible(false);
        if (this.recentKeystoreType == null) {
            this.summaryLabel.setText(Language.get("SSL_SUMMARY_NONE"));
            this.summaryLabel.setIcon(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16"));
            this.keystoreView.setVisible(false);
            return;
        }
        if ("LetsEncrypt".equals(this.recentKeystoreType)) {
            this.summaryLabel.setText(Language.get("SSL_SUMMARY_LE"));
            this.leRenew.setVisible(true);
            new KeystoreExpiryDateThread().start();
        } else if ("SelfSigned".equals(this.recentKeystoreType)) {
            this.summaryLabel.setText(Language.get("SSL_SUMMARY_SELF_SIGNED"));
        } else if ("Uploaded".equals(this.recentKeystoreType)) {
            this.summaryLabel.setText(Language.get("SSL_SUMMARY_UPLOADED"));
        }
        this.summaryLabel.setIcon(ImageLoader.getImageIcon("images/svg/general/lock.svg,16"));
        this.keystoreView.setVisible(true);
    }

    class RenewLEThread
    extends Thread {
        RenewLEThread() {
        }

        @Override
        public void run() {
            try {
                AdminNewSSL.this.techClient.renewLECertificate();
                long date = AdminNewSSL.this.techClient.fetchKeystoreExpiryDate();
                AdminNewSSL.this.setExpiryDate(date);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AdminNewSSL.this.leRenew.setEnabled(true);
                            AdminNewSSL.this.leRenew.repaint();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    class KeystoreViewThread
    extends Thread {
        KeystoreViewThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AdminNewSSL.this.saveListener.requestImmediateSave();
            try {
                KeyStoreUtility.KeystoreValidationResult result = AdminNewSSL.this.techClient.fetchKeystoreDetails();
                KeystoreDescriptionPanel.showValidationResult(SwingUtil.getRootPaneContainer(AdminNewSSL.this.rootComponent), result);
            }
            catch (Exception e) {
                String error = "<html>" + Language.get("UNABLE_TO_LOAD_KEYSTORE") + ".";
                String explanation = e.getMessage();
                if (explanation != null) {
                    error = error + "<BR><BR>" + explanation;
                }
                SHGlassOptionPane.showErrorDialog(SwingUtil.getRootPaneContainer(AdminNewSSL.this.rootComponent), error, Language.get("UNABLE_TO_LOAD_KEYSTORE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            }
            finally {
                AdminNewSSL.this.keystoreView.setEnabled(true);
            }
        }
    }

    class KeystoreExpiryDateThread
    extends Thread {
        KeystoreExpiryDateThread() {
        }

        @Override
        public void run() {
            AdminNewSSL.this.saveListener.requestImmediateSave();
            try {
                long date = AdminNewSSL.this.techClient.fetchKeystoreExpiryDate();
                AdminNewSSL.this.setExpiryDate(date);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

