/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class AdminAutoForget
extends SubSection
implements ActionListener {
    private JCheckBox autoForgetBox;
    private JTextField quantityField;
    private JComboBox unitBox;
    private GbPanel configPanel;

    @Override
    protected void initUI() {
        this.autoForgetBox = new JCheckBox(Language.get("ADMIN_AUTO_FORGET_BOX"));
        this.quantityField = TextField.getTextFieldForType(1, "10");
        this.unitBox = new JComboBox<String>(new String[]{Language.get("UNIT_MINUTES"), Language.get("UNIT_HOURS"), Language.get("UNIT_DAYS")});
        GbPanelWrapper blockWrapper = new GbPanelWrapper(this.rootComponent);
        JWrapLabel descriptionLabel = new JWrapLabel("<html>" + Language.get("ADMIN_AUTO_FORGET_DESC"));
        JLabel timeoutLabel = new JLabel(Language.get("ADMIN_AUTO_FORGET_TIMEOUT"));
        int Y = 0;
        blockWrapper.add(descriptionLabel, 0, Y++, 3, 1, 1, 0, 10, 2, new Insets(0, 0, 5, 0));
        blockWrapper.add(this.autoForgetBox, 0, Y++, 3, 1, 1, 0, 17, 2, new Insets(0, 0, 5, 0));
        SwingUtil.setWidth(this.quantityField, SimpleHelpLookAndFeel.scale(50));
        this.configPanel = new GbPanel();
        this.configPanel.add(timeoutLabel, 0, 0, 1, 1, 0, 0, 17, 0, new Insets(0, 30, 5, 0));
        this.configPanel.add(this.quantityField, 1, 0, 1, 1, 0, 0, 17, 1, new Insets(0, 5, 5, 0));
        this.configPanel.add(this.unitBox, 2, 0, 1, 1, 1, 0, 17, 0, new Insets(0, 5, 5, 0));
        blockWrapper.add(this.configPanel, 0, Y, 1, 1, 0, 0, 17, 1, new Insets(0, 0, 0, 0));
        this.autoForgetBox.addActionListener(this);
        this.quantityField.addKeyListener(this.validateListener);
        this.unitBox.addActionListener(this.validateListener);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_AUTO_FORGET");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.autoForgetBox.setSelected(config.autoForgetEnabled);
        long ms = config.autoForgetTimeoutMS;
        if (ms >= 86400000L && ms % 86400000L == 0L) {
            this.quantityField.setText(Long.toString(ms / 86400000L));
            this.unitBox.setSelectedIndex(2);
        } else if (ms >= 3600000L && ms % 3600000L == 0L) {
            this.quantityField.setText(Long.toString(ms / 3600000L));
            this.unitBox.setSelectedIndex(1);
        } else {
            this.quantityField.setText(Long.toString(ms / 60000L));
            this.unitBox.setSelectedIndex(0);
        }
        this.updateEnabled();
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.autoForgetEnabled = this.autoForgetBox.isSelected();
        long timeoutMS = 10L;
        if (this.quantityField.getText().length() > 0) {
            timeoutMS = Long.parseLong(this.quantityField.getText());
        }
        if (this.unitBox.getSelectedIndex() == 0) {
            timeoutMS *= 60000L;
        } else if (this.unitBox.getSelectedIndex() == 1) {
            timeoutMS *= 3600000L;
        } else if (this.unitBox.getSelectedIndex() == 2) {
            timeoutMS *= 86400000L;
        }
        config.autoForgetTimeoutMS = timeoutMS;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateEnabled();
        this.contentChanged(this.checkIfValid());
    }

    private void updateEnabled() {
        boolean on = this.autoForgetBox.isSelected();
        this.configPanel.setVisible(on);
    }
}

