/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.gettingstarted;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.config.LazyPassword;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.PasswordDialog;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanelWrapper;

public class AdminPassword
extends SubSection
implements ActionListener {
    JButton passwordButton;
    private LazyPassword serverPassword = new LazyPassword("password");

    @Override
    public String getTitle() {
        return Language.get("ADMIN_PASSWORD_TITLE");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.serverPassword = config.serverPassword;
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.serverPassword = this.serverPassword;
    }

    @Override
    public boolean insertDefaultPadding() {
        return true;
    }

    @Override
    public void initUI() {
        GbPanelWrapper wrapper = new GbPanelWrapper(this.rootComponent);
        JWrapLabel descriptionLabel = new JWrapLabel("<html>" + Language.get("SIMPLEHELP_ADMIN_PASSWORD") + " " + Language.get("ADMIN_PASSWORD_DESC") + "</html>");
        this.passwordButton = new JButton(Language.get("ADMIN_PASSWORD_RESET"), ImageLoader.getImageIcon("images/svg/general/lock.svg,16"));
        this.passwordButton.addActionListener(this);
        wrapper.add(descriptionLabel, 0, 0, 1, 1, 1, 1, 17, 1, new Insets(30, 150, 20, 150));
        wrapper.add(this.passwordButton, 0, 1, 1, 1, 1, 1, 10, 0, new Insets(0, 0, 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.passwordButton)) {
            PasswordDialog dialog;
            boolean requireOldPassword = true;
            if (ServerConfig.isDefaultPassword(this.serverPassword)) {
                requireOldPassword = false;
            }
            if ((dialog = new PasswordDialog(SwingUtil.getRootPaneContainer(this.getRootComponent()), 500, 200, true, true, false, requireOldPassword, OemBranding.OEM_ADMIN_USERNAME, this.serverPassword.getDecryptedPassword())).isOK()) {
                this.serverPassword = new LazyPassword(new String(dialog.newPassword));
            }
            this.saveListener.requestImmediateSave();
            this.contentChanged(this.checkIfValid());
        }
    }
}

