/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.admin.subsections.HiddenPanelContainer;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.serversettings.IgnoreKeyListenerTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import jwrapper.jwutils.swing.JWAutomatable;
import utils.loggingframework.ui.LogMappingRepositoryUI;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.listui.AbstractListUI;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.sectionproperties.AllSectionsPanel;
import utils.swing.sectionproperties.Section;

public final class AdminSection
implements Section {
    private static final Color LIGHT = SHStyle.PANEL_BACKGROUND_LIGHT;
    private static final Color DARK = SHStyle.PANEL_BACKGROUND_MEDIUM;
    protected GbPanel rootComponent = new GbPanel();
    protected SubSection[] subSections;
    private String name;
    private Icon largeIcon;
    private AllSectionsPanel.SectionCell cell;
    private AdminPanel adminPanel;
    private boolean hasError = false;
    protected RequestSaveListener saveListener = new RequestSaveListener();

    public AdminSection(SubSection[] subSections, Icon largeIcon, String name) {
        this.subSections = subSections;
        this.largeIcon = largeIcon;
        this.name = name;
        this.initUI(subSections);
    }

    public AdminSection(SubSection subSection, Icon largeIcon) {
        this(new SubSection[]{subSection}, largeIcon, subSection.getTitle());
    }

    public void setAdminPanel(AdminPanel panel) {
        this.adminPanel = panel;
    }

    private void initUI(SubSection[] subSections) {
        Color lastBackground = LIGHT;
        boolean onlyOneSubsection = subSections.length == 1;
        boolean pad = true;
        for (int i = 0; i < subSections.length; ++i) {
            SubSection subSection = subSections[i];
            subSection.setSection(this);
            JLabel leftTitle = subSection.getLeftTitleLabel();
            leftTitle.setText(subSection.getTitle());
            leftTitle.setFont(SHStyle.mediumFont);
            JPanel titlePanel = new JPanel(new BorderLayout());
            titlePanel.add((Component)leftTitle, "West");
            JLabel rightTitle = subSection.getRightTitleLabel();
            rightTitle.setFont(SHStyle.mediumFont);
            titlePanel.add((Component)rightTitle, "East");
            if (subSection.getRightTitle() != null) {
                rightTitle.setText(subSection.getRightTitle());
            }
            titlePanel.setBorder(SHBorderFactory.createEmptyBorder(10, 10, 0, 10));
            ColorPropagatingPanel subSectionPanel = new ColorPropagatingPanel(new BorderLayout());
            if (!onlyOneSubsection) {
                subSectionPanel.add((Component)titlePanel, "North");
            }
            subSectionPanel.add((Component)subSection.getRootComponent(), "Center");
            lastBackground = i % 2 == 0 ? DARK : LIGHT;
            if (subSection.insertDefaultPadding()) {
                subSection.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder(10, 15, 10, 15));
            }
            subSection.overrideBorderForSubSection();
            if (i > 0) {
                subSectionPanel.setBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
            }
            ((JComponent)subSectionPanel).setBackground(lastBackground);
            this.rootComponent.add(subSectionPanel, 0, this.rootComponent.getComponentCount(), 1, 1, 1, 1, 10, 1);
            if (!pad || !subSection.grabAllVerticalSpace()) continue;
            pad = false;
        }
        if (pad) {
            PaddyPanel paddy = new PaddyPanel();
            paddy.setBackground(lastBackground);
            this.rootComponent.add(paddy, 0, this.rootComponent.getComponentCount(), 1, 1, 0, 1000, 10, 1);
        }
    }

    @Override
    public Icon getLargeIcon() {
        return this.largeIcon;
    }

    @Override
    public String getSectionName() {
        return this.name;
    }

    @Override
    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void setSectionCell(AllSectionsPanel.SectionCell cell) {
        this.cell = cell;
    }

    public void setTechClient(TechClient client) {
        Color lastBackground = DARK;
        for (SubSection subSection : this.subSections) {
            subSection.setTechClient(client);
        }
        int count = 0;
        for (int i = 0; i < this.rootComponent.getComponentCount(); ++i) {
            Component component = this.rootComponent.getComponent(i);
            if (component instanceof PaddyPanel) {
                component.setBackground(lastBackground);
                continue;
            }
            if (component.isVisible()) {
                lastBackground = count % 2 == 0 ? DARK : LIGHT;
                ++count;
                component.setBackground(lastBackground);
                continue;
            }
            if (!(component instanceof PaddyPanel)) continue;
        }
    }

    public void loadFrom(ServerConfig currentProperties) {
        for (SubSection subSection : this.subSections) {
            try {
                subSection.loadFrom(currentProperties);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            subSection.checkEnabled();
        }
    }

    public void saveTo(ServerConfig currentProperties) {
        for (SubSection subSection : this.subSections) {
            subSection.saveTo(currentProperties);
        }
    }

    public boolean forceSave() {
        for (SubSection subSection : this.subSections) {
            if (!subSection.forceSave()) continue;
            return true;
        }
        return false;
    }

    public void saveComplete(ServerConfig currentProperties) {
        for (SubSection subSection : this.subSections) {
            subSection.saveComplete(currentProperties);
        }
    }

    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public void setIsValidAndComplete(boolean isValid) {
        this.hasError = !isValid;
        this.cell.showError(isValid, Language.get("INCOMPLETE"));
        this.cell.updateCell();
        this.cell.repaint();
    }

    public void setLargeIcon(ImageIcon largeIcon) {
        this.largeIcon = largeIcon;
        this.cell.updateCell();
        this.cell.repaint();
    }

    @Override
    public Icon getErrorIcon() {
        return ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16");
    }

    public void setupSaveListeners() {
        this.setupSaveListeners(this.rootComponent);
        for (SubSection s : this.subSections) {
            if (s instanceof HiddenPanelContainer) {
                Component[] comps;
                for (Component c : comps = ((HiddenPanelContainer)((Object)s)).getHiddenComponents()) {
                    this.addSaveListenerTo(c);
                }
            }
            s.setRequestSaveListener(this.saveListener);
        }
    }

    private void addSaveListenerTo(Component c) {
        if (c instanceof JCheckBox) {
            ((JCheckBox)c).addActionListener(this.saveListener);
        } else if (c instanceof JComboBox) {
            ((JComboBox)c).addActionListener(this.saveListener);
        } else if (c instanceof AbstractButton) {
            ((AbstractButton)c).addActionListener(this.saveListener);
        } else if (c instanceof JTextComponent) {
            if (!(c instanceof IgnoreKeyListenerTextField)) {
                ((JTextComponent)c).addKeyListener(this.saveListener);
                ((JTextComponent)c).addFocusListener(this.saveListener);
            }
        } else if (c instanceof JSlider) {
            ((JSlider)c).addChangeListener(this.saveListener);
        } else if (c instanceof JTabbedPane) {
            this.setupSaveListeners((JComponent)((JTabbedPane)c).getComponentAt(0));
        } else if (c instanceof AbstractListUI) {
            ((AbstractListUI)c).addListChangeListener(this.saveListener);
        } else if (!(c instanceof JLabel || c instanceof JList || c.getClass().toString().contains("ArrowedProgressBar"))) {
            if (c instanceof JPanel) {
                this.setupSaveListeners((JComponent)c);
            } else if (c instanceof JScrollPane) {
                this.addSaveListenerTo(((JScrollPane)c).getViewport().getView());
            } else {
                System.out.println("UNKOWN TYPE " + c + " " + c.getParent());
            }
        }
    }

    public void setupSaveListeners(JComponent parent) {
        for (Component c : parent.getComponents()) {
            this.addSaveListenerTo(c);
        }
    }

    class PaddyPanel
    extends JPanel {
        PaddyPanel() {
        }
    }

    class JWAutomatablePanel
    extends ColorPropagatingPanel
    implements JWAutomatable {
        JWAutomatablePanel() {
        }

        @Override
        public boolean grabScreenShotsOfChildren() {
            return false;
        }

        @Override
        public Component[] getChildComponents() {
            return new Component[0];
        }
    }

    public class RequestSaveListener
    implements FocusListener,
    ActionListener,
    ChangeListener,
    AbstractListUI.ListChangeListner,
    KeyListener,
    LogMappingRepositoryUI.MappingsChangeListener {
        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void mappingsChanged() {
            AdminSection.this.adminPanel.requestASave("loggingui");
        }

        @Override
        public void focusLost(FocusEvent e) {
            AdminSection.this.adminPanel.requestASave("focus");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdminSection.this.adminPanel.requestASave("action");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AdminSection.this.adminPanel.requestASave("change");
        }

        @Override
        public void listChanged(AbstractListUI source) {
            AdminSection.this.adminPanel.requestASave("list");
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            AdminSection.this.adminPanel.requestASave("keyReleased");
        }

        public void detailsChanged() {
            AdminSection.this.adminPanel.requestASave("details");
        }

        public void filtersChanged() {
            AdminSection.this.adminPanel.requestASave("filters");
        }

        public void techChanged() {
            AdminSection.this.adminPanel.requestASave("tech");
        }

        public void requestImmediateSave() {
            AdminSection.this.adminPanel.requestASave("immediate", true);
        }

        public void techGroupChanged() {
            AdminSection.this.adminPanel.requestASave("techgroup");
        }
    }
}

