/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import utils.files.ZipUtils;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.animated.arrow.ArrowedProgressBar;
import utils.swing.customlaf.SHStyle;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanelWrapper;
import utils.switches.Switches;

public class AdminRestore
extends SubSection {
    public static AdminRestore INSTANCE = null;
    private JButton restoreButton;
    private JLabel restoreTitle;
    private JWrapLabel restoreDesc;
    private JLabel restoreIcon;
    private ArrowedProgressBar barR;
    private AdminPanel adminPanel;

    public AdminRestore(AdminPanel adminPanel) {
        this.adminPanel = adminPanel;
        INSTANCE = this;
    }

    void cancelUpload() {
        this.restoreButton.setEnabled(true);
        this.restoreDesc.setText("<html>" + Language.get("ADMIN_BACKUP_RESTORE_DESC"));
        this.barR.off();
    }

    @Override
    protected void initUI() {
        try {
            if (Switches.SH_allowRestoreFromBackup) {
                this.barR = new ArrowedProgressBar();
                GbPanelWrapper restoreWrapper = new GbPanelWrapper(this.rootComponent, new Insets(3, 3, 3, 3));
                this.restoreIcon = new JLabel(ImageLoader.getImageIcon("images/svg/files-folders/zip.svg,32"));
                this.restoreTitle = new JLabel(Language.get("ADMIN_BACKUP_RESTORE_TITLE"));
                this.restoreDesc = new JWrapLabel("<html>" + Language.get("ADMIN_BACKUP_RESTORE_DESC")){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension dim = super.getPreferredSize();
                        System.out.println(dim);
                        return dim;
                    }
                };
                this.restoreDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
                this.restoreButton = new JButton(Language.get("ADMIN_BACKUP_RESTORE_NOW"));
                this.barR.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
                int YY = 0;
                restoreWrapper.add(this.barR.getRootComponent(), 0, YY, 1, 3, 0, 0, 10, 0, new Insets(10, 10, 15, 10));
                restoreWrapper.add(this.restoreIcon, 1, YY, 1, 3, 0, 0, 17, 0, new Insets(10, 10, 15, 10));
                restoreWrapper.add(this.restoreTitle, 2, YY++, 2, 1, 1, 0, 17, 0, new Insets(10, 10, 0, 10));
                restoreWrapper.add(this.restoreDesc, 2, YY++, 2, 1, 1, 1, 17, 1, new Insets(5, 10, 0, 10));
                restoreWrapper.add(this.restoreButton, 2, YY++, 1, 1, 0, 0, 17, 0, new Insets(10, 10, 3, 10));
            }
        }
        finally {
            this.restoreButton.setEnabled(true);
            this.barR.off();
        }
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminRestore.this.restoreButton.setEnabled(false);
                AdminRestore.this.restoreDesc.setText("<html>" + Language.get("ADMIN_BACKUP_RESTORING"));
                AdminRestore.this.restoreDesc.getParent().repaint();
                FileDialog fd = new FileDialog((JFrame)SwingUtil.getRootPaneContainer(AdminRestore.this.rootComponent));
                fd.setDirectory(System.getProperty("user.home"));
                fd.setLocation(50, 50);
                fd.setVisible(true);
                if (fd.getFile() == null) {
                    AdminRestore.this.cancelUpload();
                    return;
                }
                File selectedFile = new File(new File(fd.getDirectory()), fd.getFile());
                if (!SHGlassOptionPane.showOkCancelDialog(SwingUtil.getRootPaneContainer(AdminRestore.this.rootComponent), Language.get("ADMIN_RESTORE_NOW_DESC", new Object[]{selectedFile.getName()}) + "\n\n" + Language.get("ADMIN_RESTORE_NOW_DESC2"), Language.get("ADMIN_RESTORE_NOW_TITLE"), ImageLoader.getImageIcon("images/svg/arrows/reboot.svg,48"), Language.get("RESTORE"))) {
                    AdminRestore.this.cancelUpload();
                    return;
                }
                if (!ZipUtils.isZipFile(selectedFile)) {
                    SHGlassOptionPane.showErrorDialog(SwingUtil.getRootPaneContainer(AdminRestore.this.rootComponent), Language.get("ADMIN_BACKUP_INVALID_FILE_DESC", new Object[]{selectedFile.getName()}), Language.get("ADMIN_BACKUP_INVALID_FILE_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CONTINUE"));
                    AdminRestore.this.cancelUpload();
                    return;
                }
                try {
                    AdminRestore.this.barR.on();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                new RestoreThread(selectedFile).start();
            }
        });
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_BACKUP_RESTORE_MAINTITLE");
    }

    @Override
    public void loadFrom(ServerConfig config) {
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    class RestoreThread
    extends Thread {
        File configzip;

        public RestoreThread(File configzip) {
            this.configzip = configzip;
        }

        @Override
        public void run() {
            try {
                AdminRestore.this.techClient.uploadBackupRestoreFileAndRestart(this.configzip);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            finally {
                AdminRestore.this.cancelUpload();
            }
        }
    }
}

