/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.multiserver;

import com.aem.shelp.tech.admin.multiserver.MultiServerEditPanel;
import com.aem.shelp.tech.admin.multiserver.ServerEditInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public abstract class MultiServerPanel<T extends ServerConfiguration>
implements ActionListener {
    private JPanel rootComponent = new JPanel(new GridLayout(1, 1));
    private JPanel configurationListParent = new JPanel(new BorderLayout());
    private GbPanel configurationList = new GbPanel();
    private GbPanel addNewConfigurationPanel = new GbPanel();
    private JButton newConfiguration = new JButton(ImageLoader.getImageIcon("images/svg/general/add.svg,16"));
    private JPanel editConfiguration = new JPanel(new GridLayout(1, 1));
    private ArrayList<T> configs = new ArrayList();

    public void switchToEditView() {
        this.rootComponent.removeAll();
        this.rootComponent.add(this.editConfiguration);
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    public void switchToMainView() {
        for (int i = 0; i < this.configurationList.getComponentCount(); ++i) {
            Component c = this.configurationList.getComponent(i);
            if (!(c instanceof ConfigurationPanel)) continue;
            ConfigurationPanel cp = (ConfigurationPanel)c;
            cp.label.setText(cp.config.getSummary());
        }
        this.rootComponent.removeAll();
        this.rootComponent.add(this.configurationListParent);
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
        this.requestSave();
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public abstract T newConfiguration();

    public abstract JPanel getEditPanel(T var1, ServerEditInterface var2);

    public abstract String getNewButtonText();

    public abstract void requestSave();

    public MultiServerPanel() {
        this.rootComponent.add(this.configurationListParent);
        this.configurationListParent.add((Component)this.configurationList, "North");
        this.configurationListParent.add((Component)this.addNewConfigurationPanel, "Center");
        this.newConfiguration.setText(this.getNewButtonText());
        this.newConfiguration.setFont(this.newConfiguration.getFont().deriveFont(SHStyle.SMALL_FONT_SIZE));
        this.addNewConfigurationPanel.add(this.newConfiguration, 0, 0, 1, 1, 1, 1, 11, 0);
        this.newConfiguration.addActionListener(this);
        this.editConfiguration.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.addNewConfigurationPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
    }

    public void loadAll(ArrayList<T> configs) {
        this.configs = configs;
        this.configurationList.removeAll();
        for (ServerConfiguration config : configs) {
            this.addUIForConfig(config);
        }
        this.configurationList.revalidate();
        this.configurationList.repaint();
    }

    private void addUIForConfig(T config) {
        ConfigurationPanel panel = new ConfigurationPanel(this, (ServerConfiguration)config, null);
        panel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.configurationList.add(panel, 0, this.configurationList.getComponentCount(), 1, 1, 1, 0, 10, 2);
    }

    private void newConfig() {
        T config = this.newConfiguration();
        this.configs.add(config);
        this.addUIForConfig(config);
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
        this.editConfig(config);
    }

    private void removeConfig(T config) {
        this.configs.remove(config);
        for (int i = 0; i < this.configurationList.getComponentCount(); ++i) {
            Component c = this.configurationList.getComponent(i);
            if (!(c instanceof ConfigurationPanel) || ((ConfigurationPanel)c).config != config) continue;
            this.configurationList.remove(c);
            this.configurationList.revalidate();
            this.configurationList.repaint();
            break;
        }
        this.requestSave();
    }

    private void editConfig(T config) {
        MultiServerEditPanel<T> editPanelWrapper = new MultiServerEditPanel<T>(this, config);
        this.editConfiguration.removeAll();
        this.editConfiguration.add(editPanelWrapper.getRootComponent());
        this.editConfiguration.revalidate();
        this.switchToEditView();
    }

    public ArrayList<T> getConfigs() {
        return this.configs;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.newConfig();
    }

    private static class ConfigurationPanel<T extends ServerConfiguration>
    extends JPanel
    implements ActionListener {
        private final T config;
        private final MultiServerPanel parent;
        private JButton editButton;
        private JButton removeButton;
        private JLabel label;

        private ConfigurationPanel(MultiServerPanel parent, T config) {
            this.config = config;
            this.parent = parent;
            this.initUI();
        }

        private void initUI() {
            this.label = new JLabel(this.config.getSummary());
            this.editButton = new JButton(ImageLoader.getImageIcon("images/svg/general/pencil.svg,16"));
            this.removeButton = new JButton(ImageLoader.getImageIcon("images/svg/general/remove.svg,16"));
            this.editButton.addActionListener(this);
            this.removeButton.addActionListener(this);
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(this.editButton, this.removeButton);
            JPanel buttonsPanel = new JPanel(new GridLayout(1, 2));
            buttonsPanel.add(this.editButton);
            buttonsPanel.add(this.removeButton);
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "Center");
            this.add((Component)buttonsPanel, "East");
            this.setBorder(SHBorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.removeButton) {
                this.parent.removeConfig(this.config);
            } else {
                this.parent.editConfig(this.config);
            }
        }

        /* synthetic */ ConfigurationPanel(MultiServerPanel x0, ServerConfiguration x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static interface ServerConfiguration {
        public String getSummary();
    }
}

