/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.enterprise;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.adminclient.AdminClient;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.enterprise.PeerConfig;
import com.aem.shelp.tech.admin.enterprise.PeerConfigUI;
import com.aem.shelp.tech.utils.StrippedContentPanel;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import utils.progtools.net.URLParser;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.icons.CircularProgressLabel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.CardPanel;
import utils.swing.layout.GbPanel;

public class PeerServerList
implements ActionListener {
    private TechClient client;
    private CardPanel overlay;
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private JPanel titleBar = new JPanel(new BorderLayout(5, 5));
    private JButton connectToPeerButton = new JButton(Language.get("PEER_NEW"), ImageLoader.getImageIcon("images/svg/general/add.svg,16"));
    private GbPanel serverListPanel = new GbPanel();
    private StrippedContentPanel serverListContentPanel = new StrippedContentPanel(this.serverListPanel);
    private ArrayList<PeerConfig> currentPeerConfigs = new ArrayList();
    private JLabel titleLabel = new JLabel(Language.get("PEER_TITLE"));
    private JLabel desc = new JLabel(Language.get("PEER_DESC"));
    private JScrollPane scroller;

    public PeerServerList(CardPanel panel) {
        this.overlay = panel;
        this.initUI();
    }

    public void setTechClient(TechClient client) {
        this.client = client;
    }

    private void initUI() {
        this.rootComponent.add((Component)this.titleBar, "North");
        GbPanel mainContent = new GbPanel();
        JPanel footer = new JPanel();
        mainContent.add(this.serverListPanel, 0, 0, 1, 1, 1, 0, 10, 1);
        mainContent.add(footer, 0, 3, 1, 1, 1, 1, 10, 1);
        this.rootComponent.add((Component)mainContent, "Center");
        this.titleLabel.setFont(SHStyle.largeFont);
        this.connectToPeerButton.addActionListener(this);
        this.scroller = new JScrollPane(this.rootComponent){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.scroller.setBorder(SHBorderFactory.createEmptyBorder());
    }

    private void setHasContents(final boolean hasContents) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PeerServerList.this.titleBar.removeAll();
                JPanel buttons = new JPanel(new FlowLayout());
                buttons.add(PeerServerList.this.connectToPeerButton);
                if (!hasContents) {
                    PeerServerList.this.titleBar.setBorder(SHBorderFactory.createEmptyBorder(10, 5, 0, 0));
                    PeerServerList.this.titleBar.add((Component)PeerServerList.this.titleLabel, "North");
                    PeerServerList.this.titleBar.add((Component)PeerServerList.this.desc, "Center");
                    PeerServerList.this.titleBar.add((Component)buttons, "South");
                } else {
                    PeerServerList.this.titleBar.setBorder(SHBorderFactory.createEmptyBorder(5, 5, 5, 0));
                    PeerServerList.this.titleBar.add((Component)PeerServerList.this.titleLabel, "Center");
                    PeerServerList.this.titleBar.add((Component)buttons, "East");
                }
                PeerServerList.this.titleBar.revalidate();
                PeerServerList.this.titleBar.repaint();
            }
        });
    }

    public void initWith(ArrayList<PeerConfig> peerConfigs) {
        this.setHasContents(peerConfigs.size() > 0);
        this.currentPeerConfigs = peerConfigs;
        this.serverListPanel.removeAll();
        for (PeerConfig config : peerConfigs) {
            PeerConfigUI ui = new PeerConfigUI(config, this);
            this.serverListContentPanel.addContent(ui.getRootComponent(), null);
        }
        this.serverListContentPanel.addVerticalFiller();
        this.serverListContentPanel.setBackgroundColours(true);
        this.serverListPanel.revalidate();
        this.serverListPanel.repaint();
    }

    public void deletePeerConfig(PeerConfig peerConfig) {
        try {
            this.client.deletePeerConfig(peerConfig);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        this.currentPeerConfigs.remove(peerConfig);
        this.initWith(this.currentPeerConfigs);
    }

    public void addPeerConfig(PeerConfig peerConfig) {
        if (!this.currentPeerConfigs.contains(peerConfig)) {
            this.currentPeerConfigs.add(peerConfig);
            this.initWith(this.currentPeerConfigs);
        }
    }

    public JComponent getRootComponent() {
        return this.scroller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.connectToPeerButton) {
            AdminLogin configurator = new AdminLogin();
            this.overlay.showTemporaryCard(configurator);
        }
    }

    public void reloadPeers() {
        new Thread(){

            @Override
            public void run() {
                try {
                    final ArrayList<PeerConfig> configs = PeerServerList.this.client.getPeerConfigs();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PeerServerList.this.initWith(configs);
                        }
                    });
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }.start();
    }

    public ArrayList<PeerConfig> getCurrentPeerConfigs() {
        return this.currentPeerConfigs;
    }

    public void save(final PeerConfig configThatRequestedSave) {
        new Thread(){

            @Override
            public void run() {
                try {
                    PeerServerList.this.client.savePeerConfig(configThatRequestedSave, true);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }.start();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        PeerServerList serverList = new PeerServerList(null);
        frame.getContentPane().add(serverList.getRootComponent());
        ArrayList<PeerConfig> specs = new ArrayList<PeerConfig>();
        specs.add(PeerConfig.createTestConfig());
        specs.add(PeerConfig.createTestConfig());
        specs.add(PeerConfig.createTestConfig());
        serverList.initWith(specs);
        frame.setVisible(true);
    }

    class AdminLogin
    extends GbPanel
    implements Runnable,
    KeyListener {
        JLabel error;
        JButton cont;
        JTextField host;
        JFixedWidthPasswordField pword;
        CircularProgressLabel progress;
        AdminClient peerAdmin;

        public AdminLogin() {
            super(new Insets(3, 3, 3, 3));
            this.host = new JTextField(20);
            this.pword = new JFixedWidthPasswordField(20);
            this.init();
        }

        void init() {
            int Y = 0;
            this.add(new JPanel(), 0, Y++, 1, 1, 1000, 1000, 10, 1);
            this.error = new JLabel();
            this.error.setForeground(new Color(100, 0, 0));
            this.add(this.error, 1, Y++, 8, 1, 1, 1, 17, 2);
            this.add(new JLabel(Language.get("PEER_HOSTNAME")), 1, Y, 1, 1, 1, 1, 13, 0);
            this.add(this.host, 2, Y++, 8, 1, 1, 1, 17, 2);
            this.add(new JLabel(Language.get("PEER_ADMIN_PWORD")), 1, Y, 1, 1, 1, 1, 13, 0);
            this.add(this.pword, 2, Y++, 8, 1, 1, 1, 17, 2);
            JButton cancel = new JButton(Language.get("CANCEL"));
            this.cont = new JButton(Language.get("CONTINUE"));
            SHButtonUI.makeButtonBlue(this.cont);
            this.progress = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_24);
            this.progress.getCircular().switchOff();
            this.add(new JPanel(), 3, Y, 1, 1, 100, 1, 10, 2);
            this.add(this.progress, 4, Y, 1, 1, 1, 1, 17, 0);
            this.add(cancel, 5, Y, 1, 1, 1, 1, 17, 0);
            this.add(this.cont, 6, Y++, 1, 1, 1, 1, 17, 0);
            this.add(new JPanel(), 11, Y, 1, 1, 1000, 1000, 10, 1);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdminLogin.this.closeAndBack();
                }
            });
            this.cont.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdminLogin.this.doSetup();
                }
            });
            this.host.addKeyListener(this);
            this.pword.addKeyListener(this);
        }

        private void doSetup() {
            this.progress.getCircular().switchOn();
            this.host.setEnabled(false);
            this.pword.setEnabled(false);
            this.cont.setEnabled(false);
            new Thread(this).start();
        }

        public void closeAndContinue() {
            PeerServerList.this.overlay.showCard(0);
        }

        public void closeAndBack() {
            PeerServerList.this.overlay.showCard(0);
        }

        @Override
        public void run() {
            String url = this.host.getText();
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            URLParser parser = new URLParser(url);
            TechCredentials creds = new TechCredentials(OemBranding.OEM_ADMIN_USERNAME, this.pword.getText(), null);
            boolean connected = false;
            String errormsg = "";
            try {
                String hostname = parser.getHostname();
                int port = parser.getPort(true);
                this.peerAdmin = new AdminClient(hostname, port, creds.getPassword());
                connected = true;
                String authToken = PeerConfig.createAuthToken();
                PeerConfig myConfig = PeerConfig.createNewConfig(this.peerAdmin.getServerPeerName(), hostname + ":" + port, this.peerAdmin.getPubkeyHashFromConnect(), authToken);
                PeerConfig peerConfig = PeerConfig.createNewConfig(PeerServerList.this.client.getServerPeerName(), PeerServerList.this.client.getHost() + ":" + PeerServerList.this.client.getPort(), PeerServerList.this.client.getPubKeyHashFromConnect(), authToken);
                System.out.println("[PeerServerList] Config to send to peer is " + peerConfig);
                System.out.println("[PeerServerList] Config to send to my server is " + myConfig);
                this.peerAdmin.setUpPeer(peerConfig);
                PeerServerList.this.client.savePeerConfig(myConfig, false);
                this.peerAdmin.reloadPeers();
                PeerServerList.this.client.savePeerConfig(myConfig, true);
                PeerServerList.this.addPeerConfig(myConfig);
            }
            catch (Exception x) {
                x.printStackTrace();
                errormsg = x.getMessage();
            }
            try {
                this.peerAdmin.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.peerAdmin == null) {
                if (!connected) {
                    this.error.setText(Language.get("PEER_CONNECT_ERROR") + " (" + errormsg + ")");
                } else {
                    this.peerAdmin.shutdown();
                    this.error.setText(Language.get("PEER_SETUP_ERROR") + " (" + errormsg + ")");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AdminLogin.this.progress.getCircular().switchOff();
                        AdminLogin.this.host.setEnabled(true);
                        AdminLogin.this.pword.setEnabled(true);
                        AdminLogin.this.cont.setEnabled(true);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AdminLogin.this.closeAndContinue();
                    }
                });
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.doSetup();
            }
        }
    }
}

