/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.enterprise;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.adminclient.AdminClient;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.enterprise.PeerConfig;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import utils.progtools.net.URLParser;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.components.JMultiLineLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.icons.CircularProgressLabel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.CardPanel;
import utils.swing.layout.GbPanel;

public class ClusteringPanel
implements ActionListener {
    private TechClient client;
    private CardPanel overlay;
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private JPanel titleBar = new JPanel(new BorderLayout(5, 5));
    private JButton connectToPeerButton = new JButton(Language.get("CLUSTER_NEW"), ImageLoader.getImageIcon("images/svg/general/add.svg,16"));
    private JLabel titleLabel = new JLabel(Language.get("CLUSTER_TITLE"));
    private JLabel desc = new JLabel(Language.get("CLUSTER_DESC"));
    private JScrollPane scroller;

    public ClusteringPanel(CardPanel panel) {
        this.overlay = panel;
        this.initUI();
    }

    public void setTechClient(TechClient client) {
        this.client = client;
    }

    private void initUI() {
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(this.connectToPeerButton);
        this.titleBar.setBorder(SHBorderFactory.createEmptyBorder(5, 5, 5, 0));
        this.titleBar.add((Component)this.titleLabel, "Center");
        this.titleBar.add((Component)buttons, "East");
        this.rootComponent.add((Component)this.titleBar, "North");
        GbPanel mainContent = new GbPanel();
        JPanel footer = new JPanel();
        mainContent.add(footer, 0, 3, 1, 1, 1, 1, 10, 1);
        this.rootComponent.add((Component)mainContent, "Center");
        this.titleLabel.setFont(SHStyle.largeFont);
        this.connectToPeerButton.addActionListener(this);
        this.scroller = new JScrollPane(this.rootComponent){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.scroller.setBorder(SHBorderFactory.createEmptyBorder());
    }

    public JComponent getRootComponent() {
        return this.scroller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.connectToPeerButton) {
            AdminLogin configurator = new AdminLogin();
            this.overlay.showTemporaryCard(configurator);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        ClusteringPanel serverList = new ClusteringPanel(null);
        frame.getContentPane().add(serverList.getRootComponent());
        ArrayList<PeerConfig> specs = new ArrayList<PeerConfig>();
        specs.add(PeerConfig.createTestConfig());
        specs.add(PeerConfig.createTestConfig());
        specs.add(PeerConfig.createTestConfig());
        frame.setVisible(true);
    }

    class AdminLogin
    extends GbPanel
    implements Runnable,
    KeyListener {
        JLabel error;
        JButton cont;
        JTextField host;
        JFixedWidthPasswordField pword;
        CircularProgressLabel progress;
        AdminClient peerAdmin;
        String successUrl;

        public AdminLogin() {
            super(new Insets(3, 3, 3, 3));
            this.host = new JTextField(20);
            this.pword = new JFixedWidthPasswordField(20);
            this.successUrl = "";
            this.init();
        }

        void init() {
            int Y = 0;
            this.add(new JPanel(), 0, Y++, 1, 1, 1000, 750, 10, 1);
            JMultiLineLabel label = new JMultiLineLabel("", 0);
            label.addPara(Language.get("CLUSTERING_EXPLANATION_1"));
            label.addPara(Language.get("CLUSTERING_EXPLANATION_2"));
            label.addPara(Language.get("CLUSTERING_EXPLANATION_3"));
            this.add(label, 0, Y++, 20, 1, 1000, 1, 10, 2);
            this.add(new JPanel(), 0, Y++, 1, 1, 1000, 250, 10, 1);
            this.error = new JLabel();
            this.error.setForeground(new Color(100, 0, 0));
            this.add(this.error, 1, Y++, 8, 1, 1, 1, 17, 2);
            this.add(new JLabel(Language.get("CENTRAL_HOSTNAME")), 1, Y, 1, 1, 1, 1, 13, 0);
            this.add(this.host, 2, Y++, 8, 1, 1, 1, 17, 2);
            this.add(new JLabel(Language.get("CENTRAL_ADMIN_PWORD")), 1, Y, 1, 1, 1, 1, 13, 0);
            this.add(this.pword, 2, Y++, 8, 1, 1, 1, 17, 2);
            JButton cancel = new JButton(Language.get("CANCEL"));
            this.cont = new JButton(Language.get("CONTINUE"));
            SHButtonUI.makeButtonBlue(this.cont);
            this.progress = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_24);
            this.progress.getCircular().switchOff();
            this.add(new JPanel(), 3, Y, 1, 1, 100, 1, 10, 2);
            this.add(this.progress, 4, Y, 1, 1, 1, 1, 17, 0);
            this.add(cancel, 5, Y, 1, 1, 1, 1, 17, 0);
            this.add(this.cont, 6, Y++, 1, 1, 1, 1, 17, 0);
            this.add(new JPanel(), 11, Y, 1, 1, 1000, 1000, 10, 1);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdminLogin.this.closeAndBack();
                }
            });
            this.cont.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdminLogin.this.doSetup();
                }
            });
            this.host.addKeyListener(this);
            this.pword.addKeyListener(this);
        }

        private void doSetup() {
            this.progress.getCircular().switchOn();
            this.host.setEnabled(false);
            this.pword.setEnabled(false);
            this.cont.setEnabled(false);
            new Thread(this).start();
        }

        public void closeAndContinue() {
            JMultiLineLabel label = new JMultiLineLabel("", 0);
            label.setHorizontalAlignment(0);
            label.addPara(Language.get("CLUSTERING_DONE_1", new Object[]{this.successUrl}));
            label.addPara(Language.get("CLUSTERING_DONE_2"));
            ClusteringPanel.this.overlay.showTemporaryCard(label);
        }

        public void closeAndBack() {
            ClusteringPanel.this.overlay.showCard(0);
        }

        @Override
        public void run() {
            String url = this.host.getText();
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            URLParser parser = new URLParser(url);
            TechCredentials creds = new TechCredentials(OemBranding.OEM_ADMIN_USERNAME, this.pword.getText(), null);
            boolean connected = false;
            String errormsg = "";
            try {
                String hostname = parser.getHostname();
                int port = parser.getPort(true);
                this.peerAdmin = new AdminClient(hostname, port, creds.getPassword());
                connected = true;
                byte[] serverkeys = this.peerAdmin.getServerKeysDat();
                ClusteringPanel.this.client.convertToAuxiliaryServer(hostname, port, creds.getPassword(), serverkeys);
                this.successUrl = url;
            }
            catch (Exception x) {
                x.printStackTrace();
                errormsg = x.getMessage();
            }
            try {
                this.peerAdmin.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.peerAdmin == null) {
                if (!connected) {
                    this.error.setText(Language.get("CENTRAL_CONNECT_ERROR") + " (" + errormsg + ")");
                } else {
                    this.peerAdmin.shutdown();
                    this.error.setText(Language.get("CENTRAL_SETUP_ERROR") + " (" + errormsg + ")");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AdminLogin.this.progress.getCircular().switchOff();
                        AdminLogin.this.host.setEnabled(true);
                        AdminLogin.this.pword.setEnabled(true);
                        AdminLogin.this.cont.setEnabled(true);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AdminLogin.this.closeAndContinue();
                    }
                });
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.doSetup();
            }
        }
    }
}

