/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TwoTierKey;
import com.aem.shelp.tech.admin.KeyRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.filter.FilterWrapper;

public abstract class TwoTierKeysDialog
extends OKCancelDialogPanel
implements ListSelectionListener {
    private SimpleList<TwoTierKey> keyList;
    private FilterWrapper<TwoTierKey> filteredWrapper;
    private SimpleTableModel tableModel = null;
    private SHJTable keyTable;
    private KeyRenderer keyRenderer;
    private JButton deleteButton = this.addLeftButton(Language.get("REMOVE_KEY"), false, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TwoTierKeysDialog.this.keyTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            TwoTierKey twoTierKey = (TwoTierKey)TwoTierKeysDialog.this.filteredWrapper.get(row);
            TwoTierKeysDialog.this.delete(twoTierKey);
            TwoTierKeysDialog.this.filteredWrapper.remove(row);
        }
    });

    private TwoTierKeysDialog() {
        super(Language.get("CLOSE"));
        JPanel contentPanel = this.getContentPanel();
        FixedWidthPanel panel = new FixedWidthPanel(contentPanel);
        this.setContent(panel);
        SHButtonUI.makeButtonRed(this.deleteButton);
        this.deleteButton.setEnabled(false);
    }

    protected abstract void delete(TwoTierKey var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDialog(RootPaneContainer rpc, TwoTierKey[] keys, final TechClient client) {
        TwoTierKeysDialog dialog = new TwoTierKeysDialog(){

            @Override
            protected void delete(TwoTierKey twoTierKey) {
                try {
                    if (client != null) {
                        client.removeTwoTierKey(twoTierKey.techID, twoTierKey.hostname);
                    } else {
                        System.out.println("[TwoTierKeysDialog] Deleting key " + twoTierKey);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        dialog.keyList.startBatch();
        try {
            if (client != null) {
                Collections.addAll(dialog.keyList, keys);
            } else {
                for (int i = 0; i < 100; ++i) {
                    dialog.keyList.add(TwoTierKey.getTestKey());
                }
            }
        }
        finally {
            dialog.keyList.endBatch();
        }
        AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rpc, 500, (AbstractDialogPanel)dialog);
        abstractGlassDialog.setTitle(Language.get("TWO_TIER_AUTHENTICATION_KEYS"));
        abstractGlassDialog.showDialog();
    }

    private JPanel getContentPanel() {
        this.keyList = new SimpleList();
        this.filteredWrapper = new FilterWrapper<TwoTierKey>(this.keyList);
        TableStructure ts = TableStructure.createTableStructure(TwoTierKey.class, new String[]{"", ""}, new String[]{Language.get("TECHNICIAN"), Language.get("HOSTNAME")});
        this.tableModel = new SimpleTableModel(this.filteredWrapper, ts);
        this.keyTable = new SHJTable(this.tableModel);
        this.keyTable.setRowHeight(SimpleHelpLookAndFeel.scale(26));
        this.keyTable.getSelectionModel().addListSelectionListener(this);
        this.keyRenderer = new KeyRenderer();
        this.keyTable.setDefaultRenderer(Object.class, this.keyRenderer);
        ts.initTableDimensions(this.keyTable);
        JScrollPane tableScroller = new JScrollPane(this.keyTable);
        JPanel parentPanel = new JPanel();
        parentPanel.setLayout(new BorderLayout());
        parentPanel.add((Component)tableScroller, "Center");
        return parentPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.deleteButton.setEnabled(this.keyTable.getSelectedRow() != -1);
        this.deleteButton.repaint();
    }
}

