/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TwoTierKey;
import com.aem.shelp.tech.admin.TwoTierKeysDialog;
import com.aem.shelp.util.security.SecurityUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapCheckBox;
import utils.swing.components.SHComboBox;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.layout.GbPanel;

public abstract class MultiTierConfigPanel
implements ActionListener {
    private static final String[] EMAIL_VARIABLES = new String[]{"code", "technician", "email", "username"};
    private GbPanel rootComponent = new GbPanel(){

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            if (MultiTierConfigPanel.this.appCheckBox != null) {
                MultiTierConfigPanel.this.appCheckBox.setBackground(c);
            }
            if (MultiTierConfigPanel.this.emailCheckBox != null) {
                MultiTierConfigPanel.this.emailCheckBox.setBackground(c);
            }
            if (MultiTierConfigPanel.this.rememberBox != null) {
                MultiTierConfigPanel.this.rememberBox.setBackground(c);
            }
            if (MultiTierConfigPanel.this.emailWarning != null) {
                MultiTierConfigPanel.this.emailWarning.setBackground(c);
            }
        }
    };
    private JWrapCheckBox emailCheckBox = new JWrapCheckBox("<html>" + Language.get("TWO_TIER_DESCRIPTION") + "</html>");
    private GbPanel emailWarning;
    private JButton configureEmailServerButton;
    private JButton configureEmailButton;
    private boolean emailServerConfigured;
    private EmailDialogPanel emailConfigPanel;
    private JWrapCheckBox appCheckBox = new JWrapCheckBox("<html>" + Language.get("APP_AUTHENTICATION_DESC") + "</html>");
    private JButton configureAppNow = new JButton(Language.get("CONFIGURE_APP"));
    public JCheckBox rememberBox;
    private boolean twoTierRememberMachine;
    private JButton manageKeysButton;
    private ActionListener twoTierActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MultiTierConfigPanel.this.rememberBox) {
                MultiTierConfigPanel.this.saveSettings();
            } else if (e.getSource() == MultiTierConfigPanel.this.manageKeysButton) {
                MultiTierConfigPanel.this.manageKeysButton.setEnabled(false);
                MultiTierConfigPanel.this.manageKeysButton.repaint();
                new FetchKeysThread().start();
            }
        }
    };
    private TechClient client;

    public abstract void saveSettings();

    public void setRememberMachine(boolean rememberMachine) {
        this.twoTierRememberMachine = rememberMachine;
        this.rememberBox.setSelected(this.twoTierRememberMachine);
    }

    public boolean getUseAppAuthentication() {
        return this.appCheckBox.isSelected();
    }

    public void setUseAppAuthentication(boolean use) {
        this.appCheckBox.setSelected(use);
        this.updateVisible();
    }

    public boolean getUseEmailAuthentication() {
        return this.emailCheckBox.isSelected();
    }

    public void setUseEmailAuthentication(boolean use) {
        this.emailCheckBox.setSelected(use);
        this.updateVisible();
    }

    public void setEmailServerConfigured(boolean emailServerConfigured) {
        this.emailServerConfigured = emailServerConfigured;
        this.updateVisible();
    }

    public int getEmailCodeLength() {
        return this.emailConfigPanel.getCodeLength();
    }

    public String getEmailSubject() {
        return this.emailConfigPanel.subjectField.getText();
    }

    public String getEmailBody() {
        return this.emailConfigPanel.bodyArea.getText();
    }

    public String getEmailAddress() {
        return this.emailConfigPanel.emailField.getText();
    }

    public MultiTierConfigPanel(String defaultSubject, String defaultContent, boolean collectEmailAddress) {
        this.initUI();
        this.emailConfigPanel.setDefaultEmailSettings(defaultSubject, defaultContent, collectEmailAddress);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.appCheckBox.getCheckBoxComponent() || e.getSource() == this.emailCheckBox.getCheckBoxComponent()) {
            this.updateVisible();
            this.saveSettings();
        } else if (e.getSource() == this.configureAppNow) {
            this.launchAppBasedConfiguration();
        } else if (e.getSource() == this.configureEmailButton) {
            PanelGlassDialog dialog = new PanelGlassDialog(SwingUtil.getRootPaneContainer(this.rootComponent), Language.get("CONFIGURE_EMAIL"), 600, Language.get("CLOSE"), null);
            dialog.setContentPanel(this.emailConfigPanel.rootComponent);
            dialog.showDialog();
            this.saveSettings();
        } else if (e.getSource() == this.configureEmailServerButton) {
            this.switchToEmailServerConfig();
        }
    }

    private void initUI() {
        int Y = 0;
        int width = 3;
        if (this.isAdmin()) {
            width = 2;
        }
        this.rootComponent.add(this.appCheckBox.getRootComponent(), 0, Y, width, 1, 0, 0, 17, 2, new Insets(0, 0, 0, 0));
        if (this.isAdmin()) {
            this.rootComponent.add(this.configureAppNow, width, Y++, 1, 1, 0, 0, 13, 0, new Insets(0, 0, 0, 0));
            this.configureAppNow.addActionListener(this);
            this.configureAppNow.setEnabled(false);
        } else {
            ++Y;
        }
        this.appCheckBox.addActionListener(this);
        this.configureEmailServerButton = new JButton(Language.get("CONFIGURE_EMAIL_SERVER"));
        this.configureEmailServerButton.addActionListener(this);
        this.configureEmailButton = new JButton(Language.get("CONFIGURE_EMAIL"));
        this.configureEmailButton.addActionListener(this);
        this.emailWarning = new GbPanel();
        this.emailWarning.add(new JLabel(Language.get("EMAIL_WARNING")), 0, 0, 1, 1, 1, 1, 17, 2, new Insets(5, 5, 5, 5));
        this.emailWarning.add(this.configureEmailServerButton, 1, 0, 1, 1, 0, 1, 17, 2, new Insets(5, 5, 5, 0));
        this.emailCheckBox.addActionListener(this);
        this.rootComponent.add(this.emailCheckBox.getRootComponent(), 0, Y, 2, 1, 1, 0, 17, 2, new Insets(5, 0, 0, 0));
        this.rootComponent.add(this.configureEmailButton, 2, Y++, 1, 1, 0, 0, 13, 0, new Insets(0, 0, 0, 0));
        this.rootComponent.add(this.emailWarning, 0, Y++, 3, 1, 0, 0, 17, 2, new Insets(0, 0, 0, 0));
        this.emailConfigPanel = new EmailDialogPanel(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiTierConfigPanel.this.saveSettings();
            }
        }, EMAIL_VARIABLES, this.isAdmin());
        this.manageKeysButton = new JButton(Language.get("MANAGE_KEY"));
        this.manageKeysButton.addActionListener(this.twoTierActionListener);
        this.rememberBox = new JCheckBox(Language.get("ADMIN_TWO_TIER_REMEMBER_MACHINE"));
        this.rememberBox.addActionListener(this.twoTierActionListener);
        this.rootComponent.add(this.rememberBox, 0, Y, 2, 1, 1, 0, 17, 2, new Insets(10, 0, 0, 0));
        this.rootComponent.add(this.manageKeysButton, 2, Y++, 1, 1, 0, 0, 13, 0, new Insets(10, 0, 0, 0));
        SwingUtil.setSizesToWidest(new JComponent[]{this.manageKeysButton, this.configureEmailButton, this.configureEmailServerButton, this.configureAppNow});
        this.updateVisible();
    }

    private void updateVisible() {
        this.rememberBox.setEnabled(this.emailCheckBox.isSelected() || this.appCheckBox.isSelected());
        this.manageKeysButton.setEnabled(this.emailCheckBox.isSelected() || this.appCheckBox.isSelected());
        this.configureAppNow.setEnabled(this.appCheckBox.isSelected());
        this.configureEmailButton.setVisible(this.emailServerConfigured);
        this.emailWarning.setVisible(!this.emailServerConfigured);
        this.configureEmailButton.setEnabled(this.emailCheckBox.isSelected());
        this.configureEmailServerButton.setEnabled(this.emailCheckBox.isSelected());
    }

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public void setTwoTierSettings(int codeLength, String subject, String body) {
        this.setTwoTierSettings(codeLength, subject, body, null);
        this.rememberBox.setSelected(this.twoTierRememberMachine);
        this.rememberBox.repaint();
    }

    public void setTwoTierSettings(int codeLength, String subject, String body, String adminEmail) {
        this.emailConfigPanel.setTwoTierSettings(codeLength, subject, body, adminEmail);
    }

    public void setEnabled(boolean selected) {
        this.emailConfigPanel.setEnabled(selected);
        this.rootComponent.setEnabled(selected);
        this.rememberBox.setEnabled(selected);
        this.rootComponent.repaint();
    }

    public void setBackground(Color c) {
        this.rootComponent.setBackground(c);
    }

    public void setEmailAuthenticationEmailDefaults(String twoTierSubject, String twoTierBody) {
        this.emailConfigPanel.setEmailAuthenticationEmailDefaults(twoTierSubject, twoTierBody);
        this.rememberBox.setSelected(false);
    }

    public void setTechClient(TechClient techClient) {
        this.client = techClient;
    }

    public abstract void switchToEmailServerConfig();

    public abstract boolean isAdmin();

    public abstract void launchAppBasedConfiguration();

    private static class EmailDialogPanel
    implements ChangeListener,
    ActionListener,
    FocusListener {
        private final ActionListener changeListener;
        public GbPanel rootComponent = new GbPanel();
        private String exampleCode;
        private JLabel exampleLabel;
        public JTextField subjectField;
        public JTextArea bodyArea;
        private JSlider codeLengthSlider;
        public int twoTierCodeLength = 6;
        private String twoTierSubject;
        private String twoTierBody;
        private String defaultContent;
        private String defaultSubject;
        private JComboBox variablesBox = new SHComboBox();
        private JButton insertButton = new JButton();
        private JLabel emailLabel;
        public JTextField emailField;
        private String twoTierEmail;
        boolean contentWasLastFocused = true;

        public EmailDialogPanel(ActionListener changeListener, String[] variables, boolean isAdmin) {
            this.changeListener = changeListener;
            this.initUI(variables, isAdmin);
        }

        public void initUI(String[] variables, boolean isAdmin) {
            this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.exampleCode = SecurityUtil.generateNonAmbiguousCode(20);
            JLabel codeLengthLabel = new JLabel(Language.get("TWO_TIER_CODE_LENGTH"));
            JLabel subjectLabel = new JLabel(Language.get("EMAIL_SUBJECT"));
            this.subjectField = new JTextField();
            SwingUtil.setWidth(this.subjectField, 300);
            this.emailLabel = new JLabel(Language.get("ADMIN_EMAIL"));
            this.emailField = new JTextField();
            SwingUtil.setWidth(this.emailField, 300);
            JLabel bodyLabel = new JLabel(Language.get("EMAIL_BODY"));
            this.bodyArea = new JTextArea();
            this.bodyArea.setBackground(this.subjectField.getBackground());
            this.bodyArea.setFont(this.subjectField.getFont());
            JScrollPane pane = new JScrollPane(this.bodyArea);
            SwingUtil.setHeight(pane, SimpleHelpLookAndFeel.scale(150));
            KeyAdapter saveKeyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EmailDialogPanel.this.changeListener.actionPerformed(null);
                }
            };
            this.subjectField.addKeyListener(saveKeyListener);
            this.bodyArea.addKeyListener(saveKeyListener);
            this.emailField.addKeyListener(saveKeyListener);
            this.exampleLabel = new JLabel(Language.get("EXAMPLE") + ": " + this.exampleCode.substring(0, this.twoTierCodeLength));
            this.exampleLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            this.exampleLabel.setFont(SHStyle.smallerFont);
            this.codeLengthSlider = new JSlider(0, 6, 20, 8);
            this.codeLengthSlider.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
            Font currentFont = this.codeLengthSlider.getFont();
            if (currentFont != null) {
                try {
                    Method m = JSlider.class.getMethod("setFont", Font.class);
                    m.invoke((Object)this.codeLengthSlider, currentFont.deriveFont(currentFont.getSize2D() - 2.0f));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.codeLengthSlider.addChangeListener(this);
            this.codeLengthSlider.setMajorTickSpacing(2);
            this.codeLengthSlider.setPaintTicks(false);
            this.codeLengthSlider.setPaintLabels(true);
            SwingUtil.setWidth(this.codeLengthSlider, 150);
            JLabel variablesLabel = new JLabel(Language.get("SUBSTITUTIONS"));
            this.insertButton = new JButton(Language.get("TARGET_UI_EMAIL_INSERT"));
            this.insertButton.addActionListener(this);
            this.variablesBox.setModel(new DefaultComboBoxModel<String>(variables));
            this.insertButton.setEnabled(false);
            this.variablesBox.setEnabled(false);
            ColorPropagatingGBPanel variablesPanel = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
            variablesPanel.add(variablesLabel, 0, 0, 1, 1, 1, 1, 13, 0);
            variablesPanel.add(this.variablesBox, 1, 0, 1, 1, 1, 1, 17, 0);
            variablesPanel.add(this.insertButton, 2, 0, 1, 1, 0, 1, 17, 0);
            int YY = 0;
            this.rootComponent.add(codeLengthLabel, 0, YY, 1, 1, 0, 0, 13, 0, new Insets(10, 0, 0, 0));
            this.rootComponent.add(this.codeLengthSlider, 1, YY, 1, 1, 0, 0, 17, 0, new Insets(10, 10, 0, 0));
            this.rootComponent.add(this.exampleLabel, 2, YY++, 1, 1, 1000, 0, 17, 0, new Insets(10, 15, 0, 0));
            if (isAdmin) {
                this.rootComponent.add(this.emailLabel, 0, YY, 1, 1, 0, 0, 13, 0, new Insets(5, 0, 0, 0));
                this.rootComponent.add(this.emailField, 1, YY++, 2, 1, 1000, 0, 17, 0, new Insets(5, 10, 0, 0));
            }
            this.rootComponent.add(subjectLabel, 0, YY, 1, 1, 0, 0, 13, 0, new Insets(5, 0, 0, 0));
            this.rootComponent.add(this.subjectField, 1, YY++, 2, 1, 1000, 0, 17, 0, new Insets(5, 10, 0, 0));
            this.rootComponent.add(bodyLabel, 0, YY++, 3, 1, 0, 0, 17, 0, new Insets(15, 0, 0, 0));
            this.rootComponent.add(pane, 0, YY++, 3, 1, 1000, 10000, 17, 1, new Insets(10, 0, 0, 0));
            this.rootComponent.add(variablesPanel, 0, YY++, 3, 1, 100, 1, 13, 0);
            this.subjectField.addFocusListener(this);
            this.bodyArea.addFocusListener(this);
        }

        public int getCodeLength() {
            return this.codeLengthSlider.getValue();
        }

        public void setDefaultEmailSettings(String defaultSubject, String defaultContent, boolean collectEmailAddress) {
            this.exampleCode = SecurityUtil.generateNonAmbiguousCode(20);
            this.defaultSubject = defaultSubject;
            this.defaultContent = defaultContent;
        }

        private void updateTwoTierExample() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EmailDialogPanel.this.exampleLabel.setText(Language.get("EXAMPLE") + ": " + EmailDialogPanel.this.exampleCode.substring(0, EmailDialogPanel.this.twoTierCodeLength));
                    EmailDialogPanel.this.exampleLabel.repaint();
                }
            });
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.twoTierCodeLength = this.getCodeLength();
            this.updateTwoTierExample();
            this.changeListener.actionPerformed(null);
        }

        public void setEmailAuthenticationEmailDefaults(String twoTierSubject, String twoTierBody) {
            this.twoTierSubject = twoTierSubject;
            this.twoTierBody = twoTierBody;
            if (this.subjectField != null) {
                this.subjectField.setText(twoTierSubject);
                this.subjectField.repaint();
            }
            if (this.bodyArea != null) {
                this.bodyArea.setText(twoTierBody);
                this.bodyArea.repaint();
            }
        }

        public void setTwoTierSettings(int codeLength, String subject, String body, String adminEmail) {
            this.twoTierCodeLength = codeLength;
            if (this.twoTierCodeLength <= 6) {
                this.twoTierCodeLength = 6;
            }
            this.twoTierSubject = subject;
            this.twoTierBody = body;
            this.twoTierEmail = adminEmail;
            if (this.twoTierSubject == null || this.twoTierSubject.length() == 0) {
                this.twoTierSubject = this.defaultSubject;
            }
            if (this.twoTierBody == null || this.twoTierBody.length() == 0) {
                this.twoTierBody = this.defaultContent;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EmailDialogPanel.this.codeLengthSlider.removeChangeListener(EmailDialogPanel.this);
                    EmailDialogPanel.this.codeLengthSlider.setValue(EmailDialogPanel.this.twoTierCodeLength);
                    EmailDialogPanel.this.codeLengthSlider.addChangeListener(EmailDialogPanel.this);
                    EmailDialogPanel.this.updateTwoTierExample();
                    EmailDialogPanel.this.subjectField.setText(EmailDialogPanel.this.twoTierSubject);
                    EmailDialogPanel.this.bodyArea.setText(EmailDialogPanel.this.twoTierBody);
                    if (EmailDialogPanel.this.twoTierEmail != null) {
                        EmailDialogPanel.this.emailField.setText(EmailDialogPanel.this.twoTierEmail);
                    }
                    EmailDialogPanel.this.codeLengthSlider.repaint();
                    EmailDialogPanel.this.subjectField.repaint();
                    EmailDialogPanel.this.emailField.repaint();
                    EmailDialogPanel.this.bodyArea.repaint();
                }
            });
        }

        public void setEnabled(boolean selected) {
            this.subjectField.setEnabled(selected);
            this.exampleLabel.setEnabled(selected);
            this.bodyArea.setEnabled(selected);
            this.codeLengthSlider.setEnabled(selected);
            this.emailField.setEnabled(selected);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.insertButton) {
                String selectedVariable = "${" + this.variablesBox.getSelectedItem() + "}";
                if (this.contentWasLastFocused) {
                    this.bodyArea.insert(selectedVariable, this.bodyArea.getCaretPosition());
                    this.bodyArea.requestFocusInWindow();
                } else {
                    int pos = this.subjectField.getCaretPosition();
                    this.subjectField.setText(this.subjectField.getText().substring(0, pos) + selectedVariable + this.subjectField.getText().substring(pos));
                    this.subjectField.setCaretPosition(pos + selectedVariable.length());
                    this.subjectField.requestFocusInWindow();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent arg0) {
            this.variablesBox.setEnabled(true);
            this.insertButton.setEnabled(true);
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            this.contentWasLastFocused = arg0.getSource() == this.bodyArea;
        }
    }

    class FetchKeysThread
    extends Thread {
        FetchKeysThread() {
        }

        @Override
        public void run() {
            block5: {
                try {
                    TwoTierKey[] keys = MultiTierConfigPanel.this.client.getTwoTierKeys();
                    if (keys.length == 0) {
                        SHGlassOptionPane.showMessageDialog(SwingUtil.getRootPaneContainer(MultiTierConfigPanel.this.rootComponent), Language.get("MANAGE_KEYS_DESC") + "<BR><BR>" + Language.get("NO_KEYS_EXIST"), Language.get("TWO_TIER_AUTHENTICATION_KEYS"), null, Language.get("CLOSE"));
                        break block5;
                    }
                    TwoTierKeysDialog.showDialog(SwingUtil.getRootPaneContainer(MultiTierConfigPanel.this.rootComponent), keys, MultiTierConfigPanel.this.client);
                }
                catch (Throwable t) {
                    try {
                        t.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MultiTierConfigPanel.this.manageKeysButton.setEnabled(true);
                                MultiTierConfigPanel.this.manageKeysButton.repaint();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

