/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.access.AccessStyle;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class LDAPBasePickerDialog {
    private final TechClient client;
    private final GbPanel rootComponent = new GbPanel();
    private final PanelGlassDialog dialog;
    private JList list = new JList();

    public LDAPBasePickerDialog(RootPaneContainer rpc, TechClient client) throws Exception {
        this.client = client;
        String[] allGroups = client.getLDAPBases();
        if (allGroups != null) {
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (String s : allGroups) {
                model.addElement(s);
            }
            this.list.setModel(model);
        }
        this.list.setSelectionBackground(AccessStyle.TREE_SELECTION_COLOR);
        this.list.setSelectionForeground(Color.WHITE);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        scrollPane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.rootComponent.add(scrollPane, 0, 0, 1, 1, 1, 1, 10, 1);
        this.list.setFixedCellHeight(SimpleHelpLookAndFeel.scale(26));
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                JLabel label = (JLabel)c;
                label.setIcon(ImageLoader.getImageIcon("images/svg/computing/database.svg,16"));
                return c;
            }
        });
        this.dialog = new PanelGlassDialog(rpc, Language.get("LDAP_PICK_GROUPS_TITLE"), 500, Language.get("CLOSE"), null);
        this.dialog.setContentPanel(this.rootComponent);
        this.dialog.showDialog();
    }

    public String getBaseDN() {
        if (this.list.getSelectedValue() == null) {
            return null;
        }
        return String.valueOf(this.list.getSelectedValue());
    }
}

