/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jlist.SimpleListModel;

public class BlockedMachinePanel
extends GbPanel
implements ActionListener,
ListSelectionListener {
    private SimpleList<ServerConfig.BlockedRemoteMachine> machineList = new SimpleList();
    private JList list;
    private JButton unblock = new JButton(Language.get("UNBLOCK_MACHINE"));
    private ActionListener dirtyListener;

    public BlockedMachinePanel(ActionListener dirtyListener) {
        super(new Insets(3, 3, 3, 3));
        this.dirtyListener = dirtyListener;
        this.initUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(List<ServerConfig.BlockedRemoteMachine> machines) {
        this.machineList.startBatch();
        try {
            this.machineList.clear();
            if (machines != null) {
                for (ServerConfig.BlockedRemoteMachine m : machines) {
                    this.machineList.add(m);
                }
            }
        }
        finally {
            this.machineList.endBatch();
        }
    }

    public List<ServerConfig.BlockedRemoteMachine> save() {
        return this.machineList;
    }

    private void initUI() {
        this.list = new JList();
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setIcon(ImageLoader.getImageIcon("images/svg/technology/screen.svg,16"));
                return label;
            }
        });
        this.list.addListSelectionListener(this);
        SimpleListModel<ServerConfig.BlockedRemoteMachine> slm = new SimpleListModel<ServerConfig.BlockedRemoteMachine>(this.machineList);
        this.list.setModel(slm);
        JScrollPane sp = new JScrollPane(this.list);
        this.add(sp, 0, 0, 1, 1, 1, 1, 10, 1);
        this.add(this.unblock, 1, 0, 1, 1, 0, 0, 11, 0);
        this.unblock.addActionListener(this);
        this.unblock.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = this.list.getSelectedIndex();
        this.machineList.remove(index);
        this.unblock.setEnabled(false);
        this.dirtyListener.actionPerformed(new ActionEvent(this, 0, null));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.unblock.setEnabled(this.list.getSelectedIndex() != -1);
    }
}

