/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechServerConfig;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.util.PleaseWaitDialog;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;

public class AdministrationTab
implements TechServerConfig.TechServerConfigListener {
    private final RootPaneContainer rpc;
    private JPanel rootComponent = new JPanel();
    private AdminPanel fullAdminPanel = new AdminPanel();
    private TechClient client;
    private MachineTreeModel machineModel;
    private boolean showOnlyTechConfig;

    public AdministrationTab(RootPaneContainer rpc) {
        this.rpc = rpc;
        this.rootComponent.setLayout(new GridLayout(1, 1));
        this.rootComponent.add(this.fullAdminPanel);
    }

    public void setTechClient(TechClient client, MachineTreeModel machineModel) throws Exception {
        this.client = client;
        this.machineModel = machineModel;
        new TechServerConfig(client);
        TechServerConfig.INSTANCE.addTechServerConfigListener(this);
        this.fullAdminPanel.setTechClient(client, machineModel);
        if (!client.getTechUser().canAdministerServer && client.getTechUser().canAdministerGroup) {
            this.showOnlyTechConfig = true;
            System.out.println("[TechUI] Switching to group administration console");
            this.fullAdminPanel.showOnlyTechConfig();
        }
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public void updateSessionLimit() {
        this.fullAdminPanel.updateSessionLimit();
    }

    public void peersChanged() {
        this.fullAdminPanel.peersChanged();
    }

    public void loadExistingConfigIntoUI() {
        this.fullAdminPanel.loadConfig();
    }

    public void saveIfRequired() {
        this.fullAdminPanel.saveIfRequired();
    }

    public void tabActive() {
        if (!TechServerConfig.INSTANCE.hasBeenFetched()) {
            new PleaseWaitForConfigDialog().start();
        }
    }

    @Override
    public void serverConfigFetched() {
        System.out.println("[AdministrationTab] Server Config Fetched");
        this.fullAdminPanel.loadConfig();
    }

    @Override
    public void serverConfigChanged(String sourceID) {
        if (!sourceID.equals("Admin")) {
            System.out.println("[AdministrationTab] Server Config Changed");
            this.fullAdminPanel.loadConfig();
        }
    }

    public void fetchConfigFromServer() {
        TechServerConfig.INSTANCE.forceReload();
    }

    class PleaseWaitForConfigDialog
    extends Thread {
        PleaseWaitForConfigDialog() {
        }

        @Override
        public void run() {
            PleaseWaitDialog pleaseWaitDialog = null;
            try {
                pleaseWaitDialog = new PleaseWaitDialog(AdministrationTab.this.rpc, Language.get("PLEASE_WAIT_TITLE"), Language.get("PLEASE_WAIT_LOADING"));
                TechServerConfig.INSTANCE.blockUntilLoaded();
                pleaseWaitDialog.setVisible(false);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                if (pleaseWaitDialog != null) {
                    pleaseWaitDialog.setVisible(false);
                }
                SHGlassOptionPane.showErrorDialog(AdministrationTab.this.rpc, Language.get("FAILED_LOAD_MSG") + "\n\n" + e1.getMessage(), Language.get("FAILED_LOAD_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            }
        }
    }
}

