/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.sdesktop.ClientBranding;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.common.Language;
import com.aem.shelp.licence.License;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.SHUpdateCheckDialog;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.gstarted.SHWebsiteURLUtil;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.progtools.date.DateUtil;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class AdminServerVersion
implements ActionListener {
    private JPanel rootComponent = new JPanel();
    private JButton checkForUpdatesButton;
    private JButton showBackupButton;
    private JButton buyLicenseButton;
    private JLabel currentVersionLabel;
    private GbPanel checkForUpdatesPanel;
    private License license;
    private TechClient client;
    private AdminPanel adminPanel;
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public AdminServerVersion(AdminPanel adminPanel) {
        this.initUI();
        this.adminPanel = adminPanel;
    }

    public void setTechClient(TechClient client) {
        this.client = client;
    }

    public void initUI() {
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.rootComponent.setBackground(Color.white);
        GbPanelWrapper updateWrapper = new GbPanelWrapper(this.rootComponent, new Insets(3, 3, 3, 3));
        JLabel images = new JLabel(ImageLoader.getImageIcon("images/svg/logos/simplehelp-blue.svg,96"));
        SwingUtil.setHeight(images, SimpleHelpLookAndFeel.scale(100));
        JLabel currentBuildLabel = new JLabel(Language.get("ADMIN_SERVER_OVERVIEW_BUILD") + ": " + Version.getBuildDate());
        currentBuildLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.checkForUpdatesButton = new JButton(Language.get("ADMIN_SERVER_OVERVIEW_CHECK_FOR_UPDATES"));
        this.showBackupButton = new JButton(Language.get("ADMIN_BACKUP_TITLE"));
        this.buyLicenseButton = new JButton(Language.get("PURCHASE_LICENSE"));
        SHButtonUI.makeButtonBlue(this.buyLicenseButton);
        this.checkForUpdatesPanel = new GbPanel(new ScaledInsets(5, 5, 5, 5));
        this.checkForUpdatesPanel.setBackground(Color.white);
        this.showCheckForUpdates();
        this.currentVersionLabel = new JLabel(this.getServerVersionText(false, -1L));
        this.currentVersionLabel.setFont(this.currentVersionLabel.getFont().deriveFont(SimpleHelpLookAndFeel.scale(18.0f)));
        int Y = 0;
        updateWrapper.add(images, 0, Y, 1, 3, 0, 0, 17, 0, new Insets(3, 8, 3, 7));
        updateWrapper.add(this.currentVersionLabel, 1, Y++, 3, 1, 1, 0, 17, 2);
        updateWrapper.add(currentBuildLabel, 1, Y++, 3, 1, 1, 0, 17, 2, new Insets(0, 3, 20, 3));
        updateWrapper.add(this.checkForUpdatesPanel, 1, Y++, 3, 1, 1, 0, 17, 2, new Insets(0, 0, 0, 0));
        this.showBackupButton.addActionListener(this);
        this.checkForUpdatesButton.addActionListener(this);
        this.buyLicenseButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.checkForUpdatesButton) {
            SHUpdateCheckDialog dialog = new SHUpdateCheckDialog(SwingUtil.getRootPaneContainer(this.rootComponent), new SHUpdateCheckDialog.UpdateCheckPane(this.client), this.client);
            dialog.showDialog();
        } else if (e.getSource() == this.showBackupButton) {
            this.adminPanel.switchToBackupSection();
        } else if (e.getSource() == this.buyLicenseButton) {
            SHWebsiteURLUtil.launchBuyPage();
        }
    }

    private void showBuyButton() {
        this.checkForUpdatesPanel.removeAll();
        this.checkForUpdatesPanel.add(this.buyLicenseButton, 0, 0, 1, 1, 0, 0, 17, 0);
        this.checkForUpdatesPanel.add(this.showBackupButton, 1, 0, 1, 1, 1, 0, 17, 0);
        this.checkForUpdatesPanel.revalidate();
        this.checkForUpdatesPanel.repaint();
    }

    private void showCheckForUpdates() {
        this.checkForUpdatesPanel.removeAll();
        if (OemBranding.OEM_IS_SH) {
            this.checkForUpdatesPanel.add(this.showBackupButton, 0, 0, 1, 1, 0, 0, 17, 0);
            this.checkForUpdatesPanel.add(this.checkForUpdatesButton, 1, 0, 1, 1, 1, 0, 17, 0);
        } else {
            this.checkForUpdatesPanel.add(this.showBackupButton, 0, 0, 1, 1, 1, 0, 17, 0);
        }
        this.checkForUpdatesPanel.revalidate();
        this.checkForUpdatesPanel.repaint();
    }

    private String getServerVersionText(boolean isTrial, long daysTillExpire) {
        String title = "<html>" + ClientBranding.get().getApplicationName(false) + " " + Language.get("ADMIN_SERVER") + " " + Version.getExtendedUserFacing();
        if (isTrial) {
            title = title + " - <font color=\"#E84849\">Trial";
            if (daysTillExpire > 0L) {
                if (daysTillExpire > 1L) {
                    title = title + " (" + daysTillExpire + " " + Language.get("UNIT_DAYS") + " " + Language.get("REMAINING") + ")";
                } else if (daysTillExpire == 1L) {
                    title = title + " (" + daysTillExpire + " " + Language.get("UNIT_DAY") + " " + Language.get("REMAINING") + ")";
                }
            }
            title = title + "</font>";
        }
        return title;
    }

    public void setLicense(License lic) {
        boolean isTrial;
        this.license = lic;
        long daysTillExpire = -1L;
        if (this.license == null) {
            isTrial = true;
        } else {
            try {
                isTrial = this.license.isTrial();
                if (isTrial) {
                    boolean hasExpired;
                    String expiryDate = this.license.getExpiryFormattedYMD();
                    Date expiry = sdf.parse(expiryDate);
                    boolean bl = hasExpired = System.currentTimeMillis() > expiry.getTime();
                    if (hasExpired) {
                        daysTillExpire = DateUtil.getDaysBetween(System.currentTimeMillis(), expiry.getTime());
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                isTrial = false;
            }
        }
        if (isTrial) {
            this.showBuyButton();
        } else {
            this.showCheckForUpdates();
        }
        this.currentVersionLabel.setText(this.getServerVersionText(isTrial, daysTillExpire));
    }

    public void setBackupButtonRed(boolean b) {
        if (b) {
            SHButtonUI.makeButtonRed(this.showBackupButton);
        } else {
            SHButtonUI.makeButtonNormal(this.showBackupButton);
        }
        this.showBackupButton.repaint();
    }
}

