/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.LicenseIcon;
import com.aem.shelp.licence.License;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.SHUpdateCheckDialog;
import com.aem.shelp.tech.TechServerConfig;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.admin.AdminServerVersion;
import com.aem.shelp.tech.admin.rows.AdminRow;
import com.aem.shelp.tech.admin.subsections.AdminBackup;
import com.aem.shelp.tech.admin.subsections.AdminRestore;
import com.aem.shelp.tech.admin.subsections.AdminSection;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.dataexport.AdminCluster;
import com.aem.shelp.tech.admin.subsections.dataexport.AdminEmail;
import com.aem.shelp.tech.admin.subsections.dataexport.AdminEnterprise;
import com.aem.shelp.tech.admin.subsections.dataexport.AdminStatus;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminBranding;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminLicense;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminPassword;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminStatusTest;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminAutoForget;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminBlocked;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminFeatures;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminHostname;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminLanguage;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminNewSSL;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminPorts;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminRecovery;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminSSL;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminServerLog;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminWelcomePage;
import com.aem.shelp.tech.admin.subsections.serversettings.BusinessFeatureSet;
import com.aem.shelp.tech.admin.subsections.sessions.AdminCustomerDetails;
import com.aem.shelp.tech.admin.subsections.sessions.AdminDisclaimer;
import com.aem.shelp.tech.admin.subsections.sessions.AdminElevation;
import com.aem.shelp.tech.admin.subsections.sessions.AdminEndOfSession;
import com.aem.shelp.tech.admin.subsections.sessions.AdminQueuePassword;
import com.aem.shelp.tech.admin.subsections.sessions.AdminSessionSummary;
import com.aem.shelp.tech.admin.subsections.technicians.AdminAuthentication;
import com.aem.shelp.tech.admin.subsections.technicians.AdminGroups;
import com.aem.shelp.tech.admin.subsections.technicians.AdminLDAP;
import com.aem.shelp.tech.admin.subsections.technicians.AdminRadius;
import com.aem.shelp.tech.admin.subsections.technicians.AdminTechPresence;
import com.aem.shelp.tech.admin.subsections.technicians.AdminTechRestrictions;
import com.aem.shelp.tech.admin.subsections.technicians.AdminTechnicians;
import com.aem.shelp.util.ErrorDialogs;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jwrapper.jwutils.swing.JWAutomatable;
import jwrapper.jwutils.swing.JWAutomate;
import utils.progtools.SaverUtil;
import utils.progtools.StackTracer;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.icons.CircularProgressLabel;
import utils.swing.images.ImageLoader;
import utils.swing.sectionproperties.AllSectionsPanel;
import utils.swing.sectionproperties.Section;
import utils.switches.Switches;

public class AdminPanel
extends AllSectionsPanel
implements JWAutomatable {
    private static final boolean DEBUG_PRINT_CHANGES = true;
    public static License LOADED_LICENSE = null;
    private JPanel savingLanelPanel;
    private CircularProgressLabel savingLabel;
    private ArrayList<AdminSection> allSections = new ArrayList();
    private AdminServerVersion serverPanel;
    private AdminRadius radiusPanel;
    private AdminEnterprise adminEnterprise;
    private AdminCluster adminCluster;
    private AdminSection licenseSection;
    private SaverUtil saveUtil;
    private AdminSection backupSection;
    private AdminSection loginSecuritySection;
    private AdminSection emailSection;
    private boolean disableSaveListener = false;
    private AdminTechnicians techniciansPanel;
    private AdminGroups groupsPanel;
    private TechServerConfig serverConfig;
    TechClient client;
    private SaverUtil.SaveListener saveListener = new SaverUtil.SaveListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performSave() {
            try {
                long start = System.currentTimeMillis();
                AdminPanel.this.setSavingLabelOn();
                Object object = AdminPanel.this.serverConfig.getLock();
                synchronized (object) {
                    final ServerConfig currentConfig = AdminPanel.this.serverConfig.getServerConfig();
                    System.out.println("[AdminPanel] Saving configuration now");
                    String oldSettings = currentConfig.printConfig();
                    String oldDisclaimer = currentConfig.disclaimer;
                    boolean forceSave = false;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            for (AdminSection section : AdminPanel.this.allSections) {
                                section.saveTo(currentConfig);
                            }
                        }
                    });
                    for (AdminSection section : AdminPanel.this.allSections) {
                        if (forceSave || !section.forceSave()) continue;
                        forceSave = true;
                    }
                    String newSettings = currentConfig.printConfig();
                    String newDisclaimer = currentConfig.disclaimer;
                    if (forceSave || AdminPanel.differ(oldSettings, newSettings, true) || AdminPanel.differ(oldDisclaimer, newDisclaimer, true)) {
                        System.out.println("[AdminPanel] There is a config change. Sending configuration to server now.");
                        if (CentralDebugging.PRINT_SERVER_CONFIG_ON_SAVE) {
                            System.out.println(currentConfig.printConfig());
                        }
                        AdminPanel.this.serverConfig.requestSave("Admin");
                    } else {
                        System.out.println("[AdminPanel] Config appears unchanged. Skipping save.");
                    }
                    for (AdminSection section : AdminPanel.this.allSections) {
                        section.saveComplete(currentConfig);
                    }
                }
                long timeTaken = System.currentTimeMillis() - start;
                if (timeTaken > 500L) {
                    AdminPanel.this.setSavingLabelOff();
                } else {
                    Timer timer = new Timer((int)(500L - timeTaken), new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AdminPanel.this.setSavingLabelOff();
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
            catch (Throwable t) {
                System.out.println("[AminPanel] SEVERE ERROR: unable to save server configuration");
                t.printStackTrace();
                AdminPanel.this.setSavingLabelError(t);
            }
        }
    };

    public AdminPanel() {
        AdminRow gettingStartedRow;
        this.savingLanelPanel = new JPanel(new GridLayout(1, 1));
        this.savingLanelPanel.setBackground(Color.white);
        SwingUtil.setWidth(this.savingLanelPanel, SimpleHelpLookAndFeel.scale(48));
        this.setRightContents(this.savingLanelPanel);
        this.savingLabel = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_24);
        this.savingLabel.setToolTipText(Language.get("PLEASE_WAIT_SAVING"));
        this.saveUtil = new SaverUtil("AdminPanel", 1000, this.saveListener, false);
        this.serverPanel = new AdminServerVersion(this);
        this.allSectionsPanel.add(this.serverPanel.getRootComponent(), 0, this.allSectionsPanel.getComponentCount(), 1, 1, 1, 0, 17, 2);
        AdminSection passwordSection = new AdminSection(new AdminPassword(), ImageLoader.getImageIcon("images/svg/general/lock.svg,48"));
        this.allSections.add(passwordSection);
        this.licenseSection = new AdminSection(new AdminLicense(), LicenseIcon.getLicenseIcon(1, true));
        this.allSections.add(this.licenseSection);
        AdminSection brandingSection = null;
        if (OemBranding.OEM_IS_SH) {
            brandingSection = new AdminSection(new AdminBranding(), ImageLoader.getImageIcon("images/svg/general/palette.svg,48"));
            this.allSections.add(brandingSection);
        }
        AdminSection statusSection = new AdminSection(new AdminStatusTest(), ImageLoader.getImageIcon("images/svg/general/heartbeat.svg,48"));
        this.allSections.add(statusSection);
        if (OemBranding.OEM_IS_SH) {
            gettingStartedRow = new AdminRow(this, new Section[]{passwordSection, this.licenseSection, brandingSection, statusSection}, Language.get("ADMIN_ROW_STARTED"));
            this.addSectionRow(gettingStartedRow);
        } else {
            gettingStartedRow = new AdminRow(this, new Section[]{passwordSection, this.licenseSection, statusSection}, Language.get("ADMIN_ROW_STARTED"));
            this.addSectionRow(gettingStartedRow);
        }
        this.techniciansPanel = new AdminTechnicians();
        this.groupsPanel = new AdminGroups(this);
        AdminSection techniciansSection = new AdminSection(this.techniciansPanel, ImageLoader.getImageIcon("images/svg/users/technician.svg,48"));
        this.allSections.add(techniciansSection);
        AdminSection groupsSection = new AdminSection(this.groupsPanel, ImageLoader.getImageIcon("images/svg/users/queue.svg,48"));
        this.allSections.add(groupsSection);
        this.radiusPanel = new AdminRadius();
        this.loginSecuritySection = new AdminSection(new SubSection[]{new AdminTechRestrictions(), new AdminAuthentication(this), new AdminLDAP(), this.radiusPanel}, ImageLoader.getImageIcon("images/svg/security/key.svg,48"), Language.get("ADMIN_LOGIN_SECURITY"));
        this.allSections.add(this.loginSecuritySection);
        AdminRow techniciansRows = new AdminRow(this, new Section[]{techniciansSection, groupsSection, this.loginSecuritySection}, Language.get("ADMIN_ROW_TECHNICIANS"));
        this.addSectionRow(techniciansRows);
        AdminSection sessionFeaturesSection = new AdminSection(new SubSection[]{new AdminDisclaimer(), new AdminTechPresence(), new AdminQueuePassword(), new AdminElevation()}, ImageLoader.getImageIcon("images/svg/general/help.svg,48"), Language.get("ADMIN_SESSION_FEATURES"));
        this.allSections.add(sessionFeaturesSection);
        AdminSection customerDetailsSection = new AdminSection(new AdminCustomerDetails(), ImageLoader.getImageIcon("images/svg/users/profile.svg,48"));
        this.allSections.add(customerDetailsSection);
        AdminSection endOfSession = new AdminSection(new SubSection[]{new AdminEndOfSession(), new AdminSessionSummary()}, ImageLoader.getImageIcon("images/svg/general/disconnect.svg,48"), Language.get("POST_SESSION_TAB"));
        this.allSections.add(endOfSession);
        AdminRow sessionsRows = new AdminRow(this, new Section[]{sessionFeaturesSection, customerDetailsSection, endOfSession}, Language.get("ADMIN_ROW_SESSIONS"));
        this.addSectionRow(sessionsRows);
        SubSection[] featureSections = OemBranding.OEM_IS_SH ? new SubSection[]{new AdminLanguage(), new AdminFeatures(), new BusinessFeatureSet(), new AdminWelcomePage()} : new SubSection[]{new AdminLanguage(), new AdminFeatures(), new AdminWelcomePage()};
        AdminSection serverFeaturesSection = new AdminSection(featureSections, ImageLoader.getImageIcon("images/svg/general/switches.svg,48"), Language.get("ADMIN_SERVER_FEATURES"));
        this.allSections.add(serverFeaturesSection);
        AdminSection networkSection = new AdminSection(new SubSection[]{new AdminHostname(), new AdminPorts(), Switches.SH_Lets_Encrypt_Support ? new AdminNewSSL() : new AdminSSL()}, ImageLoader.getImageIcon("images/svg/computing/network.svg,48"), Language.get("ADMIN_NETWORK_SETTINGS"));
        this.allSections.add(networkSection);
        AdminSection serverLogSection = new AdminSection(AdminServerLog.getInstance(), ImageLoader.getImageIcon("images/svg/files-folders/text.svg,48"));
        this.allSections.add(serverLogSection);
        SubSection[] advancedSubSections = Switches.SH_autoForgetServices ? new SubSection[]{new AdminRecovery(), new AdminAutoForget(), new AdminBlocked()} : new SubSection[]{new AdminRecovery(), new AdminBlocked()};
        AdminSection advancedSection = new AdminSection(advancedSubSections, ImageLoader.getImageIcon("images/svg/security/shield.svg,48"), Language.get("ADMIN_ADVANCED_SECTION"));
        this.allSections.add(advancedSection);
        AdminRow serverSettingsRows = new AdminRow(this, new Section[]{serverFeaturesSection, networkSection, serverLogSection, advancedSection}, Language.get("ADMIN_ROW_SERVER_SETTINGS"));
        this.addSectionRow(serverSettingsRows);
        this.emailSection = new AdminSection(new AdminEmail(), ImageLoader.getImageIcon("images/svg/computing/email.svg,48"));
        this.allSections.add(this.emailSection);
        AdminSection statusPageSection = new AdminSection(new AdminStatus(), ImageLoader.getImageIcon("images/svg/computing/window-code.svg,48"));
        this.allSections.add(statusPageSection);
        this.adminEnterprise = new AdminEnterprise();
        AdminSection entPageSection = new AdminSection(this.adminEnterprise, ImageLoader.getImageIcon("images/svg/computing/monolith.svg,48"));
        this.allSections.add(entPageSection);
        this.adminCluster = new AdminCluster();
        AdminSection clusterPageSection = new AdminSection(this.adminCluster, ImageLoader.getImageIcon("images/svg/computing/clustering.svg,48"));
        this.allSections.add(clusterPageSection);
        AdminRow serverSettingsRows2 = new AdminRow(this, new Section[]{this.emailSection, statusPageSection, entPageSection, clusterPageSection}, Language.get("ADMIN_ROW_SERVER_SETTINGS"));
        this.addSectionRow(serverSettingsRows2);
        this.backupSection = Switches.SH_allowRestoreFromBackup ? new AdminSection(new SubSection[]{new AdminBackup(this), new AdminRestore(this)}, null, Language.get("ADMIN_BACKUP_TITLE")) : new AdminSection(new AdminBackup(this), null);
        this.finish();
    }

    public void switchToBackupSection() {
        this.selectSection(this.backupSection);
    }

    public void switchToLoginSecuritySection() {
        this.selectSection(this.loginSecuritySection);
    }

    public void switchToEmailSection() {
        this.selectSection(this.emailSection);
    }

    @Override
    public void initBackButton() {
        this.back.setText(Language.get("ALL_SETTINGS"));
        this.back.setIcon(ImageLoader.getImageIcon("images/svg/arrows/left.svg,16"));
    }

    public void setTechClient(TechClient client, MachineTreeModel model) {
        this.client = client;
        this.serverConfig = TechServerConfig.INSTANCE;
        this.techniciansPanel.setMachineTreeModel(model);
        this.groupsPanel.setMachineTreeModel(model);
        this.serverPanel.setTechClient(client);
        this.backupSection.setTechClient(client);
        for (AdminSection section : this.allSections) {
            section.setTechClient(client);
        }
        for (AdminSection section : this.allSections) {
            section.setAdminPanel(this);
            section.setupSaveListeners();
        }
        if (AdminBackup.INSTANCE != null) {
            new AdminBackup.CheckBackupThread(AdminBackup.INSTANCE).start();
        }
        if (TechServerConfig.INSTANCE.hasBeenFetched()) {
            this.loadConfig();
        }
    }

    public void loadConfig() {
        AdminGroups.INSTANCE.reloadTwoTierEmailDefaults();
        AdminAuthentication.INSTANCE.reloadTwoTierEmailDefaults();
        AdminStatusTest.INSTANCE.setServerOSIsWindows(this.serverConfig.isWindows());
        new Thread(){

            @Override
            public void run() {
                if (AdminBranding.INSTANCE != null) {
                    try {
                        AdminBranding.INSTANCE.fetchBrandingSettings();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
        License lic = this.client.getServerLicense();
        if (lic == null) {
            AdminLicense.INSTANCE.setLicense(null);
            this.serverPanel.setLicense(null);
            SHUpdateCheckDialog.setLicense(null);
            LOADED_LICENSE = null;
            this.radiusPanel.licenseChanged();
        } else {
            AdminLicense.INSTANCE.setLicense(lic);
            this.serverPanel.setLicense(lic);
            SHUpdateCheckDialog.setLicense(lic);
            LOADED_LICENSE = lic;
            this.radiusPanel.licenseChanged();
            this.adminEnterprise.licenseChanged();
            this.adminCluster.licenseChanged();
            String expiryDate = lic.getExpiryFormattedYMD();
            boolean isTrial = lic.isTrial();
            this.licenseSection.setLargeIcon(LicenseIcon.getLicenseIcon(this.client.getSessionLimit(), isTrial));
        }
        this.loadProperties();
    }

    public void peersChanged() {
        try {
            this.adminEnterprise.peersChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateSessionLimit() {
        try {
            boolean isTrial = LOADED_LICENSE.isTrial();
            this.licenseSection.setLargeIcon(LicenseIcon.getLicenseIcon(this.client.getSessionLimit(), isTrial));
            this.adminEnterprise.updateSessionLimit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadFromConfigOnEDT(final ServerConfig config) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AdminPanel.this.loadFromConfigOnEDT(config);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return;
        }
        for (AdminSection section : this.allSections) {
            section.loadFrom(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() {
        this.disableSaveListener = true;
        try {
            Object object = this.serverConfig.getLock();
            synchronized (object) {
                ServerConfig config = this.serverConfig.getServerConfig();
                this.loadFromConfigOnEDT(config);
            }
        }
        finally {
            this.disableSaveListener = false;
        }
    }

    public void requestASave(String actionType) {
        this.requestASave(actionType, false);
    }

    public void requestASave(String actionType, boolean immediate) {
        boolean hasError = false;
        for (AdminSection section : this.allSections) {
            if (!section.hasError()) continue;
            hasError = true;
            break;
        }
        if (!hasError) {
            if (!this.disableSaveListener) {
                System.out.println("[AdminPanel] Save requested (" + actionType + ")");
                if (immediate) {
                    this.saveUtil.saveNow();
                } else {
                    this.saveUtil.queueSave();
                }
            }
        } else {
            System.out.println("[AdminPanel] Skipping save due to config error");
            this.saveUtil.cancelSave();
        }
    }

    public void deferSave() {
        this.saveUtil.deferSave();
    }

    public static boolean differ(String s1, String s2, boolean showDiff) {
        int s2Index;
        if (!showDiff) {
            return s1.compareTo(s2) != 0;
        }
        char[] s1Chars = s1.toCharArray();
        char[] s2Chars = s2.toCharArray();
        int s1Index = 0;
        for (s2Index = 0; s1Index < s1Chars.length && s2Index < s2Chars.length && s1Chars[s1Index] == s2Chars[s2Index]; ++s1Index, ++s2Index) {
        }
        if (s1Index == s1Chars.length && s2Index == s2Chars.length) {
            return false;
        }
        int changePoint = s1Index;
        s1Index = s1Chars.length - 1;
        for (s2Index = s2Chars.length - 1; s1Index > changePoint && s2Index > changePoint && s1Chars[s1Index] == s2Chars[s2Index]; --s1Index, --s2Index) {
        }
        return true;
    }

    public void setLastBackedUp(String lastBackupDate) {
        if (lastBackupDate == null) {
            this.serverPanel.setBackupButtonRed(true);
        } else {
            this.serverPanel.setBackupButtonRed(false);
        }
    }

    @Override
    public boolean grabScreenShotsOfChildren() {
        return true;
    }

    @Override
    public Component[] getChildComponents() {
        this.specificSectionPanel.setSize(this.getSize());
        ArrayList<JComponent> children = new ArrayList<JComponent>();
        for (AdminSection section : this.allSections) {
            JComponent component = section.getRootComponent();
            component.setSize(this.specificSectionPanel.getSize());
            component.setPreferredSize(this.specificSectionPanel.getSize());
            JWAutomate.layoutComponent(component);
            children.add(component);
        }
        return children.toArray(new Component[0]);
    }

    @Override
    public JComponent getRootComponent() {
        return super.getRootComponent();
    }

    public void saveIfRequired() {
        this.saveUtil.skipDelayIfSaveScheduled();
    }

    public void setSavingLabelOn() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminPanel.this.savingLanelPanel.removeAll();
                AdminPanel.this.savingLanelPanel.add(AdminPanel.this.savingLabel);
                AdminPanel.this.savingLabel.switchOn();
                AdminPanel.this.setRightContents(AdminPanel.this.savingLanelPanel);
            }
        });
    }

    public void setSavingLabelOff() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminPanel.this.savingLanelPanel.removeAll();
                AdminPanel.this.savingLanelPanel.revalidate();
                AdminPanel.this.savingLanelPanel.repaint();
            }
        });
    }

    public void setSavingLabelError(final Throwable t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminPanel.this.savingLanelPanel.removeAll();
                JLabel warningLabel = new JLabel(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,24"));
                warningLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        ErrorDialogs.ErrorGlassDialog dialog = new ErrorDialogs.ErrorGlassDialog(SwingUtil.getRootPaneContainer(AdminPanel.this.getRootComponent()), Language.get("FAILED_SAVE_MSG"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), true, false);
                        dialog.setText(Language.get("FAILED_SAVE_MSG"), null, StackTracer.getStacktrace(t));
                        dialog.showDialog();
                    }
                });
                AdminPanel.this.savingLanelPanel.add(warningLabel);
                AdminPanel.this.savingLanelPanel.revalidate();
                AdminPanel.this.savingLanelPanel.repaint();
            }
        });
    }

    public void showOnlyTechConfig() {
        this.removeAll();
        this.add(this.techniciansPanel.getRootComponent());
        this.techniciansPanel.forceAtLeastOneGroupSelected();
        this.revalidate();
        this.repaint();
    }

    public void loadTechnicians(TechUser[] usersToAdminister, TechGroup[] groupsToAdminister) {
        this.techniciansPanel.loadTechnicians(usersToAdminister, groupsToAdminister);
    }
}

