/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.model.machine.filters;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.hierarchy.model.TreeNodeFilterProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import utils.xml.XML14Util;

public class FavouriteMachineFilter
extends TreeNodeFilterProcessor<MachineGroup, Machine> {
    public static final String ID = "FavouritesFilter";
    private MachineGroup rootGroup;
    private Set<String> favouritesSet = new HashSet<String>();
    private static final Object INCLUDED = new Object();

    public FavouriteMachineFilter(MachineGroup rootGroup) {
        this.rootGroup = rootGroup;
    }

    @Override
    public boolean includes(Machine machine) {
        return this.favouritesSet.contains(machine.getID());
    }

    @Override
    public MachineGroup getRoot() {
        return this.rootGroup;
    }

    @Override
    public String getMetadata() {
        return "FAV";
    }

    @Override
    public void setRoot(MachineGroup root) {
        this.rootGroup = root;
    }

    @Override
    public void saveToXML(StringBuffer xml) {
        xml.append("<FilterProcessor class=\"" + this.getXMLIdentifier() + "\">\n");
        for (String machineID : this.favouritesSet) {
            xml.append("\t<ID>").append(XML14Util.escape(machineID)).append("</ID>\n");
        }
        xml.append("</FilterProcessor>\n");
    }

    @Override
    public boolean removeIfEmpty() {
        return true;
    }

    @Override
    public String getXMLIdentifier() {
        return ID;
    }

    public void setFavourite(Machine machine, boolean favourite) {
        if (favourite) {
            this.favouritesSet.add(machine.getMachineID());
        } else {
            this.favouritesSet.remove(machine.getMachineID());
        }
    }

    public void loadStateFrom(Element filterProcessor) {
        System.out.println("------------------------- LOADING");
        this.favouritesSet.clear();
        ArrayList<Element> machineIDList = XML14Util.getChildrenByName(filterProcessor, "ID");
        for (Element idElement : machineIDList) {
            String id = idElement.getTextContent();
            this.favouritesSet.add(id);
        }
    }
}

