/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.model.machine;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.model.machine.MachineGroupStats;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import com.aem.shelp.tech.hierarchy.model.TreeGroupComparator;
import com.aem.shelp.tech.hierarchy.model.stats.DescendentTreeStats;

public class MachineGroup
extends TreeGroup<MachineGroup, Machine> {
    protected boolean isActiveSessionGroup = false;

    protected MachineGroup(String groupName) {
        this.groupName = groupName;
    }

    public static MachineGroup newGroup(String name) {
        return new MachineGroup(name);
    }

    public void setIsActiveSessionGroup(boolean isActiveSessionGroup) {
        this.isActiveSessionGroup = isActiveSessionGroup;
    }

    public Object clone() {
        MachineGroup group = new MachineGroup(this.groupName);
        group.copyStateFrom(this);
        return group;
    }

    @Override
    protected void copyStateFrom(MachineGroup group) {
        super.copyStateFrom(group);
        group.isActiveSessionGroup = this.isActiveSessionGroup;
    }

    @Override
    protected DescendentTreeStats<Machine> initGroupStats() {
        return new MachineGroupStats();
    }

    protected Machine[] initElementArray(int size) {
        return new Machine[size];
    }

    @Override
    public int compareTo(MachineGroup o) {
        return TreeGroupComparator.INSTANCE.compare(this, o);
    }

    @Override
    public int getTreeElementDescendents() {
        if (this.isActiveSessionGroup) {
            return ((MachineGroupStats)this.stats).activeSessionCount;
        }
        return this.stats.descendentElementCount;
    }

    @Override
    public void setParent(MachineGroup parent) {
        super.setParent(parent);
        this.setIsActiveSessionGroup(parent.isActiveSessionGroup);
    }
}

