/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.gstarted.SHWebsiteURLUtil;
import com.aem.shelp.tech.gstarted.TrialUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JWrapTextAreaLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ProblemsPanel
extends GbPanel
implements ActionListener {
    private JPanel hashPanel = new ColorPropagatingPanel(new BorderLayout(10, 10));
    private JPanel http10Panel = new ColorPropagatingPanel(new BorderLayout(10, 10));
    private JPanel overLimitPanel = new ColorPropagatingPanel(new BorderLayout(10, 10));
    private JButton hashButton = new JButton();
    private JButton http10Button = new JButton();
    private JButton overLimitButton = new JButton();
    private JWrapTextAreaLabel hashLabel = new JWrapTextAreaLabel();
    private JWrapTextAreaLabel http10Label = new JWrapTextAreaLabel();
    private JWrapTextAreaLabel overLimitLabel = new JWrapTextAreaLabel();
    TechClient tmpClient;

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public void setBorder(Border b) {
    }

    public ProblemsPanel() {
        super(new Insets(3, 3, 3, 3));
        this.initUI();
    }

    private void initUI() {
        super.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(1, 0, 1, 0, SHStyle.WARNING_GRADIENT_COLOR), SHBorderFactory.createEmptyBorder(3, 3, 3, 3)));
        super.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        this.hashPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        this.http10Panel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        this.overLimitPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        this.hashLabel.setText(Language.get("PROBLEM_HASH"));
        this.http10Label.setText(Language.get("PROBLEM_HTTP10"));
        this.overLimitLabel.setText(Language.get("OVER_MACHINE_LIMIT"));
        this.hashLabel.setBorder(SHBorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.http10Label.setBorder(SHBorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.overLimitLabel.setBorder(SHBorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.hashPanel.add((Component)this.hashLabel, "Center");
        this.http10Panel.add((Component)this.http10Label, "Center");
        this.overLimitPanel.add((Component)this.overLimitLabel, "Center");
        if (OemBranding.OEM_IS_SH) {
            GbPanel rightPanel = new GbPanel();
            rightPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
            rightPanel.add(this.hashButton, 0, 0, 1, 1, 0, 0, 10, 0);
            this.hashPanel.add((Component)rightPanel, "East");
            rightPanel = new GbPanel();
            rightPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
            rightPanel.add(this.http10Button, 0, 0, 1, 1, 0, 0, 10, 0);
            this.http10Panel.add((Component)rightPanel, "East");
            rightPanel = new GbPanel();
            rightPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
            rightPanel.add(this.overLimitButton, 0, 0, 1, 1, 0, 0, 10, 0);
            this.overLimitPanel.add((Component)rightPanel, "East");
        }
        JLabel iconLabel = new JLabel(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16"));
        GbPanel leftPanel = new GbPanel();
        leftPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        leftPanel.add(iconLabel, 0, 0, 1, 1, 0, 0, 11, 0);
        this.hashPanel.add((Component)leftPanel, "West");
        iconLabel = new JLabel(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16"));
        leftPanel = new GbPanel();
        leftPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        leftPanel.add(iconLabel, 0, 0, 1, 1, 0, 0, 10, 0);
        this.http10Panel.add((Component)leftPanel, "West");
        iconLabel = new JLabel(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16"));
        leftPanel = new GbPanel();
        leftPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        leftPanel.add(iconLabel, 0, 0, 1, 1, 0, 0, 10, 0);
        this.overLimitPanel.add((Component)leftPanel, "West");
        this.add(this.hashPanel, 0, 0, 1, 1, 1, 1, 10, 2);
        this.add(this.http10Panel, 0, 1, 1, 1, 1, 1, 10, 2);
        this.add(this.overLimitPanel, 0, 2, 1, 1, 1, 1, 10, 2);
        this.hashButton.setToolTipText(Language.get("FIND_OUT_MORE"));
        this.http10Button.setToolTipText(Language.get("FIND_OUT_MORE"));
        this.overLimitButton.setText(Language.get("UPGRADE"));
        this.hashButton.setIcon(ImageLoader.getImageIcon("images/svg/dialogs/question.svg,16"));
        this.http10Button.setIcon(ImageLoader.getImageIcon("images/svg/dialogs/question.svg,16"));
        this.overLimitButton.setIcon(ImageLoader.getImageIcon("images/svg/arrows/right.svg,16"));
        this.hashButton.addActionListener(this);
        this.http10Button.addActionListener(this);
        this.overLimitButton.addActionListener(this);
    }

    public void initFor(Machine machine, TechClient client) {
        this.tmpClient = client;
        if (machine != null) {
            this.hashPanel.setVisible(machine.isProblemHashMismatch());
            this.http10Panel.setVisible(machine.isProblemHTTP_1_0());
        } else {
            this.hashPanel.setVisible(false);
            this.http10Panel.setVisible(false);
        }
        if (client != null) {
            this.overLimitPanel.setVisible(client.amOverMachineLimit());
        } else {
            this.overLimitPanel.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.hashButton) {
            SHWebsiteURLUtil.launchTroubleShootingServerID();
        } else if (e.getSource() == this.http10Button) {
            SHWebsiteURLUtil.launchTroubleShootingHTTP10Page();
        } else if (e.getSource() == this.overLimitButton) {
            if (this.tmpClient.getServerLicense().isVersion2Business()) {
                TrialUtils.entUpgradeRequestPopup(SwingUtil.getRootPaneContainer(this), this, this.tmpClient);
            } else {
                TrialUtils.bizUpgradeRequestPopup(SwingUtil.getRootPaneContainer(this), this, this.tmpClient);
            }
        }
    }
}

