/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.sgateway.ServiceConfigureListener;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.GbPanel;

public class MachineNotificationPanel
implements ActionListener {
    private GbPanel buttonsPanel = new GbPanel();
    private JButton sendButton;
    private JButton cancelButton;
    private GbPanel msgPanel = new GbPanel(new ScaledInsets(5, 5, 5, 5));
    private JTextField subject = new JTextField();
    private JTextArea content = new JTextArea();
    private JScrollPane scroll = new JScrollPane(this.content);
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private BorderPanel contentPanel = new BorderPanel();
    private Machine[] configuringMachines;
    private AccessPanelListener accessPanelListener;
    private ServiceConfigureListener serviceListener;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public MachineNotificationPanel(Machine[] machines, AccessPanelListener listener, ServiceConfigureListener serviceListener) {
        this.accessPanelListener = listener;
        this.configuringMachines = machines;
        this.serviceListener = serviceListener;
        this.initUI();
    }

    private void initUI() {
        JLabel title = new JLabel();
        title.setFont(SHStyle.largeFont);
        title.setText(Language.get("RANOTIFY_TITLE"));
        title.setBorder(SHBorderFactory.createEmptyBorder(3, 3, 3, 3));
        title.setHorizontalAlignment(0);
        this.content.setLineWrap(true);
        this.content.setWrapStyleWord(true);
        this.rootComponent.add((Component)title, "North");
        this.rootComponent.add((Component)this.contentPanel, "Center");
        this.sendButton = new JButton(Language.get("SEND_NOTIFICATION"));
        this.cancelButton = new JButton(Language.get("CANCEL"));
        this.buttonsPanel = new GbPanel(new ScaledInsets(0, 3, 3, 3));
        this.buttonsPanel.add(this.cancelButton, 0, 0, 1, 0, 1, 1, 13, 0);
        this.buttonsPanel.add(this.sendButton, 1, 0, 1, 0, 0, 1, 17, 0);
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder(3, 3, 3, 3));
        SHButtonUI.makeButtonBlue(this.sendButton);
        JLabel ltitle = new JLabel(Language.get("HEADING"));
        JLabel lmsg = new JLabel(Language.get("MESSAGE"));
        EmptyBorder shunt = new EmptyBorder(5, 0, 0, 0);
        ltitle.setBorder(shunt);
        lmsg.setBorder(shunt);
        this.msgPanel.add(ltitle, 0, 0, 1, 1, 1, 1, 18, 0);
        this.msgPanel.add(this.subject, 1, 0, 1, 1, 1000, 1, 17, 2);
        this.msgPanel.add(lmsg, 0, 1, 1, 1, 1, 1, 18, 0);
        this.msgPanel.add(this.scroll, 1, 1, 1, 1, 1000, 10000, 17, 1);
        this.contentPanel.addCenter(this.msgPanel);
        this.contentPanel.addSouth(this.buttonsPanel);
        this.cancelButton.addActionListener(this);
        this.sendButton.addActionListener(this);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setSize(500, 200);
        Language.loadTranslations();
        MachineNotificationPanel mcp = new MachineNotificationPanel(null, null, null);
        frame.getContentPane().add(mcp.getRootComponent());
        frame.setVisible(true);
        Thread.sleep(1000L);
    }

    public boolean isConfiguring() {
        return this.configuringMachines != null;
    }

    public void stopConfiguring(boolean saveResult) {
        this.configuringMachines = null;
    }

    private void okPressed() {
        if (this.configuringMachines != null) {
            new NotifierThread(this.configuringMachines).start();
        }
        this.configuringMachines = null;
        this.serviceListener.cancelled();
    }

    private void cancelPressed() {
        this.configuringMachines = null;
        this.serviceListener.cancelled();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sendButton) {
            this.okPressed();
        } else {
            this.cancelPressed();
        }
    }

    class NotifierThread
    extends Thread {
        Machine[] machines;

        public NotifierThread(Machine[] machines) {
            this.machines = machines;
        }

        @Override
        public void run() {
            MachineNotificationPanel.this.accessPanelListener.doRemoteMachinesNotification(this.machines, MachineNotificationPanel.this.subject.getText().trim(), MachineNotificationPanel.this.content.getText().trim());
        }
    }
}

